<?php
function fetch_listing_address() {
    global $wpdb;
    global $post;

    // Ensure we have the global post object, or return if not
    if ( ! is_a( $post, 'WP_Post' ) ) {
        return;
    }

    // Get the current post ID
    $current_post_id = $post->ID;

    // Prepare the SQL query
    $query = $wpdb->prepare("SELECT address FROM wp_0dr04ss6sy_mylisting_locations WHERE listing_id = %d", $current_post_id);

    // Execute the query and get the result
    $address = $wpdb->get_var($query);

    // Return the address, or false if not found
    return $address ? $address : false;
}
?>