# Listing Priority

### How can listings gain higher priority?
Listings can be given higher priority in search results in the following ways:
1. When submitting a listing, the user buy a premium package which automatically marks the listing as `Featured`, indefinitely.
2. When the user buys a promotion package, which marks the listing as `Promoted`, for a set amount of time.
3. The site owner manually assigning the priority to a listing.

By default, listing priority is set to `Normal`, which means no extra priority is given to them.

### What are the different priority levels?
The difference between `Normal`, `Featured`, and `Promoted` listings is as follows.
- `Promoted` listings have the highest importance in search results. They will also appear ahead of featured listings.
- `Featured` listings are a level below promoted listings in importance, but will be shown ahead of normal listings.
- `Normal` priority listings will appear below promoted and featured listings. They aren't given any special importance.

### How does custom priority work?
In addition to this, when the site owner edits a listing through the backend form, there's another setting named `Custom priority`.

This is a special setting which can be useful to manually prioritise a listing above all others, even ahead of Promoted ones.

It accepts a numeric value. Higher value means higher priority in search results. A value of `0` would mean no priority, `1` would be equal to featured listings, `2` would be equal to promoted listings, and anything higher than that would give it priority over every other listing.
