<?php

// Enqueue child theme style.css
add_action( 'wp_enqueue_scripts', function() {
    wp_enqueue_style( 'child-style', get_stylesheet_uri() );

    if ( is_rtl() ) {
    	wp_enqueue_style( 'mylisting-rtl', get_template_directory_uri() . '/rtl.css', [], wp_get_theme()->get('Version') );
    }
}, 500 );

// Happy Coding :)


add_action( 'template_redirect', 'redirect_to_specific_page' );

function redirect_to_specific_page() {

if ( is_page('add-listing') && ! is_user_logged_in() || is_page('create-a-listing') && ! is_user_logged_in()) {

wp_redirect( 'my-account', 301 ); 
  exit;
    }
}

//Modifys the checkout process for Entertainers to not need to add billing information during the checkout process
add_filter( 'woocommerce_checkout_fields', 'custom_override_checkout_fields' );

function custom_override_checkout_fields( $fields ) {
    // Check if "Entertainers Package" is in the cart
    if (WC()->cart) {
        $entertainers_package_found = false;
        foreach (WC()->cart->get_cart() as $cart_item) {
            // Change "Entertainers Package" to the actual product name
            if ($cart_item['data']->get_name() === 'Entertainers Package') {
                $entertainers_package_found = true;
                break;
            }
        }
        // If "Entertainers Package" is found, remove the billing fields
        if ($entertainers_package_found) {
            unset($fields['billing']['billing_first_name']);
            unset($fields['billing']['billing_last_name']);
            unset($fields['billing']['billing_company']);
            unset($fields['billing']['billing_address_1']);
            unset($fields['billing']['billing_address_2']);
            unset($fields['billing']['billing_city']);
            unset($fields['billing']['billing_postcode']);
            unset($fields['billing']['billing_country']);
            unset($fields['billing']['billing_state']);
            unset($fields['billing']['billing_phone']);
            unset($fields['order']['order_comments']);
            unset($fields['billing']['billing_address_2']);
            unset($fields['billing']['billing_postcode']);
            unset($fields['billing']['billing_company']);
            unset($fields['billing']['billing_email']);
            unset($fields['billing']['billing_city']);
        }
    }
    return $fields;
}
//AIzaSyCbQqMzAn3k7ga3XWNRhc1f6ZPXpw834Zc

function display_rescan_page() {
    ?>
    <div class="wrap">
        <h1>Rescan Brewpub Locations</h1>
        <form method="post" action="">
            <input type="hidden" name="rescan_brewpubs" value="1" />
            <?php submit_button('Rescan Now'); ?>
        </form>
    </div>
    <?php

    if (isset($_POST['rescan_brewpubs']) && $_POST['rescan_brewpubs'] == '1') {
        $results = update_brewpub_markers(true);
        
        // Display success message
        echo '<div class="notice notice-success is-dismissible"><p>Brewpub locations have been rescanned and updated.</p></div>';
        
        // Display new found places
        if (!empty($results['new_places'])) {
            echo '<div class="notice notice-info is-dismissible"><p>New Brewpub Locations Added:</p><ul>';
            foreach ($results['new_places'] as $place) {
                echo '<li>' . esc_html($place) . '</li>';
            }
            echo '</ul></div>';
        }
        
        // Display debug errors
        if (!empty($results['errors'])) {
            echo '<div class="notice notice-error is-dismissible"><p>Errors Encountered:</p><ul>';
            foreach ($results['errors'] as $error) {
                echo '<li>' . esc_html($error) . '</li>';
            }
            echo '</ul></div>';
        }
    }
}

add_action('admin_menu', 'register_custom_rescan_page');

function register_custom_rescan_page() {
    add_submenu_page(
        'wp-google-maps-menu',
        'Rescan Brewpub Locations',
        'Rescan Brewpubs',
        'manage_options',
        'rescan-brewpub-locations',
        'display_rescan_page'
    );
}

add_action('update_brewpub_markers_event', 'update_brewpub_markers');

function update_brewpub_markers($manual = false) {
    global $wpdb;
    $batch_size = 50;
    $total_locations = $wpdb->get_var(
        "SELECT COUNT(*) FROM {$wpdb->prefix}postmeta 
        WHERE meta_key = '_location-category'"
    );

    error_log('Total locations found: ' . $total_locations);

    $offset = 0;
    $new_places = [];
    $errors = [];

    while ($offset < $total_locations) {
        $locations = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT post_id, meta_value AS category FROM {$wpdb->prefix}postmeta 
                WHERE meta_key = '_location-category'
                LIMIT %d OFFSET %d",
                $batch_size,
                $offset
            )
        );

        foreach ($locations as $location) {
            $post_id = $location->post_id;
            $categories = maybe_unserialize($location->category);

            if (is_array($categories)) {
                error_log('Categories for post_id ' . $post_id . ': ' . print_r($categories, true));
            } else {
                error_log('Failed to unserialize categories for post_id ' . $post_id);
            }

            if (is_array($categories) && in_array('Brewpub', $categories)) {
                error_log('Brewpub category found for post_id ' . $post_id);

                $address = $wpdb->get_var(
                    $wpdb->prepare(
                        "SELECT meta_value FROM {$wpdb->prefix}postmeta WHERE post_id = %d AND meta_key = '_job_location'",
                        $post_id
                    )
                );
                
                if (!$address) {
                    $post_content = get_post_field('post_content', $post_id);
                    preg_match('/<div class="map-block-address">.*?<p>(.*?)<\/p>/s', $post_content, $matches);
                    if (isset($matches[1])) {
                        $address = $matches[1];
                        error_log('Address found in post content for post_id ' . $post_id . ': ' . $address);
                    } else {
                        error_log('No address found for post_id ' . $post_id);
                        $address = 'Unknown Address';
                    }
                }

                if ($address == 'Unknown Address') {
                    error_log('Skipping post_id ' . $post_id . ' due to missing address');
                    continue;
                }

                $title = $wpdb->get_var(
                    $wpdb->prepare(
                        "SELECT post_title FROM {$wpdb->prefix}posts WHERE ID = %d",
                        $post_id
                    )
                );

                $description = $wpdb->get_var(
                    $wpdb->prepare(
                        "SELECT meta_value FROM {$wpdb->prefix}postmeta WHERE post_id = %d AND meta_key = '_job_tagline'",
                        $post_id
                    )
                );

                $pic_meta_value = $wpdb->get_var(
                    $wpdb->prepare(
                        "SELECT meta_value FROM {$wpdb->prefix}postmeta WHERE post_id = %d AND meta_key = '_job_cover'",
                        $post_id
                    )
                );
                $pic_array = maybe_unserialize($pic_meta_value);
                $pic = is_array($pic_array) ? $pic_array[0] : '';

                $link = $wpdb->get_var(
                    $wpdb->prepare(
                        "SELECT meta_value FROM {$wpdb->prefix}postmeta WHERE post_id = %d AND meta_key = '_job_website'",
                        $post_id
                    )
                );

                // Ensure values are not NULL
                $title = $title ? $title : 'No Title';
                $description = $description ? $description : 'No Description';
                $pic = $pic ? $pic : '';
                $link = $link ? $link : '';

                // Log all the fetched data for debugging
                error_log('Fetched data for post_id ' . $post_id . ': Address: ' . $address . ', Title: ' . $title . ', Description: ' . $description . ', Pic: ' . $pic . ', Link: ' . $link);

                // Get coordinates from address
                $coordinates = get_coordinates_from_address($address);
                $lat = $coordinates['lat'];
                $lng = $coordinates['lng'];

                if (empty($lat) || empty($lng)) {
                    $errors[] = "Failed to get coordinates for address: $address";
                    continue;
                }

                $existing_marker = $wpdb->get_var(
                    $wpdb->prepare(
                        "SELECT id FROM {$wpdb->prefix}wpgmza WHERE address = %s AND title = %s",
                        $address,
                        $title
                    )
                );

                if ($existing_marker) {
                    error_log('Updating existing marker for post_id ' . $post_id);
                    $wpdb->update(
                        "{$wpdb->prefix}wpgmza",
                        array(
                            'address' => $address,
                            'description' => $description,
                            'pic' => $pic,
                            'link' => $link,
                            'lat' => $lat,
                            'lng' => $lng,
                        ),
                        array('id' => $existing_marker)
                    );
                } else {
                    error_log('Inserting new marker for post_id ' . $post_id);
                    $wpdb->insert(
                        "{$wpdb->prefix}wpgmza",
                        array(
                            'map_id' => 3,
                            'address' => $address,
                            'description' => $description,
                            'pic' => $pic,
                            'link' => $link,
                            'icon' => '',
                            'lat' => $lat,
                            'lng' => $lng,
                            'anim' => '',
                            'title' => $title,
                            'infoopen' => '',
                            'category' => '',
                            'approved' => 1,
                            'retina' => '',
                            'type' => '',
                            'did' => '',
                            'sticky' => '',
                            'other_data' => 'a:2:{s:10:"hover_icon";s:72:"//wisco.live/wp-content/plugins/wp-google-maps/images/spotlight-poi3.png";s:12:"hover_retina";s:1:"0";}',
                            'latlng' => '',
                            'layergroup' => ''
                        )
                    );
                    $new_places[] = $title;
                }
            }
        }

        $offset += $batch_size;
        wp_cache_flush();
    }

    if ($manual) {
        return array('new_places' => $new_places, 'errors' => $errors);
    }
}

// Function to get coordinates from address using Google Maps Geocoding API
if (!function_exists('get_coordinates_from_address')) {
    function get_coordinates_from_address($address) {
        $api_key = 'AIzaSyCbQqMzAn3k7ga3XWNRhc1f6ZPXpw834Zc';
        $response = wp_remote_get("https://maps.googleapis.com/maps/api/geocode/json?address=" . urlencode($address) . "&key=" . $api_key);

        if (is_array($response) && !is_wp_error($response)) {
            $body = json_decode($response['body'], true);
            if (isset($body['results'][0]['geometry']['location'])) {
                return $body['results'][0]['geometry']['location'];
            } else {
                error_log('Geocoding API error for address ' . $address . ': ' . print_r($body, true));
                return array('lat' => '', 'lng' => '');
            }
        } else {
            error_log('Geocoding API request error for address ' . $address . ': ' . print_r($response, true));
            return array('lat' => '', 'lng' => '');
        }
    }
}

// Schedule the hourly event if not already scheduled
if (!wp_next_scheduled('update_brewpub_markers_event')) {
    wp_schedule_event(time(), 'hourly', 'update_brewpub_markers_event');
}





//AIzaSyCbQqMzAn3k7ga3XWNRhc1f6ZPXpw834Zc