import React from 'react';
import Button from '../../components/sui-button';
import { getLink } from '../../../js/utils/helpers';

/**
 * WordPress dependencies
 */
const { __ } = wp.i18n;

/**
 * UpsellCard Component
 *
 * Displays Upsell card.
 *
 * @param {Object}   props          Component props.
 * @param {boolean}  props.rightTag Whether to show right "Pro" tag layout.
 * @param {Function} props.onTrack  Function to call when "Unlock Pro" button is clicked.
 */
export default function UpsellCard( { rightTag, onTrack } ) {
	return (
		<>
			<div className="sui-box-purple" style={ { marginTop: rightTag ? '30px' : '0' } }>
				<div className={ rightTag ? 'purple-box-right' : '' } >
					{
						! rightTag && (
							<div className="sui-tag sui-tag-purple sui-tag-sm">{ __( 'Pro', 'wphb' ) }</div>
						)
					}
					<span className="sui-description">
						{ __( 'Get faster load times and smarter optimizations.', 'wphb' ) }
						{
							rightTag && (
								<div className="sui-tag sui-tag-purple sui-tag-sm">{ __( 'Pro', 'wphb' ) }</div>
							)
						}
					</span>
					<ol className="sui-upsell-list">
						<li><span className="sui-icon-check sui-md" aria-hidden="true"></span> { __( 'Generate critical CSS', 'wphb' ) }</li>
						<li><span className="sui-icon-check sui-md" aria-hidden="true"></span> { __( 'Delay JavaScript execution', 'wphb' ) }</li>
						<li><span className="sui-icon-check sui-md" aria-hidden="true"></span> { __( '119-Points CDN network', 'wphb' ) }</li>
					</ol>
					<div className="sui-button-group">
						<Button
							classes={ [ 'sui-button', 'sui-button-ghost' ] }
							target="blank"
							url={ getLink( 'docs' ) }
							text={ __( 'Learn More', 'wphb' ) } />
						<Button
							classes={ [ 'sui-button', 'sui-button-purple' ] }
							target="blank"
							url={ getLink( 'upsell' ) }
							onClick={ ( ) => {
								onTrack( );
							} }
							text={ __( 'Unlock Pro', 'wphb' ) } />
					</div>
				</div>
			</div>
		</>
	);
}

