import React from 'react';
/**
 * Internal dependencies
 */
import Icon from '../../components/sui-icon';
import Tooltip from '../../components/sui-tooltip';

/**
 * Reusable Toggle Settings Row Component
 *
 * @param {Object}   props             - Component props
 * @param {string}   props.text        - The label text to display
 * @param {string}   props.id          - The unique ID for the toggle input
 * @param {string}   props.toggleName  - The name attribute for the toggle input
 * @param {boolean}  props.checked     - Whether the toggle is checked
 * @param {Function} props.onChange    - Callback function when toggle state changes
 * @param {string}   props.icon        - SUI icon name to display
 * @param {string}   props.tooltipText - Tooltip text to display
 *
 * @return {JSX.Element} Toggle settings row component
 */
const ToggleSettingsRow = ( {
	text,
	id,
	toggleName,
	checked = false,
	onChange,
	icon = '',
	tooltipText = '',
} ) => {
	return (
		<label htmlFor={ id } className="sui-toggle wizard-settings__toggle" aria-label={ text }>
			<div className="sui-toggle-label">
				<span className="wizard-icon-box">
					<Icon classes={ icon } />
				</span>
				{ text }
				<Tooltip classes="sui-tooltip sui-tooltip-constrained" text={ tooltipText }>
					<Icon classes="hum-icon-question" />
				</Tooltip>
			</div>
			<input
				type="checkbox"
				id={ id }
				name={ toggleName || id }
				checked={ checked }
				onChange={ onChange }
			/>
			<span className="sui-toggle-slider"></span>
		</label>
	);
};

export default ToggleSettingsRow;
