import React from 'react';
import Select from '../../sui-select';
import { __ } from '@wordpress/i18n';

const defaultOptions = Array.from( { length: 24 }, ( _, i ) => {
	const hour = i % 12 === 0 ? 12 : i % 12;
	const period = i < 12 ? 'AM' : 'PM';
	const label = `${ hour }:00 ${ period } — ${ wphb.getTimezone }`;
	return { 0: label, 1: label };
} );

export default function TimePicker( { value, onChange, options, id } ) {
	const uid = Math.random().toString( 36 ).substring( 2, 9 );
	const uniqueId = id || `wphb-time-picker-${ uid }`;

	const timeOptions = options || defaultOptions;

	return (
		<div className="wphb-time-picker">
			<Select
				classes="wphb-select"
				selectId={ uniqueId }
				label={ __( 'Time of the day', 'wphb' ) }
				items={ timeOptions }
				selected={ value }
				onChange={ ( e ) => onChange( e.target.value ) }
			/>
		</div>
	);
}
