import React from 'react';
import TimePicker from '../time-picker';
import RecipientsBox from '../recipients-box';
import Select from '../../sui-select';
import { __ } from '@wordpress/i18n';

const daysOfWeek = [
	{
		0: 'Sunday',
		1: __( 'Sunday', 'wphb' ),
	},
	{
		0: 'Monday',
		1: __( 'Monday', 'wphb' ),
	},
	{
		0: 'Tuesday',
		1: __( 'Tuesday', 'wphb' ),
	},
	{
		0: 'Wednesday',
		1: __( 'Wednesday', 'wphb' ),
	},
	{
		0: 'Thursday',
		1: __( 'Thursday', 'wphb' ),
	},
	{
		0: 'Friday',
		1: __( 'Friday', 'wphb' ),
	},
	{
		0: 'Saturday',
		1: __( 'Saturday', 'wphb' ),
	},
];

const daysOfMonth = Array.from( { length: 31 }, ( _, i ) => ( { 0: ( i + 1 ).toString(), 1: ( i + 1 ).toString() } ) );

export default function SettingsDetailsBox( { type, settings, updateSettings, sameAsReportRecipients, isMember } ) {
	const tabList = [
		{
			id: 'daily',
			label: __( 'Daily', 'wphb' ),
			content: (
				<div className="wphb-settings-schedule-report">
					<TimePicker
						value={ settings.time }
						onChange={ ( val ) => updateSettings( { target: { id: 'time', value: val } } ) }
					/>
				</div>
			)
		},
		{
			id: 'weekly',
			label: __( 'Weekly', 'wphb' ),
			content: (
				<div className="wphb-settings-schedule-report">
					<Select
						classes="wphb-select"
						selectId="wphb-report-day"
						label={ __( 'Day of the week', 'wphb' ) }
						placeholder={ __( 'Select day', 'wphb' ) }
						items={ daysOfWeek }
						onChange={ ( e ) => updateSettings( { target: { id: 'weekDay', value: e.target.value } } ) }
						selected={ settings.weekDay || 'Monday' }
					/>
					<TimePicker
						value={ settings.time }
						onChange={ ( val ) => updateSettings( { target: { id: 'time', value: val } } ) }
					/>
				</div>
			)
		},
		{
			id: 'monthly',
			label: __( 'Monthly', 'wphb' ),
			content: (
				<div className="wphb-settings-schedule-report">
					<Select
						classes="wphb-select"
						selectId="wphb-report-day-month"
						label={ __( 'Day of the month', 'wphb' ) }
						items={ daysOfMonth }
						onChange={ ( e ) => updateSettings( { target: { id: 'monthDay', value: e.target.value } } ) }
						selected={ settings.monthDay || '1' }
					/>
					<TimePicker
						value={ settings.time }
						onChange={ ( val ) => updateSettings( { target: { id: 'time', value: val } } ) }
					/>
				</div>
			)
		}
	];

	const activeTab = settings.frequency || 'daily';
	const alertTabs = [ '5 mins', '10 mins', '30 mins' ];
	if ( isMember ) {
		alertTabs.splice( 0, 0, 'Instant' );
	}

	return (
		<div className="wphb-settings-details">
			<div className="wphb-settings-details-left settings-details-box">
				{ type === 'report' && (
					<div className="sui-tabs sui-side-tabs">
						<div role="tablist" className="sui-tabs-menu">
							{ tabList.map( ( tab ) => (
								<button
									type="button"
									role="tab"
									id={ `wphb-tab__${ tab.id }` }
									key={ tab.id }
									className={ `sui-tab-item${ activeTab === tab.id ? ' active' : '' }` }
									aria-controls={ `wphb-tab__${ tab.id }--content` }
									aria-selected={ activeTab === tab.id ? 'true' : 'false' }
									tabIndex={ activeTab === tab.id ? 0 : -1 }
									onClick={ () => updateSettings( { target: { id: 'frequency', value: tab.id } } ) }
								>
									{ tab.label }
								</button>
							) ) }
						</div>
						<div className="sui-tabs-content">
							{ tabList.map( ( tab ) => (
								<div
									role="tabpanel"
									id={ `wphb-tab__${ tab.id }--content` }
									key={ tab.id }
									className={ `sui-tab-content${ activeTab === tab.id ? ' active' : '' }` }
									aria-labelledby={ `wphb-tab__${ tab.id }` }
									tabIndex={ 0 }
									hidden={ activeTab !== tab.id }
								>
									{ tab.content }
								</div>
							) ) }
						</div>
					</div>
				) }
				{ type === 'downtime' && (
					<div className="sui-tabs sui-side-tabs">
						<div role="tablist" className="sui-tabs-menu">
							{ alertTabs.map( ( label ) => {
								const id = label.replace( /\s/g, '' ).toLowerCase();
								return (
									<button
										type="button"
										role="tab"
										id={ `wphb-tab__${ id }` }
										key={ id }
										className={ `sui-tab-item${ settings.downtime === label.toLowerCase() ? ' active' : '' }` }
										aria-controls={ `wphb-tab__${ id }--content` }
										aria-selected={ settings.downtime === label.toLowerCase() ? 'true' : 'false' }
										tabIndex={ settings.downtime === label.toLowerCase() ? 0 : -1 }
										onClick={ () => updateSettings( { target: { id: 'downtime', value: label.toLowerCase() } } ) }
									>
										{ label }
									</button>
								);
							} ) }
						</div>
						<p style={ { textAlign: 'center', marginBottom: 0 } }>{ __( 'How long downtime must last before triggering an alert', 'wphb' ) }</p>
						<div className="sui-tabs-content">
							{ alertTabs.map( ( label ) => {
								const id = label.replace( /\s/g, '' ).toLowerCase();
								return (
									<div
										role="tabpanel"
										id={ `wphb-tab__${ id }--content` }
										key={ id }
										className={ `sui-tab-content${ settings.downtimeThreshold === label.toLowerCase() ? ' active' : '' }` }
										aria-labelledby={ `wphb-tab__${ id }` }
										tabIndex={ 0 }
										hidden={ settings.downtimeThreshold !== label.toLowerCase() }
									>
										<div className="sui-border-frame">
											<div className="wphb-settings-details-desc">
												{ __( 'How long downtime must last before triggering an alert', 'wphb' ) }
											</div>
										</div>
									</div>
								);
							} ) }
						</div>
					</div>
				) }
			</div>
			<div className="wphb-settings-details-right">
				<RecipientsBox
					recipients={ settings.recipients }
					onAdd={ ( recipients ) => {
						updateSettings( {
							target: {
								id: 'recipients',
								value: recipients
							}
						} );
						updateSettings( {
							target: {
								id: 'sameAsReportRecipient',
								value: false
							}
						} );
					} }
					children={ type === 'downtime' && sameAsReportRecipients && (
						<div className="sui-form-field wphb-same-as-report-recipient">
							<label htmlFor="wphb-same-report-recipient" className="sui-checkbox">
								<input
									type="checkbox"
									id="wphb-same-report-recipient"
									aria-labelledby="label-wphb-same-report-recipient"
									checked={ !! settings.sameAsReportRecipient }
									onChange={ ( e ) =>
										updateSettings( {
											target: {
												id: 'sameAsReportRecipient',
												value: e.target.checked
											}
										} )
									}
								/>
								<span aria-hidden="true"></span>
								<span id="label-wphb-same-report-recipient">
									{ __( 'Same as report recipient', 'wphb' ) }
								</span>
							</label>
						</div>
					) }
				/>
			</div>
		</div>
	);
}
