import React, { useState } from 'react';
import AddRecipientsModal from '../add-recipients-modal';
import { __ } from '@wordpress/i18n';

export default function RecipientsBox( { recipients = [], onAdd, children } ) {
	const [ showModal, setShowModal ] = useState( false );

	const handleRemoveUser = ( recipientToRemove ) => {
		const updatedRecipients = recipients.filter( ( r ) => r.email !== recipientToRemove.email );
		onAdd( updatedRecipients );
	};

	return (
		<div className="wphb-recipients-box">
			<div className="wphb-recipients-title">{ __( 'Recipients', 'wphb' ) }</div>
			{ children && children }
			<div className="sui-recipients" id="modal-user-recipients-list">
				{ recipients.map( ( r ) => (
					<div className="sui-recipient" key={ r.email } data-id={ r.id } data-email={ r.email }>
						<span className="recipient-name">
							<span className="subscriber">
								<img src={ r.avatar } alt={ r.email } />
							</span>
							<span className="wphb-recipient-name">{ r.name }</span>
						</span>
						<span className="sui-recipient-email">{ r.email }</span>
						<button
							type="button"
							className="sui-button-icon sui-tooltip sui-tooltip-bottom-right"
							data-tooltip={ __( 'Remove recipient', 'wphb' ) }
							onClick={ () => handleRemoveUser( r ) }
						>
							<span className="sui-icon-trash" aria-hidden="true"></span>
						</button>
					</div>
				) ) }
			</div>
			<button className="wphb-add-recipient" onClick={ () => setShowModal( true ) }>+</button>
			{ showModal && (
				<AddRecipientsModal
					existingRecipients={ recipients }
					onAdd={ ( newRecipients ) => {
						onAdd( newRecipients );
					} }
					onClose={ () => setShowModal( false ) }
				/>
			) }
		</div>
	);
}
