import React from 'react';

export default function RadioGroup( { options, selected, onChange, name = 'radio-group' } ) {
	return (
		<div className="wphb-radio-group">
			{ options.map( ( opt, idx ) => {
				const inputId = `${ name }-${ opt.value }-${ idx }`;
				return (
					<div key={ opt.value } className="wphb-radio-label">
						<input
							type="radio"
							id={ inputId }
							name={ name }
							value={ opt.value }
							checked={ selected === opt.value }
							onChange={ () => onChange( opt.value ) }
						/>
						<label htmlFor={ inputId }>{ opt.label }</label>
					</div>
				);
			} ) }
		</div>
	);
}
