import React from 'react';
import Toggle from '../../sui-toggle';
import Tooltip from '../../sui-tooltip';
import { __ } from '@wordpress/i18n';

export default function NotificationSettingsRow( { label, description, value, onToggle, details } ) {
	return (
		<div className="wphb-settings-row">
			<div className="wphb-settings-row-main">
				<span>{ label }</span>
				<Tooltip text={ description } />
				<div className="wphb-settings-row-status">
					<span>{ value ? __( 'On', 'wphb' ) : __( 'Disabled', 'wphb' ) }</span>
					<Tooltip text={ value ? __( 'This setting is enabled.', 'wphb' ) : __( 'This setting is disabled.', 'wphb' ) } />
					<Toggle checked={ value } onChange={ ( e ) => onToggle( e.target.checked ) } />
				</div>
			</div>
			{ value && details }
		</div>
	);
}
