import React from 'react';
import Toggle from '../sui-toggle';
import Icon from '../sui-icon';
import SettingsDetailsBox from './settings-details-box';
import Tooltip from '../sui-tooltip';
import { __ } from '@wordpress/i18n';

export default function NotificationsSettings( props ) {
	// Helper to update nested notifications settings
	const updateNotificationSetting = ( type, key, value ) => {
		props.updateSettings( {
			target: {
				id: 'notifications',
				value: { [ type ]: { [ key ]: value } }
			}
		} );
	};

	return (
		<div className="wphb-notifications-settings">
			<div className="sui-box-settings-row sui-flushed">
				<div className="wphb-settings-row-main">
					<span className="row-text">{ __( 'Schedule Report', 'wphb' ) }</span>
					<Tooltip text={ __( 'Enable to receive scheduled performance reports.', 'wphb' ) } >
						<Icon classes="hum-icon-question" />
					</Tooltip>
					<div className="wphb-settings-row-status">
						<span className="row-text">{ props.settings.notifications.report.enabled ? __( 'On', 'wphb' ) : __( 'Disabled', 'wphb' ) }</span>
						{ ! props.settings.notifications.report.enabled && (
							<Tooltip text={ __( 'This setting is disabled.', 'wphb' ) } >
								<Icon classes="hum-icon-question" />
							</Tooltip>
						) }
						<Toggle
							id="report-enabled"
							checked={ props.settings.notifications.report.enabled || false }
							onChange={ ( e ) => updateNotificationSetting( 'report', 'enabled', e.target.checked ) }
							disabled={ ! props.isConnected }
						/>
					</div>
				</div>
				{ props.settings.notifications.report.enabled && (
					<SettingsDetailsBox
						type="report"
						settings={ props.settings.notifications.report }
						updateSettings={ ( e ) => updateNotificationSetting( 'report', e.target.id, e.target.value ) }
					/>
				) }
			</div>
			<div className="sui-box-settings-row sui-flushed">
				<div className="wphb-settings-row-main">
					<span className="row-text">{ __( 'Downtime Alert', 'wphb' ) }</span>
					<Tooltip text={ __( 'Enable to receive downtime alerts.', 'wphb' ) } >
						<Icon classes="hum-icon-question" />
					</Tooltip>
					<div className="wphb-settings-row-status">
						<span className="row-text">{ props.settings.notifications.alert.enabled ? __( 'On', 'wphb' ) : __( 'Disabled', 'wphb' ) }</span>
						{ ! props.settings.notifications.alert.enabled && (
							<Tooltip text={ props.settings.notifications.alert.enabled ? __( 'This setting is enabled.', 'wphb' ) : __( 'This setting is disabled.', 'wphb' ) } >
								<Icon classes="hum-icon-question" />
							</Tooltip>
						) }
						<Toggle
							id="alert-enabled"
							checked={ props.settings.notifications.alert.enabled || false }
							onChange={ ( e ) => updateNotificationSetting( 'alert', 'enabled', e.target.checked ) }
							disabled={ ! props.isConnected }
						/>
					</div>
				</div>
				{ props.settings.notifications.alert.enabled && (
					<SettingsDetailsBox
						type="downtime"
						settings={ props.settings.notifications.alert }
						updateSettings={ ( e ) => updateNotificationSetting( 'alert', e.target.id, e.target.value ) }
						sameAsReportRecipients={ props.settings.notifications.report.enabled && props.settings.notifications.report.recipients.length > 0 }
						isMember={ props.isMember }
					/>
				) }
			</div>
		</div>
	);
}
