import React, { useState } from 'react';
import { __ } from '@wordpress/i18n';

export default function AddRecipientModal( { onAdd, onClose } ) {
	const [ email, setEmail ] = useState( '' );
	return (
		<div className="wphb-modal-overlay">
			<div className="wphb-modal">
				<h3>{ __( 'Add Recipient', 'wphb' ) }</h3>
				<input
					type="email"
					value={ email }
					onChange={ ( e ) => setEmail( e.target.value ) }
					placeholder={ __( 'Recipient email', 'wphb' ) }
				/>
				<button onClick={ () => onAdd( email ) }>{ __( 'Add', 'wphb' ) }</button>
				<button onClick={ onClose }>{ __( 'Cancel', 'wphb' ) }</button>
			</div>
		</div>
	);
}
