import React from 'react';
import Button from '../sui-button';

import './style.scss';

const { __ } = wp.i18n;

export default function ConnectNotice( { onConnect } ) {
	return (
		<div className="wphb-connect-notice">
			<div className="wphb-connect-icon">
				<span>!</span>
			</div>
			<div className="wphb-connect-text">
				{ __( 'Site not connected to WPMU DEV. ', 'wphb' ) }
				<br />
				{ __( 'Connect your account to enable reports & alerts.', 'wphb' ) }
			</div>
			<div className="wphb-connect-actions">
				<Button
					type="button"
					classes={ [ 'sui-button', 'btn-connect' ] }
					text={ __( 'Connect now', 'wphb' ) }
					onClick={ onConnect }
				/>
			</div>
		</div>
	);
}
