import React from 'react';

const { __ } = wp.i18n;

/**
 * ConfirmationModal component
 *
 * @param {Object}   props
 * @param {boolean}  props.show                - Whether the modal is visible (required)
 * @param {string}   props.title               - Modal title (required)
 * @param {string}   props.message             - Modal message (required)
 * @param {Function} props.onConfirm           - Confirm button click handler (required)
 * @param {Function} props.onCancel            - Cancel button click handler (required)
 * @param {string}   [props.confirmText]       - Confirm button text (optional, default: 'Confirm')
 * @param {string}   [props.cancelText]        - Cancel button text (optional, default: 'Cancel')
 * @param {Array}    [props.additionalClasses] - Additional classes for the modal overlay (optional)
 * @return {JSX.Element|null} The rendered modal or null
 */
export default function ConfirmationModal( {
	show,
	title,
	message,
	onConfirm,
	onCancel,
	confirmText = __( 'Confirm', 'wphb' ),
	cancelText = __( 'Cancel', 'wphb' ),
	additionalClasses = [],
} ) {
	if ( ! show ) {
		return null;
	}
	return (
		<div className={ 'wphb-modal-overlay ' + ( Array.isArray( additionalClasses ) ? additionalClasses.join( ' ' ) : '' ) }>
			<div className="wphb-modal">
				<h3>{ title }</h3>
				<p>{ message }</p>
				<div className="wphb-modal-actions">
					<button className="sui-button sui-button-blue" onClick={ onConfirm }>{ confirmText }</button>
					<button className="sui-button sui-button-ghost" onClick={ onCancel }>{ cancelText }</button>
				</div>
			</div>
		</div>
	);
}
