<?php
namespace WoolentorPro\Modules\StoreVacation\Admin;
use WooLentorPro\Traits\Singleton;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Fields {
    use Singleton;

    /**
     * Settings Fields Fields;
     */
    public function sitting_fields(){
        $fields = [
            [
                'name'     => 'store_vacation',
                'label'    => esc_html__( 'Store Vacation', 'woolentor' ),
                'type'     => 'module',
                'default'  => 'off',
                'section'  => 'woolentor_store_vacation_settings',
                'option_id'=> 'enable',
                'require_settings' => true,
                'documentation' => esc_url('https://woolentor.com/doc/setup-the-store-vacation-module-in-woocommerce/'),
                'setting_fields' => array(
                    
                    array(
                        'name'  => 'enable',
                        'label' => esc_html__( 'Enable / Disable', 'woolentor' ),
                        'desc'  => esc_html__( 'Enable/Disable store vacation mode', 'woolentor' ),
                        'type'  => 'checkbox',
                        'default' => 'off',
                        'class' => 'woolentor-action-field-left'
                    ),
    
                    array(
                        'name'    => 'vacation_start_date',
                        'label'   => esc_html__( 'Start Date', 'woolentor' ),
                        'type'    => 'date',
                        'desc'    => esc_html__( 'Select vacation start date', 'woolentor' ),
                        'class'   => 'woolentor-action-field-left'
                    ),
    
                    array(
                        'name'    => 'vacation_end_date',
                        'label'   => esc_html__( 'End Date', 'woolentor' ),
                        'type'    => 'date',
                        'desc'    => esc_html__( 'Select vacation end date', 'woolentor' ),
                        'class'   => 'woolentor-action-field-left'
                    ),
    
                    array(
                        'name'      => 'notice_heading',
                        'headding'  => esc_html__( 'Notice Settings', 'woolentor' ),
                        'type'      => 'title'
                    ),
        
                    array(
                        'name'    => 'notice_position',
                        'label'   => esc_html__( 'Notice Position', 'woolentor' ),
                        'type'    => 'select',
                        'default' => 'woocommerce_before_cart',
                        'options' => array(
                            'woocommerce_before_shop_loop'      => esc_html__('Before Shop Loop', 'woolentor'),
                            'woocommerce_before_single_product' => esc_html__('Before Single Product', 'woolentor'),
                            'woocommerce_before_cart'           => esc_html__('Before Cart', 'woolentor'),
                            'shop_and_single_product'           => esc_html__('Shop & Single Product', 'woolentor'),
                            'use_shortcode'                     => esc_html__( 'Use Shortcode / Widget', 'woolentor' ),
                        ),
                        'class'   => 'woolentor-action-field-left'
                    ),

                    array(
                        'name'    => 'vacation_use_shortcode_message',
                        'headding'=> wp_kses_post('Use the shortcode <code>[woolentor_vacation_notice]</code> or the widget to display the vacation notice wherever you need it.'),
                        'type'    => 'title',
                        'condition' => array( 'notice_position', '==', 'use_shortcode' ),
                        'class'     => 'woolentor_option_field_notice'
                    ),

                    array(
                        'name'    => 'vacation_message',
                        'label'   => esc_html__( 'Vacation Message', 'woolentor' ),
                        'type'    => 'textarea',
                        'desc'    => esc_html__( 'Enter message to display during vacation. You can use these placeholders: {start_date}, {end_date}, {days_remaining}', 'woolentor' ),
                        'default' => esc_html__( '🏖️ Dear valued customers, our store is currently on vacation from {start_date} to {end_date}. During this time, new orders will be temporarily suspended. We will resume normal operations on {end_date}. Thank you for your understanding!', 'woolentor' ),
                    ),
        
                    array(
                        'name'    => 'notice_color',
                        'label'   => esc_html__( 'Notice Text Color', 'woolentor' ),
                        'type'    => 'color',
                        'default' => '#000000',
                        'class'   => 'woolentor-action-field-left'
                    ),
        
                    array(
                        'name'    => 'notice_bg_color',
                        'label'   => esc_html__( 'Notice Background Color', 'woolentor' ),
                        'type'    => 'color',
                        'default' => '#ffffff',
                        'class'   => 'woolentor-action-field-left'
                    ),

                    // Product Settings
                    array(
                        'name'      => 'product_heading',
                        'headding'  => esc_html__( 'Product Settings', 'woolentor' ),
                        'type'      => 'title'
                    ),

                    array(
                        'name'    => 'hide_add_to_cart',
                        'label'   => esc_html__( 'Turn Off Purchases', 'woolentor' ),
                        'type'    => 'checkbox',
                        'desc'    => esc_html__( 'Turn off purchases during vacation', 'woolentor' ),
                        'default' => 'off',
                        'class'   => 'woolentor-action-field-left'
                    ),

                    array(
                        'name'    => 'product_availability_text',
                        'label'   => esc_html__( 'Product Availability Text', 'woolentor' ),
                        'type'    => 'text',
                        'desc'    => esc_html__( 'Text to show instead of Add to Cart button', 'woolentor' ),
                        'default' => esc_html__( 'Available after vacation', 'woolentor' ),
                        'class'   => 'woolentor-action-field-left',
                        'condition' => array( 'hide_add_to_cart', '==', 'true' ),
                    ),




                    array(
                        'name'      => 'advanced_heading',
                        'headding'  => esc_html__( 'Advanced Settings', 'woolentor' ),
                        'type'      => 'title'
                    ),
            
                    array(
                        'name'    => 'multiple_schedules',
                        'label'   => esc_html__( 'Multiple Schedules', 'woolentor' ),
                        'type'    => 'repeater',
                        'title_field' => 'title',
                        'fields'  => [
                            array(
                                'name'        => 'title',
                                'label'       => esc_html__( 'Schedule Title', 'woolentor' ),
                                'type'        => 'text',
                            ),
                            array(
                                'name'        => 'recurring',
                                'label'       => esc_html__( 'Recurring', 'woolentor' ),
                                'type'        => 'select',
                                'options'     => array(
                                    'none'      => esc_html__('None', 'woolentor'),
                                    'weekly'    => esc_html__('Weekly', 'woolentor'),
                                    'monthly'   => esc_html__('Monthly', 'woolentor'),
                                    'yearly'    => esc_html__('Yearly', 'woolentor'),
                                ),
                            ),
                            array(
                                'name'        => 'start_date',
                                'label'       => esc_html__( 'Start Date', 'woolentor' ),
                                'type'        => 'date',
                            ),
                            array(
                                'name'        => 'end_date',
                                'label'       => esc_html__( 'End Date', 'woolentor' ),
                                'type'        => 'date',
                                'condition' => array( 'recurring', '==', 'none' ),
                            ),
                            array(
                                'name'        => 'message',
                                'label'       => esc_html__( 'Message', 'woolentor' ),
                                'type'        => 'textarea',
                            )
                        ]
                    ),
            
                    array(
                        'name'      => 'category_specific_heading',
                        'headding'  => esc_html__( 'Category Specific Settings', 'woolentor' ),
                        'type'      => 'title',
                    ),
            
                    array(
                        'name'    => 'category_specific_vacation',
                        'label'   => esc_html__( 'Category Specific', 'woolentor' ),
                        'type'    => 'repeater',
                        'title_field' => 'category',
                        'fields'  => [
                            array(
                                'name'        => 'category',
                                'label'       => esc_html__( 'Category', 'woolentor' ),
                                'type'        => 'select',
                                'options'     => woolentor_taxonomy_list('product_cat','term_id'),
                            ),
                            array(
                                'name'        => 'start_date',
                                'label'       => esc_html__( 'Start Date', 'woolentor' ),
                                'type'        => 'date',
                            ),
                            array(
                                'name'        => 'end_date',
                                'label'       => esc_html__( 'End Date', 'woolentor' ),
                                'type'        => 'date',
                            ),
                            array(
                                'name'        => 'message',
                                'label'       => esc_html__( 'Message', 'woolentor' ),
                                'type'        => 'textarea',
                            ),
                        ]
                    ),
            
                    array(
                        'name'      => 'notice_customization_heading',
                        'headding'  => esc_html__( 'Notice Customization', 'woolentor' ),
                        'type'      => 'title'
                    ),
            
                    array(
                        'name'    => 'notice_style',
                        'label'   => esc_html__( 'Notice Style', 'woolentor' ),
                        'type'    => 'select',
                        'default' => 'banner',
                        'options' => array(
                            'banner'    => esc_html__('Banner', 'woolentor'),
                            'popup'     => esc_html__('Popup', 'woolentor'),
                            'floating'  => esc_html__('Floating', 'woolentor'),
                        ),
                        'class'   => 'woolentor-action-field-left',
                    ),
            
                    array(
                        'name'    => 'show_countdown',
                        'label'   => esc_html__( 'Show Countdown', 'woolentor' ),
                        'type'    => 'checkbox',
                        'class'   => 'woolentor-action-field-left',
                        'condition' => array( 'notice_style', '==', 'popup' ),
                    ),

                    array(
                        'name'    => 'floating_position',
                        'label'   => esc_html__( 'Floating Notice Position', 'woolentor' ),
                        'type'    => 'select',
                        'default' => 'bottom-right',
                        'options' => array(
                            'top-left'     => esc_html__('Top Left', 'woolentor'),
                            'top-right'    => esc_html__('Top Right', 'woolentor'),
                            'bottom-left'  => esc_html__('Bottom Left', 'woolentor'),
                            'bottom-right' => esc_html__('Bottom Right', 'woolentor'),
                        ),
                        'condition' => array( 'notice_style', '==', 'floating' ),
                        'class'   => 'woolentor-action-field-left'
                    ),
            
                    array(
                        'name'      => 'access_control_heading',
                        'headding'  => esc_html__( 'Access Control', 'woolentor' ),
                        'type'      => 'title'
                    ),
            
                    array(
                        'name'    => 'allowed_user_roles',
                        'label'   => esc_html__( 'Allowed User Roles', 'woolentor' ),
                        'type'    => 'multiselect',
                        'options' => woolentor_user_role_list(),
                        'class'   => 'woolentor-action-field-left',
                    ),
            
                    array(
                        'name'    => 'allowed_ips',
                        'label'   => esc_html__( 'Allowed IPs', 'woolentor' ),
                        'type'    => 'textarea',
                        'desc'    => esc_html__('Enter IPs separated by commas', 'woolentor'),
                    ),
            
                    array(
                        'name'      => 'seo_heading',
                        'headding'  => esc_html__( 'SEO Settings', 'woolentor' ),
                        'type'      => 'title'
                    ),
            
                    array(
                        'name'    => 'vacation_meta_title',
                        'label'   => esc_html__( 'Meta Title', 'woolentor' ),
                        'type'    => 'text'
                    ),
            
                    array(
                        'name'    => 'vacation_meta_description',
                        'label'   => esc_html__( 'Meta Description', 'woolentor' ),
                        'type'    => 'textarea'
                    ),
    
                )
            ]

        ];

        return $fields;
    }

}