<?php

if (! defined('ABSPATH') ) {
	exit; // restict for direct access
}

if (!class_exists('Addify_User_Redirect_Front') ) {

	class Addify_User_Redirect_Front extends Addify_User_Redirect {

		public function __construct() {

			add_filter('woocommerce_login_redirect', array($this, 'afurd_login_redirect'), 9, 2);
			add_filter( 'woocommerce_registration_redirect', array($this, 'afurd_registration_redirect' ), 9, 2);
			add_filter('login_redirect', array($this, 'afurd_wp_login_redirect'), 10, 3);
			add_filter('logout_redirect', array($this, 'afurd_wp_logout_redirect'), 10, 3);
			add_filter( 'register_new_user', array($this, 'afurd_registration_redirect' ), 9, 2);

			add_action('woocommerce_login_form_start', array($this, 'afurd_added_login_field'));
			add_action('woocommerce_register_form_start', array($this, 'afurd_added_login_field'));

			add_action('login_form', array($this, 'afurd_added_login_field'));
			add_filter('register_form', array($this, 'afurd_added_login_field'));
		}

		public function afurd_added_login_field() {

			wp_nonce_field( 'afurd_fields_nonce', 'afurd_field_nonce' );
			?>

			<input type="hidden" name="pre_page" value="<?php echo esc_attr(wp_get_referer()); ?>">

			<?php 
		}

		
		public function afurd_login_redirect( $redirect_to, $user) {

			if ( wc_get_checkout_url() == $redirect_to ) {

				return $redirect_to;
			}

			include_once  ABSPATH . 'wp-admin/includes/plugin.php' ;
			//All Roles Redirect

			$afurd__all_roles           = get_option('afurd_login_redirect_page_all_roles');
			$afurd_custom_url_all_roles = get_option('afurd_login_redirect_custom_url_all_roles');

			//Current User Role Redirect
			$afurd_current_role_redirect        = get_option('afurd_login_redirect_page_' . esc_attr($user->roles[0]));
			$afurd_current_user_role_custom_url = get_option('afurd_login_redirect_custom_url_' . esc_attr($user->roles[0]));

			//Check if there is condition set for current user role
			if (!empty($afurd_current_role_redirect)) {

				if ('same_page' == $afurd_current_role_redirect) {

					if (isset($_POST['pre_page']) && '' != $_POST['pre_page']) {

						// if our nonce isn't there, or we can't verify it, return
						if ( !isset( $_POST['afurd_field_nonce'] ) || !wp_verify_nonce( sanitize_text_field($_POST['afurd_field_nonce']), 'afurd_fields_nonce' ) ) {
							return;
						}

						wp_redirect(esc_url_raw($_POST['pre_page']));
						exit();
					} else {

						$redirect_url = esc_url(wp_get_referer());
						if ( empty($redirect_url) ) {
							return $redirect_to;
						}
						wp_redirect($redirect_url);
						exit();

					}


				} elseif ('home_page' == $afurd_current_role_redirect) {

					wp_redirect(esc_url( home_url( '/' ) ));
					exit();

				} elseif ('default' == $afurd_current_role_redirect) {

					if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {

						wp_redirect(get_permalink( get_option('woocommerce_myaccount_page_id') ));
						exit();
					} else {

						return $redirect_to;
						exit();
					}

				} elseif ('custom_url' == $afurd_current_role_redirect) {

					wp_redirect(esc_url( $afurd_current_user_role_custom_url ));
					exit();
				}

				//If no condition set for current user role then check condition for all user roles.
			} elseif (!empty($afurd__all_roles)) {

				if ('same_page' == $afurd__all_roles) {

					if (isset($_POST['pre_page']) && '' != $_POST['pre_page']) {

						wp_redirect(esc_url_raw($_POST['pre_page']));
						exit();
					} else {

						$redirect_url = esc_url(wp_get_referer());
						if ( empty($redirect_url) ) {
							return $redirect_to;
						}
						wp_redirect($redirect_url);
						exit();

					}

				} elseif ('home_page' == $afurd__all_roles) {

					wp_redirect(esc_url( home_url( '/' ) ));
					exit();

				} elseif ('default' == $afurd__all_roles) {

					if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {

						wp_redirect(get_permalink( get_option('woocommerce_myaccount_page_id') ));
						exit();
					} else {

						return $redirect_to;
						exit();
					}

				} elseif ('custom_url' == $afurd__all_roles) {

					wp_redirect(esc_url( $afurd_custom_url_all_roles ));
					exit();
				}
			} else {

				return $redirect_to;
			}
				

		}

		public function afurd_wp_logout_redirect( $redirect_to, $request, $user) {
			if (isset($user->roles) && is_array($user->roles)) {
				global $wp_roles;
				$roles = $wp_roles->get_names();
				//All Roles Redirect

				$afurd__all_roles           = get_option('afurd_logout_redirect_page_all_roles');
				$afurd_custom_url_all_roles = get_option('afurd_logout_redirect_custom_url_all_roles');

				//Current User Role Redirect
				$afurd_current_role_redirect        = get_option('afurd_logout_redirect_page_' . esc_attr($user->roles[0]));
				$afurd_current_user_role_custom_url = get_option('afurd_logout_redirect_custom_url_' . esc_attr($user->roles[0]));


				//Check if there is condition set for current user role
				if (!empty($afurd_current_role_redirect)) {

					if ('same_page' == $afurd_current_role_redirect) {

						if (isset($_POST['pre_page']) && '' != $_POST['pre_page']) {

							// if our nonce isn't there, or we can't verify it, return
							if ( !isset( $_POST['afurd_field_nonce'] ) || !wp_verify_nonce( sanitize_text_field($_POST['afurd_field_nonce']), 'afurd_fields_nonce' ) ) {
								return;
							}

							wp_redirect(esc_url_raw($_POST['pre_page']));
							exit();
						} else {

							$redirect_url = esc_url(wp_get_referer());
							if ( empty($redirect_url) ) {
								return $redirect_to;
							}
							wp_redirect($redirect_url);
							exit();

						}

					} elseif ('home_page' == $afurd_current_role_redirect) {

						wp_redirect(esc_url(home_url('/')));
						exit();

					} elseif ('default' == $afurd_current_role_redirect) {

						wp_redirect($redirect_to);
						exit();

					} elseif ('custom_url' == $afurd_current_role_redirect) {

						wp_redirect(esc_url($afurd_current_user_role_custom_url));
						exit();
					}

					//If no condition set for current user role then check condition for all user roles.
				} elseif (!empty($afurd__all_roles)) {

					if ('same_page' == $afurd__all_roles) {
						echo 'Heloo i am in same page';
						if (isset($_POST['pre_page']) && '' != $_POST['pre_page']) {

							wp_redirect(esc_url_raw($_POST['pre_page']));
							exit();
						} else {

							$redirect_url = esc_url(wp_get_referer());
							
							if ( empty($redirect_url) ) {
								return $redirect_to;
							}
							wp_redirect($redirect_url);
							exit();

						}

					} elseif ('home_page' == $afurd__all_roles) {

						wp_redirect(esc_url(home_url('/')));
						exit();

					} elseif ('default' == $afurd__all_roles) {

						wp_redirect($redirect_to);
						exit();

					} elseif ('custom_url' == $afurd__all_roles) {

						wp_redirect(esc_url($afurd_custom_url_all_roles));
						exit();
					}
				} else {

					wp_redirect($redirect_to);
					exit();
				}
			} else {

				return $redirect_to;
			}

		}

		public function afurd_wp_login_redirect( $redirect_to, $request, $user) {
			if ( is_checkout() ) {
				return;
			}
			if (isset($user->roles) && is_array($user->roles)) {
				global $wp_roles;
				$roles = $wp_roles->get_names();
				//All Roles Redirect
				$afurd__all_roles           = get_option('afurd_login_redirect_page_all_roles');
				$afurd_custom_url_all_roles = get_option('afurd_login_redirect_custom_url_all_roles');

				//Current User Role Redirect

				foreach ($roles as $key => $value) {
					if (in_array($key, $user->roles)) {
						$afurd_current_role_redirect        = get_option('afurd_login_redirect_page_' . esc_attr($key));
						$afurd_current_user_role_custom_url = get_option('afurd_login_redirect_custom_url_' . esc_attr($key));
					}
				}
				//Check if there is condition set for current user role
				if (!empty($afurd_current_role_redirect)) {

					if ('same_page' == $afurd_current_role_redirect) {

						if (isset($_POST['pre_page']) && '' != $_POST['pre_page']) {

							// if our nonce isn't there, or we can't verify it, return
							if ( !isset( $_POST['afurd_field_nonce'] ) || !wp_verify_nonce( sanitize_text_field($_POST['afurd_field_nonce']), 'afurd_fields_nonce' ) ) {
								return;
							}

							wp_redirect(esc_url_raw($_POST['pre_page']));
							exit();
						} else {

							$redirect_url = esc_url(wp_get_referer());
							if ( empty($redirect_url) ) {
								return $redirect_to;
							}
							wp_redirect($redirect_url);
							exit();


						}

					} elseif ('home_page' == $afurd_current_role_redirect) {

						wp_redirect(esc_url(home_url('/')));
						exit();

					} elseif ('default' == $afurd_current_role_redirect) {

						wp_redirect(esc_url(admin_url()));
						exit();

					} elseif ('custom_url' == $afurd_current_role_redirect) {

						wp_redirect(esc_url($afurd_current_user_role_custom_url));
						exit();
					}

					//If no condition set for current user role then check condition for all user roles.
				} elseif (!empty($afurd__all_roles)) {

					if ('same_page' == $afurd__all_roles) {

						if (isset($_POST['pre_page']) && '' != $_POST['pre_page']) {

							wp_redirect(esc_url_raw($_POST['pre_page']));
							exit();
						} else {

							$redirect_url = esc_url(wp_get_referer());
							if ( empty($redirect_url) ) {
								return $redirect_to;
							}
							wp_redirect($redirect_url);
							exit();

						}

					} elseif ('home_page' == $afurd__all_roles) {

						wp_redirect(esc_url(home_url('/')));
						exit();

					} elseif ('default' == $afurd__all_roles) {

						wp_redirect(esc_url(admin_url()));
						exit();

					} elseif ('custom_url' == $afurd__all_roles) {

						wp_redirect(esc_url($afurd_custom_url_all_roles));
						exit();
					}
				} else {

					wp_redirect($redirect_to);
					exit();
				}
			} else {

				return $redirect_to;
			}

		}

		public function afurd_registration_redirect( $redirect_to ) {

			if ( wc_get_checkout_url() == $redirect_to ) {

				return $redirect_to;
			}
			

			if (isset($_POST['wp_urr_user_role']) && '' != $_POST['wp_urr_user_role']) {

				// if our nonce isn't there, or we can't verify it, return
				if ( !isset( $_POST['wp_urr_field_nonce'] ) || !wp_verify_nonce( sanitize_text_field($_POST['wp_urr_field_nonce']), 'wp_urr_fields_nonce' ) ) {
					return;
				}

				$afurd_userrole = sanitize_text_field($_POST['wp_urr_user_role']);
			} else {

				$afurd_userrole = get_option('default_role');
			}
			include_once  ABSPATH . 'wp-admin/includes/plugin.php' ;

			//All Roles Redirect

			$afurd__all_roles           = get_option('afurd_reg_redirect_page_all_roles');
			$afurd_custom_url_all_roles = get_option('afurd_reg_redirect_custom_url_all_roles');

			//Current User Role Redirect

			$afurd_current_role_redirect        = get_option('afurd_reg_redirect_page_' . esc_attr($afurd_userrole));
			$afurd_current_user_role_custom_url = get_option('afurd_reg_redirect_custom_url_' . esc_attr($afurd_userrole));

			//Check if there is condition set for current user role
			if (!empty($afurd_current_role_redirect)) {

				if ('same_page' == $afurd_current_role_redirect) {

					if (isset($_POST['pre_page']) && '' != $_POST['pre_page']) {

						// if our nonce isn't there, or we can't verify it, return
						if ( !isset( $_POST['afurd_field_nonce'] ) || !wp_verify_nonce( sanitize_text_field($_POST['afurd_field_nonce']), 'afurd_fields_nonce' ) ) {
							return;
						}

						wp_redirect(esc_url_raw($_POST['pre_page']));
						exit();
					} else {

						$redirect_url = esc_url(wp_get_referer());
						if ( empty($redirect_url) ) {
							return $redirect_to;
						}
						wp_redirect($redirect_url);
						exit();

					}

				} elseif ('home_page' == $afurd_current_role_redirect) {

					wp_redirect(esc_url(home_url('/')));
					exit();

				} elseif ('default' == $afurd_current_role_redirect) {

					wp_redirect(esc_url(admin_url()));
					exit();

				} elseif ('custom_url' == $afurd_current_role_redirect) {

					wp_redirect(esc_url($afurd_current_user_role_custom_url));
					exit();
				}

				//If no condition set for current user role then check condition for all user roles.
			} elseif (!empty($afurd__all_roles)) {

				if ('same_page' == $afurd__all_roles) {

					if (isset($_POST['pre_page']) && '' != $_POST['pre_page']) {

						wp_redirect(esc_url_raw($_POST['pre_page']));
						exit();
					} else {

						$redirect_url = esc_url(wp_get_referer());
						if ( empty($redirect_url) ) {
							return $redirect_to;
						}
						wp_redirect($redirect_url);
						exit();

					}

				} elseif ('home_page' == $afurd__all_roles) {

					wp_redirect(esc_url(home_url('/')));
					exit();

				} elseif ('default' == $afurd__all_roles) {

					wp_redirect(esc_url(admin_url()));
					exit();

				} elseif ('custom_url' == $afurd__all_roles) {

					wp_redirect(esc_url($afurd_custom_url_all_roles));
					exit();
				}
			} else {

				wp_redirect($redirect_to);
				exit();
			}

		}

	}

	new Addify_User_Redirect_Front();

}
