<?php
if (! defined('ABSPATH') ) {
	exit; // restict for direct access
}

if (!class_exists('Addify_User_Redirect_Admin') ) {

	class Addify_User_Redirect_Admin extends Addify_User_Redirect {

		public function __construct() {

			add_action('admin_menu', array( $this, 'afurd_custom_menu_admin' ));
			add_action( 'admin_enqueue_scripts', array( $this, 'afurd_admin_scripts' ) );
			add_action( 'init', array( $this, 'afurd_save_settings' ) );
			
		}

		public function afurd_custom_menu_admin() {

			add_submenu_page( 'woocommerce', esc_html__('User Redirect', 'addify-user-redirect'), esc_html__('User Redirect', 'addify-user-redirect'), 'manage_options', 'addify-user-redirect', array($this, 'afurd_settings') );
		}

		public function afurd_admin_scripts() {

			$screen = get_current_screen();

			if ('woocommerce_page_addify-user-redirect' == $screen->id) {

				wp_enqueue_script( 'jquery-ui', plugins_url( '/assets/js/jquery-ui.js', __FILE__ ), array('jquery'), '1.0'  );

				wp_enqueue_script('jquery-ui-tabs');
				

				wp_enqueue_style( 'afurd-admin', plugins_url( '/assets/css/afurd_admin.css', __FILE__ ), false, '1.0' );
				wp_enqueue_script( 'afurd-admin', plugins_url( '/assets/js/afurd_admin.js', __FILE__ ), false, '1.0' );
				
				wp_enqueue_script('parsley', plugins_url( '/assets/js/parsley.min.js', __FILE__ ), false, '1.0' );
				wp_enqueue_style('parsley', plugins_url( '/assets/css/parsley.css', __FILE__ ), false, '1.0' );
			}

		}

		public function afurd_save_settings() {

			if (isset($_POST['addify-user-redirect_save_settings']) && '' != $_POST['addify-user-redirect_save_settings']) {

				include_once ABSPATH . 'wp-includes/pluggable.php';
				
				if (!empty($_REQUEST['afurd_nonce_field'])) {

						$retrieved_nonce = sanitize_text_field($_REQUEST['afurd_nonce_field']);
				} else {
						$retrieved_nonce = 0;
				}

				if (!wp_verify_nonce($retrieved_nonce, 'afurd_nonce_action')) {

					die('Failed security check');
				}

				$this->afurd_save_data();

				add_action('admin_notices', array($this, 'afurd_author_admin_notice'));
			}

		}

		public function afurd_settings() {

			if (!empty(get_option('afurd_login_redirect_page_all_roles'))) {

				$afurd_login_redirect_page_all_roles = get_option('afurd_login_redirect_page_all_roles');
			} else {
				$afurd_login_redirect_page_all_roles = '';
			}

			if (!empty(get_option('afurd_login_redirect_custom_url_all_roles'))) {

				$afurd_login_redirect_custom_url_all_roles = get_option('afurd_login_redirect_custom_url_all_roles');
			} else {
				$afurd_login_redirect_custom_url_all_roles = '';
			}

			//Registration Redirect

			if (!empty(get_option('afurd_reg_redirect_page_all_roles'))) {

				$afurd_reg_redirect_page_all_roles = get_option('afurd_reg_redirect_page_all_roles');
			} else {
				$afurd_reg_redirect_page_all_roles = '';
			}

			if (!empty(get_option('afurd_reg_redirect_custom_url_all_roles'))) {

				$afurd_reg_redirect_custom_url_all_roles = get_option('afurd_reg_redirect_custom_url_all_roles');
			} else {
				$afurd_reg_redirect_custom_url_all_roles = '';
			}

			//Logout Redirect

			if (!empty(get_option('afurd_logout_redirect_page_all_roles'))) {

				$afurd_logout_redirect_page_all_roles = get_option('afurd_logout_redirect_page_all_roles');
			} else {
				$afurd_logout_redirect_page_all_roles = '';
			}

			if (!empty(get_option('afurd_logout_redirect_custom_url_all_roles'))) {

				$afurd_logout_redirect_custom_url_all_roles = get_option('afurd_logout_redirect_custom_url_all_roles');
			} else {
				$afurd_logout_redirect_custom_url_all_roles = '';
			}


			?>

			<div id="addify_settings_tabs">
				<div class="addify_setting_tab_ulli">
					<div class="addify-logo">
						<img src="<?php echo esc_url(AFURD_URL) . 'assets/img/addify-logo.png'; ?>" width="200">
						<h2>Addify</h2>
					</div>

					<ul>
						<li><a href="#tabs-1"><span class="dashicons dashicons-admin-tools"></span><?php echo esc_html__('Redirect After Login', 'addify-user-redirec'); ?></a></li>
						<li><a href="#tabs-2"><span class="dashicons dashicons-admin-tools"></span><?php echo esc_html__('Redirect After Registration', 'addify-user-redirec'); ?></a></li>
						<li><a href="#tabs-3"><span class="dashicons dashicons-admin-tools"></span><?php echo esc_html__('Redirect After Logout', 'addify-user-redirec'); ?></a></li>

					</ul>
				</div>

				<div class="addify-tabs-content">
					<form id="addify_setting_form" action="" method="post">
						<?php wp_nonce_field('afurd_nonce_action', 'afurd_nonce_field'); ?>
						<div class="addify-top-content">
							<h1><?php echo esc_html__('Addify User Redirect Module Settings', 'addify-user-redirect'); ?></h1>
						</div>

						<div class="addify-singletab" id="tabs-1">
							<h2><?php echo esc_html__('Redirect After Login Settings', 'addify-user-redirect'); ?></h2>

							<table class="addify-table-optoin">
								<tbody>
								<tr class="addify-option-field">
									
									<td>
										<?php

										global $wp_roles;
										$roles = $wp_roles->get_names();
										?>
										<div class="af_userroles">
											<b class="afurd_label_class"><?php echo esc_html__('All User Roles', 'addify-user-redirect'); ?>:</b>
											<input type="hidden" name="afurd_login_redirect_role_all_roles" id="afurd_login_redirect_role_all_roles" value="afurd_login_redirect_role_all_roles" />
											<select class="afurd_select_class" name="afurd_login_redirect_page_all_roles" id="afurd_login_redirect_page_all_roles" onchange="getLoginAllUserRole(this.value);">
												<option value=""><?php echo esc_html__('---Select Page---', 'addify-user-redirect'); ?></option>
												<option value="default" <?php echo selected('default', esc_attr($afurd_login_redirect_page_all_roles)); ?>><?php echo esc_html__('Default(My Account)', 'addify-user-redirect'); ?></option>
												<option value="same_page" <?php echo selected('same_page', esc_attr($afurd_login_redirect_page_all_roles)); ?>><?php echo esc_html__('Previous URL', 'addify-user-redirect'); ?></option>
												<option value="home_page" <?php echo selected('home_page', esc_attr($afurd_login_redirect_page_all_roles)); ?>><?php echo esc_html__('Home Page', 'addify-user-redirect'); ?></option>
												<option value="custom_url" <?php echo selected('custom_url', esc_attr($afurd_login_redirect_page_all_roles)); ?>><?php echo esc_html__('Custom URL', 'addify-user-redirect'); ?></option>
											</select>
											<input value="<?php echo esc_attr($afurd_login_redirect_custom_url_all_roles); ?>" class="afurd_input_class" type="text" placeholder="<?php echo esc_html__('Enter URL(http://www.example.com)', 'addify-user-redirect'); ?>" name="afurd_login_redirect_custom_url_all_roles" id="afurd_login_redirect_custom_url_all_roles" />
										</div>

										<?php 
										foreach ($roles as $key => $value) {

											if (!empty(get_option('afurd_login_redirect_page_' . $key))) {

												$afurd_login_redirect_page = get_option('afurd_login_redirect_page_' . $key);
											} else {
												$afurd_login_redirect_page = '';
											}

											if (!empty(get_option('afurd_login_redirect_custom_url_' . $key))) {

												$afurd_login_redirect_custom_url = get_option('afurd_login_redirect_custom_url_' . $key);
											} else {
												$afurd_login_redirect_custom_url = '';
											}

											?>

											<div class="af_userroles">
												<b class="afurd_label_class"><?php echo esc_attr($value); ?>:</b>
												<input type="hidden" name="afurd_login_redirect_role_<?php echo esc_attr($key); ?>" id="afurd_login_redirect_role_<?php echo esc_attr($key); ?>" value="afurd_login_redirect_role_<?php echo esc_attr($key); ?>" />
												<select class="afurd_select_class" name="afurd_login_redirect_page_<?php echo esc_attr($key); ?>" id="afurd_login_redirect_page_<?php echo esc_attr($key); ?>" onchange="getLoginSelectedUserRole(this.value, '<?php echo esc_attr($key); ?>');">
													<option value=""><?php echo esc_html__('---Select Page---', 'addify-user-redirect'); ?></option>
													<option value="default" <?php echo selected('default', esc_attr($afurd_login_redirect_page)); ?>><?php echo esc_html__('Default(My Account)', 'addify-user-redirect'); ?></option>
													<option value="same_page" <?php echo selected('same_page', esc_attr($afurd_login_redirect_page)); ?>><?php echo esc_html__('Previous URL', 'addify-user-redirect'); ?></option>
													<option value="home_page" <?php echo selected('home_page', esc_attr($afurd_login_redirect_page)); ?>><?php echo esc_html__('Home Page', 'addify-user-redirect'); ?></option>
													<option value="custom_url" <?php echo selected('custom_url', esc_attr($afurd_login_redirect_page)); ?>><?php echo esc_html__('Custom URL', 'addify-user-redirect'); ?></option>
												</select>
												<input value="<?php echo esc_attr($afurd_login_redirect_custom_url); ?>" class="afurd_input_class" type="text" placeholder="<?php echo esc_html__('Enter URL(http://www.example.com)', 'addify-user-redirect'); ?>" name="afurd_login_redirect_custom_url_<?php echo esc_attr($key); ?>" id="afurd_login_redirect_custom_url_<?php echo esc_attr($key); ?>" />
											</div>

											<script>
												jQuery(document).ready(function($) {

													"use strict";

													var value = $("#afurd_login_redirect_page_<?php echo esc_attr($key); ?> option:selected").val();
													if(value == 'custom_url') {

														jQuery("#afurd_login_redirect_custom_url_<?php echo esc_attr($key); ?>").show();
													} else {
														jQuery("#afurd_login_redirect_custom_url_<?php echo esc_attr($key); ?>").hide();
													}
												});
											</script>

										<?php } ?>

									</td>
								</tr>
								</tbody>
							</table>
						</div>

						<div class="addify-singletab" id="tabs-2">

							<h2><?php echo esc_html__('Redirect After Registration Settings', 'addify-user-redirect'); ?></h2>

							

							<table class="addify-table-optoin">
								<tbody>
								<tr class="addify-option-field">
									
									<td>
										<?php

										global $wp_roles;
										$roles = $wp_roles->get_names();
										?>
										<div class="af_userroles">
											<b class="afurd_label_class"><?php echo esc_html__('All User Roles', 'addify-user-redirect'); ?>:</b>
											<input type="hidden" name="afurd_reg_redirect_role_all_roles" id="afurd_reg_redirect_role_all_roles" value="afurd_reg_redirect_role_all_roles" />
											<select class="afurd_select_class" name="afurd_reg_redirect_page_all_roles" id="afurd_reg_redirect_page_all_roles" onchange="getRegAllUserRole(this.value);">
												<option value=""><?php echo esc_html__('---Select Page---', 'addify-user-redirect'); ?></option>
												<option value="default" <?php echo selected('default', esc_attr($afurd_reg_redirect_page_all_roles)); ?>><?php echo esc_html__('Default(My Account)', 'addify-user-redirect'); ?></option>
												<option value="same_page" <?php echo selected('same_page', esc_attr($afurd_reg_redirect_page_all_roles)); ?>><?php echo esc_html__('Previous URL', 'addify-user-redirect'); ?></option>
												<option value="home_page" <?php echo selected('home_page', esc_attr($afurd_reg_redirect_page_all_roles)); ?>><?php echo esc_html__('Home Page', 'addify-user-redirect'); ?></option>
												<option value="custom_url" <?php echo selected('custom_url', esc_attr($afurd_reg_redirect_page_all_roles)); ?>><?php echo esc_html__('Custom URL', 'addify-user-redirect'); ?></option>
											</select>
											<input value="<?php echo esc_attr($afurd_reg_redirect_custom_url_all_roles); ?>" class="afurd_input_class" type="text" placeholder="<?php echo esc_html__('Enter URL(http://www.example.com)', 'addify-user-redirect'); ?>" name="afurd_reg_redirect_custom_url_all_roles" id="afurd_reg_redirect_custom_url_all_roles" />
										</div>

										<?php 
										foreach ($roles as $key => $value) {

											if (!empty(get_option('afurd_reg_redirect_page_' . $key))) {

												$afurd_reg_redirect_page = get_option('afurd_reg_redirect_page_' . $key);
											} else {
												$afurd_reg_redirect_page = '';
											}

											if (!empty(get_option('afurd_reg_redirect_custom_url_' . $key))) {

												$afurd_reg_redirect_custom_url = get_option('afurd_reg_redirect_custom_url_' . $key);
											} else {
												$afurd_reg_redirect_custom_url = '';
											}

											?>

											<div class="af_userroles">
												<b class="afurd_label_class"><?php echo esc_attr($value); ?>:</b>
												<input type="hidden" name="afurd_reg_redirect_role_<?php echo esc_attr($key); ?>" id="afurd_reg_redirect_role_<?php echo esc_attr($key); ?>" value="afurd_reg_redirect_role_<?php echo esc_attr($key); ?>" />
												<select class="afurd_select_class" name="afurd_reg_redirect_page_<?php echo esc_attr($key); ?>" id="afurd_reg_redirect_page_<?php echo esc_attr($key); ?>" onchange="getRegSelectedUserRole(this.value, '<?php echo esc_attr($key); ?>');">
													<option value=""><?php echo esc_html__('---Select Page---', 'addify-user-redirect'); ?></option>
													<option value="default" <?php echo selected('default', esc_attr($afurd_reg_redirect_page)); ?>><?php echo esc_html__('Default(My Account)', 'addify-user-redirect'); ?></option>
													<option value="same_page" <?php echo selected('same_page', esc_attr($afurd_reg_redirect_page)); ?>><?php echo esc_html__('Previous URL', 'addify-user-redirect'); ?></option>
													<option value="home_page" <?php echo selected('home_page', esc_attr($afurd_reg_redirect_page)); ?>><?php echo esc_html__('Home Page', 'addify-user-redirect'); ?></option>
													<option value="custom_url" <?php echo selected('custom_url', esc_attr($afurd_reg_redirect_page)); ?>><?php echo esc_html__('Custom URL', 'addify-user-redirect'); ?></option>
												</select>
												<input value="<?php echo esc_attr($afurd_reg_redirect_custom_url); ?>" class="afurd_input_class" type="text" placeholder="<?php echo esc_html__('Enter URL(http://www.example.com)', 'addify-user-redirect'); ?>" name="afurd_reg_redirect_custom_url_<?php echo esc_attr($key); ?>" id="afurd_reg_redirect_custom_url_<?php echo esc_attr($key); ?>" />
											</div>

											<script>
												jQuery(document).ready(function($) {

													"use strict";

													var value = $("#afurd_login_redirect_page_<?php echo esc_attr($key); ?> option:selected").val();
													if(value == 'custom_url') {

														jQuery("#afurd_login_redirect_custom_url_<?php echo esc_attr($key); ?>").show();
													} else {
														jQuery("#afurd_login_redirect_custom_url_<?php echo esc_attr($key); ?>").hide();
													}
												});
											</script>

											<script>
												jQuery(document).ready(function($) {

													"use strict";

													var value = $("#afurd_reg_redirect_page_<?php echo esc_attr($key); ?> option:selected").val();
													if(value == 'custom_url') {

														jQuery("#afurd_reg_redirect_custom_url_<?php echo esc_attr($key); ?>").show();
													} else {
														jQuery("#afurd_reg_redirect_custom_url_<?php echo esc_attr($key); ?>").hide();
													}
												});
											</script>

										<?php } ?>

									</td>
								</tr>
								</tbody>
							</table>

						</div>
						<div class="addify-singletab" id="tabs-3">

							<h2><?php echo esc_html__('Redirect After Logout Settings', 'addify-user-redirect'); ?></h2>
							<h4><?php echo esc_html__('Note:', 'addify-user-redirect'); ?></h4>
							<p><?php echo esc_html__('Previous URL is not available as an option for Logout due to technical Issues.', 'addify-user-redirect'); ?></p>
							<table class="addify-table-optoin">
								<tbody>
								<tr class="addify-option-field">
									
									<td>
										<?php

										global $wp_roles;
										$roles = $wp_roles->get_names();
										?>
										<div class="af_userroles">
											<b class="afurd_label_class"><?php echo esc_html__('All User Roles', 'addify-user-redirect'); ?>:</b>
											<input type="hidden" name="afurd_logout_redirect_role_all_roles" id="afurd_logout_redirect_role_all_roles" value="afurd_logout_redirect_role_all_roles" />
											<select class="afurd_select_class" name="afurd_logout_redirect_page_all_roles" id="afurd_logout_redirect_page_all_roles" onchange="getLogoutAllUserRole(this.value);">
												<option value=""><?php echo esc_html__('---Select Page---', 'addify-user-redirect'); ?></option>
												<option value="default" <?php echo selected('default', esc_attr($afurd_logout_redirect_page_all_roles)); ?>><?php echo esc_html__('Default(My Account)', 'addify-user-redirect'); ?></option>
												 
												<option value="home_page" <?php echo selected('home_page', esc_attr($afurd_logout_redirect_page_all_roles)); ?>><?php echo esc_html__('Home Page', 'addify-user-redirect'); ?></option>
												<option value="custom_url" <?php echo selected('custom_url', esc_attr($afurd_logout_redirect_page_all_roles)); ?>><?php echo esc_html__('Custom URL', 'addify-user-redirect'); ?></option>
											</select>
											<input value="<?php echo esc_attr($afurd_logout_redirect_custom_url_all_roles); ?>" class="afurd_input_class" type="text" placeholder="<?php echo esc_html__('Enter URL(http://www.example.com)', 'addify-user-redirect'); ?>" name="afurd_logout_redirect_custom_url_all_roles" id="afurd_logout_redirect_custom_url_all_roles" />
										</div>

										<?php 
										foreach ($roles as $key => $value) {

											if (!empty(get_option('afurd_logout_redirect_page_' . $key))) {

												$afurd_logout_redirect_page = get_option('afurd_logout_redirect_page_' . $key);
											} else {
												$afurd_logout_redirect_page = '';
											}

											if (!empty(get_option('afurd_logout_redirect_custom_url_' . $key))) {

												$afurd_logout_redirect_custom_url = get_option('afurd_logout_redirect_custom_url_' . $key);
											} else {
												$afurd_logout_redirect_custom_url = '';
											}

											?>

											<div class="af_userroles">
												<b class="afurd_label_class"><?php echo esc_attr($value); ?>:</b>
												<input type="hidden" name="afurd_logout_redirect_role_<?php echo esc_attr($key); ?>" id="afurd_logout_redirect_role_<?php echo esc_attr($key); ?>" value="afurd_logout_redirect_role_<?php echo esc_attr($key); ?>" />
												<select class="afurd_select_class" name="afurd_logout_redirect_page_<?php echo esc_attr($key); ?>" id="afurd_logout_redirect_page_<?php echo esc_attr($key); ?>" onchange="getLogoutSelectedUserRole(this.value, '<?php echo esc_attr($key); ?>');">
													<option value=""><?php echo esc_html__('---Select Page---', 'addify-user-redirect'); ?></option>
													<option value="default" <?php echo selected('default', esc_attr($afurd_logout_redirect_page)); ?>><?php echo esc_html__('Default(My Account)', 'addify-user-redirect'); ?></option>
													
													<option value="home_page" <?php echo selected('home_page', esc_attr($afurd_logout_redirect_page)); ?>><?php echo esc_html__('Home Page', 'addify-user-redirect'); ?></option>
													<option value="custom_url" <?php echo selected('custom_url', esc_attr($afurd_logout_redirect_page)); ?>><?php echo esc_html__('Custom URL', 'addify-user-redirect'); ?></option>
												</select>
												<input value="<?php echo esc_attr($afurd_logout_redirect_custom_url); ?>" class="afurd_input_class" type="text" placeholder="<?php echo esc_html__('Enter URL(http://www.example.com)', 'addify-user-redirect'); ?>" name="afurd_logout_redirect_custom_url_<?php echo esc_attr($key); ?>" id="afurd_logout_redirect_custom_url_<?php echo esc_attr($key); ?>" />
											</div>

											<script>
												jQuery(document).ready(function($) {

													"use strict";

													var value = $("#afurd_login_redirect_page_<?php echo esc_attr($key); ?> option:selected").val();
													if(value == 'custom_url') {

														jQuery("#afurd_login_redirect_custom_url_<?php echo esc_attr($key); ?>").show();
													} else {
														jQuery("#afurd_login_redirect_custom_url_<?php echo esc_attr($key); ?>").hide();
													}
												});
											</script>

											<script>
												jQuery(document).ready(function($) {

													"use strict";

													var value = $("#afurd_reg_redirect_page_<?php echo esc_attr($key); ?> option:selected").val();
													if(value == 'custom_url') {

														jQuery("#afurd_reg_redirect_custom_url_<?php echo esc_attr($key); ?>").show();
													} else {
														jQuery("#afurd_reg_redirect_custom_url_<?php echo esc_attr($key); ?>").hide();
													}
												});
											</script>

											<script>
												jQuery(document).ready(function($) {

													"use strict";

													var value = $("#afurd_logout_redirect_page_<?php echo esc_attr($key); ?> option:selected").val();
													if(value == 'custom_url') {

														jQuery("#afurd_logout_redirect_custom_url_<?php echo esc_attr($key); ?>").show();
													} else {
														jQuery("#afurd_logout_redirect_custom_url_<?php echo esc_attr($key); ?>").hide();
													}
												});
											</script>

										<?php } ?>

									</td>
								</tr>
								</tbody>
							</table>

						</div>

						<?php submit_button(esc_html__('Save Settings', 'addify-user-redirect' ), 'primary', 'addify-user-redirect_save_settings'); ?>

					</form>
				</div>

			</div>

			<?php 
		}

		public function afurd_save_data() {

			global $wp;

			if (!empty($_POST)) {

				if (!empty($_REQUEST['afurd_nonce_field'])) {

						$retrieved_nonce = sanitize_text_field($_REQUEST['afurd_nonce_field']);
				} else {
						$retrieved_nonce = 0;
				}

				if (!wp_verify_nonce($retrieved_nonce, 'afurd_nonce_action')) {

					die('Failed security check');
				}

				foreach ($_POST as $key => $value) {

					if ( 'addify-user-redirect_save_settings' != $key) {
						update_option(esc_attr($key), esc_attr($value));
					}
				}
			}
		}

		public function afurd_author_admin_notice() { 
			?>
			<div class="updated notice notice-success is-dismissible">
				<p><?php echo esc_html__('Settings saved successfully.', 'addify-user-redirect'); ?></p>
			</div>
			<?php 
		}

	}

	new Addify_User_Redirect_Admin();

}
