<?php
/**
 * Plugin Name:       Redirect After Login, Registration & Logout
 * Plugin URI:        https://woocommerce.com/products/redirect-after-login-registration-logout
 * Description:       Redirect user after login, registration and logout. (PLEASE TAKE BACKUP BEFORE UPDATING THE PLUGIN).
 * Version:           1.1.5
 * Author:            Addify
 * Developed By:      Addify
 * Author URI:        http://www.addifypro.com
 * Support:                http://www.addifypro.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       addify-user-redirect
 *
 * Woo: 5253507:449fa87236e10cee7adc3d8dbf7f5201
 * WC requires at least: 3.0.9
 * WC tested up to: 5.*.*
 */

if (! defined('WPINC') ) {
	die;
}

if (!class_exists('Addify_User_Redirect') ) {

	class Addify_User_Redirect {

		public function __construct() {

			$this->afurd_global_constents_vars();
			add_action('wp_loaded', array( $this, 'afurd_init' ));
			if (is_admin() ) {
				include_once AFURD_PLUGIN_DIR . 'class-afurd-admin.php';
			} else {
				include_once AFURD_PLUGIN_DIR . 'class-afurd-front.php';
			}
		}

		public function afurd_global_constents_vars() {

			if (!defined('AFURD_URL') ) {
				define('AFURD_URL', plugin_dir_url(__FILE__));
			}

			if (!defined('AFURD_BASENAME') ) {
				define('AFURD_BASENAME', plugin_basename(__FILE__));
			}

			if (! defined('AFURD_PLUGIN_DIR') ) {
				define('AFURD_PLUGIN_DIR', plugin_dir_path(__FILE__));
			}
		}

		public function afurd_init() {

			if (function_exists('load_plugin_textdomain') ) {
				load_plugin_textdomain('addify-user-redirect', false, dirname(plugin_basename(__FILE__)) . '/languages/');
			}
		}

	}

	new Addify_User_Redirect();

}
