<?php if (!defined('ABSPATH')) die('Access denied.'); ?>
<div class="postbox aio_hidden" data-template="wordpress-forms">
	<h3 class="hndle"><label for="title"><?php _e('Wordpress forms CAPTCHA settings', 'all-in-one-wp-security-and-firewall'); ?></label></h3>
	<div class="inside">
		<div id="user-login-captcha-badge">
		<?php
		// Display security info badge
		$aiowps_feature_mgr->output_feature_details_badge("user-login-captcha");
		?>
		</div>
		<table class="form-table">
			<tr valign="top">
				<th scope="row"><?php _e('Enable CAPTCHA on login page', 'all-in-one-wp-security-and-firewall'); ?>:</th>
				<td>
					<div class="aiowps_switch_container">
						<?php AIOWPSecurity_Utility_UI::setting_checkbox(__('Enable this if you want to insert a CAPTCHA form on the login page.', 'all-in-one-wp-security-and-firewall'), 'aiowps_enable_login_captcha', '1' == $aio_wp_security->configs->get_value('aiowps_enable_login_captcha')); ?>
					</div>
				</td>
			</tr>
		</table>
	</div>
	<div class="inside">
		<div id="user-registration-captcha-badge">
		<?php
		// Display security info badge
		$aiowps_feature_mgr->output_feature_details_badge("user-registration-captcha");
		?>
		</div>
		<table class="form-table">
			<tr valign="top">
				<th scope="row"><?php _e('Enable CAPTCHA on registration page', 'all-in-one-wp-security-and-firewall'); ?>:</th>
				<td>
					<div class="aiowps_switch_container">
						<?php AIOWPSecurity_Utility_UI::setting_checkbox(__('Enable this if you want to insert a CAPTCHA form on the WordPress user registration page (if you allow user registration).', 'all-in-one-wp-security-and-firewall'), 'aiowps_enable_registration_page_captcha', '1' == $aio_wp_security->configs->get_value('aiowps_enable_registration_page_captcha')); ?>
					</div>
				</td>
			</tr>
		</table>
	</div>
	<div class="inside">
		<div id="lost-password-captcha-badge">
		<?php
		//Display security info badge
		global $aiowps_feature_mgr;
		$aiowps_feature_mgr->output_feature_details_badge("lost-password-captcha");
		?>
		</div>
		<table class="form-table">
			<tr valign="top">
				<th scope="row"><?php _e('Enable CAPTCHA on lost password page', 'all-in-one-wp-security-and-firewall'); ?>:</th>
				<td>
					<div class="aiowps_switch_container">
						<?php AIOWPSecurity_Utility_UI::setting_checkbox(__('Enable this if you want to insert a CAPTCHA form on the lost password page.', 'all-in-one-wp-security-and-firewall'), 'aiowps_enable_lost_password_captcha', '1' == $aio_wp_security->configs->get_value('aiowps_enable_lost_password_captcha')); ?>
					</div>
				</td>
			</tr>
		</table>
	</div>
	<div class="inside">
		<div id="custom-login-captcha-badge">
		<?php
		//Display security info badge
		global $aiowps_feature_mgr;
		$aiowps_feature_mgr->output_feature_details_badge("custom-login-captcha");
		?>
		</div>
		<table class="form-table">
			<tr valign="top">
				<th scope="row"><?php _e('Enable CAPTCHA on custom login form', 'all-in-one-wp-security-and-firewall'); ?>:</th>
				<td>
					<div class="aiowps_switch_container">
						<?php AIOWPSecurity_Utility_UI::setting_checkbox(sprintf(__('Enable this if you want to insert CAPTCHA on a custom login form generated by the following WP function: %s', 'all-in-one-wp-security-and-firewall'), 'wp_login_form()'), 'aiowps_enable_custom_login_captcha', '1' == $aio_wp_security->configs->get_value('aiowps_enable_custom_login_captcha')); ?>
					</div>
				</td>
			</tr>
		</table>
	</div>
	<div class="inside">
		<div id="comment-form-captcha-badge">
		<?php
		// Display security info badge
		$aiowps_feature_mgr->output_feature_details_badge("comment-form-captcha");
		?>
		</div>
		<table class="form-table">
			<tr valign="top">
				<th scope="row"><?php _e('Enable CAPTCHA on comment forms', 'all-in-one-wp-security-and-firewall'); ?>:</th>
				<td>
					<div class="aiowps_switch_container">
						<?php AIOWPSecurity_Utility_UI::setting_checkbox(__('Enable this if you want to insert a CAPTCHA field on the comment forms.', 'all-in-one-wp-security-and-firewall'), 'aiowps_enable_comment_captcha', '1' == $aio_wp_security->configs->get_value('aiowps_enable_comment_captcha')); ?>
					</div>
				</td>
			</tr>
		</table>
	</div>
	<div class="inside">
		<div id="password_protected-captcha-badge">
		<?php
		// Display security info badge
		$aiowps_feature_mgr->output_feature_details_badge("password_protected-captcha");
		?>
		</div>
		<table class="form-table">
			<tr valign="top">
				<th scope="row"><?php _e('Enable CAPTCHA on password protected pages/posts', 'all-in-one-wp-security-and-firewall'); ?>:</th>
				<td>
					<div class="aiowps_switch_container">
						<?php AIOWPSecurity_Utility_UI::setting_checkbox(__('Enable this if you want to insert a CAPTCHA field on password-protected posts and pages.', 'all-in-one-wp-security-and-firewall'), 'aiowps_enable_password_protected_captcha', '1' == $aio_wp_security->configs->get_value('aiowps_enable_password_protected_captcha')); ?>
					</div>
				</td>
			</tr>
		</table>
	</div>
</div>
