<?php 
// ---------------------------------------------------------------
//	General Woocommerce
// ---------------------------------------------------------------
// Add woocommerce theme support
add_theme_support( 'woocommerce' );

function pagels_ponderosa_shop_page_redirect() {
    if( is_shop() ){
        wp_redirect( home_url( '/store/' ) );
        exit();
    }
}
add_action( 'template_redirect', 'pagels_ponderosa_shop_page_redirect' );


// Remove breadcrumbs from shop & categories
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);

function pagels_ponderosa_replace_add_to_cart_button( $button, $product ) {
	if (is_product_category() || is_shop()) {
		$button_text = __("View Product", "woocommerce");
		$button_link = $product->get_permalink();
		$button = '<a href="' . $button_link . '" class="button alt">' . $button_text . '</a>';
		return $button;
	}
}
add_filter( 'woocommerce_loop_add_to_cart_link', 'pagels_ponderosa_replace_add_to_cart_button', 10, 2 );

// ---------------------------------------------------------------
//	Single Product Page
// ---------------------------------------------------------------
// Remove the Sidebar
function pagels_ponderosa_remove_sidebar_product_pages() {
	if ( is_product() ) {
	remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
	}
}
add_action( 'wp', 'pagels_ponderosa_remove_sidebar_product_pages' );


// Move the product title on single product pages
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5); 
add_action('woocommerce_before_single_product', 'woocommerce_template_single_title', 5);


// Add wrapper div opener to title
function before_the_title() {
    echo "<header class='entry-header'>";
}
add_action ( "woocommerce_before_single_product", "before_the_title", 1 );


// Add wrapper div closer to title
function after_the_title() {
    echo "</header>";
}
add_action ( "woocommerce_before_single_product", "after_the_title", 6 );


// Remove related product from single product page
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );


// Flip position of summary and price on single product page
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 20 );


// Remove the tabbed interface from single product page
function pagels_ponderosa_remove_product_tabs($tabs) {
	unset($tabs['description']);     			// Remove Description tab
	unset($tabs['additional_information']);  	// Remove Additional Information tab
	unset($tabs['reviews']); 					// Remove Reviews tab

	return $tabs;
}
add_filter( 'woocommerce_product_tabs', 'pagels_ponderosa_remove_product_tabs', 98 );


// Remove SKU from single product page
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );


// Add label above input
function pagels_ponderosa_echo_qty_front_add_cart() {
 echo '<div class="label-qty">Quantity </div>'; 
}
add_action( 'woocommerce_before_add_to_cart_quantity', 'pagels_ponderosa_echo_qty_front_add_cart' );


// ---------------------------------------------------------------
//	Shop Page
// ---------------------------------------------------------------
// Remove the shop title from template
function pagels_ponderosa_hide_shop_page_title( $title ) {
	if ( is_shop() ) $title = false;
	return $title;
 }
 add_filter( 'woocommerce_show_page_title', 'pagels_ponderosa_hide_shop_page_title' );
 

 // ---------------------------------------------------------------
//	Archive Page
// ---------------------------------------------------------------
// Move the product title on single product pages

//remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
// remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title' );
// add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_title', 5 );

// remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
// add_action('woocommerce_before_single_product', 'woocommerce_template_single_title', 5);


// Add wrapper div opener to title
function before_the_loop() {
	echo "<div class='products-wrapper'>";
	echo "<div class='tools'>";
}
add_action ( "woocommerce_before_shop_loop", "before_the_loop", 1 );

// Add wrapper div opener to title
function before_the_loop_end() {
	echo "</div>";
}
add_action ( "woocommerce_before_shop_loop", "before_the_loop_end", 50 );

// Add wrapper div closer to title
function after_the_loop() {
    echo "</div>";
}
add_action ( "woocommerce_after_shop_loop", "after_the_loop", 1 );


// ---------------------------------------------------------------
//	Cart Page
// ---------------------------------------------------------------
function cart_header() {
	echo "<header class='shopping-cart-header'>";
		echo "<h1 class='shopping-cart-header__title page-title'>Cart</h1>";
	echo "</header>";
}
add_action ( "woocommerce_before_cart", "cart_header", 1 );

// ---------------------------------------------------------------
//	Checkout Page
// ---------------------------------------------------------------
function checkout_header() {
	echo "<header class='shopping-cart-header'>";
		echo "<h1 class='shopping-cart-header__title page-title'>Checkout</h1>";
	echo "</header>";
}
add_action ( "woocommerce_before_checkout_form", "checkout_header", 1 );