<?php

/**
 * Set up a WP-Admin page for managing turning on and off theme features.
 */
function pagels_ponderosa_add_options_page()
{
	add_theme_page(
		'Theme Options',
		'Theme Options',
		'manage_options',
		'pagels_ponderosa-options',
		'pagels_ponderosa_options_page'
	);

	// Call register settings function
	add_action('admin_init', 'pagels_ponderosa_options');
}
add_action('admin_menu', 'pagels_ponderosa_add_options_page');


/**
 * Register settings for the WP-Admin page.
 */
function pagels_ponderosa_options()
{
	register_setting('pagels_ponderosa-options', 'pagels_ponderosa-align-wide', array('default' => 1));
	register_setting('pagels_ponderosa-options', 'pagels_ponderosa-wp-block-styles', array('default' => 1));
	register_setting('pagels_ponderosa-options', 'pagels_ponderosa-editor-color-palette', array('default' => 1));
	register_setting('pagels_ponderosa-options', 'pagels_ponderosa-dark-mode');
	register_setting('pagels_ponderosa-options', 'pagels_ponderosa-responsive-embeds', array('default' => 1));
}


/**
 * Build the WP-Admin settings page.
 */
function pagels_ponderosa_options_page()
{ ?>
	<div class="wrap">
		<h1><?php _e('Gutenberg Starter Theme Options', 'pagels_ponderosa'); ?></h1>
		<form method="post" action="options.php">
			<?php settings_fields('pagels_ponderosa-options'); ?>
			<?php do_settings_sections('pagels_ponderosa-options'); ?>

			<table class="form-table">
				<tr valign="top">
					<td>
						<label>
							<input name="pagels_ponderosa-align-wide" type="checkbox" value="1" <?php checked('1', get_option('pagels_ponderosa-align-wide')); ?> />
							<?php _e('Enable wide and full alignments.', 'pagels_ponderosa'); ?>
							(<a href="https://developer.wordpress.org/block-editor/developers/themes/theme-support/#wide-alignment"><code>align-wide</code></a>)
						</label>
					</td>
				</tr>
				<tr valign="top">
					<td>
						<label>
							<input name="pagels_ponderosa-editor-color-palette" type="checkbox" value="1" <?php checked('1', get_option('pagels_ponderosa-editor-color-palette')); ?> />
							<?php _e('Enable a custom theme color palette.', 'pagels_ponderosa'); ?>
							(<a href="https://developer.wordpress.org/block-editor/developers/themes/theme-support/#block-color-palettes"><code>editor-color-palette</code></a>)
						</label>
					</td>
				</tr>
				<tr valign="top">
					<td>
						<label>
							<input name="pagels_ponderosa-dark-mode" type="checkbox" value="1" <?php checked('1', get_option('pagels_ponderosa-dark-mode')); ?> />
							<?php _e('Enable a dark theme style.', 'pagels_ponderosa'); ?>
							(<a href="https://developer.wordpress.org/block-editor/developers/themes/theme-support/#dark-backgrounds"><code>dark-editor-style</code></a>)
						</label>
					</td>
				</tr>
				<tr valign="top">
					<td>
						<label>
							<input name="pagels_ponderosa-wp-block-styles" type="checkbox" value="1" <?php checked('1', get_option('pagels_ponderosa-wp-block-styles')); ?> />
							<?php _e('Enable core block styles on the front end.', 'pagels_ponderosa'); ?>
							(<a href="https://developer.wordpress.org/block-editor/developers/themes/theme-support/#default-block-styles"><code>wp-block-styles</code></a>)
						</label>
					</td>
				</tr>
				<tr valign="top">
					<td>
						<label>
							<input name="pagels_ponderosa-responsive-embeds" type="checkbox" value="1" <?php checked('1', get_option('pagels_ponderosa-responsive-embeds')); ?> />
							<?php _e('Enable responsive embedded content.', 'pagels_ponderosa'); ?>
							(<a href="https://developer.wordpress.org/block-editor/developers/themes/theme-support/#responsive-embedded-content"><code>responsive-embeds</code></a>)
						</label>
					</td>
				</tr>
			</table>

			<?php submit_button(); ?>
		</form>
	</div>
<?php }


/**
 * Enable alignwide and alignfull support if the pagels_ponderosa-align-wide setting is active.
 */
function pagels_ponderosa_enable_align_wide()
{

	if (get_option('pagels_ponderosa-align-wide', 1) == 1) {

		// Add support for full and wide align images.
		add_theme_support('align-wide');
	}
}
add_action('after_setup_theme', 'pagels_ponderosa_enable_align_wide');

/**
 * Enable custom text line-heights.
 */
function pagels_ponderosa_enable_custom_line_height()
{

	if (get_option('pagels-ponderosa-line-height', 1) == 1) {

		// Add support for custom line heights.
		add_theme_support( 'custom-line-height' );
	}
}
add_action('after_setup_theme', 'pagels_ponderosa_enable_custom_line_height');


/**
 * Enable custom units.
 */
function pagels_ponderosa_enable_custom_units()
{

	if (get_option('pagels-ponderosa-custom-units', 1) == 1) {

		// Add support for custom units.
		add_theme_support( 'custom-units' );
	}
}
add_action('after_setup_theme', 'pagels_ponderosa_enable_custom_units');


/**
 * Enable custom theme colors if the pagels_ponderosa-editor-color-palette setting is active.
 */
function pagels_ponderosa_enable_editor_color_palette()
{
	if (get_option('pagels_ponderosa-editor-color-palette', 1) == 1) {

		// Add support for a custom color scheme.
		add_theme_support('editor-color-palette', array(
			array(
				'name'  => __('Red', 'pagels_ponderosa'),
				'slug'  => 'red',
				'color' => 'hsl(1, 62%, 38%)',
			),
			array(
				'name'  => __('Blue', 'pagels_ponderosa'),
				'slug'  => 'blue',
				'color' => 'hsl(206, 48%, 18%)',
			),
			array(
				'name'  => __('Orange', 'pagels_ponderosa'),
				'slug'  => 'orange',
				'color' => 'hsl(19, 76%, 54%)',
			),
			array(
				'name'  => __('White', 'pagels_ponderosa'),
				'slug'  => 'white',
				'color' => 'hsl(0, 0%, 100%)',
			),
			array(
				'name'  => __('Black', 'pagels_ponderosa'),
				'slug'  => 'black',
				'color' => 'hsl(0, 0%, 0%)',
			),
		));
	}
}
add_action('after_setup_theme', 'pagels_ponderosa_enable_editor_color_palette');


/**
 * Enable dark mode if pagels_ponderosa-dark-mode setting is active.
 */
function pagels_ponderosa_enable_dark_mode()
{
	if (get_option('pagels_ponderosa-dark-mode') == 1) {

		// Add support for editor styles.
		add_theme_support('editor-styles');
		add_editor_style('style-editor-dark.css');

		// Add support for dark styles.
		add_theme_support('dark-editor-style');
	}
}
add_action('after_setup_theme', 'pagels_ponderosa_enable_dark_mode');


/**
 * Enable dark mode on the front end if pagels_ponderosa-dark-mode setting is active.
 */
function pagels_ponderosa_enable_dark_mode_frontend_styles()
{
	if (get_option('pagels_ponderosa-dark-mode') == 1) {
		wp_enqueue_style('pagels_ponderosadark-style', get_template_directory_uri() . '/css/dark-mode.css');
	}
}
add_action('wp_enqueue_scripts', 'pagels_ponderosa_enable_dark_mode_frontend_styles');

/**
 * Enable core block styles support if the pagels_ponderosa-wp-block-styles setting is active.
 */
function pagels_ponderosa_enable_wp_block_styles()
{

	if (get_option('pagels_ponderosa-wp-block-styles', 1) == 1) {

		// Adding support for core block visual styles.
		add_theme_support('wp-block-styles');
	}
}
add_action('after_setup_theme', 'pagels_ponderosa_enable_wp_block_styles');


/**
 * Enable responsive embedded content if the pagels_ponderosa-responsive-embeds setting is active.
 */
function pagels_ponderosa_enable_responsive_embeds()
{

	if (get_option('pagels_ponderosa-responsive-embeds', 1) == 1) {

		// Adding support for responsive embedded content.
		add_theme_support('responsive-embeds');
	}
}
add_action('after_setup_theme', 'pagels_ponderosa_enable_responsive_embeds');


/**
 * Turn off WP lazy image loading
 */
add_filter( 'wp_lazy_loading_enabled', '__return_false' );


/**
 * Turn off the linking of products in the cart
 */
add_filter( 'woocommerce_cart_item_permalink', '__return_null' );