<?php

/**
 * pagels_ponderosa functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package pagels_ponderosa
 */

if (!function_exists('pagels_ponderosa_setup')) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function pagels_ponderosa_setup()
	{
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on pagels_ponderosa, use a find and replace
		 * to change 'pagels_ponderosa' to the name of your theme in all the template files.
		 */
		load_theme_textdomain('pagels_ponderosa', get_template_directory() . '/languages');

		// Add default posts and comments RSS feed links to head.
		add_theme_support('automatic-feed-links');

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support('title-tag');

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support('post-thumbnails');

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(array(
			'menu-1' => esc_html__('Primary', 'pagels_ponderosa'),
			'menu-2' => esc_html__('Secondary', 'pagels_ponderosa'),
			'menu-3' => esc_html__('Footer', 'pagels_ponderosa'),
		));

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support('html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		));

		// Set up the WordPress core custom background feature.
		add_theme_support('custom-background', apply_filters('_s_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		)));

		// Add theme support for selective refresh for widgets.
		add_theme_support('customize-selective-refresh-widgets');

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support('custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		));
	}
endif;
add_action('after_setup_theme', 'pagels_ponderosa_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function pagels_ponderosa_content_width()
{
	$GLOBALS['content_width'] = apply_filters('pagels_ponderosa_content_width', 640);
}
add_action('after_setup_theme', 'pagels_ponderosa_content_width', 0);

/**
 * Register Google Fonts
 */
function pagels_ponderosa_fonts_url()
{
	$fonts_url = '';

	/*
	 *Translators: If there are characters in your language that are not
	 * supported by Noto Serif, translate this to 'off'. Do not translate
	 * into your own language.
	 */
	$notoserif = esc_html_x('on', 'Noto Serif font: on or off', 'pagels_ponderosa');

	if ('off' !== $notoserif) {
		$font_families = array();
		$font_families[] = 'Noto Serif:400,400italic,700,700italic';

		$query_args = array(
			'family' => urlencode(implode('|', $font_families)),
			'subset' => urlencode('latin,latin-ext'),
		);

		$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
	}

	return $fonts_url;
}

/**
 * Enqueue scripts and styles.
 */
function pagels_ponderosa_scripts()
{
	wp_enqueue_style('pagels_ponderosa-fonts', get_template_directory_uri() . '/dist/css/fonts/pagels.css');

	wp_enqueue_style('pagels_ponderosa-fonts-2', '//cloud.typenetwork.com/projects/4168/fontface.css/', array(), '20151215');

	wp_enqueue_style('pagels_ponderosa-style', get_template_directory_uri() . '/dist/css/style.css');

	wp_enqueue_style('pagels_ponderosa-blocks-style', get_template_directory_uri() . '/css/blocks.css');

	wp_enqueue_script('pagels_ponderosa-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true);

	wp_enqueue_script('pagels_ponderosa-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true);

	wp_enqueue_script('pagels_ponderosa-site', get_template_directory_uri() . '/js/site.js', array(), '20151215', true);

	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'pagels_ponderosa_scripts', 10);


/**
 * Enqueue WordPress theme styles within Gutenberg.
 */
function pagels_ponderosa_editor_styles()
{
	wp_enqueue_style('pagels_ponderosa-fonts', get_template_directory_uri() . '/dist/css/fonts/pagels.css');

	wp_enqueue_style('pagels_ponderosa-fonts-2', '//cloud.typenetwork.com/projects/4168/fontface.css/');

	wp_enqueue_style('pagels_ponderosa_editor', get_theme_file_uri('/dist/css/style-editor.css'), false, '1.0', 'all');
}
add_action('enqueue_block_editor_assets', 'pagels_ponderosa_editor_styles', 10);


/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Theme Settings
 */
require get_template_directory() . '/inc/theme-options.php';

/**
 * Woocommerce
 */
require get_template_directory() . '/inc/woocommerce.php';
