# Gutenberg Starter Theme

The Gutenberg Starter theme is designed to provide a simple, interference-free theme for testing Gutenberg. It uses no editor styles by default, and is built so that its front-end appearance is as close to the editor's default Gutenberg styles as possible.

The theme is primarily intended for use by those developing for and testing Gutenberg, but may also be helpful for those developing themes, or for folks who would like their site to look like Gutenberg in general.

## Theme Options

There are a few optional settings available in the `Appearance > Theme Options` panel added to WP-Admin. Each setting maps to a [theme support](https://developer.wordpress.org/block-editor/developers/themes/theme-support/) option offered by Gutenberg:

- [**Wide alignment**](https://developer.wordpress.org/block-editor/developers/themes/theme-support/#wide-alignment). By default, wide and full alignments are active in the theme. This setting provides you the option to turn them off.
- [**Color palette**](https://developer.wordpress.org/block-editor/developers/themes/theme-support/#block-color-palettes). The theme provides a limited custom color palette by default. This can be toggled off if you'd like to test the default Gutenberg colors.
- [**Dark background**](https://developer.wordpress.org/block-editor/developers/themes/theme-support/#dark-backgrounds). Gutenberg provides some alternate UI colors, optimized for themes that use a dark background color. Turning this on will allow you to test those by enabling a dark mode of the theme.
- [**Block Styles**](https://developer.wordpress.org/block-editor/developers/themes/theme-support/#default-block-styles). This option allows you to opt-in or out of having Gutenberg provide some structural CSS for certain blocks on the front end.
- [**Responsive embedded content**](https://developer.wordpress.org/block-editor/developers/themes/theme-support/#responsive-embedded-content). When this is active, embed blocks will automatically reflect the aspect ratio of content that is embedded in an iFrame.

## Contributing

Fixes and enhancements for the theme are welcome and encouraged! For more information about contributing, please visit [CONTRIBUTING.md](https://github.com/WordPress/pagels_ponderosa/blob/master/CONTRIBUTING.md).
