<?php
/**
 * Template: Schema General section.
 *
 * @package Smartcrwal
 */

namespace SmartCrawl;

use SmartCrawl\Schema\Type_Constants;

// phpcs:disable WordPress.WP.GlobalVariablesOverride.Prohibited
$option_name    = empty( $_view['option_name'] ) ? '' : $_view['option_name'];
$options        = empty( $options ) ? array() : $options;
$social_options = empty( $social_options ) ? array() : $social_options;
$pages          = empty( $pages ) ? array() : $pages;

$sitename             = (string) \smartcrawl_get_array_value( $social_options, 'sitename' );
$schema_website_logo  = (string) \smartcrawl_get_array_value( $options, 'schema_website_logo' );
$schema_type          = (string) \smartcrawl_get_array_value( $social_options, 'schema_type' );
$schema_output_page   = (int) \smartcrawl_get_array_value( $options, 'schema_output_page' );
$sitelinks_search_box = (bool) \smartcrawl_get_array_value( $options, 'sitelinks_search_box' );
?>

<div id="wds-schema-website" class="sui-box-settings-row">
	<div class="sui-box-settings-col-1">
		<label class="sui-settings-label">
			<?php esc_html_e( 'Website Details', 'wds' ); ?>
		</label>
		<p class="sui-description">
			<?php esc_html_e( "Specify your website's name and logo. In some cases, this information may be different from your Person/Organization information.", 'wds' ); ?>
		</p>
	</div>

	<div class="sui-box-settings-col-2">
		<div class="sui-form-field">
			<label for="sitename" class="sui-label">
				<?php esc_html_e( 'Website Name', 'wds' ); ?>
			</label>
			<input
				id="sitename"
				class="sui-form-control"
				type="text"
				name="<?php echo esc_attr( "{$option_name}[sitename]" ); ?>"
				value="<?php echo esc_attr( $sitename ); ?>"
				placeholder="<?php echo esc_html( get_bloginfo( 'name' ) ); ?>"
			>
			<span class="sui-description">
				<?php esc_html_e( 'Please add the site name you would like to appear in the schema markup.', 'wds' ); ?>
			</span>
		</div>

		<div class="sui-form-field">
			<label for="schema_website_logo" class="sui-label">
				<?php esc_html_e( 'Website Logo', 'wds' ); ?>
			</label>

			<?php
			$this->render_view(
				'media-item-selector',
				array(
					'id'    => 'schema_website_logo',
					'value' => $schema_website_logo,
					'field' => 'id',
				)
			);
			?>
			<p class="sui-description">
				<?php esc_html_e( 'Specify the image of your website’s logo.', 'wds' ); ?>
			</p>
		</div>
	</div>
</div>

<div id="wds-schema-person-organization" class="sui-box-settings-row">
	<div class="sui-box-settings-col-1">
		<label class="sui-settings-label">
			<?php esc_html_e( 'Person or Organization', 'wds' ); ?>
		</label>
		<p class="sui-description">
			<?php esc_html_e( "Specify if your site represents a Person or an Organization. This information will be used in Google's Knowledge Graph Card, the block you can see on the right side of the search results.", 'wds' ); ?>
		</p>
	</div>

	<div class="sui-box-settings-col-2">
		<div id="wds-site-type">
			<?php
			$this->render_view(
				'side-tabs',
				array(
					'id'    => 'wds-site-type-tabs',
					'name'  => "{$option_name}[schema_type]",
					'value' => ! empty( $schema_type ) ? $schema_type : Type_Constants::TYPE_ORGANIZATION,
					'tabs'  => array(
						array(
							'value'         => Type_Constants::TYPE_PERSON,
							'label'         => esc_html__( 'Person', 'wds' ),
							'template'      => 'schema/schema-person-settings',
							'template_args' => array(
								'options'        => $options,
								'social_options' => $social_options,
								'pages'          => $pages,
							),
						),
						array(
							'value'         => Type_Constants::TYPE_ORGANIZATION,
							'label'         => esc_html__( 'Organization', 'wds' ),
							'template'      => 'schema/schema-organization-settings',
							'template_args' => array(
								'options'        => $options,
								'social_options' => $social_options,
								'pages'          => $pages,
							),
						),
					),
				)
			);
			?>
		</div>
	</div>
</div>

<?php
$this->render_view(
	'schema/schema-social-accounts',
	array(
		'options'        => $options,
		'social_options' => $social_options,
	)
);
?>

<div id="wds-schema-sitelinks-searchbox" class="sui-box-settings-row">
	<div class="sui-box-settings-col-1">
		<label class="sui-settings-label">
			<?php esc_html_e( 'Sitelinks Searchbox', 'wds' ); ?>
		</label>
		<p class="sui-description">
			<?php esc_html_e( 'When someone searches for your name or brand name in Google, you can enable a mini search box under the main result for users to search your website directly.', 'wds' ); ?>
		</p>
	</div>

	<div class="sui-box-settings-col-2">
		<?php
		$this->render_view(
			'toggle-item',
			array(
				'field_name'       => $option_name . '[sitelinks_search_box]',
				'checked'          => $sitelinks_search_box,
				'item_label'       => esc_html__( 'Enable Google Sitelinks Searchbox', 'wds' ),
				'item_description' => esc_html__( 'Note: WordPress comes with a search component built-in so we just need to link to it to enable this feature.', 'wds' ),
			)
		);
		?>
	</div>
</div>

<div id="wds-schema-output-page" class="sui-box-settings-row">
	<div class="sui-box-settings-col-1">
		<label class="sui-settings-label">
			<?php esc_html_e( 'Output Page', 'wds' ); ?>
		</label>
		<p class="sui-description">
			<?php esc_html_e( "It's recommended that your base person or organization schema output is put on the page that most reflects information related to your brand/company.", 'wds' ); ?>
		</p>
	</div>

	<div class="sui-box-settings-col-2">
		<?php
		$this->render_view(
			'post-search-dropdown-form-field',
			array(
				'field_name'       => 'schema_output_page',
				'field_label'      => esc_html__( 'Output Page', 'wds' ),
				'first_option'     => esc_html__( 'Homepage', 'wds' ),
				'selected_post_id' => $schema_output_page,
				'pages'            => $pages,
			)
		);
		?>
	</div>
</div>