/********************************************************************************************************************************************/
/********************************************************* General Settings *****************************************************************/
/********************************************************************************************************************************************/

jQuery(document).ready(function () {

	/*************************************************** Services Drag and Drop Feature **************************************************************/

	// Services Ordering
	jQuery('.ups_services tbody').sortable({
		items: 'tr',
		cursor: 'move',
		axis: 'y',
		handle: '.sort',
		scrollSensitivity: 40,
		forcePlaceholderSize: true,
		helper: 'clone',
		opacity: 0.65,
		placeholder: 'wc-metabox-sortable-placeholder',
		start: function(event, ui) {
			ui.item.css('baclbsround-color', '#f6f6f6');
		},
		stop: function(event, ui) {
			ui.item.removeAttr('style');
			ups_services_row_indexes();
		}
	});
		
	// Enabling and disabling of individual and bulk services at once.
	handle_bulk_select( 'ph-ups-service-checkbox', 'ph-ups-bulk-select-service' );

	/*************************************************** Order Level Settings **************************************************************/

	jQuery("#generate_return_label").click(function () {
		service = jQuery("#return_label_service").val();
		if (service == '') {
			alert("Select service");
			return false;
		}
		else {
			href = jQuery(this).attr('href');
			href = href + "&return_label_service=" + service;
			jQuery(this).attr('href', href);
		}
		return true;
	});

	jQuery('#ph_ups_choose_upload_document').on('click', function (event) {

		orderId = jQuery('#order_id').val();
		docType = jQuery('#ph_user_created_form_doc_type').val();

		file_frame = wp.media.frames.file_frame = wp.media({
			title: 'Select a Document to Upload',
			button: {
				text: 'Use this document',
			},
			multiple: false
		});

		file_frame.on('select', function () {

			// Make the div elements unclickable and show loading icon
			jQuery("#PhUpsDocUploadMetabox").css("pointer-events", "none");
			jQuery("#PhUpsDocUploadMetabox").css("opacity", '0.5');
			jQuery("#ph-loading-spinner").addClass("spinner");
			jQuery("#ph-loading-spinner").addClass("is-active");

			//For single document selection
			attachment = file_frame.state().get('selection').first().toJSON();

			var data = {
				'action': 'ph_ups_upload_document',
				'attachment': attachment,
				'docType': docType,
				'orderId': orderId
			};

			jQuery.post(ajaxurl, data, function (response) {

				response = JSON.parse(response);

				if (response.success == true) {

					jQuery("#ph-loading-spinner").removeClass("spinner, is-active");
					location.reload();

				} else {

					jQuery("#ph-loading-spinner").removeClass("spinner, is-active");
					location.reload();

				}
			});
		});

		file_frame.open();
	});

	// Bulk Action
	jQuery("#doaction, #doaction2").click(function() {

		selected = jQuery(this).closest("form").find("select[name^='action']").val();

		if ( selected == 'ups_generate_label' ) {

			phUPSDisableClick();		
		}
	});

	jQuery('.ph-ups-close-oauth-banner').off('click').on('click', function (e) {
		e.preventDefault();
	
		var data = {
			action: 'ph_ups_close_rest_migration_banner',
			_ajax_nonce: ph_ups_settings.banner_nonce
		};
	
		jQuery.post(ajaxurl, data, function (response) {
			if (response && response.success) {
				// Nonce verified and option updated — reload page
				setTimeout(function () {
					location.reload();
				}, 1000);
			} else {
				// Nonce failed or some error returned
				var message = response.data && response.data.message
					? response.data.message
					: 'Something went wrong. Please refresh and try again.';
				alert(message);
				console.warn('Error:', response);
			}
		}).fail(function (jqXHR, textStatus, errorThrown) {
			alert('AJAX Error: ' + textStatus + ' - ' + errorThrown);
			console.error('AJAX Failure:', jqXHR.responseText);
		});
	});

	jQuery('#ph_ups_close_banner').on('click', function(){
		jQuery('.ph_registration_banner').fadeOut('slow', function(){
			jQuery('.ph_registration_banner').remove();
		});
	});

	/*************************************************** Common JS for both Global and Zone **************************************************************/

	// Fetch the plugin_id.
	const ph_ups_plugin_id = ph_ups_settings.plugin_id;

	// Check to add js according to the location.
	if ( window.location.href.indexOf( ph_ups_plugin_id ) !== -1 )  {	
		// Define the ID.
		PH_UPS_PREFIX = '#woocommerce_' + ph_ups_plugin_id + '_';
		
	} else {
		return;
	}

	// Get the value of 'subtab' parameter from the URL.
	let active_subtab_value = ph_ups_get_url_parameter('subtab');

	jQuery('.ph-ups-tabs').on('click', function () {
		let tabClass = jQuery(this).attr('class').match(/tab_[^\s]+/)?.[0] || '';
		let tab = tabClass.replace('tab_', ''); // Extract the identifier from class.
		ph_ups_show_selected_tab( jQuery(this), tab);
		ph_ups_update_subtab_to_url();
	});

	// When active_subtab_value is empty.
	if ( ! active_subtab_value) {
		active_subtab_value = 'general';
	}

	// Activate the corresponding subtab.
	ph_ups_show_selected_tab( jQuery('.tab_' + active_subtab_value), active_subtab_value );

	/**
	 * Binds validation to the WooCommerce save button on page load.
	 * Triggers validation for required fields based on the active subtab.
	 */
	jQuery(document).ready(function($) {
		$('.woocommerce-save-button').on('click', function(event) {
			ph_validate_all_required_fields(active_subtab_value, event);
		});
	});

	/********************************************* General Settings *************************************************/

	// Silent Debug mode
	jQuery(PH_UPS_PREFIX + 'debug').click(function () {
		ph_ups_silent_debug_option();
	});

	// Toggle Address Validation
	jQuery(PH_UPS_PREFIX + 'residential').click(function () {
		ph_ups_address_validation_options();
	});

	// Toggle Address Suggestion
	jQuery(PH_UPS_PREFIX + 'address_validation').click(function () {
		ph_ups_address_validation_options();
	});

	jQuery(PH_UPS_PREFIX + 'suggested_address').click(function () {
		ph_ups_address_validation_options();
	});

	// Toggle Minimum Insurance amount
	jQuery(PH_UPS_PREFIX + 'insuredvalue').click(function () {
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'insuredvalue', PH_UPS_PREFIX + 'min_order_amount_for_insurance');
	});

	// Toggle Ship From Address Different from Shipper Address
	jQuery(PH_UPS_PREFIX + 'ship_from_address_different_from_shipper').click(function () {
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'ship_from_address_different_from_shipper', '.ph_ups_different_ship_from_address');

		ph_ups_make_fields_required(
			PH_UPS_PREFIX + 'ship_from_address_different_from_shipper',
			[
				PH_UPS_PREFIX + 'ship_from_addressline',
				PH_UPS_PREFIX + 'ship_from_city',
				PH_UPS_PREFIX + 'ship_from_postcode'
			]
		);

		ph_ship_from_address_for_freight();
	});

	/********************************************* Rates Settings ***************************************************/

	// Toggle Estimated delivery related data
	jQuery(PH_UPS_PREFIX + 'enable_estimated_delivery').click(function () {
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'enable_estimated_delivery', '.ph_ups_est_delivery');
	});

	// Toggle Access Point Locator related data
	jQuery(PH_UPS_PREFIX + 'accesspoint_locator').click(function () {
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'accesspoint_locator', '.ph_ups_accesspoint');
	});

	// Toggle Total Insured Value in Commercial Invoice based on Insurance Option setting.
	jQuery(PH_UPS_PREFIX + 'insuredvalue').click(function () {
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'insuredvalue', PH_UPS_PREFIX + 'total_insured_commercial');
	});

	// Toggle Availability
	jQuery(PH_UPS_PREFIX + 'availability').change(function () {
		ph_ups_load_availability_options();
	});

	jQuery(PH_UPS_PREFIX + 'ups_tradability').click(function () {
		ph_ups_tradability_cart_title();
	});

	jQuery('.ph_ups_accesspoint_limit').attr({
		"max": 50,
		"min": 1
	});

	jQuery(PH_UPS_PREFIX + 'accesspoint_max_limit').change(function (e) {
		ph_ups_show_max_limit_error();
	});

	jQuery(PH_UPS_PREFIX + 'email_notification').change(function (e) {
		ph_ups_email_notification_code_trigger();
	});

	// Min-Max adjustment validation for weight limit fields.
	jQuery(PH_UPS_PREFIX + 'min_weight_limit').on('input change', function() {
		ph_ups_validate_min_and_max_settings(this, PH_UPS_PREFIX + 'max_weight_limit');
	});

	jQuery(PH_UPS_PREFIX + 'max_weight_limit').on('input change', function() {
		ph_ups_validate_min_and_max_settings(PH_UPS_PREFIX + 'min_weight_limit', this);
	});

	// Min-Max adjustment validation for shipping cost fields.
	jQuery(PH_UPS_PREFIX + 'min_shipping_cost').on('input change', function() {
		ph_ups_validate_min_and_max_settings(this, PH_UPS_PREFIX + 'max_shipping_cost');
	});

	jQuery(PH_UPS_PREFIX + 'max_shipping_cost').on('input change', function() {
		ph_ups_validate_min_and_max_settings(PH_UPS_PREFIX + 'min_shipping_cost', this);
	});

	/********************************************* Label Settings ***************************************************/

	// Toggle Label Size
	jQuery(PH_UPS_PREFIX + 'show_label_in_browser').click(function () {
		ph_toggle_ups_label_size();
		ph_toggle_ups_label_zoom_factor();
	});

	// Automate Package Generation Check box checked
	jQuery(PH_UPS_PREFIX + 'automate_package_generation').click(function () {
		ph_ups_toggle_based_automate_pakage_generation();
		ph_automate_label_generation_trigger();
	});

	// Toggle Automatic Label Generation
	jQuery(PH_UPS_PREFIX + 'automate_label_generation').click(function () {
		ph_automate_label_generation_trigger();
	});

	// Toggle Label Format based on Print Label Type option and Display Label in Browser.
	jQuery(PH_UPS_PREFIX + 'print_label_type').change(function () {
		ph_ups_toggle_label_format();
		ph_toggle_ups_label_size();
		ph_toggle_ups_label_zoom_factor();
	});

	//Toggle Email Settings
	jQuery(PH_UPS_PREFIX + 'auto_email_label').change(function () {
		ph_ups_toggle_label_email_settings();
	});

	// Custom Description For Label & Additional Description
	jQuery(PH_UPS_PREFIX + 'label_description').change(function () {
		ph_ups_custom_description_for_label();
		ph_toggle_additional_description();
	});

	jQuery(PH_UPS_PREFIX + 'duties_and_taxes').change(function () {
		xa_ups_duties_payer_options()
	});

	jQuery(PH_UPS_PREFIX + 'transportation').change(function () {
		ph_ups_transportation_options()
	});

	// Toggle Custom Tracking
	jQuery(PH_UPS_PREFIX + 'custom_tracking').click(function () {
		ph_toggle_ups_custom_tracking();
	});

	// Email subject & content placeholder options.
	var phUPSEmailSubPlaceholders = [
		{ placeholder: '[ORDER_NO]', label: 'Add [ORDER_NO]' },
		{ placeholder: '[ORDER_ID]', label: 'Add [ORDER_ID]' },
	];

	var phUPSEmailSubTextarea 	= jQuery(PH_UPS_PREFIX + 'email_subject');
	var phUPSButtonContainer = jQuery('<div class="ph-ups-copy-button-container"></div>');

	jQuery.each(phUPSEmailSubPlaceholders, function(index, data) {
		
		var button = jQuery('<button>')
			.attr('type', 'button')
			.addClass('ph-ups-email-sub-copy-btn button-secondary')
			.data('placeholder', data.placeholder)
			.text(data.label);

		phUPSButtonContainer.append(button);
	});

	// Add a message element for copy feedback
	var phUPSCopyMessage = jQuery('<div class="ph-ups-copy-sub-message"><span class="tick">&#10003;</span>Copied!</div>');
	phUPSEmailSubTextarea.after(phUPSButtonContainer);
	phUPSEmailSubTextarea.after(phUPSCopyMessage);

	// Handle button click events for copying placeholders
	jQuery('.ph-ups-email-sub-copy-btn').on('click', function() {
		
		let placeholderText = jQuery(this).data('placeholder');

		// Use the Clipboard API to copy text
		navigator.clipboard.writeText(placeholderText).then(function() {
			// Get the textarea and its selection start
			let textareaElem = phUPSEmailSubTextarea[0];
			let start = textareaElem.selectionStart;
			let end = textareaElem.selectionEnd;
			let currentValue = textareaElem.value;

			// Insert text at the cursor position
			textareaElem.value = currentValue.slice(0, start) + placeholderText + currentValue.slice(end);

			// Move the cursor to the end of the inserted text
			textareaElem.selectionStart = textareaElem.selectionEnd = start + placeholderText.length;

			// Show the copied message
			let messageElement = jQuery('.ph-ups-copy-sub-message');

			messageElement.show();

			if (jQuery('.woocommerce-save-button').is(':disabled')) {
				
				jQuery(textareaElem).trigger('change');
			}
			
			setTimeout(function() {
				messageElement.fadeOut();
			}, 2000); // Hide the message after 2 seconds

		}).catch(function(error) {

			console.error('Failed to copy text: ', error);
		});
	});

	var phUPSEmailPlaceholders = [
		{ placeholder: '[DOWNLOAD LINK]', label: 'Add [DOWNLOAD LINK]' },
		{ placeholder: '[ORDER NO]', label: 'Add [ORDER NO]' },
		{ placeholder: '[ORDER AMOUNT]', label: 'Add [ORDER AMOUNT]' },
		{ placeholder: '[PRODUCTS ID]', label: 'Add [PRODUCTS ID]' },
		{ placeholder: '[PRODUCTS SKU]', label: 'Add [PRODUCTS SKU]' },
		{ placeholder: '[PRODUCTS NAME]', label: 'Add [PRODUCTS NAME]' },
		{ placeholder: '[PRODUCTS QUANTITY]', label: 'Add [PRODUCTS QUANTITY]' },
		{ placeholder: '[ALL_PRODUCT INFO]', label: 'Add [ALL_PRODUCT INFO]' },
		{ placeholder: '[ORDER_PRODUCTS]', label: 'Add [ORDER_PRODUCTS]' },
		{ placeholder: '[CUSTOMER EMAIL]', label: 'Add [CUSTOMER EMAIL]' },
		{ placeholder: '[CUSTOMER NAME]', label: 'Add [CUSTOMER NAME]' },
	];

	var phUPSEmailTextarea 	= jQuery(PH_UPS_PREFIX + 'email_content');
	var phUPSButtonContainer = jQuery('<div class="ph-ups-copy-button-container"></div>');

	jQuery.each(phUPSEmailPlaceholders, function(index, data) {
		
		var button = jQuery('<button>')
			.attr('type', 'button')
			.addClass('ph-ups-email-copy-btn button-secondary')
			.data('placeholder', data.placeholder)
			.text(data.label);

		phUPSButtonContainer.append(button);
	});

	// Add a message element for copy feedback
	var phUPSCopyMessage = jQuery('<div class="ph-ups-copy-message"><span class="tick">&#10003;</span>Copied!</div>');
	phUPSEmailTextarea.after(phUPSButtonContainer);
	phUPSEmailTextarea.after(phUPSCopyMessage);

	// Handle button click events for copying placeholders
	jQuery('.ph-ups-email-copy-btn').on('click', function() {
		
		let placeholderText = jQuery(this).data('placeholder');

		// Use the Clipboard API to copy text
		navigator.clipboard.writeText(placeholderText).then(function() {
			// Get the textarea and its selection start
			let textareaElem = phUPSEmailTextarea[0];
			let start = textareaElem.selectionStart;
			let end = textareaElem.selectionEnd;
			let currentValue = textareaElem.value;

			// Insert text at the cursor position
			textareaElem.value = currentValue.slice(0, start) + placeholderText + currentValue.slice(end);

			// Move the cursor to the end of the inserted text
			textareaElem.selectionStart = textareaElem.selectionEnd = start + placeholderText.length;

			// Show the copied message
			let messageElement = jQuery('.ph-ups-copy-message');

			messageElement.show();

			if (jQuery('.woocommerce-save-button').is(':disabled')) {
				
				jQuery(textareaElem).trigger('change');
			}
			
			setTimeout(function() {
				messageElement.fadeOut();
			}, 2000); // Hide the message after 2 seconds

		}).catch(function(error) {

			console.error('Failed to copy text: ', error);
		});
	});

	/********************************************* Int Forms Settings ************************************************/

	// Toggle NAFTA Certificate for Commercial Invoice
	jQuery(PH_UPS_PREFIX + 'commercial_invoice').click(function () {
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'commercial_invoice', PH_UPS_PREFIX + 'nafta_co_form');
	});

	jQuery(PH_UPS_PREFIX + 'commercial_invoice').click(function () {
		ph_ups_toggle_nafta_certificate_options();
	});

	jQuery(PH_UPS_PREFIX + 'invoice_commodity_value').change(function () {
		ph_ups_include_tax()
	});

	// Toggle Producer Option & Blanket Period for NAFTA Certificate
	jQuery(PH_UPS_PREFIX + 'nafta_co_form').click(function () {
		ph_ups_toggle_nafta_certificate_options();
	});

	// Toggle EEI Data for Commercial Invoice
	jQuery(PH_UPS_PREFIX + 'commercial_invoice').click(function () {
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'commercial_invoice', PH_UPS_PREFIX + 'eei_data');
	});

	jQuery(PH_UPS_PREFIX + 'commercial_invoice').click(function () {
		ph_ups_eei_options();
		ph_ups_load_shipper_filed_options();
	});

	jQuery(PH_UPS_PREFIX + 'eei_data').click(function () {
		ph_ups_eei_options();
		ph_ups_load_shipper_filed_options();
	});

	jQuery(PH_UPS_PREFIX + 'eei_shipper_filed_option').change(function () {
		ph_ups_load_shipper_filed_options();
	});

	// Toggle declaration Statement for Commercial Invoice
	jQuery(PH_UPS_PREFIX + 'commercial_invoice').click(function () {
		ph_ups_toggle_based_on_checkbox_status( this, '.commercial_invoice_toggle');
		ph_ups_toggle_vendor_collect_id_number();
	});

	jQuery(PH_UPS_PREFIX + 'vendor_info').click(function () {

		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'vendor_info', PH_UPS_PREFIX + 'vendor_collect_id_number');
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'vendor_info', PH_UPS_PREFIX + 'default_consignee_type');
	});

	/********************************************* Special Services ************************************************/

	jQuery(PH_UPS_PREFIX + 'international_special_commodities').click(function () {

		ph_ups_toggle_based_on_restricted_article();

		if (jQuery(PH_UPS_PREFIX + 'international_special_commodities').is(':checked')) {

			jQuery('.ph_ups_isc_toggol').closest('tr').show();
		} else {
			jQuery('.ph_ups_isc_toggol').closest('tr').hide();
		}
	});

	jQuery(PH_UPS_PREFIX + 'ph_ups_restricted_article').click(function () {

		ph_ups_toggle_based_on_restricted_article();
	});

	jQuery(PH_UPS_PREFIX + 'saturday_delivery').click(function () {

		ph_ups_toggle_based_on_saturday_delivery();
		
	});

	/********************************************* Packaging Settings ************************************************/

	// Toggle Packing Methods
	jQuery(PH_UPS_PREFIX + 'packing_method').change(function () {
		wf_load_packing_method_options();
		ph_toggle_box_packing_options_based_on_algorithms();
	});

	// Toggle Exclude Box Weight
	jQuery(PH_UPS_PREFIX + 'packing_algorithm').change(function () {
		ph_toggle_box_packing_options_based_on_algorithms();
	});

	// Add Boxes.
	jQuery(window).load(function() {

		jQuery('.ups_boxes .insert').click(function() {
			var $tbody 	  = jQuery('.ups_boxes').find('tbody');
			var oauthReg  = ph_ups_settings.ph_is_oauth_reg;
			var stepValue = ph_ups_settings.step_value;
			var size 	  = $tbody.find('tr').size();
			size += 1;

			// Generate a unique box name index.
			size = ph_ups_generate_unique_box_name(size);

			var code = '<tr class="new">' +
				'<td class="ph-ups-select-box-td"><input type="checkbox" class="ph-ups-select-box" /></td>' +
				'<td><input type="text" size="15" name="boxes_name[' + size + ']" minlength="3" /></td>' +
				'<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_outer_length[' + size + ']" min="0" step="' + stepValue + '" /></td>' +
				'<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_outer_width[' + size + ']" min="0" step="' + stepValue + '" /></td>' +
				'<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_outer_height[' + size + ']" min="0" step="' + stepValue + '" /></td>' +
				'<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_inner_length[' + size + ']" min="0" step="' + stepValue + '" /></td>' +
				'<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_inner_width[' + size + ']" min="0" step="' + stepValue + '" /></td>' +
				'<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_inner_height[' + size + ']" min="0" step="' + stepValue + '" /></td>' +
				'<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_box_weight[' + size + ']" min="0" step="' + stepValue + '" /></td>' +
				'<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_max_weight[' + size + ']" min="0" step="' + stepValue + '" /></td>';
			
				if (oauthReg) {
					code += '<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_max_quantity[' + size + ']" min="0" step="1" /></td>';
				}
				
				code += '<td><input type="checkbox" class="ph-ups-enable-box" name="boxes_enabled[' + size + ']" /></td>' +
					'</tr>';

			$tbody.append(code);

			return false;
		});

		jQuery('.ups_boxes .remove').click(function() {
			var $tbody = jQuery('.ups_boxes').find('tbody');

			$tbody.find('.ph-ups-select-box-td input:checked').each(function() {
				jQuery(this).closest('tr').hide().find('input').val('');
			});

			return false;
		});

	});

	// Reset boxes confirmation
	jQuery('.ph-ups-reset-boxes').on('click', function(e) {
        let confirmation = confirm("Resetting will clear all Custom Boxes. Are you sure you want to proceed?");
        if (!confirmation) {
            e.preventDefault();
        }
    });

	// Selecting and deselecting of individual and bulk boxes at once.
	handle_bulk_select( 'ph-ups-select-box', 'ph-ups-bulk-select-box' );

	// Enabling and disabling of individual and bulk boxes at once.
	handle_bulk_select( 'ph-ups-enable-box', 'ph-ups-bulk-enable-box' );

	/********************************************* Freight Settings ************************************************/

	// Discontinued.

	/********************************************* Pickup Settings ***************************************************/

	// Toggle pickup options
	jQuery(PH_UPS_PREFIX + 'pickup_enabled').click(function () {
		wf_ups_load_pickup_options();
	});

	// Toggle working days
	jQuery(PH_UPS_PREFIX + 'pickup_date').change(function () {
		wf_ups_load_working_days();
	});

	/********************************************* Advanced Settings ***************************************************/

	jQuery(PH_UPS_PREFIX + 'default_recipient_phone').click(function () {
		ph_toggle_ups_default_recipient_ph_num();
	});

	// Default Recipient Phone number validation.
	jQuery(PH_UPS_PREFIX + 'default_recipient_phone_num' ).on('input', function () {
		ph_validate_phone_num( this, 15 );
	});

	/********************************************* Help & Support Send Report Settings ************************************************/

	jQuery('#ph_ups_ticket_number').keyup(function () {
		jQuery('#ph_ups_ticket_number').removeClass('required_field');
		jQuery('.ph_ups_ticket_number_error').hide();
	});

	jQuery("#ph_ups_consent").click(function () {
		jQuery('#ph_ups_consent').removeClass('required_field');
		jQuery('.ph_ups_consent_error').hide();
	});

	jQuery("#ph_ups_submit_ticket").click(function () {

		jQuery('.ph_error_message').remove();

		var required = false;
		var ticket_num = jQuery('#ph_ups_ticket_number').val();
		var consent = jQuery('#ph_ups_consent').is(':checked');

		if (!ticket_num) {
			jQuery('#ph_ups_ticket_number').addClass('required_field');
			jQuery('.ph_ups_ticket_number_error').show();
			required = true;
		}

		if (!consent) {
			jQuery('#ph_ups_consent').addClass('required_field');
			jQuery('.ph_ups_consent_error').show();
			required = true;
		}

		if (required) {
			return false;
		}
		// Change Text and Disable the Button
		jQuery("#ph_ups_submit_ticket").prop("value", "Please Wait...");
		jQuery("#ph_ups_submit_ticket").attr('disabled', 'disabled');

		let key_data = {
			action: 'ph_ups_get_ups_log_data',
		}

		jQuery.post(ajaxurl, key_data, function (result, status) {

			try {

				let response = JSON.parse(result);

				if (response.status == true) {

					let key_data = {
						action: 'ph_ups_submit_support_ticket',
						ticket_num: ticket_num,
						log_file: response.file_path
					}

					jQuery.post(ajaxurl, key_data, function (result, status) {

						let response2 = JSON.parse(result);

						if (response2.status == true) {
							message = "<b>Diagnostic report sent successfully.</b> PluginHive Support Team will contact you shortly via email."
							jQuery(".ph_ups_help_table").after("<p style='color:green;' class='ph_error_message'>" + message + "</p>");

							// Add original text and enable the button
							jQuery("#ph_ups_submit_ticket").prop("value", "Send Report");
							jQuery("#ph_ups_submit_ticket").removeAttr("disabled");
						} else {

							// Add original text and enable the button
							jQuery("#ph_ups_submit_ticket").prop("value", "Send Report");
							jQuery("#ph_ups_submit_ticket").removeAttr("disabled");
						}

					});

				} else {
					message = response.message;
					jQuery(".ph_ups_help_table").after("<p style='color:red;' class='ph_error_message'>" + message + "</p>");

					// Add original text and enable the button
					jQuery("#ph_ups_submit_ticket").prop("value", "Send Report");
					jQuery("#ph_ups_submit_ticket").removeAttr("disabled");
				}

			} catch (err) {
				alert(err.message);

				// Add original text and enable the button
				jQuery("#ph_ups_submit_ticket").prop("value", "Send Report");
				jQuery("#ph_ups_submit_ticket").removeAttr("disabled");
			}

		});
	});

	/*************************************************** Order Level Settings **************************************************************/

	// Set the selected weight/dimension unit in a hidden field to convert while saving the settings
	jQuery(PH_UPS_PREFIX + 'units').on('change', function () {

		jQuery('#selected_dim_unit').val(jQuery(PH_UPS_PREFIX + 'units').val());

	});	
});

/********************************************************************************************************************************************/
/******************************************************* Required Functions **************************************************************/
/********************************************************************************************************************************************/

/**
 * Displays the selected UPS settings tab and initializes related options.
 *
 * @param {jQuery} element - The clicked tab element.
 * @param {string} tab - The selected tab identifier (e.g., 'general', 'rates').
 */
function ph_ups_show_selected_tab(element, tab) {

	// Remove active class from all tabs.
	jQuery(".ph-ups-tabs").removeClass("nav-tab-active");

	// Add nav-tab-active to active subtab.
	element.addClass("nav-tab-active");

	// Hide all sections and their accompanying paragraphs.
	jQuery( '.ph_ups_general_tab, .ph_ups_rates_tab, .ph_ups_label_tab, .ph_ups_int_forms_tab, .ph_ups_spl_services_tab, .ph_ups_packaging_tab, .ph_ups_freight_tab, .ph_ups_pickup_tab, .ph_ups_advanced_tab, .ph_ups_help_tab' ).closest( 'tr, h3' ).hide();
	jQuery( '.ph_ups_general_tab, .ph_ups_rates_tab, .ph_ups_label_tab, .ph_ups_int_forms_tab, .ph_ups_spl_services_tab, .ph_ups_packaging_tab, .ph_ups_freight_tab, .ph_ups_pickup_tab, .ph_ups_advanced_tab, .ph_ups_help_tab' ).next( 'p' ).hide();

	jQuery('.ph-ups-freight-banner-section').hide();

	// Show the selected tab section and its accompanying paragraph.
	jQuery( '.ph_ups_' + tab + '_tab' ).closest( 'tr, h3' ).show();
	jQuery( '.ph_ups_' + tab + '_tab' ).next( 'p' ).show();

	if (tab == 'general') {
		ph_ups_address_validation_options(); 
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'insuredvalue', PH_UPS_PREFIX + 'min_order_amount_for_insurance');
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'ship_from_address_different_from_shipper', '.ph_ups_different_ship_from_address');
		ph_ups_make_fields_required(
			PH_UPS_PREFIX + 'ship_from_address_different_from_shipper',
			[
				PH_UPS_PREFIX + 'ship_from_addressline',
				PH_UPS_PREFIX + 'ship_from_city',
				PH_UPS_PREFIX + 'ship_from_postcode'
			]
		);
		ph_ups_silent_debug_option();
		ph_ship_from_address_for_freight();
	}

	if (tab == 'rates') {
		ph_ups_load_availability_options();
		ph_ups_tradability_cart_title();
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'enable_estimated_delivery', '.ph_ups_est_delivery');
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'accesspoint_locator', '.ph_ups_accesspoint');
		ph_ups_show_max_limit_error();
		ph_ups_email_notification_code_trigger();
		ph_ups_validate_min_and_max_settings(PH_UPS_PREFIX + 'min_weight_limit', PH_UPS_PREFIX + 'max_weight_limit');
		ph_ups_validate_min_and_max_settings(PH_UPS_PREFIX + 'min_shipping_cost', PH_UPS_PREFIX + 'max_shipping_cost');
	}

	if (tab == 'label') {
		xa_ups_duties_payer_options();
		ph_ups_transportation_options();
		ph_toggle_ups_label_size();
		ph_ups_toggle_label_format();
		ph_ups_custom_description_for_label();
		ph_toggle_additional_description();
		ph_ups_toggle_label_email_settings();
		ph_ups_toggle_based_automate_pakage_generation();
		ph_toggle_ups_label_zoom_factor();
		ph_toggle_ups_custom_tracking();
		ph_automate_label_generation_trigger();
	}

	if (tab == 'int_forms') {
		ph_ups_include_tax();
		ph_ups_eei_options();
		ph_ups_load_shipper_filed_options();
		ph_ups_toggle_nafta_certificate_options();
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'insuredvalue', PH_UPS_PREFIX + 'total_insured_commercial');
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'commercial_invoice', '.commercial_invoice_toggle');
		ph_ups_toggle_vendor_collect_id_number();
	}

	if (tab == 'spl_services') {

		if (jQuery(PH_UPS_PREFIX + 'international_special_commodities').is(':checked')) {

			jQuery('.ph_ups_isc_toggol').closest('tr').show();
		} else {
			jQuery('.ph_ups_isc_toggol').closest('tr').hide();
		}

		ph_ups_toggle_based_on_restricted_article();

		ph_ups_toggle_based_on_saturday_delivery();

		// Toggle gfp_freight_class option
		if ( ph_ups_settings.ph_new_customer ) {

			ph_ups_toggle_based_on_checkbox_status('input[name="ups_service[US48][enabled]', PH_UPS_PREFIX + 'gfp_freight_class');
		} else {

			jQuery( PH_UPS_PREFIX + 'gfp_freight_class').closest('tr').hide();
		}
	}

	if (tab == 'packaging') {
		wf_load_packing_method_options();
		ph_toggle_box_packing_options_based_on_algorithms();
	}

	if (tab == 'freight') {
		
		jQuery('.ph-ups-freight-banner-section').show();
	}

	if ( tab == 'advanced' ) {
		
		jQuery(PH_UPS_PREFIX + 'client_credentials').closest('tr').hide();
		jQuery(PH_UPS_PREFIX + 'client_license_hash').closest('tr').hide();

		jQuery(PH_UPS_PREFIX + 'user_id').closest('tr').hide();
		jQuery(PH_UPS_PREFIX + 'password').closest('tr').hide();
		jQuery(PH_UPS_PREFIX + 'access_key').closest('tr').hide();
		jQuery(PH_UPS_PREFIX + 'shipper_number').closest('tr').hide();

		var phUPSClientCredentials = jQuery(PH_UPS_PREFIX + 'client_credentials').val();
		var phUPSClientLicenseHash = jQuery(PH_UPS_PREFIX + 'client_license_hash').val();

		if ( ph_ups_settings.ph_new_customer || (phUPSClientCredentials != 'undefined' && phUPSClientCredentials != '') && (phUPSClientLicenseHash != 'undefined' && phUPSClientLicenseHash != '') ) {

			jQuery(PH_UPS_PREFIX + 'ph_legacy_section').hide();
		}

		ph_toggle_ups_default_recipient_ph_num();
	}

	if (tab == 'pickup') {
		wf_ups_load_pickup_options();
	}

	if (tab == 'help' || (tab == 'freight' && ph_ups_settings.ph_new_customer)) {
		jQuery(".woocommerce-save-button").hide();
	} else {
		jQuery(".woocommerce-save-button").show();
	}

	/**
	 * Handles click on the WooCommerce save button.
	 * Validates all required fields for the given tab before allowing save.
	 *
	 * @param {Event} event - The click event on the save button.
	 */
	jQuery('.woocommerce-save-button').on('click', function(event) {
		ph_validate_all_required_fields(tab, event);
	});

	ph_ups_update_subtab_to_url();
	return false;
}

function ups_services_row_indexes() {
	jQuery('.ups_services tbody tr').each(function(index, el) {
		jQuery('input.order', el).val(parseInt(jQuery(el).index('.ups_services tr')));
	});
};

/**
 * Handles bulk selection for checkboxes.
 *
 * @param {string} checkbox_class - The class name of the checkboxes to be handled.
 * @param {string} bulk_select_id - The id of the bulk select checkbox.
 * @returns {void}
 */
function handle_bulk_select(checkbox_class, bulk_select_id) {

	if (jQuery( `.${checkbox_class}:checked` ).length === jQuery( `.${checkbox_class}` ).length) {
		jQuery( `#${bulk_select_id}` ).prop( 'checked', true );
	}

	// Handle bulk select.
	jQuery( document ).on(
		'click',
		`#${bulk_select_id}`,
		function () {
			jQuery( `.${checkbox_class}` ).prop( 'checked', jQuery( this ).prop( 'checked' ) );
		}
	);

	// Handle individual checkbox.
	jQuery( document ).on(
		'change',
		`.${checkbox_class}`,
		function () {
			if ( ! jQuery( this ).prop( 'checked' )) {

				jQuery( `#${bulk_select_id}` ).prop( 'checked', false );
			}

			if (jQuery( `.${checkbox_class}:checked` ).length === jQuery( `.${checkbox_class}` ).length) {
				jQuery( `#${bulk_select_id}` ).prop( 'checked', true );
			}
		}
	);
}

/**
 * Validates fields and focuses on the subtab containing the first invalid input.
 *
 * @param {string} currentTab - The active subtab key.
 * @param {Event} event - The triggering event (e.g., form submit).
 *
 * @returns {boolean|void} False if validation fails in a different subtab.
 */
function ph_validate_all_required_fields(currentTab, event) {

	const invalidInputs = jQuery('input:invalid');

	if (invalidInputs.length === 0) return;

	const firstInvalid = invalidInputs.first();
	const classAttr = firstInvalid.attr('class') || '';
	const classList = classAttr.split(/\s+/);
	const tabClass  = classList.find(cls => cls.endsWith('_tab'));

	// Skip if the invalid input does not belong to the carrier's settings tabs.
	if( ! ph_ups_is_tab_part_of_carrier_settings(tabClass) ) return;

	let subtab = tabClass.match(/ph_ups_(.+?)_tab/)?.[1];
	// If the subtab value is 'box_packing', switch context to the 'packaging' tab and initialize related options
	subtab = ph_handle_box_packing_validation(subtab);

	if ( subtab && subtab !== currentTab) {
		event.preventDefault();

		// Update URL without reload
		const newUrl = new URL(window.location.href);
		newUrl.searchParams.set('subtab', subtab);
		window.history.replaceState({}, '', newUrl.toString());

		// Switch to correct subtab
		ph_ups_show_selected_tab(jQuery('.tab_' + subtab), subtab);

		// Smooth scroll and show browser tooltip
		jQuery('html, body').stop(true).animate({
			scrollTop: firstInvalid.offset().top - 100
		}, 300, function () {
			firstInvalid[0].reportValidity();
		});

		return false;
	}
}

/**
 * Determines if the given tab class is part of the carrier settings tabs.
 *
 * @param {string} cls - The class to check.
 * @returns {boolean}
 */
function ph_ups_is_tab_part_of_carrier_settings(cls) {

	let tabClasses = [
		'ph_ups_general_tab',
		'ph_ups_rates_tab',
		'ph_ups_label_tab',
		'ph_ups_int_forms_tab',
		'ph_ups_packaging_tab',
		'ph_ups_pickup_tab',
		'ph_ups_advanced_tab',

		// Box packing table class - Needed, since it is not focusable with parent class.
		'ph_ups_box_packing_tab'
	];

	return tabClasses.includes(cls);
}

/**
 * Ensures correct setup if the invalid field is from box packing.
 *
 * @param {string|undefined} tabClass - The current tab identifier.
 * @returns {string} - Subtab identifier
 */
function ph_handle_box_packing_validation(tabClass) {

	// Exit early if a specific tab class is provided (validation not required).
	if ('box_packing' !== tabClass) return tabClass;

	// Set the packing method value to 'box_packing' and trigger change event.
	jQuery(PH_UPS_PREFIX + 'packing_method').val('box_packing').trigger('change');
	wf_load_packing_method_options();
	ph_toggle_box_packing_options_based_on_algorithms();

	return 'packaging';
}

/**
 * Limits the input field to a specified maximum length and allows only numbers, '+', '-', '(', and ')'.
 *
 * @param {string} input - The jQuery selector for the input field.
 * @param {number} maxLength - The maximum allowed length for the input value.
 */
function ph_validate_phone_num( input, maxLength ) {
	jQuery(input).on('input', function () {
		let value = jQuery(this).val();

		// Allow only numbers, +, -, (, and )
		value = value.replace(/[^0-9+\-()]/g, '');

		// Trim to maxLength characters if exceeded
		if (value.length > maxLength) {
			value = value.substring(0, maxLength);
		}

		jQuery(this).val(value);
	});
}

/**
 * Validates and updates the min and max attributes for shipping cost and weight limit fields.
 *
 * @param {HTMLElement|string} minField - The minimum input field (can be a reference or selector).
 * @param {HTMLElement|string} maxField - The maximum input field (can be a reference or selector).
 */
function ph_ups_validate_min_and_max_settings(minField, maxField) {
	
	let minSettingVal = parseFloat( jQuery(minField).val() ) || 0;
	let maxSettingVal = parseFloat( jQuery(maxField).val() ) || 0;

	jQuery(minField).attr('max', maxSettingVal > 0 ? maxSettingVal : '');
	jQuery(maxField).attr('min', minSettingVal > 0 ? minSettingVal : '');
}

/**
 * Toggles the 'required' attribute for a set of input fields based on the state of a checkbox.
 *
 * @param {string} checkboxSelector - The jQuery selector for the checkbox that controls the required state.
 * @param {string[]} fieldSelectors - An array of jQuery selectors for the fields that should be required when the checkbox is checked.
 */
function ph_ups_make_fields_required(checkboxSelector, fieldSelectors) {
	let isChecked = jQuery(checkboxSelector).is(':checked');

	fieldSelectors.forEach(function (selector) {
		jQuery(selector).prop('required', isChecked);
	});
}

/**
 * Toggle Default Phone Number settings
 */
function ph_toggle_ups_default_recipient_ph_num() {

	let defaultRecipientPhoneNum = jQuery(PH_UPS_PREFIX + 'default_recipient_phone_num');

	if (jQuery(PH_UPS_PREFIX + 'default_recipient_phone').is(':checked')) {
		defaultRecipientPhoneNum.closest('tr').show();
		defaultRecipientPhoneNum.prop('required', true);
	} else {
		defaultRecipientPhoneNum.closest('tr').hide();
		defaultRecipientPhoneNum.prop('required', false);
	}
}

function ph_ship_from_address_for_freight() {

	if (jQuery(PH_UPS_PREFIX + "enable_freight").is(':checked') && jQuery(PH_UPS_PREFIX + "ship_from_address_different_from_shipper").is(':checked')) {

		jQuery(PH_UPS_PREFIX + "ship_from_address_for_freight").closest('tr').show();
	} else {

		jQuery(PH_UPS_PREFIX + "ship_from_address_for_freight").closest('tr').hide();
	}
}

function ph_ups_toggle_based_on_restricted_article() {

	if (jQuery(PH_UPS_PREFIX + 'international_special_commodities').is(':checked') && jQuery(PH_UPS_PREFIX + 'ph_ups_restricted_article').is(':checked')) {

		jQuery('.ph_restricted_article').closest('tr').show();
	} else {

		jQuery('.ph_restricted_article').closest('tr').hide();
	}
}

function ph_ups_toggle_based_on_saturday_delivery() {

	const $sat_del = jQuery(PH_UPS_PREFIX + 'saturday_delivery');
	const isChecked = $sat_del.is(':checked');

	jQuery(PH_UPS_PREFIX + 'saturday_delivery_suffix').closest('tr').toggle(isChecked);
}

function ph_ups_show_max_limit_error() {
	jQuery('.ph_ups_max_limit_error').hide();
	val = jQuery(PH_UPS_PREFIX + 'accesspoint_max_limit').val();
	if (val < 1 || val > 50) {
		jQuery(PH_UPS_PREFIX + 'accesspoint_max_limit').after("<p style='color:red' class='ph_ups_max_limit_error'>Please enter a valid value. (Valid Values : 1-50)</p>");
	}
}

// Toggle based on checkbox status
function ph_ups_toggle_based_on_checkbox_status(tocheck, to_toggle) {
	if (!jQuery(tocheck).is(':checked')) {
		jQuery(to_toggle).closest('tr').hide();
	}
	else {
		jQuery(to_toggle).closest('tr').show();
	}
}

// Silent debug
function ph_ups_silent_debug_option() {

	var checked = jQuery(PH_UPS_PREFIX + 'debug').is(":checked");

	if (checked) {

		jQuery('.ph_ups_silent_debug').closest('tr').show();

	} else {

		jQuery('.ph_ups_silent_debug').closest('tr').hide();

	}
}

function ph_ups_address_validation_options() {

	if (jQuery(PH_UPS_PREFIX + 'residential').is(':checked')) {

		jQuery(PH_UPS_PREFIX + 'address_validation').closest('tr').hide();
		jQuery(PH_UPS_PREFIX + 'suggested_address').closest('tr').hide();
		jQuery(PH_UPS_PREFIX + 'suggested_display').closest('tr').hide();
	} else {

		jQuery(PH_UPS_PREFIX + 'address_validation').closest('tr').show();

		if (jQuery(PH_UPS_PREFIX + 'address_validation').is(':checked')) {

			jQuery(PH_UPS_PREFIX + 'suggested_address').closest('tr').show();

			if (jQuery(PH_UPS_PREFIX + 'suggested_address').is(':checked')) {

				jQuery(PH_UPS_PREFIX + 'suggested_display').closest('tr').show();

			} else {

				jQuery(PH_UPS_PREFIX + 'suggested_display').closest('tr').hide();
			}
		} else {

			jQuery(PH_UPS_PREFIX + 'suggested_address').closest('tr').hide();
			jQuery(PH_UPS_PREFIX + 'suggested_display').closest('tr').hide();
		}

	}
}

function ph_ups_load_availability_options() {
	available = jQuery(PH_UPS_PREFIX + 'availability');
	if (available.val() == 'all') {
		jQuery(PH_UPS_PREFIX + 'countries').closest('tr').hide();
	} else {
		jQuery(PH_UPS_PREFIX + 'countries').closest('tr').show();
	}
}

/**
 * Toggle Tradability Cart Title
 */
function ph_ups_tradability_cart_title() {

	if (jQuery(PH_UPS_PREFIX + 'ups_tradability').is(':checked')) {
		jQuery(PH_UPS_PREFIX + "tradability_cart_title").closest('tr').show();
	}
	else {
		jQuery(PH_UPS_PREFIX + "tradability_cart_title").closest('tr').hide();
	}
}

function ph_ups_email_notification_code_trigger() {

	var test = jQuery(PH_UPS_PREFIX + 'email_notification').val();

	if (test && test.length) {

		jQuery(PH_UPS_PREFIX + "email_notification_code").closest('tr').show();
	}
	else {

		jQuery(PH_UPS_PREFIX + "email_notification_code").closest('tr').hide();
	}
}

/**
 * Toggle Label Size option.
 */
function ph_toggle_ups_label_size() {

	if (jQuery(PH_UPS_PREFIX + "print_label_type").val() == 'gif' || jQuery(PH_UPS_PREFIX + "print_label_type").val() == 'png') {

		jQuery(PH_UPS_PREFIX + "show_label_in_browser").closest('tr').show();
		ph_ups_toggle_based_on_checkbox_status(PH_UPS_PREFIX + 'show_label_in_browser', PH_UPS_PREFIX + 'label_in_browser_zoom');
	} else {

		jQuery(PH_UPS_PREFIX + "show_label_in_browser").closest('tr').hide();
		jQuery(PH_UPS_PREFIX + "label_in_browser_zoom").closest('tr').hide();
	}
}

/**
 * Toggle Label Zoom Factor
 */
function ph_toggle_ups_label_zoom_factor() {

	var labelInBrowser = jQuery(PH_UPS_PREFIX + 'show_label_in_browser').is(':checked');
	var labelType = jQuery(PH_UPS_PREFIX + "print_label_type").val();

	if (labelInBrowser && (labelType == 'gif' || labelType == 'png')) {

		jQuery(PH_UPS_PREFIX + "label_in_browser_zoom").closest('tr').show();
		jQuery(PH_UPS_PREFIX + "rotate_label").closest('tr').show();
		jQuery(".ups_display_browser_options").closest('tr').show();

	} else {
		jQuery(PH_UPS_PREFIX + "label_in_browser_zoom").closest('tr').hide();
		jQuery(PH_UPS_PREFIX + "rotate_label").closest('tr').hide();
		jQuery(".ups_display_browser_options").closest('tr').hide();
	}
}

/**
 * Toggle Custom Tracking
 */
function ph_toggle_ups_custom_tracking() {

	if (jQuery(PH_UPS_PREFIX + 'custom_tracking').is(':checked')) {
		jQuery(PH_UPS_PREFIX + "custom_tracking_url").closest('tr').show();
	}
	else {
		jQuery(PH_UPS_PREFIX + "custom_tracking_url").closest('tr').hide();
	}
}

/**
 * Toggle Automatic Label Generation
 */
function ph_automate_label_generation_trigger() {

	let checked1 = jQuery(PH_UPS_PREFIX + 'automate_label_generation').is(":checked");
	let checked2 = jQuery(PH_UPS_PREFIX + 'automate_package_generation').is(":checked");
	if (checked1 && checked2) {
		jQuery(PH_UPS_PREFIX + 'automate_label_trigger').closest('tr').show();
	} else {
		jQuery(PH_UPS_PREFIX + 'automate_label_trigger').closest('tr').hide();
	}
}

/**
 * Toggle Label Format based on Print Label Type option and Display Label in Browser.
 */
function ph_ups_toggle_label_format() {

	if (jQuery(PH_UPS_PREFIX + "print_label_type").val() == 'gif' || jQuery(PH_UPS_PREFIX + "print_label_type").val() == 'png') {

		jQuery(PH_UPS_PREFIX + "label_format").closest('tr').show();
	} else {

		jQuery(PH_UPS_PREFIX + "label_format").closest('tr').hide();
	}
}

/**
 * Toggle UPS Label Email Settings.
 */
function ph_ups_toggle_label_email_settings() {

	let sendLabelTO = jQuery(PH_UPS_PREFIX + "auto_email_label").val();

	if (sendLabelTO == '') {

		jQuery(".ph_ups_email_label_settings").closest('tr').hide();
		jQuery(PH_UPS_PREFIX + "email_recipients").closest('tr').hide();
	} else {

		jQuery(".ph_ups_email_label_settings").closest('tr').show();

		if (jQuery.isArray(sendLabelTO) && sendLabelTO.includes("shipper")) {

			jQuery(PH_UPS_PREFIX + "email_recipients").closest('tr').show();
		} else {

			jQuery(PH_UPS_PREFIX + "email_recipients").closest('tr').hide();
		}
	}
}

/**
 * Custom Description For Label
*/
function ph_ups_custom_description_for_label() {

	if (jQuery(PH_UPS_PREFIX + "label_description").val() == 'custom_description') {

		jQuery(PH_UPS_PREFIX + "label_custom_description").prop("required", true).closest('tr').show();
	} else {

		jQuery(PH_UPS_PREFIX + "label_custom_description").prop("required", false).closest('tr').hide();
	}
}

/**
 * Additional Shipment Description
*/
function ph_toggle_additional_description() {

	if (jQuery(PH_UPS_PREFIX + "label_description").val() == 'order_number') {

		jQuery(".ph_additional_shipment_description").closest('tr').hide();
	} else {

		jQuery(".ph_additional_shipment_description").closest('tr').show();
	}
}

/**
 *  Automate Package Generation Check box checked
**/
function ph_ups_toggle_based_automate_pakage_generation() {

	if (jQuery(PH_UPS_PREFIX + 'automate_package_generation').is(':checked')) {
		
		jQuery(PH_UPS_PREFIX + "automate_label_generation").closest('tr').show();
	} else {

		jQuery(PH_UPS_PREFIX + "automate_label_generation").closest('tr').hide();
		jQuery(PH_UPS_PREFIX + 'automate_label_generation').removeAttr('checked');
	}

}

function ph_ups_toggle_nafta_certificate_options() {
	let check1 = jQuery(PH_UPS_PREFIX + 'commercial_invoice').is(':checked');
	let check2 = jQuery(PH_UPS_PREFIX + 'nafta_co_form').is(':checked')

	if (check1 && check2) {
		jQuery('.ph_ups_nafta_group').closest('tr').show();
	}
	else {
		jQuery('.ph_ups_nafta_group').closest('tr').hide();
	}
}

function ph_ups_eei_options() {
	let check1 = jQuery(PH_UPS_PREFIX + 'commercial_invoice').is(':checked');
	let check2 = jQuery(PH_UPS_PREFIX + 'eei_data').is(':checked')

	if (check1 && check2) {
		jQuery('.ph_ups_eei_group').closest('tr').show();
	}
	else {
		jQuery('.ph_ups_eei_group').closest('tr').hide();
	}
}

function ph_ups_load_shipper_filed_options() {

	var eei_filed_option = jQuery(PH_UPS_PREFIX + 'eei_shipper_filed_option').val();
	var invoice_enabled = jQuery(PH_UPS_PREFIX + 'commercial_invoice').is(":checked");
	var eei_enabled = jQuery(PH_UPS_PREFIX + 'eei_data').is(":checked");

	if (invoice_enabled && eei_enabled) {
		if (eei_filed_option == 'A') {

			jQuery('.eei_pre_departure_itn_number').closest('tr').show();
			jQuery('.eei_exemption_legend').closest('tr').hide();

		} else if (eei_filed_option == 'B') {

			jQuery('.eei_pre_departure_itn_number').closest('tr').hide();
			jQuery('.eei_exemption_legend').closest('tr').show();

		} else {

			jQuery('.eei_pre_departure_itn_number').closest('tr').hide();
			jQuery('.eei_exemption_legend').closest('tr').hide();

		}
	}

}

// Toggle vendor_collect_id_number field
function ph_ups_toggle_vendor_collect_id_number() {

	let check1 = jQuery(PH_UPS_PREFIX + 'commercial_invoice').is(':checked');
	let check2 = jQuery(PH_UPS_PREFIX + 'vendor_info').is(':checked')
	
	if (check1 && check2) {
		jQuery(PH_UPS_PREFIX + 'vendor_collect_id_number').closest('tr').show();
		jQuery(PH_UPS_PREFIX + 'default_consignee_type').closest('tr').show();
	}
	else {
		jQuery(PH_UPS_PREFIX + 'vendor_collect_id_number').closest('tr').hide();
		jQuery(PH_UPS_PREFIX + 'default_consignee_type').closest('tr').hide();
	}
}

function wf_load_packing_method_options() {
	pack_method = jQuery(PH_UPS_PREFIX + 'packing_method').val();

	jQuery('#ph_ups_packing_options').hide();
	jQuery('.weight_based_option').closest('tr').hide();
	jQuery('.xa_ups_box_packing').closest('tr').hide();

	switch (pack_method) {

		case 'box_packing':
			jQuery('.xa_ups_box_packing').closest('tr').show();
			jQuery('#ph_ups_packing_options').show();
			break;

		case 'weight_based':
			jQuery('.weight_based_option').closest('tr').show();

			let boxMaxQuantity = jQuery(PH_UPS_PREFIX + 'box_max_quantity').closest('tr');
		
			if( ph_ups_settings.ph_is_oauth_reg ) {
				boxMaxQuantity.show();
			} else {
				boxMaxQuantity.hide();
			}
			break;

		case 'per_item':

		default:
			break;
	}
}

function ph_toggle_box_packing_options_based_on_algorithms() {

	pack_method = jQuery(PH_UPS_PREFIX + 'packing_method').val();
	packing_algorithm = jQuery(PH_UPS_PREFIX + 'packing_algorithm').val();

	// Show/hide relevant rows based on packing_algorithm and pack_method
	const isBoxPacking = (pack_method === 'box_packing');

	jQuery('.exclude_box_weight').closest('tr').toggle(
		packing_algorithm === 'volume_based' && isBoxPacking
	);

	jQuery('.stack_to_volume').closest('tr').toggle(
		packing_algorithm === 'stack_first' && isBoxPacking
	);
}

function wf_ups_load_pickup_options() {
	var checked = jQuery(PH_UPS_PREFIX + 'pickup_enabled').is(":checked");
	if (checked) {
		jQuery('.wf_ups_pickup_grp').closest('tr').show();
	} else {
		jQuery('.wf_ups_pickup_grp').closest('tr').hide();
	}
	wf_ups_load_working_days();
}

function wf_ups_load_working_days() {

	var pickup_date = jQuery(PH_UPS_PREFIX + 'pickup_date').val();
	var checked = jQuery(PH_UPS_PREFIX + 'pickup_enabled').is(":checked");

	if (!checked || pickup_date != 'specific') {
		jQuery('.pickup_working_days').closest('tr').hide();
	} else {
		jQuery('.pickup_working_days').closest('tr').show();
	}
}

/**
 * Duties and taxes select box
**/
function xa_ups_duties_payer_options() {

	val = jQuery(PH_UPS_PREFIX + "duties_and_taxes").val();
	if (val == 'third_party') {

		jQuery(PH_UPS_PREFIX + "shipping_payor_acc_no").closest('tr').show();
		jQuery(PH_UPS_PREFIX + "shipping_payor_post_code").closest('tr').show();
		jQuery(PH_UPS_PREFIX + "shipping_payor_country_code").closest('tr').show();

	} else {

		jQuery(PH_UPS_PREFIX + "shipping_payor_acc_no").closest('tr').hide();
		jQuery(PH_UPS_PREFIX + "shipping_payor_post_code").closest('tr').hide();
		jQuery(PH_UPS_PREFIX + "shipping_payor_country_code").closest('tr').hide();
	}
}

function ph_ups_transportation_options() {

	val = jQuery(PH_UPS_PREFIX + "transportation").val();

	if (val == 'third_party') {

		jQuery(PH_UPS_PREFIX + "transport_payor_acc_no").closest('tr').show();
		jQuery(PH_UPS_PREFIX + "transport_payor_post_code").closest('tr').show();
		jQuery(PH_UPS_PREFIX + "transport_payor_country_code").closest('tr').show();

	} else {

		jQuery(PH_UPS_PREFIX + "transport_payor_acc_no").closest('tr').hide();
		jQuery(PH_UPS_PREFIX + "transport_payor_post_code").closest('tr').hide();
		jQuery(PH_UPS_PREFIX + "transport_payor_country_code").closest('tr').hide();
	}
}

function ph_ups_include_tax() {

	val = jQuery(PH_UPS_PREFIX + "invoice_commodity_value").val();

	if (val == 'discount_price') {

		jQuery(PH_UPS_PREFIX + "include_tax").closest('tr').show();

	} else {

		jQuery(PH_UPS_PREFIX + "include_tax").closest('tr').hide();

	}
}

/**
 * Function to get URL parameter by name
 */
function ph_ups_get_url_parameter(name) {
	name        = name.replace( /[\[]/, '\\[' ).replace( /[\]]/, '\\]' );
	let regex   = new RegExp( '[\\?&]' + name + '=([^&#]*)' );
	let results = regex.exec( location.search );
	return results === null ? '' : decodeURIComponent( results[1].replace( /\+/g, ' ' ) );
};

/**
 * Add subtab key value pair to the url
 */
function ph_ups_update_subtab_to_url() {

	const ph_ups_plugin_id = ph_ups_settings.plugin_id;

	// Check if you are on the UPS plugin page
	if (window.location.href.includes( ph_ups_plugin_id )) {
		let currentUrl = window.location.href;
		let separator = currentUrl.includes('?') ? '&' : '?';

		// Get the class name of the active subtab and extract the value
		let subtabName = jQuery('.ph-ups-tabs.nav-tab-active').attr('class').match(/tab_([^\s]+)/)?.[1] || '';

		// Check if 'subtab' key is already present in the URL
		let newUrl = currentUrl.includes('subtab=')
			? subtabName ? currentUrl.replace(/(subtab=)[^\&]+/, '$1' + subtabName) : currentUrl.replace(/(\&?subtab=)[^\&]+/, '')
			: currentUrl + separator + 'subtab=' + subtabName;
		window.history.replaceState({}, null, newUrl);
	}
}

// Generates a unique box name index based on the provided size.
function ph_ups_generate_unique_box_name(size) {

	// Locate the table body within the `.ups_boxes` container
	let $tbody = jQuery('.ups_boxes').find('tbody');
	let new_box_name;

	// Loop until a unique box name is found
	do {
		// Generate the box name with the current size index
		new_box_name = `boxes_name[${size}]`;

		// Check if an input with this box name already exists
		let exists = $tbody.find(`input[name="${new_box_name}"]`).length > 0;

		// If no existing box name matches, break out of the loop
		if (!exists) break;

		// Increment size to check the next possible name if a match was found
		size++;
	} while (true);

	// Return the unique size index for the box name
	return size;
}