jQuery(document).ready(function () {

	jQuery('#ph-ups-clear-table-history').hide();
	jQuery('#ph-ups-cleanup-cron-type').select2();

	// Toggle Cleanup settings.
	ph_toggle_ups_cleanup_settings();

	jQuery('#ph-ups-enabled-cleanup-cron').change(
		function () {
			ph_toggle_ups_cleanup_settings();
		}
	);

	jQuery("#ph-ups-cleanup-save").click( function() {

		if (!jQuery('#ph-ups-enabled-cleanup-cron').is(':checked')) {
			return true;
		}

		let cleanup_older_day = jQuery("#ph-ups-cleanup-older-day").val().trim();

		if ( '' != cleanup_older_day && cleanup_older_day < 90 ) {
			jQuery("#ph-ups-cleanup-older-day").css("border", "1px solid red");
		} else {
			jQuery("#ph-ups-cleanup-older-day").css("border", "1px solid black");
			jQuery('#ph-ups-confirmation-popup').fadeIn();
		}
		
		return false;
	});

	jQuery('#ph-ups-cleanup-proceed-btn').click(function() {
	    jQuery('#ph-ups-confirmation-popup').fadeOut();
		jQuery('#ph-ups-cleanup-settings-form').submit();
	});

	jQuery('#ph-ups-cleanup-cancel-btn').click(function() {
	    jQuery('#ph-ups-confirmation-popup').fadeOut();
	});

	jQuery(".ph-ups-old-meta-delete-history").click( function() {
		
		jQuery('.ph-ups-cleanup-toggle-symbol').toggleClass('ph-ups-cleanup-toggle-symbol-click');
		jQuery('#ph-ups-clear-table-history').toggle();
		jQuery('.ph-ups-old-meta-delete-history-table').toggle();
	});

	// Pop up deleted orders history.
	jQuery(".ph-ups-show-deleted-orders").click( function() {

		var ph_orders = jQuery(this).closest('td').find('.ph-ups-cleanup-orders').val();

		jQuery("#ph-ups-popup-details").html("<p>The data of the following order(s) was cleared in this cleanup:<br></p>"+ph_orders);

		$("#ph-ups-overlay, #ph-ups-cleanup-deleted-orders-popup").fadeIn(); // Show popup and overlay.
        $("body").css("overflow", "hidden");
	});

    // Close popup when clicking anywhere on the screen or close button.
	jQuery(document).on("click", "#ph-ups-overlay, .ph-ups-close-popup", function() {
		jQuery("#ph-ups-overlay, #ph-ups-cleanup-deleted-orders-popup").fadeOut(function() {
			jQuery('#ph-ups-popup-details').empty(); // Clear popup content after fade out
		});

		// Restore scrolling to the page.
		jQuery("body").css("overflow", "auto");
	});

	// Clear Delete Meta History Table.
	jQuery("#ph-ups-clear-table-history").click( function() {

		let key_data = {
			action : 'ph_ups_clear_history_of_cleanup_table',
		}
		
		jQuery.post( ajaxurl, key_data, function( result, status ) {

			let response = JSON.parse(result);
			if( response.status == true ) {
				jQuery(".ph-ups-old-meta-delete-history-div").after(response.message);
				jQuery(".ph-ups-old-meta-delete-history-div").remove();
			}
		});
	});

	/**
	 * Toggles the visibility of cleanup settings based on checkbox state.
	 */
	function ph_toggle_ups_cleanup_settings() {
		if (jQuery('#ph-ups-enabled-cleanup-cron').is(':checked')) {
			jQuery(".ph-ups-cleanup-settings").closest("tr").show();
		} else {
			jQuery(".ph-ups-cleanup-settings").closest("tr").hide();
		}
	}

});