//phpcs:disable
/**
 * JQuery script for handling various admin page actions related to WooCommerce UPS Shipping Plugin with Print Label.
 *
 * @package ups-woocommerce-shipping
 */

jQuery(document).ready(function() {
    // Set initial state based on current checkbox value
    toggleInsuranceFields(jQuery('#ups_insurance').is(':checked'));
    
    // Initial Saturday delivery state check
    if (typeof handleSaturdayDeliveryState === 'function') {
        handleSaturdayDeliveryState();
    }
    
    // Handle insurance checkbox changes
    jQuery('#ups_insurance').on('change', function() {
        toggleInsuranceFields(jQuery(this).is(':checked'));
    });
    
    // Handle return shipment toggle
    jQuery('#ups_return').on('change', function() {
        if (jQuery(this).is(':checked')) {
            jQuery('#ret_s').show();
        } else {
            jQuery('#ret_s').hide();
        }
    });

    // Handle calculated shipping rates radio button changes
    jQuery(document).on('change', 'input[name="wf_ups_service_choosing_radio"]', function() {
        var selectedValue = jQuery('input[name="wf_ups_service_choosing_radio"]:checked').val();
        
        if (selectedValue == 'wf_ups_individual_service') {
            jQuery(".ups_manual_service").prop("disabled", false);
        } else {
            jQuery(".ups_manual_service").val(selectedValue).change();
            jQuery(".ups_manual_service").prop("disabled", true);
        }
        
        // Check Saturday delivery state after service selection changes
        if (typeof handleSaturdayDeliveryState === 'function') {
            handleSaturdayDeliveryState();
        }
    });
});

// ups-saturday-delivery.js
function handleSaturdayDeliveryState() {
    var saturdayDeliveryCheckbox = jQuery('#ups_sat_delivery');
    var hasValidSaturdayService = false;

    // Check the calculated shipping rates (from "Calculate Shipping Cost")
    jQuery('input[name="wf_ups_service_choosing_radio"]:checked').each(function() {
        var selectedRateService = jQuery(this).val();
        
        // Check if it's not the individual service option
        if (selectedRateService && selectedRateService !== 'wf_ups_individual_service') {
            // Extract the actual service code from the full service ID
            // If the format is "ups:service_code", get the part after the colon
            var actualServiceCode = selectedRateService;
            if (selectedRateService.includes(':')) {
                var serviceParts = selectedRateService.split(':');
                actualServiceCode = serviceParts[serviceParts.length - 1]; // Get the last part
            }
            
            // Check if this service ends with '_sat'
            if (actualServiceCode.toString().endsWith('_sat')) {
                hasValidSaturdayService = true;
                return false;
            }
        }
    });

    // Handle Saturday delivery checkbox based on service selection
    if (hasValidSaturdayService) {
        saturdayDeliveryCheckbox.prop('checked', true);
        saturdayDeliveryCheckbox.prop('disabled', true);
    } else {
        saturdayDeliveryCheckbox.prop('disabled', false);
    }
}

/**
 * Toggle Insurance Fields visibility based on checkbox state
 *
 * @param {boolean} isVisible - Whether to show or hide insurance fields
 */
function toggleInsuranceFields(isVisible) {
    if (isVisible) {
        jQuery('.ups-insurance-column-header').show();
        jQuery('.ups-insurance-column-data').show();
    } else {
        jQuery('.ups-insurance-column-header').hide();
        jQuery('.ups-insurance-column-data').hide();
    }
}

