<?php

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('PH_UPS_REST_Migration')) {

    /**
     * Class PH_UPS_REST_Migration
     *
     * Handles the display and management of the migration banner for UPS OAuth 2.0 authentication.
     *
     * @package PluginHive\UPS
     */
    class PH_UPS_REST_Migration
    {

        /**
         * Option key for banner display.
         *
         * @var string
         */
        private static $ph_migration_banner_option = 'ph_ups_display_rest_migration_banner_v6.3.0';

        /**
         * Banner display flag.
         *
         * @var string
         */
        public $ph_display_migration_banner;

        /**
         * Constructor.
         * Initializes banner display settings and hooks.
         */
        public function __construct()
        {
            $this->ph_display_migration_banner = get_option(self::$ph_migration_banner_option, 'yes');

            if (!class_exists('PH_WC_UPS_Settings_Helper')) {
                require_once PH_WC_UPS_PLUGIN_DIR_PATH . 'includes/settings/class-ph-ups-settings-helper.php';
            }

            $settings_helper = new PH_WC_UPS_Settings_Helper();
            $settings = $settings_helper->settings;

            add_action('wp_ajax_ph_ups_close_rest_migration_banner', [$this, 'ph_ups_close_rest_migration_banner'], 10);

            if (
                'yes' === $this->ph_display_migration_banner &&
                !Ph_UPS_Woo_Shipping_Common::ph_is_oauth_registered_customer() &&
                !empty($settings['access_key'])
            ) {
                add_action('admin_notices', [$this, 'ph_ups_add_rest_migration_banner']);
            }
        }

        /**
         * Renders the REST migration admin notice banner.
         *
         * @return void
         */
        public function ph_ups_add_rest_migration_banner()
        {
            ?>
            <div class="notice notice-warning is-dismissible">

                <h3><strong><?php esc_html_e('Plugin Notice: UPS Integration Updated to OAuth 2.0', 'ups-woocommerce-shipping'); ?></strong></h3>

                <p>
                    <?php
                    printf(
                        /* translators: %s: Plugin Name */
                        esc_html__('Support for Legacy UPS Access Keys has been discontinued from the version of the %s (v6.3.0).', 'ups-woocommerce-shipping'),
                        '<b>' . esc_html__('WooCommerce UPS Shipping Plugin with Print Label', 'ups-woocommerce-shipping') . '</b>'
                    );
                    ?>
                </p>

                <hr>

                <p><strong><?php esc_html_e('Impact:', 'ups-woocommerce-shipping'); ?></strong> 
                    <?php esc_html_e('If you are still using a Legacy Access Key, shipping functionality is now disabled.', 'ups-woocommerce-shipping'); ?>
                </p>

                <p><strong><?php esc_html_e('Recommendation:', 'ups-woocommerce-shipping'); ?></strong> 
                    <?php esc_html_e('To continue using UPS shipping services, you must migrate to OAuth 2.0 authentication.', 'ups-woocommerce-shipping'); ?>
                </p>

                <p><strong><?php esc_html_e('Action Required:', 'ups-woocommerce-shipping'); ?></strong>
                    <?php esc_html_e('Register your UPS account using OAuth 2.0 within the plugin settings.', 'ups-woocommerce-shipping'); ?>
                </p>

                <p><?php esc_html_e('Refer to our step-by-step guide for OAuth 2.0 registration at', 'ups-woocommerce-shipping'); ?>
                    <a href="https://www.pluginhive.com/knowledge-base/setting-woocommerce-ups-shipping-plugin/?utm_source=ups&utm_medium=plugin_settings#add_ups_account" target="_blank" rel="noopener noreferrer">
                        <?php esc_html_e('OAuth 2.0 Registration Guide', 'ups-woocommerce-shipping'); ?>
                    </a>.
                </p>

                <p>
                    <a class="button button-primary" href="<?php echo admin_url('/admin.php?page=ph_ups_registration'); ?>" target="_blank" rel="noopener noreferrer">
                        <?php esc_html_e('Register with OAuth 2.0', 'ups-woocommerce-shipping'); ?>
                    </a>
                </p>

                <hr>

                <p><strong><?php esc_html_e('Need Assistance?', 'ups-woocommerce-shipping'); ?></strong> 
                    <?php esc_html_e('Our support team is ready to assist you with OAuth 2.0 registration.', 'ups-woocommerce-shipping'); ?>
                </p>

                <p style="margin-top: 15px;">
                    <button type="button" class="ph-ups-close-oauth-banner ph-ups-close-notice button">
                        <?php esc_html_e('Close', 'ups-woocommerce-shipping'); ?>
                    </button>
                    &nbsp;
                    <a class="button button-primary" href="https://www.pluginhive.com/support/?utm_source=ups&utm_medium=plugin_settings" target="_blank" rel="noopener noreferrer">
                        <?php esc_html_e('Contact Support', 'ups-woocommerce-shipping'); ?>
                    </a>
                </p>

            </div>
            <?php
        }

        /**
         * Handles AJAX request to close the migration banner.
         *
         * @return void
         */
        public function ph_ups_close_rest_migration_banner()
        {
            if (!check_ajax_referer('ph-ups-close-oauth-banner', '_ajax_nonce', false)) {
                wp_send_json_error(['message' => 'Security check failed (invalid nonce).']);
            }

            update_option(self::$ph_migration_banner_option, 'no');
            wp_send_json_success(true);
        }
    }

    new PH_UPS_REST_Migration();
}
