<?php

if (!class_exists('PH_UPS_Registration_Menu')) {

	class PH_UPS_Registration_Menu
	{
		/**
		 * @var string|null $ph_shedule_event_notice
		 */
		public static $ph_shedule_event_notice;

		public function __construct()
		{

			add_action('admin_menu', array($this, 'ph_ups_registration_menu'));

			// Update Account to our our account once registration successfull - Multi Warehoiuse
			// add_filter('ph_ups_plugin_settings', array($this, 'ph_modify_ups_settings_data'), 10, 2);

		}

		/**
		 * Admin Menu
		 */
		public function ph_ups_registration_menu()
		{

			// Add Menu Page for Settings
			add_menu_page(
				__('UPS Shipping', 'ups-woocommerce-shipping'),
				__('UPS Shipping', 'ups-woocommerce-shipping'),
				'manage_woocommerce',
				'ph_ups_registration',
				array($this, 'ph_ups_registration_page'),
				plugins_url('ups-woocommerce-shipping') . '/resources/images/ups-menu-icon.svg',
				56
			);

			add_submenu_page(
				'ph_ups_registration',
				__('Registration', 'ups-woocommerce-shipping'),
				__('Registration', 'ups-woocommerce-shipping'),
				'manage_woocommerce',
				'ph_ups_registration',
				array($this, 'ph_ups_registration_page')
			);

			add_submenu_page(
				'ph_ups_registration',
				__('Settings', 'ups-woocommerce-shipping'),
				__('Settings', 'ups-woocommerce-shipping'),
				'manage_woocommerce',
				'ph_ups_plugin_settings',
				array($this, 'ph_ups_plugin_setting_page')
			);

			// Add a advanced submenu
			add_submenu_page(
				'ph_ups_registration',
				__('Advanced', 'ups-woocommerce-shipping'),
				__('Advanced', 'ups-woocommerce-shipping'),
				'manage_woocommerce',
				'ph-ups-cleanup',
				array($this, 'ph_ups_clean_up')
			);

			add_submenu_page(
				'ph_ups_registration',
				__( 'Extensions', 'ups-woocommerce-shipping' ),
				__( 'Extensions', 'ups-woocommerce-shipping' ),
				'manage_woocommerce',
				'ph-ups-plugin-extensions',
				array( $this, 'ph_ups_plugin_extension_page' ),
				20
			);
		}

		/**
		 * UPS Registration
		 */
		public function ph_ups_registration_page()
		{
			include_once('html-ph-ups-registration-page-content.php');
		}

		/**
		 * UPS Plugin Settings
		 */
		public function ph_ups_plugin_setting_page()
		{

			if (!headers_sent() && is_admin()) {

				wp_redirect(admin_url('/admin.php?page=wc-settings&tab=shipping&section=wf_shipping_ups'));
				exit;
			}
		}

		/**
		 * Cleanup Screen Output
		**/
		public function ph_ups_clean_up() {

			include_once PH_WC_UPS_PLUGIN_DIR_PATH . 'includes/cleanup/ph-ups-cleanup-html.php';
		}

		/**
		 * Extensions
		 */
		public function ph_ups_plugin_extension_page() {

			if ( ! headers_sent() && is_admin() ) {

				include PH_WC_UPS_PLUGIN_DIR_PATH . 'includes/extensions/ph-ups-ext-view-html.php';
			}
		}
	}

	new PH_UPS_Registration_Menu();
}
