<?php

if ( ! class_exists( 'PH_UPS_Weight_Packing' ) ) {

	include_once 'class-ph-ups-weight-packing-util.php';

	class PH_UPS_Weight_Packing {

		private $package_requests;
		private $pack_obj;

		public function __construct( $strategy, $options = array() ) {

			switch ( $strategy ) {
				case 'pack_ascending':
					include_once 'class-ph-ups-weight-packing-ascending.php';
					$this->pack_obj = new PH_UPS_Weight_Packing_Ascending();
					break;
				case 'pack_simple':
					include_once 'class-ph-ups-weight-packing-simple.php';
					$this->pack_obj = new PH_UPS_Weight_Packing_Simple();
					break;
				default:
					include_once 'class-ph-ups-weight-packing-descending.php';
					$this->pack_obj = new PH_UPS_Weight_Packing_Descending();
					break;
			}
		}

		public function set_max_weight( $max_weight ) {

			$this->pack_obj->set_max_weight( $max_weight );
		}

		/**
		 * Sets the max quantity of the box.
		 *
		 * @param float $max_quantity The quantity the box can hold.
		 *
		 * @return void
		 */		
		public function set_max_quantity( $max_quantity ) {

			$this->pack_obj->set_max_quantity( $max_quantity );
		}

		/**
		 * Sets the weight of the box.
		 *
		 * @param float $box_weight The weight of the box to be set.
		 *
		 * @return void
		 */
		public function set_box_weight( $box_weight ) {

			$this->pack_obj->set_box_weight( $box_weight );
		}

		public function add_item( $item_weight, $item_data, $quantity ) {

			$this->pack_obj->add_item( $item_weight, $item_data, $quantity );
		}

		public function pack_items() {

			$result = apply_filters( 'ph_ups_modify_weight_based_pack_items', null, $this->pack_obj, $this );

			if ( ! $result ) {

				$this->pack_obj->pack_items();
				$result = $this->get_result();
			}

			return $result;
		}

		public function get_packable_items() {

			return $this->pack_obj->get_packable_items();
		}

		public function get_result() {

			return $this->pack_obj->get_result();
		}
	}

	abstract class PH_UPS_Weight_Packing_Strategy {

		private $packable_items = array();
		private $max_weight;
		public $pack_util;
		private $result;
		private $box_weight;
		private $max_quantity;

		public function __construct() {

			$this->pack_util = new PH_UPS_Weight_Packing_Util();
		}

		/**
		 * Set the maximum weight.
		 *
		 * @param float $max_weight The maximum weight value to set.
		 */
		public function set_max_weight( $max_weight ) {

			$this->max_weight = $max_weight;
		}

		/**
		 * Get the maximum weight.
		 *
		 * @return float The maximum weight value.
		 */
		public function get_max_weight() {

			return $this->max_weight;
		}

		/**
		 * Set the maximum quantity.
		 *
		 * @param int $max_quantity The maximum quantity value to set.
		 */
		public function set_max_quantity( $max_quantity ) {

			$this->max_quantity = $max_quantity;
		}

		/**
		 * Get the maximum quantity.
		 *
		 * @return int The maximum quantity value.
		 */
		public function get_max_quantity() {

			return $this->max_quantity;
		}

		/**
		 * Sets the weight of the box.
		 *
		 * @param float $box_weight The weight of the box to be set.
		 *
		 * @return void
		 */
		public function set_box_weight( $box_weight ) {

			$this->box_weight = (float) $box_weight;
		}

		/**
		 * Retrieves the current weight of the box.
		 *
		 * @return float The weight of the box.
		 */
		public function get_box_weight() {

			return $this->box_weight;
		}

		public function set_result( $result ) {

			$this->result = $result;
		}

		public function get_result() {

			return $this->result;
		}

		public function get_packable_items() {

			return $this->packable_items;
		}

		public function add_item( $item_weight, $item_data, $quantity = 1 ) {

			for ( $i = 0;$i < $quantity;$i++ ) {

				$this->packable_items[] = array(

					'weight' => $item_weight,
					'data'   => $item_data,
				);
			}
		}

		abstract function pack_items();
	}

	class PH_UPS_Weight_Packing_Result {

		private $errors   = array();
		private $packed   = array();
		private $unpacked = array();

		public function set_error( $errors ) {

			$this->errors[] = $errors;
		}

		public function set_packed_boxes( $packages ) {

			$this->packed = $packages;
		}

		public function set_unpacked_items( $packages ) {

			$this->unpacked = $packages;
		}

		public function get_errors() {

			return $this->errors;
		}

		public function get_packed_boxes() {

			return $this->packed;
		}

		public function get_unpacked_items() {

			return $this->unpacked;
		}
	}
}
