<?php
/**
 * Plugin extensions HTML content for WooCommerce UPS Shipping Plugin.
 *
 * @package ups-woocommerce-shipping
 */

defined( 'ABSPATH' ) || exit();

// Including the file containing all the Extensible plugins.
require_once 'ph-ups-ext-details.php';

/**
 * Function to render each plugin block
 *
 * @param array  $plugins       The plugins array.
 * @param string $class_value   The class for the block.
 * @return void
 */
function ph_render_plugin_extensions_block( $plugins, $class_value ) {

	$new_tab_message = sprintf(
		'<span class="screen-reader-text">%1$s</span>',
		/* translators: Hidden accessibility text. */
		esc_html__( '(Opens in a new browser tab)', 'ups-woocommerce-shipping' )
	);

	foreach ( $plugins as $slug => $plugin ) : ?>
		<section class="<?php echo esc_attr( $class_value ); ?>">
			<h3>
				<img alt="plugin_product_image" class="ph-ext-plugin-img" src="<?php echo esc_url( $plugin['image'] ); ?>"/><br>
				<?php echo esc_html( $plugin['title'] ); ?>
			</h3>
			<?php if ( isset( $plugin['benefits'] ) ) : ?>
				<ul class="ph-ext-promo-benefits">
					<?php foreach ( $plugin['benefits'] as $benefit ) : ?>
						<li><?php echo esc_html( $benefit ); ?></li>
					<?php endforeach; ?>
				</ul>
			<?php endif; ?>

			<div class="ph-ext-button-container">
				<a target="_blank" class="ph-ext-button-upsell" href="<?php echo esc_url( $plugin['buy_url'] ); ?>">
					<?php esc_html_e( 'Buy Now', 'ups-woocommerce-shipping' ); ?>
					<?php
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Reason: $new_tab_message is properly escaped.
						echo $new_tab_message;
					?>
				</a>
				<a target="_blank" class="ph-ext-more-info" href="<?php echo esc_url( $plugin['info_url'] ); ?>">
					<?php esc_html_e( 'Visit Site', 'ups-woocommerce-shipping' ); ?>
					<?php
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Reason: $new_tab_message is properly escaped.
						echo $new_tab_message;
					?>
				</a>
			</div>
		</section>
		<?php
	endforeach;
}

?>
<div class="wrap">
	<div class="ph-logo-container"> 
		<?php require_once PH_WC_UPS_PLUGIN_DIR_PATH . 'includes/admin-views/ph-ups-page-header-html.php'; ?>
	</div>
	<div class="ph-ext-container">
		<h1><?php echo esc_html__( 'Optimized for Seamless Integration', 'ups-woocommerce-shipping' ); ?></h1>
		<h2><?php echo esc_html__( 'These plugins integrate flawlessly to provide a seamless and efficient experience across your store.', 'ups-woocommerce-shipping' ); ?></h2>

		<section class="ph-ext-promo-plugins">
			<?php ph_render_plugin_extensions_block( $extensible_plugins, 'ph-ext-promo-block' ); ?>
		</section>
		<hr>
		<h1><?php echo esc_html__( 'Discover More Possibilities', 'ups-woocommerce-shipping' ); ?></h1>
		<h2><?php echo esc_html__( 'Browse through our other plugins to find solutions that fit your unique needs.', 'ups-woocommerce-shipping' ); ?></h2>
		<section class="ph-ext-promo-plugins">
			<?php ph_render_plugin_extensions_block( $suggestive_plugins, 'ph-suggestive-ext-promo-block' ); ?>
		</section>
	</div>
</div>

<style>
	/* To hide any kind of notice on the extensions page*/
	.notice {
		display: none;
	}
</style>