<?php
/**
 * Extensible plugin details for WooCommerce UPS Shipping Plugin.
 *
 * @package ups-woocommerce-shipping
 */

defined( 'ABSPATH' ) || exit();

// List of extensible plugins from PluginHive.
$extensible_plugins = array(

	'fedex'              => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=3320&variation_id=3321&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/woocommerce-fedex-shipping-plugin-with-print-label/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'WooCommerce Shipping Plugin for FedEx with Print Label',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_fedex.jpg',
		'benefits' => array(
			__( 'Accurate FedEx Shipping Rates on Checkout', 'ups-woocommerce-shipping' ),
			__( 'Effortless FedEx Shipping Label Printing', 'ups-woocommerce-shipping' ),
			__( 'Automated Live Order Tracking with Notifications', 'ups-woocommerce-shipping' ),
			__( 'FedEx Compatible Plugin for WooCommerce', 'ups-woocommerce-shipping' ),
		),
	),

	'canada_post'        => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=3290&variation_id=3292&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/woocommerce-canada-post-shipping-plugin-with-print-label/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'WooCommerce Canada Post Shipping Plugin with Print Label',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_canada_post.jpg',
		'benefits' => array(
			__( 'Accurate Canada Post Rates on Checkout', 'ups-woocommerce-shipping' ),
			__( 'Effortless Canada Post Shipping Label Printing', 'ups-woocommerce-shipping' ),
			__( 'Automated Live Order Tracking with Notifications', 'ups-woocommerce-shipping' ),
			__( 'Canada Post Certified Plugin for WooCommerce', 'ups-woocommerce-shipping' ),
		),
	),

	'multi_carrier'      => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=3279&variation_id=3283&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/multiple-carrier-shipping-plugin-woocommerce/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'Multi-Carrier Shipping Plugin for WooCommerce',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_multi_carrier.jpg',
		'benefits' => array(
			__( 'Access Multiple Carrier Shipping Options', 'ups-woocommerce-shipping' ),
			__( 'Flexible WooCommerce Flat Rate Shipping Rules', 'ups-woocommerce-shipping' ),
			__( 'Multi-Vendor Shipping Capability', 'ups-woocommerce-shipping' ),
			__( 'Regional and International Coverage', 'ups-woocommerce-shipping' ),
		),
	),

	'tforce_freight'     => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=172070&variation_id=172077&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/woocommerce-tforce-freight-shipping-plugin-with-print-label/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'PH TForce Freight Shipping Plugin for WooCommerce with Print Label',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_tforce.jpg',
		'benefits' => array(
			__( 'Accurate TForce Freight Shipping Rates', 'ups-woocommerce-shipping' ),
			__( 'Effortless Shipping Label Printing', 'ups-woocommerce-shipping' ),
			__( 'Automated Order Tracking Notifications', 'ups-woocommerce-shipping' ),
			__( 'Customizable Shipping Methods & Cost', 'ups-woocommerce-shipping' ),
		),
	),

	'royalmail'          => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=285&variation_id=797&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/woocommerce-royal-mail-shipping-with-tracking/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'WooCommerce Royal Mail Shipping with Tracking',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_royalmail.jpg',
		'benefits' => array(
			__( 'Latest Royal Mail Shipping Rates', 'ups-woocommerce-shipping' ),
			__( 'Automated Order Tracking Notifications', 'ups-woocommerce-shipping' ),
			__( 'Customizable Shipping Methods & Cost', 'ups-woocommerce-shipping' ),
			__( 'Seamless WooCommerce Checkout Integration', 'ups-woocommerce-shipping' ),
		),
	),

	'postnord'           => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=131906&variation_id=162475&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/postnord-shipping-plugin-for-woocommerce-with-print-label/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'PostNord WooCommerce Shipping Plugin with Print Label',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_postnord.jpg',
		'benefits' => array(
			__( 'Easy PostNord Shipping Label Printing', 'ups-woocommerce-shipping' ),
			__( 'Regional & International Coverage', 'ups-woocommerce-shipping' ),
			__( 'PostNord Tracking and Notifications', 'ups-woocommerce-shipping' ),
			__( 'Reliable Customs Management', 'ups-woocommerce-shipping' ),
		),
	),

	'table_rate'         => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=3289&variation_id=79422&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/woocommerce-table-rate-shipping-pro-plugin/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'WooCommerce Table Rate Shipping Pro Plugin',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_table_rate.jpg',
		'benefits' => array(
			__( 'Custom Shipping Based on Cart Conditions', 'ups-woocommerce-shipping' ),
			__( 'Effortless Integration with WooCommerce Zones', 'ups-woocommerce-shipping' ),
			__( 'Support for Global Shipping Scenarios', 'ups-woocommerce-shipping' ),
			__( 'Flexible Shipping Cost Adjustments', 'ups-woocommerce-shipping' ),
		),
	),

	'estimated_delivery' => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=3248&variation_id=3269&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/estimated-delivery-date-plugin-woocommerce/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'Estimated Delivery Date Plugin For WooCommerce',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/03/ph_img_est_delivery.jpg',
		'benefits' => array(
			__( 'Precise Order Delivery Date Estimates', 'ups-woocommerce-shipping' ),
			__( 'Customizable Delivery Date based on Rules', 'ups-woocommerce-shipping' ),
			__( 'Easy Holidays and Vacation Handling', 'ups-woocommerce-shipping' ),
			__( 'WooCommerce & WordPress Integration', 'ups-woocommerce-shipping' ),
		),
	),
);

// List of suggestive plugins from PluginHive.
$suggestive_plugins = array(

	'bookings'       => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=624&variation_id=1276&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/woocommerce-booking-and-appointments/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'WooCommerce Bookings And Appointments',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_bookings.jpg',
	),

	'deposits'       => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=102163&variation_id=102167&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/woocommerce-deposits/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'PH WooCommerce Deposits',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_deposits.jpg',
	),

	'product_addons' => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=99973&variation_id=99976&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/woocommerce-product-addons/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'PH WooCommerce Product Addons',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_product_addons.jpg',
	),

	'hide_shipping'  => array(
		'buy_url'  => 'https://www.pluginhive.com/cart/?add-to-cart=131602&variation_id=131605&attribute_pa_subscriptions-options=singe-site-subscription&utm_source=ups&utm_medium=plugin_settings',
		'info_url' => 'https://www.pluginhive.com/product/hide-woocommerce-shipping-methods-and-rate-adjustment/?utm_source=ups&utm_medium=plugin_settings',
		'title'    => 'PH Hide WooCommerce Shipping Methods & Rate Adjustment',
		'image'    => 'https://www.pluginhive.com/wp-content/uploads/2025/01/ph_img_hide_shipping.jpg',
	),
);
