<?php
/**
 * Plugin informational banner HTML content for WooCommerce UPS Shipping Plugin.
 *
 * @package ups-woocommerce-shipping
 */

defined( 'ABSPATH' ) || exit();

// Including the file containing all the Upgradable plugins.
require_once 'ph-ups-info-banner-details.php';

?>
<div class="ph-info-banner">
	<?php foreach ( $promo_banner_sections as $section ) : ?>
		<div class="ph-info-banner-section">
			<a class="ph-info-banner-link" href="<?php echo esc_url( $section['link'] ); ?>" target="_blank">
				<img class="ph-info-banner-svg" alt="<?php echo esc_attr( $section['alt_img_text'] ); ?>" src="<?php echo esc_url( $section['image_url'] ); ?>" />
				<span><?php echo wp_kses_post( $section['text'] ); ?></span>
			</a>
		</div>
	<?php endforeach; ?>
</div>