<?php

if (!defined('ABSPATH')) {
    exit;
}

// Define PH_UPS_MAX_CLEANUP_ORDER
if (!defined('PH_UPS_MAX_CLEANUP_ORDER')) {

    define('PH_UPS_MAX_CLEANUP_ORDER', 100);
}

// Define PH_UPS_MAX_CLEANUP_HISTORY
if (!defined('PH_UPS_MAX_CLEANUP_HISTORY')) {

    define('PH_UPS_MAX_CLEANUP_HISTORY', 10);
}

class PH_UPS_Delete_Old_Meta_Data
{

    public $ph_cleanup_settings;

    /**
     * Constructor
     */
    public function __construct()
    {
        if (isset($_POST['ph_ups_cleanup_cron_type'])) {

            $this->ph_ups_save_cleanup_settings();
        }

        // Cron 
        add_action('ph_ups_cleanup_older_order_meta', array($this, 'ph_get_and_save_orders_for_delete_meta'), 20);

        add_action('ph_ups_cleanup_meta', array($this, 'ph_ups_run_cleanup_meta'), 20);

        // Clear history Table
        add_action('wp_ajax_ph_ups_clear_history_of_cleanup_table', array($this, 'ph_ups_clear_history_of_cleanup_table'));
    }

    /**
     * Save Cleanup Settings
     */
    public function ph_ups_save_cleanup_settings()
    {
        $ph_ups_cleanup_cron_type     = isset($_POST['ph_ups_cleanup_cron_type']) ? $_POST['ph_ups_cleanup_cron_type'] : '';
        $ph_ups_cleanup_older_day     = !empty($_POST['ph_ups_cleanup_older_day']) ? $_POST['ph_ups_cleanup_older_day'] : 120;
        $ph_include_processed_orders  = isset($_POST['ph_include_processed_orders']) ? $_POST['ph_include_processed_orders'] : 'initial';
        $ph_ups_enabled_cleanup_cron  = isset($_POST['ph_ups_enabled_cleanup_cron']) ? $_POST['ph_ups_enabled_cleanup_cron'] : 'no';

        $ph_cleanup_meta_settings = array(
            'ph_ups_cleanup_cron_type'      => $ph_ups_cleanup_cron_type,
            'ph_ups_cleanup_older_day'      => $ph_ups_cleanup_older_day,
            'ph_include_processed_orders'   => $ph_include_processed_orders,
            'ph_ups_enabled_cleanup_cron'   => $ph_ups_enabled_cleanup_cron,
        );

        update_option('woocommerce_ph_ups_cleanup_meta_settings', $ph_cleanup_meta_settings);

        // Check if cleanup cron is disabled
        if ('yes' !== $ph_ups_enabled_cleanup_cron) {

            $timestamp = wp_next_scheduled('ph_ups_cleanup_older_order_meta');

            if ($timestamp) {
                wp_unschedule_event($timestamp, 'ph_ups_cleanup_older_order_meta'); // Remove scheduled event.
            }

            $timestamp = wp_next_scheduled('ph_ups_cleanup_meta');

            if ($timestamp) {
                wp_unschedule_event($timestamp, 'ph_ups_cleanup_meta'); // Remove scheduled event.
            }

            return; // Exit function
        }
        if ('day' == $ph_ups_cleanup_cron_type) {

            $recurrence = 'daily';
        } else if ('week' == $ph_ups_cleanup_cron_type) {

            $recurrence = 'weekly';
        } else {

            $recurrence = 'monthly';
        }

        try {

            $start_time_stamp = strtotime('now');

            $timestamp = wp_next_scheduled('ph_ups_cleanup_older_order_meta');

            if ($timestamp) {
                wp_unschedule_event($timestamp, 'ph_ups_cleanup_older_order_meta');
            }

            wp_schedule_event($start_time_stamp, $recurrence, 'ph_ups_cleanup_older_order_meta');
        } catch (Exception $e) {

            PH_UPS_Registration_Menu::$ph_shedule_event_notice = __('Failed to schedule event. Please try again.', 'ph-ups-woocommerce-shipping');
        }
    }

    /**
     * Save order to db for cleanup
     */
    public function ph_get_and_save_orders_for_delete_meta()
    {

        $ph_cleanup_settings = get_option('woocommerce_ph_ups_cleanup_meta_settings', []);

        $ph_ups_cleanup_cron_type       = isset($ph_cleanup_settings['ph_ups_cleanup_cron_type']) ? $ph_cleanup_settings['ph_ups_cleanup_cron_type'] : '';
        $ph_ups_cleanup_older_day       = isset($ph_cleanup_settings['ph_ups_cleanup_older_day']) && !empty($ph_cleanup_settings['ph_ups_cleanup_older_day']) ? $ph_cleanup_settings['ph_ups_cleanup_older_day'] : '';
        $ph_include_processed_orders    = isset($ph_cleanup_settings['ph_include_processed_orders']) ? $ph_cleanup_settings['ph_include_processed_orders'] : 'off';
        $ph_ups_enabled_cleanup_cron    = isset($ph_cleanup_settings['ph_ups_enabled_cleanup_cron']) ? $ph_cleanup_settings['ph_ups_enabled_cleanup_cron'] : 'no';

        if ('day' == $ph_ups_cleanup_cron_type) {

            $cron_for = 1;
        } else if ('week' == $ph_ups_cleanup_cron_type) {

            $cron_for = 7;
        } else {

            $cron_for = 30;
        }

        $from     = $ph_include_processed_orders == 'off' ? date('Y-m-d', strtotime("now -" . ($ph_ups_cleanup_older_day + $cron_for) . " day")) : '';
        $to        = date('Y-m-d', strtotime("now -" . ($ph_ups_cleanup_older_day) . " day"));

        // Load WooCommerce
        if (!function_exists('wc_get_orders')) {
            // Include WooCommerce initialization file
            include_once ABSPATH . 'wp-content/plugins/woocommerce/woocommerce.php';
        }

        $ph_args = array(
            'post_type'      => 'shop_order',
            'posts_per_page' => -1,
            'date_before'    => $to,
            'return'         => 'ids'
        );

        if (!empty($from)) {

            $ph_args['date_after'] = $from;
        }

        $orders = wc_get_orders($ph_args);

        $ph_cleanup_meta_settings = array(

            'ph_ups_cleanup_cron_type'      => $ph_ups_cleanup_cron_type,
            'ph_ups_cleanup_older_day'      => $ph_ups_cleanup_older_day,
            'ph_include_processed_orders'   => $ph_include_processed_orders == 'initial' ? 'off' : $ph_include_processed_orders, // Set the "Include Processed Orders" option to "off" to avoid including orders that have already been processed.
            'ph_ups_enabled_cleanup_cron'   => $ph_ups_enabled_cleanup_cron,
            'ph_from_date'                  => $from,
            'ph_to_date'                    => $to,
            'ph_order_ids'                  => $orders,
            'ph_order_ids_left'             => $orders,
            'ph_order_ids_migrated'         => array(),
            'ph_needed_migrated'            => true,
            'ph_migrated_started'           => !empty($orders) ? true : false,
        );

        update_option('woocommerce_ph_ups_cleanup_meta_settings', $ph_cleanup_meta_settings);

        if (!empty($orders)) {

            $this->ph_schedule_cleanup_meta_event();
        }
    }

    /**
     * Schedule Cleanup
     */
    private function ph_schedule_cleanup_meta_event()
    {

        try {

            $start_time_stamp = strtotime("now +5 minutes");
            wp_schedule_single_event($start_time_stamp, 'ph_ups_cleanup_meta');
        } catch (Exception $e) {

            PH_UPS_Registration_Menu::$ph_shedule_event_notice = __('Failed to schedule event. Please try again.', 'ph-ups-woocommerce-shipping');
        }
    }

    /**
     * Cleanup Details
     */
    public function ph_ups_run_cleanup_meta()
    {

        $this->ph_cleanup_settings = get_option('woocommerce_ph_ups_cleanup_meta_settings', array());

        if (!empty($this->ph_cleanup_settings['ph_order_ids_left'])) {

            $ph_cleanup_order_ids = $this->ph_ups_delete_meta_data();
        }


        if (!empty($ph_cleanup_order_ids)) {

            $this->ph_cleanup_settings['ph_order_ids_migrated'] = array_merge($this->ph_cleanup_settings['ph_order_ids_migrated'], $ph_cleanup_order_ids);
        }

        if (!empty($this->ph_cleanup_settings['ph_order_ids_left'])) {

            $this->ph_schedule_cleanup_meta_event();
        } else {

            $this->ph_cleanup_settings['ph_migrated_started'] = false;
        }

        update_option('woocommerce_ph_ups_cleanup_meta_settings', $this->ph_cleanup_settings);
    }

    /**
     * Delete Selected Meta
     */
    public function ph_ups_delete_meta_data()
    {

        // Including wf_product class file for backward compatibility for Cleanup Process
        if (!class_exists('wf_product')) {

            include_once 'backward_compatibility/class-wf-legacy.php';
        }

        // Load WooCommerce
        if (!function_exists('wc_get_orders')) {
            // Include WooCommerce initialization file
            include_once ABSPATH . 'wp-content/plugins/woocommerce/woocommerce.php';
        }

        $cleanup_order_ids = array();
        $num_of_cleanup_orders  = 0;
        $order_no_string        = '';

        $ph_max_cleanup_count = PH_UPS_MAX_CLEANUP_ORDER;

        foreach ($this->ph_cleanup_settings['ph_order_ids_left'] as $key => $order_id) {

            $order = wc_get_order($order_id);

            if ($order instanceof WC_Order && ($order->get_meta('_wf_ups_stored_packages', true) || $order->get_meta('wf_woo_ups_shipmentId', true))) {

                $ph_wc_storage_handler = new PH_UPS_WC_Storage_Handler($order);

                $ph_wc_storage_handler->ph_delete_meta_data('ph_ups_ship_to_different_address');
                $ph_wc_storage_handler->ph_delete_meta_data('ph_ups_total_landed_cost');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_accesspoint_name');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_accesspoint_address');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_accesspoint_city');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_accesspoint_statecode');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_accesspoint_countrycode');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_accesspoint_postcode');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_selected_accesspoint_detail');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_accesspoint_location');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_shipfrom_address_preference');
                $ph_wc_storage_handler->ph_delete_meta_data('_wf_ups_stored_packages');
                $ph_wc_storage_handler->ph_delete_meta_data('wf_ups_selected_service');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_shipment_label_type_as_forward');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_shipfrom_address_preference');
                $ph_wc_storage_handler->ph_delete_meta_data('ph_ship_from_address');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_vcid_number');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_vcid_consignee');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_delivery_signature');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_shipping_address_as_sold_to');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_eei_itn_number');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_eei_exemption_legend');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_eei_ultimate_consignee_type');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_direct_delivery');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_import_control');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_insurance');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_cod');
                $ph_wc_storage_handler->ph_delete_meta_data('_wf_ups_cod');
                $ph_wc_storage_handler->ph_delete_meta_data('_wf_ups_sat_delivery');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_export_compliance');
                $ph_wc_storage_handler->ph_delete_meta_data('ph_ups_shipping_tax_id_num');
                $ph_wc_storage_handler->ph_delete_meta_data('ph_ups_ship_to_tax_id_num');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_label_details_array');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_label_details_array');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_commercial_invoice_details');
                $ph_wc_storage_handler->ph_delete_meta_data('ph_ups_dangerous_goods_image');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_control_log_receipt');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_return_label_details_array');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_return_commercial_invoice_details');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_created_shipments_details_array');
                $ph_wc_storage_handler->ph_delete_meta_data('_ups_shipment_date_time_stamp');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_label_details_array');
                $ph_wc_storage_handler->ph_delete_meta_data('ph_ups_dangerous_goods_manifest_required');
                $ph_wc_storage_handler->ph_delete_meta_data('ph_ups_dangerous_goods_manifest_data');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_saturday_delivery');
                $ph_wc_storage_handler->ph_delete_meta_data('wf_ups_generate_packages_rates_response');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_rest_created_shipments_details_array');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_rest_label_details_array');
                $ph_wc_storage_handler->ph_delete_meta_data('_ph_ups_upload_document_details');
                $ph_wc_storage_handler->ph_delete_meta_data('wfupstrackingmsg');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_shipment_ids');
                $ph_wc_storage_handler->ph_delete_meta_data('_shipping_accesspoint');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_created_shipments_xml_request_array');
                $ph_wc_storage_handler->ph_delete_meta_data('xa_ups_generated_label_services');
                $ph_wc_storage_handler->ph_delete_meta_data('ph_ups_auto_label_generation');
                $ph_wc_storage_handler->ph_delete_meta_data('ups_created_shipments_json_request_array');

                $prnorder_id	= PH_UPS_WC_Storage_Handler::ph_get_meta_data($order_id, '_ups_pickup_prn');

                if (!empty($prnorder_id)) {

                    $ph_wc_storage_handler->ph_delete_meta_data('_ups_pickup_prnorder_ids_' . $prnorder_id);
                }

                $ph_wc_storage_handler->ph_delete_meta_data('_ups_pickup_prn');
                $ph_wc_storage_handler->ph_delete_meta_data('_ups_pickup_date');


                $ph_wc_storage_handler->ph_save_meta_data();

                $cleanup_order_ids[] = $order_id;

                $order_no_string .= empty($order_no_string) ? $order_id : ', ' . $order_id;

                $num_of_cleanup_orders++;
            }

            unset($this->ph_cleanup_settings['ph_order_ids_left'][$key]);

            if (--$ph_max_cleanup_count < 1) {
                break;
            }
        }

        if (!empty($cleanup_order_ids)) {

            $delete_order_meta_history  = get_option('woocommerce_ph_ups_delete_order_meta_history', []);

            $ph_meta_history_key = $this->ph_cleanup_settings['ph_from_date'] . "_to_" . $this->ph_cleanup_settings['ph_to_date'];

            if (isset($delete_order_meta_history[$ph_meta_history_key])) {

                $delete_order_meta_history[$ph_meta_history_key]['ph_ups_cleanup_orders']           = array_merge($delete_order_meta_history[$ph_meta_history_key]['ph_ups_cleanup_orders'], $cleanup_order_ids);
                $delete_order_meta_history[$ph_meta_history_key]['order_no_string']             .= ", " . $order_no_string;
                $delete_order_meta_history[$ph_meta_history_key]['ph_num_of_cleanup_orders']    += $num_of_cleanup_orders;
            } else {

                $delete_order_meta_history[$ph_meta_history_key] = array(
                    'ph_date_of_cleanup'        => date('Y-m-d'),
                    'ph_num_of_cleanup_orders'    => $num_of_cleanup_orders,
                    'ph_to_date'                => $this->ph_cleanup_settings['ph_to_date'],
                    'ph_from_date'                => $this->ph_cleanup_settings['ph_from_date'],
                    'ph_ups_cleanup_orders'            => $cleanup_order_ids,
                    'order_no_string'            => $order_no_string,
                );
            }

            $ph_history_count = count($delete_order_meta_history);

            if ($ph_history_count > 10) {

                foreach ($delete_order_meta_history as $key => $val) {


                    unset($delete_order_meta_history[$key]);

                    if (--$ph_history_count <= 10) {

                        break;
                    }
                }
            }

            update_option('woocommerce_ph_ups_delete_order_meta_history', $delete_order_meta_history);
        }

        return $cleanup_order_ids;
    }

    /**
     * Clear Cleanup Details Table
     */
    public function ph_ups_clear_history_of_cleanup_table()
    {

        $result        = array(
            'status'    =>    false,
            'message'    => __('<p>Cleanup Meta History Table is empty.No need to delete again</p>', 'ph-ups-woocommerce-shipping'),
        );

        $delete_order_meta_history  = get_option('woocommerce_ph_ups_delete_order_meta_history', []);

        if (!empty($delete_order_meta_history)) {

            update_option('woocommerce_ph_ups_delete_order_meta_history', []);

            $result        = array(
                'status'    =>    true,
                'message'    =>     __('<p><b>Cleanup Meta History Table is deleted.</b></p>', 'ph-ups-woocommerce-shipping'),
            );
        }

        echo print_r(json_encode($result), true);

        exit;
    }
}

new PH_UPS_Delete_Old_Meta_Data();
