<head>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />

    <!-- jQuery library -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <!-- jQuery UI library -->
    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
</head>

<?php
$ph_cleanup_settings = get_option('woocommerce_ph_ups_cleanup_meta_settings', []);

$ph_ups_cleanup_cron_type     = isset($ph_cleanup_settings['ph_ups_cleanup_cron_type']) ? $ph_cleanup_settings['ph_ups_cleanup_cron_type'] : '';
$ph_ups_cleanup_older_day     = isset($ph_cleanup_settings['ph_ups_cleanup_older_day']) ? $ph_cleanup_settings['ph_ups_cleanup_older_day'] : '';
$ph_include_processed_orders  = isset($ph_cleanup_settings['ph_include_processed_orders']) ? $ph_cleanup_settings['ph_include_processed_orders'] : 'off';
$ph_enabled_cleanup           = (!isset($ph_cleanup_settings['ph_ups_enabled_cleanup_cron']) && !empty($ph_cleanup_settings['ph_ups_cleanup_cron_type'])) || (!empty($ph_cleanup_settings['ph_ups_enabled_cleanup_cron']) && 'yes' === $ph_cleanup_settings['ph_ups_enabled_cleanup_cron']) ? 'yes' : 'no';

?>
<div class="ph-ups-cleanup-settings-container">
    <?php if (!empty(PH_UPS_Registration_Menu::$ph_shedule_event_notice)) { ?>
        <div class="ph-ups-cleanup-event-notice">
            <p style="color:red"><?php echo PH_UPS_Registration_Menu::$ph_shedule_event_notice ?></p>
        </div>
    <?php } ?>
    <h3><?php echo __('Cleanup UPS Shipment Details', 'ups-woocommerce-shipping'); ?></h3>
    <p><?php echo __('Improve efficiency & performance by clearing outdated data from WooCommerce Orders.', 'ups-woocommerce-shipping'); ?></p>
    <div class="ph-ups-cleanup-warning-div">
        <h4 style="font-size:15px"><?php echo __('Please note that this action will permanently erase ups shipping details like', 'ups-woocommerce-shipping'); ?></h4>
        <ol>
            <li><?php echo __('Shipping Labels', 'ups-woocommerce-shipping'); ?></li>
            <li><?php echo __('Return Labels', 'ups-woocommerce-shipping'); ?></li>
            <li><?php echo __('Commercial Invoices', 'ups-woocommerce-shipping'); ?></li>
            <li><?php echo __('Tracking Details', 'ups-woocommerce-shipping'); ?></li>
            <li><?php echo __('Packages Created', 'ups-woocommerce-shipping'); ?></li>
        </ol>
    </div>
    <br>
    <div class="ph-ups-old-meta-delete-history-div">
        <h3 class="ph-ups-auto-clean"><?php echo __('Cleanup Settings', 'ups-woocommerce-shipping'); ?></h3>
        <p><b><?php echo __('Steps to initiate Cleanup', 'ups-woocommerce-shipping'); ?></b>
        <ol>
            <li><?php echo __('Pick a date range for clearing ups data (Please note: We recommend avoiding data from the last month)', 'ups-woocommerce-shipping'); ?></li>
            <li><?php echo __('Choose the Order Status to filter data for cleanup', 'ups-woocommerce-shipping'); ?></li>
            <li><?php echo __('Click the "Cleanup" button to start the process, then click "Proceed"', 'ups-woocommerce-shipping'); ?></li>
            <li><?php echo __('Check the Cleanup History table to review the cleared data', 'ups-woocommerce-shipping'); ?></li>
        </ol>
        </p>
        <form method="post" id="ph-ups-cleanup-settings-form">
            <hr>
            <table class="ph-ups-advanced-table">
                <tr>
                    <th><?php _e('Enable Cleanup', 'ups-woocommerce-shipping'); ?></th>
                    <td>
                        <input type="checkbox" name="ph_ups_enabled_cleanup_cron" id="ph-ups-enabled-cleanup-cron" value="yes" <?php checked($ph_enabled_cleanup, 'yes'); ?>>
                        <label><?php _e('Check this to enable the cleanup.', 'ups-woocommerce-shipping'); ?></label>
                    </td>
                </tr>

                <tr>
                    <th><?php echo __('Cleanup Period', 'ups-woocommerce-shipping'); ?></th>
                    <td>
                        <select name="ph_ups_cleanup_cron_type" class="ph-ups-cleanup-settings" id="ph-ups-cleanup-cron-type" style="width: 100%" class="select2 ph-cleanup-select">
                            <option value="day" <?php echo $ph_ups_cleanup_cron_type == 'day' ? 'selected' : ''  ?>><?php echo __('Every Day', 'ups-woocommerce-shipping') ?></option>
                            <option value="week" <?php echo $ph_ups_cleanup_cron_type == 'week' ? 'selected' : ''  ?>><?php echo __('Every Week', 'ups-woocommerce-shipping') ?></option>
                            <option value="month" <?php echo $ph_ups_cleanup_cron_type == 'month' ? 'selected' : ''  ?>><?php echo __('Every Month', 'ups-woocommerce-shipping') ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th><?php echo __('Order Meta Data Deletion Age (Days)', 'ups-woocommerce-shipping'); ?></th>
                    <td>
                        <input style="width: 100%" type="number" class="ph-ups-cleanup-settings" name="ph_ups_cleanup_older_day" id="ph-ups-cleanup-older-day" placeholder="Default 120" value="<?php echo $ph_ups_cleanup_older_day ?>" min="90">
                        <br><small><?php echo __('Default Value: 120 days (if no value is selected) <br>Minimum Value: 90 days (orders older than 90 days will be deleted)', 'ups-woocommerce-shipping'); ?></small>
                    </td>
                </tr>
                <?php if (!empty($ph_cleanup_settings)) { ?>
                    <tr>
                        <th><?php echo __('Include Processed Orders', 'ups-woocommerce-shipping'); ?></th>
                        <td>
                            <input type="checkbox" class="ph-ups-cleanup-settings" name="ph_include_processed_orders" id="ph-include-processed-orders" <?php echo $ph_include_processed_orders == 'on' ? 'checked' : ''; ?>>
                        </td>
                    </tr>
                <?php } ?>
            </table>
            <input type="submit" name="ph_ups_cleanup_save" id="ph-ups-cleanup-save" class="button button-primary" value="<?php echo __('Save', 'ups-woocommerce-shipping'); ?>">
        </form>
    </div>
    <br>
    <?php if (!empty($ph_cleanup_settings)) { ?>
        <div class="ph-ups-cleanup-status">
            <?php if (isset($ph_cleanup_settings['ph_migrated_started'])) { ?>

                <h3><?php echo __('Cleanup Status', 'ups-woocommerce-shipping'); ?></h3>
                <table class="ph-ups-cleanup-status-table">
                    <tr>
                        <th><?php echo __('Orders Cleared:', 'ups-woocommerce-shipping'); ?></th>
                        <td><?php echo count($ph_cleanup_settings['ph_order_ids_migrated']) ?></td>
                    </tr>
                    <tr>
                        <th><?php echo __('Orders Pending:', 'ups-woocommerce-shipping'); ?></th>
                        <td><?php echo count($ph_cleanup_settings['ph_order_ids_left']) ?></td>
                    </tr>
                    <tr>
                        <th><?php echo __('Status:', 'ups-woocommerce-shipping'); ?></th>
                        <td style="color: <?php echo $ph_cleanup_settings['ph_migrated_started'] ? 'blue' : 'green' ?>;"><?php echo __($ph_cleanup_settings['ph_migrated_started'] ? "Running" : "Completed", 'ups-woocommerce-shipping') ?></td>
                    </tr>
                </table>
            <?php } ?>
            <br>

            <?php

            $ph_history_details = get_option('woocommerce_ph_ups_delete_order_meta_history', []);

            if (!empty($ph_history_details)) {
            ?>
                <hr>
                <button name="ph-ups-clear-table-history" id="ph-ups-clear-table-history" class="button button-primary ph-ups-clear-history-button" style="margin-right: 20px; float: right; margin-top: 0.3%"><?php echo __('Clear Table', 'ups-woocommerce-shipping');  ?></button>
                <h3 class="ph-ups-old-meta-delete-history"><?php echo __('Cleanup History', 'ups-woocommerce-shipping');  ?>
                    <span class="ph-ups-cleanup-toggle-symbol" aria-hidden="true"></span>
                </h3>
                <div class="ph-ups-old-meta-delete-history-table" hidden>
                    <hr>
                    <table style="width: 100%;">
                        <tr>
                            <th><?php echo __('Sl no', 'ups-woocommerce-shipping');  ?></th>
                            <th><?php echo __('Cleanup Date', 'ups-woocommerce-shipping');  ?></th>
                            <th><?php echo __('Orders Cleared', 'ups-woocommerce-shipping');  ?></th>
                            <th><?php echo __('From Date', 'ups-woocommerce-shipping');  ?></th>
                            <th><?php echo __('To Date', 'ups-woocommerce-shipping');  ?></th>
                            <th><?php echo __('Actions', 'ups-woocommerce-shipping');  ?></th>
                        </tr>
                        <?php
                        $ph_sl_no = 1;
                        foreach ($ph_history_details as $key => $data) { ?>
                            <tr style="text-align: center;">
                                <td><?php echo $ph_sl_no++ ?></td>
                                <td><?php echo $data['ph_date_of_cleanup'] ?></td>
                                <td><?php echo $data['ph_num_of_cleanup_orders'] ?></td>
                                <td><?php echo !empty($data['ph_from_date']) ? $data['ph_from_date'] : '-' ?></td>
                                <td><?php echo $data['ph_to_date'] ?></td>
                                <td>
                                    <input type="text" id="ph-ups-cleanup-orders" class="ph-ups-cleanup-orders" value="<?php echo $data['order_no_string'] ?>" hidden />
                                    <input type="button" id="ph-ups-show-deleted-orders" class="button button-primary ph-ups-show-deleted-orders ph-ups-cleanup-meta-button" style="width: auto;" value="<?php echo __('More Details', 'ups-woocommerce-shipping'); ?>">
                                </td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
                <!-- For fading background on clicking more details button -->
                <div id="ph-ups-overlay"></div>
                <div id="ph-ups-cleanup-deleted-orders-popup" class="ph-ups-popup-modal" hidden>
                    <div class="ph-ups-cleanup-popup-content">
                        <span class="ph-ups-close-popup">&times;</span>
                        <h2><?php echo __('Orders Cleared', 'ups-woocommerce-shipping');  ?></h2>
                        <hr>
                        <div id="ph-ups-popup-details">
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    <?php } ?>
</div>

<div id="ph-ups-confirmation-popup" class="ph-ups-conf-popup">
    <div class="ph-ups-conf-popup-content">
        <h4><?php echo __('This action is not reversible. Do you want to proceed?', 'ups-woocommerce-shipping');  ?></h4>
        <div class="ph-ups-cleanup-button-container">
            <button id="ph-ups-cleanup-proceed-btn" class="button button-primary ph-ups-cleanup-proceed-btn"><?php echo __('Proceed', 'ups-woocommerce-shipping');  ?></button>
            <button id="ph-ups-cleanup-cancel-btn" class="button button-primary ph-ups-cleanup-cancel-btn"><?php echo __('Cancel', 'ups-woocommerce-shipping');  ?></button>
        </div>
    </div>
</div>