<?php
if ( ! class_exists( 'wf_ups_pickup_admin' ) ) {

	class wf_ups_pickup_admin extends WF_Shipping_UPS_Admin {

		// Class Variables Declaration
		private $pickup_enabled;
		private $debug_datas;

		var $_pickup_prn  = '_ups_pickup_prn';
		var $_pickup_date = '_ups_pickup_date';

		public function __construct() {

			$this->settings       = get_option( 'woocommerce_' . WF_UPS_ID . '_settings', null );
			$this->pickup_enabled = ( isset( $this->settings['pickup_enabled'] ) && $this->settings['pickup_enabled'] == 'yes' ) ? true : false;
			$this->debug          = isset( $this->settings['debug'] ) && $this->settings['debug'] == 'yes' ? true : false;
			$this->debug_datas    = array();

			if ( $this->pickup_enabled ) {

				if ( ! class_exists( 'PH_UPS_Pickup_Admin_Rest' ) ) {

					include_once 'ups_rest/class-ph-ups-rest-pickup-admin.php';
				}

				$this->init();
			}
		}

		private function init() {

			// HPOs Option
			add_filter( 'bulk_actions-woocommerce_page_wc-orders', array( $this, 'ph_ups_add_pickup_bulk_actions' ) );
			add_action( 'admin_init', array( $this, 'ph_ups_handle_pickup_bulk_actions_hpo_table' ) );

			// Legacy Option
			add_filter( 'bulk_actions-edit-shop_order', array( $this, 'ph_ups_add_pickup_bulk_actions' ) );
			add_filter( 'handle_bulk_actions-edit-shop_order', array( $this, 'ph_ups_handle_pickup_bulk_actions_post_table' ), 10, 3 );

			// To display Pickup Number & Date in Ship-To Column
			add_action( 'manage_shop_order_posts_custom_column', array( $this, 'display_order_list_pickup_status' ), 10, 2 );
			add_action( 'woocommerce_shop_order_list_table_custom_column', array( $this, 'display_order_list_pickup_status' ), 10, 2 );
		}

		/**
		 * Add bulk actions
		 *
		 * @param array $actions
		 * @return array $actions
		 */
		public function ph_ups_add_pickup_bulk_actions( $actions ) {
			if ( $this->disble_ups_print_label != 'yes' ) {

				$actions['ups_pickup_request'] = __( 'Request UPS Pickup', 'ups-woocommerce-shipping' );
				$actions['ups_pickup_cancel']  = __( 'Cancel UPS Pickup', 'ups-woocommerce-shipping' );
			}

			return $actions;
		}

		/**
		 * Handle Bulk Actions on new screens (HPOS enabled sites)
		 */
		public function ph_ups_handle_pickup_bulk_actions_hpo_table() {
			$action    = isset( $_GET['action'] ) && ! empty( $_GET['action'] ) ? $_GET['action'] : '';
			$action    = empty( $action ) ? ( isset( $_GET['action2'] ) && ! empty( $_GET['action2'] ) ? $_GET['action2'] : '' ) : $action;
			$order_ids = isset( $_GET['id'] ) && is_array( $_GET['id'] ) ? $_GET['id'] : array();

			if ( ! empty( $order_ids ) && is_array( $order_ids ) ) {

				$this->perform_pickup_list_action( $action, $order_ids );
			}
		}

		/**
		 * Handle bulk actions on old screens (Non HPOS sites)
		 *
		 * @param mixed  $redirect_to
		 * @param string $action
		 * @param array  $post_ids
		 * @return mixed $redirect_to
		 */
		public function ph_ups_handle_pickup_bulk_actions_post_table( $redirect_to, $action, $post_ids ) {

			if ( ! empty( $post_ids ) && is_array( $post_ids ) ) {

				$this->perform_pickup_list_action( $action, $post_ids );
			}

			return $redirect_to;
		}

		public function perform_pickup_list_action( $action, $order_ids ) {

				// Pickup Request
				if ( $action == 'ups_pickup_request' ) {

				// Check for active plugin license
				if ( ! Ph_UPS_Woo_Shipping_Common::phHasActiveLicense() ) {

					wf_admin_notice::add_notice( 'Please activate a valid plugin license to continue using the WooCommerce UPS Shipping Plugin with Print Label functionality.', 'error' );
					
					Ph_UPS_Woo_Shipping_Common::phAddDebugLog('Plugin license inactive. WooCommerce UPS Shipping Plugin with Print Label functionality is disabled.', $this->debug);

					return;
				}

				if ( ! Ph_UPS_Woo_Shipping_Common::ph_is_oauth_registered_customer() ) {

					
					wf_admin_notice::add_notice( 'UPS Pickup Request functionality is unavailable. Please register your UPS account using UPS OAuth in the Registration section to enable this feature.', 'error' );

					Ph_UPS_Woo_Shipping_Common::phAddDebugLog('UPS Pickup Request functionality is unavailable. Please register your UPS account using UPS OAuth in the Registration section to enable this feature.', $this->debug);

					return;
				}
				
				// Pickup support for both origin address and shipping address
				$origin_address_order_ids   = array();
				$shipping_address_order_ids = array();

				// Sorting order_ids based on shipping address preference for pickup
				foreach ( $order_ids as $key => $order_id ) {

					$pickupPrn             = PH_UPS_WC_Storage_Handler::ph_get_meta_data( $order_id, $this->_pickup_prn );
					$selected_service_code = PH_UPS_WC_Storage_Handler::ph_get_meta_data( $order_id, 'wf_ups_selected_service' );

					if ( ( ! isset( $selected_service_code ) || empty( $selected_service_code ) ) || ! empty( $pickupPrn ) ) {

						wf_admin_notice::add_notice( 'Skipped Order #' . $order_id . ': Label not generated yet/ Pickup is already requested' );
						continue;
					}

					$ship_from_address = PH_UPS_WC_Storage_Handler::ph_get_meta_data( $order_id, 'ph_ship_from_address' );

					if ( $ship_from_address == 'origin_address' ) {

						$origin_address_order_ids[] = $order_id;
					} else {

						$shipping_address_order_ids[] = $order_id;
					}
				}

				$origin_address_result   = array();
				$shipping_address_result = array();

				// When ship from address set to origin address
				if ( ! empty( $origin_address_order_ids ) ) {

					$PH_UPS_Pickup_Admin_Rest = new PH_UPS_Pickup_Admin_Rest();
					$request                  = $PH_UPS_Pickup_Admin_Rest->get_pickup_creation_request( $origin_address_order_ids, 'origin' );

					if ( ! empty( $request ) ) {

						$origin_address_result = $PH_UPS_Pickup_Admin_Rest->request_pickup( $request );
						
						if ( is_array( $origin_address_result ) && isset( $origin_address_result['PRN'] ) ) {

							// Update PRN for all the orders in the request
							foreach ( $origin_address_order_ids as $orderId ) {

								PH_UPS_WC_Storage_Handler::ph_add_and_save_meta_data( $orderId, $this->_pickup_prn, $origin_address_result['PRN'] );
								PH_UPS_WC_Storage_Handler::ph_add_and_save_meta_data( $orderId, $this->_pickup_prn . 'order_ids_' . $origin_address_result['PRN'], $origin_address_order_ids );
							}
						}
					}
				}

				// When ship from address set to shipping address
				if ( ! empty( $shipping_address_order_ids ) ) {

					foreach ( $shipping_address_order_ids as $key => $order_id ) {

						$PH_UPS_Pickup_Admin_Rest = new PH_UPS_Pickup_Admin_Rest();

						$request = $PH_UPS_Pickup_Admin_Rest->get_pickup_creation_request( array( $order_id ), 'shipping' );

						if ( ! empty( $request ) ) {

							$shipping_address_result[ $key ] = $PH_UPS_Pickup_Admin_Rest->request_pickup( $request );

							if ( $shipping_address_result[ $key ] && isset( $shipping_address_result[ $key ]['PRN'] ) ) {

								$order_object        = wc_get_order( $order_id );
								$ph_metadata_handler = new PH_UPS_WC_Storage_Handler( $order_object );

								$ph_metadata_handler->ph_update_meta_data( $this->_pickup_prn, $shipping_address_result[ $key ]['PRN'] );
								$ph_metadata_handler->ph_update_meta_data( $this->_pickup_prn . 'order_ids_' . $shipping_address_result[ $key ]['PRN'], $shipping_address_order_ids );

								$ph_metadata_handler->ph_save_meta_data();
							}
						}
					}
				}

				if ( $origin_address_result || $shipping_address_result ) {

					$pickup_order_ids          = array();
					$origin_pickup_order_ids   = array();
					$shipping_pickup_order_ids = array();

					if ( isset( $origin_address_result ) && isset( $origin_address_result['PRN'] ) ) {
						$origin_pickup_order_ids = $origin_address_order_ids;
					}

					if ( isset( $shipping_address_result ) ) {

						foreach ( $shipping_address_result as $key => $result ) {

							if ( isset( $result['PRN'] ) ) {

								$shipping_pickup_order_ids[] = $shipping_address_order_ids[ $key ];
							}
						}
					}

					$pickup_order_ids = array_merge( $origin_pickup_order_ids, $shipping_pickup_order_ids );
					wf_admin_notice::add_notice( 'UPS pickup requested for following order id(s): ' . implode( ', ', $pickup_order_ids ), 'success' );
				}
			} elseif ( $action == 'ups_pickup_cancel' ) {

				// Check for active plugin license
				if ( ! Ph_UPS_Woo_Shipping_Common::phHasActiveLicense() ) {

					wf_admin_notice::add_notice( 'Please activate a valid plugin license to continue using the WooCommerce UPS Shipping Plugin with Print Label functionality.', 'error' );
					
					Ph_UPS_Woo_Shipping_Common::phAddDebugLog('Plugin license inactive. WooCommerce UPS Shipping Plugin with Print Label functionality is disabled.', $this->debug);

					return;
				}

				if ( ! Ph_UPS_Woo_Shipping_Common::ph_is_oauth_registered_customer() ) {

					
					wf_admin_notice::add_notice( 'UPS Pickup Cancel functionality is unavailable. Please register your UPS account using UPS OAuth in the Registration section to enable this feature.', 'error' );

					Ph_UPS_Woo_Shipping_Common::phAddDebugLog('UPS Pickup Cancel functionality is unavailable. Please register your UPS account using UPS OAuth in the Registration section to enable this feature.', $this->debug);

					return;
				}

				foreach ( $order_ids as $order_id ) {

					$pickupPrn       = PH_UPS_WC_Storage_Handler::ph_get_meta_data( $order_id, $this->_pickup_prn );
					$pickupPrnOrders = PH_UPS_WC_Storage_Handler::ph_get_meta_data( $order_id, $this->_pickup_prn . 'order_ids_' . $pickupPrn );

					$PH_UPS_Pickup_Admin_Rest = new PH_UPS_Pickup_Admin_Rest();

					$result = $PH_UPS_Pickup_Admin_Rest->pickup_cancel( $order_id, $pickupPrn );

					if ( $result ) {

						wf_admin_notice::add_notice( 'Pickup request cancelled for PRN: ' . $this->get_pickup_no( $order_id ), 'warning' );

						$order_object        = wc_get_order( $order_id );
						$ph_metadata_handler = new PH_UPS_WC_Storage_Handler( $order_object );

						// Delete PRN meta details for all orders with same PRN number
						if ( ! empty( $pickupPrnOrders ) ) {

							foreach ( $pickupPrnOrders as $oid ) {

								$rel_order_object        = wc_get_order( $oid );
								$rel_ph_metadata_handler = new PH_UPS_WC_Storage_Handler( $rel_order_object );
								$rel_ph_metadata_handler = $this->delete_pickup_details( $oid, $rel_ph_metadata_handler );

								$rel_ph_metadata_handler->ph_delete_meta_data( $this->_pickup_prn . 'order_ids_' . $pickupPrn );

								$rel_ph_metadata_handler->ph_save_meta_data();
							}
						}

						// To support existing orders.
						$ph_metadata_handler = $this->delete_pickup_details( $order_id, $ph_metadata_handler );

						$ph_metadata_handler->ph_save_meta_data();
					}
				}
			}

			if ( $this->debug && ! empty( $this->debug_datas ) ) {

				foreach ( $this->debug_datas as $data ) {
					if ( ! empty( $data ) ) {
						foreach ( $data as $title => $value ) {

							echo '<div style="background: #eee;overflow: auto;padding: 10px;margin: 10px;">' . $title;
							echo '<xmp>' . $value . '</xmp></div>';
						}
					}
				}
				exit();
			}
		}



		function display_order_list_pickup_status( $column, $order_id ) {

			switch ( $column ) {

				case 'shipping_address':
					if ( $this->is_pickup_requested( $order_id ) ) {

						printf( '<small class="meta">' . __( 'UPS PRN: ' . $this->get_pickup_no( $order_id ) ) . '</small>' );

						if ( ! empty( $this->get_pickup_date( $order_id ) ) ) {

							printf( '<small class="meta">' . __( 'UPS Pickup Date: ' . $this->get_pickup_date( $order_id ) ) . '</small>' );
						}
					}

					break;
			}
		}

		public function is_pickup_requested( $order_id ) {

			return $this->get_pickup_no( $order_id ) ? true : false;
		}

		public function get_pickup_no( $order_id ) {

			if ( empty( $order_id ) ) {
				return false;
			}

			$pickup_confirmation_number = PH_UPS_WC_Storage_Handler::ph_get_meta_data( $order_id, $this->_pickup_prn );

			return $pickup_confirmation_number;
		}

		public function get_pickup_date( $order_id ) {
			if ( empty( $order_id ) ) {
				return false;
			}

			$pickup_date = PH_UPS_WC_Storage_Handler::ph_get_meta_data( $order_id, $this->_pickup_date );

			if ( ! empty( $pickup_date ) ) {

				$wp_date_format = get_option( 'date_format' );
				$pickup_date    = date( $wp_date_format, strtotime( $pickup_date ) );
			}

			return $pickup_date;
		}

		function delete_pickup_details( $order_id, $ph_metadata_handler ) {
			$ph_metadata_handler->ph_delete_meta_data( $this->_pickup_prn );

			return $ph_metadata_handler;
		}

		public function admin_diagnostic_report( $data ) {

			if ( function_exists( 'wc_get_logger' ) ) {

				$log = wc_get_logger();
				$log->debug( ( $data ) . PHP_EOL . PHP_EOL, array( 'source' => PH_UPS_DEBUG_LOG_FILE_NAME ) );
			}
		}
	}

	new wf_ups_pickup_admin();
}
