<tr valign="top" id="ph_ups_packing_options" class="ph_ups_packaging_tab">

	<td class="titledesc" colspan="2" style="padding-left:0px">

		<strong><?php _e( 'Box Dimensions', 'ups-woocommerce-shipping' ); ?></strong><br /><br />

		<table class="ups_boxes widefat">

			<thead>
				<tr>
					<th class="check-column">
						<input type="checkbox" id='ph-ups-bulk-select-box' />
					</th>

					<th><?php _e( 'Box Name', 'ups-woocommerce-shipping' ); ?></th>
					<th>
						<?php
						_e( 'Outer Length', 'ups-woocommerce-shipping' );
						echo " ($this->dim_unit)";
						?>
					</th>
					<th>
						<?php
						_e( 'Outer Width', 'ups-woocommerce-shipping' );
						echo " ($this->dim_unit)";
						?>
					</th>
					<th>
						<?php
						_e( 'Outer Height', 'ups-woocommerce-shipping' );
						echo " ($this->dim_unit)";
						?>
					</th>
					<th>
						<?php
						_e( 'Inner Length', 'ups-woocommerce-shipping' );
						echo " ($this->dim_unit)";
						?>
					</th>
					<th>
						<?php
						_e( 'Inner Width', 'ups-woocommerce-shipping' );
						echo " ($this->dim_unit)";
						?>
					</th>
					<th>
						<?php
						_e( 'Inner Height', 'ups-woocommerce-shipping' );
						echo " ($this->dim_unit)";
						?>
					</th>
					<th>
						<?php
						_e( 'Box Weight', 'ups-woocommerce-shipping' );
						echo " ($this->weight_unit)";
						?>
					</th>
					<th>
						<?php
						_e( 'Max Weight', 'ups-woocommerce-shipping' );
						echo " ($this->weight_unit)";
						?>
					</th>


					<th><?php _e( 'Max Quantity', 'ups-woocommerce-shipping' ); ?></th>


					<th>
						<label for='ph-ups-bulk-enable-box'>
							<input type='checkbox' id='ph-ups-bulk-enable-box' /><?php esc_html_e( 'Enabled', 'ups-woocommerce-shipping' ); ?>
						</label>
					</th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<th colspan="3">
						<a href="#" class="button plus insert"><?php _e( 'Add Box', 'ups-woocommerce-shipping' ); ?></a>
						<a href="#" class="button minus remove"><?php _e( 'Remove selected box(es)', 'ups-woocommerce-shipping' ); ?></a>

						<a href=<?php echo admin_url( 'admin.php?page=wc-settings&tab=shipping&section=wf_shipping_ups&ph_ups_reset_boxes&nocache=' . time() ); ?> class="button minus reset ph-ups-reset-boxes"><?php _e( 'Reset Box(es)', 'ups-woocommerce-shipping' ); ?></a>
					</th>
					<th colspan="9">
						<small class="description"><?php _e( 'Items will be packed into these boxes depending based on item dimensions and volume. Outer dimensions will be passed to UPS, whereas inner dimensions will be used for packing. Items not fitting into boxes will be packed individually.', 'ups-woocommerce-shipping' ); ?></small>
					</th>
				</tr>
			</tfoot>
			<tbody>
				<?php

				// To update the frontend with recent changes on clicking Save Changes
				$this->boxes         = ! empty( $this->settings['boxes'] ) ? $this->settings['boxes'] : $default_boxes;
				$this->ups_packaging = isset( $this->settings['ups_packaging'] ) ? $this->settings['ups_packaging'] : array();

				// Sort boxes based on key to bring the custom boxes at the end of the table.
				ksort( $this->boxes );

				if ( ! empty( $this->boxes ) ) {

					foreach ( $this->boxes as $key => $box ) {

						if ( ! $this->upsSimpleRate && array_key_exists( $key, $this->simpleRateBoxes ) ) {

							echo '<tr style="display:none;">';
						} else {

							echo '<tr>';
						}

						$boxName          = isset( $box['boxes_name'] ) ? $box['boxes_name'] : '';
						$box_max_quantity = ! empty( $box['max_quantity'] ) ? $box['max_quantity'] : 0;

						// Default boxes cannot be removed from settings
						if ( array_key_exists( $key, $this->packaging ) || array_key_exists( $key, $this->simpleRateBoxes ) ) {

							echo '<td>';

							if ( $key == 'D_25KG_BOX' || $key == 'E_10KG_BOX' ) {
								echo '<span class="xa-tooltip"><img src="' . site_url( '/wp-content/plugins/woocommerce/assets/images/help.png' ) . '" height="16" width="16" /><span class="xa-tooltiptext">' . __( 'Use the box for shipments from the United States and Puerto Rico for Worldwide Express and Worldwide Express Plus services only.', 'ups-woocommerce-shipping' ) . '</span></span>';
							}

							echo '</td>';

							echo '<td><input type="text" size="15" readonly name="boxes_name[' . $key . ']" value="' . $box['boxes_name'] . '" /></td>';
						} else {

							echo '<td class="ph-ups-select-box-td"><input type="checkbox" class="ph-ups-select-box" /></td>';
							echo '<td><input type="text" size="15" minlength="3" name="boxes_name[' . $key . ']" value="' . esc_attr( $boxName ) . '" /></td>';
						}

						?>
						
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_outer_length[<?php echo $key; ?>]" min="0" step="<?php echo esc_attr( PH_WC_UPS_Constants::STEP_VALUE ); ?>" value="<?php echo esc_attr( $box['outer_length'] ); ?>" /></td>
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_outer_width[<?php echo $key; ?>]" min="0" step="<?php echo esc_attr( PH_WC_UPS_Constants::STEP_VALUE ); ?>" value="<?php echo esc_attr( $box['outer_width'] ); ?>" /></td>
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_outer_height[<?php echo $key; ?>]" min="0" step="<?php echo esc_attr( PH_WC_UPS_Constants::STEP_VALUE ); ?>" value="<?php echo esc_attr( $box['outer_height'] ); ?>" /></td>
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_inner_length[<?php echo $key; ?>]" min="0" step="<?php echo esc_attr( PH_WC_UPS_Constants::STEP_VALUE ); ?>" value="<?php echo esc_attr( $box['inner_length'] ); ?>" /></td>
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_inner_width[<?php echo $key; ?>]" min="0" step="<?php echo esc_attr( PH_WC_UPS_Constants::STEP_VALUE ); ?>" value="<?php echo esc_attr( $box['inner_width'] ); ?>" /></td>
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_inner_height[<?php echo $key; ?>]" min="0" step="<?php echo esc_attr( PH_WC_UPS_Constants::STEP_VALUE ); ?>" value="<?php echo esc_attr( $box['inner_height'] ); ?>" /></td>
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_box_weight[<?php echo $key; ?>]" min="0" step="<?php echo esc_attr( PH_WC_UPS_Constants::STEP_VALUE ); ?>" value="<?php echo esc_attr( $box['box_weight'] ); ?>" /></td>
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_max_weight[<?php echo $key; ?>]" min="0" step="<?php echo esc_attr( PH_WC_UPS_Constants::STEP_VALUE ); ?>" value="<?php echo esc_attr( $box['max_weight'] ); ?>" /></td>
						<td><input class="ph_ups_box_packing_tab" type="number" name="boxes_max_quantity[<?php echo $key; ?>]" min="0" step="1" value="<?php echo esc_attr( $box_max_quantity ); ?>" /></td>
						<td><input type='checkbox' name='boxes_enabled[<?php echo esc_attr( $key ); ?>]' class='ph-ups-enable-box' <?php checked( ( ! isset( $box['box_enabled'] ) || ! empty( $box['box_enabled'] ) ), true ); ?> /></td>

						<?php

							echo '</tr>';
					}
				}
				?>
			</tbody>
		</table>
	</td>
</tr>