<?php
/**
 * Log trait for consistent log handling across classes.
 *
 * @package snapshot
 */

namespace WPMUDEV\Snapshot4\Helper\Traits;

use WPMUDEV\Snapshot4\Model\Log as ModelLog;

trait Log {
	/**
	 * Log model instance.
	 *
	 * @var \WPMUDEV\Snapshot4\Model\Log
	 */
	private $log_instance = null;

	/**
	 * Gets a safe log instance for creating log entries.
	 *
	 * @return \WPMUDEV\Snapshot4\Model\Log
	 */
	protected function get_log() {
		if ( null === $this->log_instance || ! $this->log_instance instanceof ModelLog ) {
			$this->log_instance = new ModelLog();
		}

		return $this->log_instance;
	}

	/**
	 * Create a log entry safely.
	 *
	 * @param array $data Log data.
	 * @return mixed
	 */
	protected function log( $data ) {
		return $this->get_log()->create( $data );
	}
}