<?php

/**
 * Plugin Name: reBlock Styles
 * Description: A collection of block styles.
 * Version: 1.0
 * Author: Jeremy Techtmann
 */

/**
 * Register Custom Block Styles
 */
function block_styles_font_end()
{
    //wp_enqueue_script('your-script-name', $this->urlpath  . '/your-script-filename.js', array('jquery'), '1.2.3', true);
    wp_enqueue_style('reblock_styles_front', plugins_url('/dist/css/block-styles.css', __FILE__), false, '1.0.0', 'all');
}
add_action('wp_enqueue_scripts', "block_styles_font_end");

function block_styles_editor()
{
    wp_enqueue_style('reblock_styles_back', plugins_url('/dist/css/block-styles.css', __FILE__), false, '1.0.0', 'all');
}
add_action('enqueue_block_editor_assets', 'block_styles_editor');


function reblock_styles()
{
    if (function_exists('register_block_style')) {
        /**
         * Register block styles
         */
        register_block_style(
            'core/image',
            array(
                'name' => 'distress-top-bottom',
                'label' => __('Distress - Top/Bottom'),
            )
        );

        register_block_style(
            'core/columns',
            array(
                'name' => 'reverse',
                'label' => __('Reverse'),
            )
        );

        register_block_style(
            'core/cover',
            array(
                'name' => 'distress-top-bottom',
                'label' => __('Distress - Top/Bottom'),
            )
        );

        register_block_style(
            'core/heading',
            array(
                'name' => 'wide',
                'label' => __('Width - Wide'),
            )
        );

        register_block_style(
            'core/heading',
            array(
                'name' => 'full',
                'label' => __('Width - Full'),
            )
        );
    
    }
}
add_action('init', 'reblock_styles');
