<?php

/**
 * Plugin Name: reBlock Patterns
 * Description: A collection of block patterns.
 * Version: 1.0
 * Author: Jeremy Techtmann
 */

 /**
 * Register Custom Pattern Styles
 */
function pattern_styles_font_end()
{
    //wp_enqueue_script('your-script-name', $this->urlpath  . '/your-script-filename.js', array('jquery'), '1.2.3', true);
    wp_enqueue_style('reblock_pattern_styles', plugins_url('/dist/css/pattern-styles.css', __FILE__), false, '1.0.0', 'all');
}
add_action('wp_enqueue_scripts', "pattern_styles_font_end", 200);

function pattern_styles_editor()
{
    wp_enqueue_style('reblock_pattern_styles', plugins_url('/dist/css/pattern-styles.css', __FILE__), false, '1.0.0', 'all');
}
add_action('enqueue_block_editor_assets', 'pattern_styles_editor');


 /**
 * UnRegister Core Block Patterns
 */
remove_theme_support( 'core-block-patterns' );
// unregister_block_pattern( 'core/text-two-columns' );
// unregister_block_pattern( 'core/two-buttons' );
// unregister_block_pattern( 'core/two-images' );
// unregister_block_pattern( 'core/text-two-columns-with-images' );
// unregister_block_pattern( 'core/text-three-columns-buttons' );
// unregister_block_pattern( 'core/large-header' );
// unregister_block_pattern( 'core/large-header-paragraph' );
// unregister_block_pattern( 'core/three-buttons' );
// unregister_block_pattern( 'core/quote' );

/**
 * Register Custom Block Pattenr Category
 */
// register_block_pattern_category(
//     'hero',
//     array( 'label' => __( 'Hero', 'my-plugin' ) )
// );

/**
 * Register Custom Block Patterns
 */
function reblock_patterns()
{
    if (function_exists('register_block_pattern')) {
        /**
         * Register block patterns
         */
        register_block_pattern(
            'reblock_patterns/header-home',
            array(
                'title'       => __( 'Header - Home', 'reblock_patterns' ),
                'description' => __( 'Home page header with an image inserter', 'reblock_patterns' ),
                'content'     => "<!-- wp:cover {\"url\":\"https://source.unsplash.com/Zm2n2O7Fph4/1200x800\",\"id\":30,\"dimRatio\":10,\"focalPoint\":{\"x\":\"0.51\",\"y\":\"0.50\"},\"align\":\"full\",\"className\":\"pattern-header-home\",\"gtRemoveMarginBottom\":true} -->\n<div class=\"wp-block-cover alignfull has-background-dim-10 has-background-dim pattern-header-home gt-remove-margin-bottom\" style=\"background-image:url(https://source.unsplash.com/Zm2n2O7Fph4/1200x800);background-position:51% 50%\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":1,\"className\":\"has-text-align-center is-style-wide\"} -->\n<h1 class=\"has-text-align-center is-style-wide\"><strong>Ponderosa Farmstead<br></strong>Farm Raised. Hand Crafted</h1>\n<!-- /wp:heading -->\n\n<!-- wp:image {\"id\":42,\"sizeSlug\":\"large\",\"className\":\"logo\"} -->\n<figure class=\"wp-block-image size-large logo\"><img src=\"https://pagels.pantheonlocal.com/wp-content/uploads/2020/08/logo-pf.png\" alt=\"\" class=\"wp-image-42\"/></figure>\n<!-- /wp:image --></div></div>\n<!-- /wp:cover -->",
            )
        );

        register_block_pattern(
            'reblock_patterns/header-hero',
            array(
                'title'       => __( 'Header - Hero', 'reblock_patterns' ),
                'description' => __( 'Sub page header hero', 'reblock_patterns' ),
                'content'     => "<!-- wp:cover {\"url\":\"https://source.unsplash.com/Zm2n2O7Fph4/1200x800\",\"id\":30,\"dimRatio\":10,\"focalPoint\":{\"x\":\"0.51\",\"y\":\"0.50\"},\"align\":\"full\",\"className\":\"pattern-header-hero is-style-default\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim-10 has-background-dim pattern-header-hero is-style-default\" style=\"background-image:url(https://source.unsplash.com/Zm2n2O7Fph4/1200x800);background-position:51% 50%\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":1,\"className\":\"has-text-align-center is-style-wide\"} -->\n<h1 class=\"has-text-align-center is-style-wide\">The<br><strong>farmstead</strong></h1>\n<!-- /wp:heading --></div></div>\n<!-- /wp:cover -->",
            )
        );

        register_block_pattern(
            'reblock_patterns/cta-with-background',
            array(
                'title'       => __( 'CTA With Background', 'reblock_patterns' ),
                'description' => __( 'A center aligned CTA with background.', 'reblock_patterns' ),
                'content'     => "<!-- wp:cover {\"url\":\"https://pagels.pantheonlocal.com/wp-content/uploads/2020/08/bg-farm-made-1.png\",\"id\":66,\"dimRatio\":0,\"align\":\"full\",\"className\":\"pattern-cta-with-background\"} -->\n<div class=\"wp-block-cover alignfull pattern-cta-with-background\" style=\"background-image:url(https://pagels.pantheonlocal.com/wp-content/uploads/2020/08/bg-farm-made-1.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"align\":\"center\"} -->\n<h2 class=\"has-text-align-center\"><strong>Cheese Tastes Better<br></strong>Fresh From The Farm</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">At Ponderosa Farmstead in Kewaunee, Wisconsin, we believe farm-made, hand-crafted products taste better and are better for you. As a farmstead, we use milk exclusively from our herd to make the freshest cheese possible. Everything we do centers around our third-generation family dairy farm—from the lush land to the content cows, it’s simply the best place to make artisan, farmstead cheese. \&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link\">About Us</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover -->",
            )
        );

        register_block_pattern(
            'reblock_patterns/image-with-icon',
            array(
                'title'       => __( 'Image With Icon', 'reblock_patterns' ),
                'description' => __( 'Full width image with image icon.', 'reblock_patterns' ),
                'content'     => "<!-- wp:group {\"align\":\"full\",\"className\":\"pattern-image-with-icon\"} -->\n<div class=\"wp-block-group alignfull pattern-image-with-icon\"><div class=\"wp-block-group__inner-container\"><!-- wp:image {\"align\":\"center\",\"id\":36,\"sizeSlug\":\"large\",\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-image is-style-default\"><figure class=\"aligncenter size-large\"><img src=\"/wp-content/plugins/reblock-patterns/dist/images/logo-proudly-wisc.png\" alt=\"\" class=\"wp-image-36\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:cover {\"url\":\"https://source.unsplash.com/Zm2n2O7Fph4/1200x800\",\"id\":30,\"dimRatio\":0,\"focalPoint\":{\"x\":\"0.50\",\"y\":\"1.00\"},\"minHeight\":75,\"minHeightUnit\":\"vh\",\"align\":\"full\",\"className\":\"is-style-distress-top-bottom\"} -->\n<div class=\"wp-block-cover alignfull is-style-distress-top-bottom\" style=\"background-image:url(https://source.unsplash.com/Zm2n2O7Fph4/1200x800);background-position:50% 100%;min-height:75vh\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\"></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover --></div></div>\n<!-- /wp:group -->",
            )
        );
    

        register_block_pattern(
            'reblock_patterns/columns-image-text',
            array(
                'title'       => __( 'Columns - Image/Text', 'reblock_patterns' ),
                'description' => __( 'Two column layout with an Image on one side and Text on the other.', 'reblock_patterns' ),
                'content'     => "<!-- wp:columns {\"align\":\"wide\",\"className\":\"columns-image-text is-style-default\"} -->\n<div class=\"wp-block-columns alignwide columns-image-text is-style-default\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading -->\n<h2><strong>This is</strong> the Title</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Sita nobis eribus dolecepelese invent ad quis dolum eum eossitaquias voluptatest lam landanimin re mos inis eatquissi rae conempor autecuptiaes de renda pernam rationsed estiis ut ut prae enditas alia dolupta temquis estrumqui ut volorro voluptio\&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":20,\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link\" style=\"border-radius:20px\">Gift Baskets</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"align\":\"center\",\"id\":59,\"width\":445,\"height\":500,\"sizeSlug\":\"large\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large is-resized\"><img src=\"https://source.unsplash.com/CUWC-6MRcNg\" alt=\"\" class=\"wp-image-59\" width=\"445\" height=\"500\"/></figure></div>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
            )
        );

        register_block_pattern( 
            'reblock_patterns/columns-image-quote',
            array(
                'title'       => __( 'Columns - Image/Quote', 'reblock_patterns' ),
                'description' => __( 'Two column layout with an Image on one side and Text on the other.', 'reblock_patterns' ),
                'content'     => "<!-- wp:columns {\"verticalAlignment\":null,\"align\":\"wide\",\"className\":\"pattern-image-quote\"} -->\n<div class=\"wp-block-columns alignwide pattern-image-quote\"><!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"column-image\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center column-image\"><!-- wp:image {\"id\":69,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"/wp-content/plugins/reblock-patterns/dist/images/employee.jpg\" alt=\"\" class=\"wp-image-69\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"column-quote\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center column-quote\"><!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>“It’s a cheesemaker’s dream—to be this close to the milk source and use it within seconds. If you gave any cheesemaker a blank check and said, ‘Here, design your own plant,’ they’re gonna build a plant on the farm, I’ll guarantee it.”</p><cite>Ben Shibler</cite></blockquote>\n<!-- /wp:quote --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
            )
        );

        register_block_pattern(
            'reblock_patterns/image-text-vertical',
            array(
                'title'       => __( 'Vertical Image & Text', 'reblock_patterns' ),
                'description' => __( 'A vertical image and text block with a CTA included.', 'reblock_patterns' ),
                'content'     => "<!-- wp:group {\"align\":\"wide\",\"className\":\"pattern-text-image-vertical\"} -->\n<div class=\"wp-block-group alignwide pattern-text-image-vertical\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading -->\n<h2><strong>This is the title</strong> of the Block</h2>\n<!-- /wp:heading -->\n\n<!-- wp:image {\"id\":30,\"sizeSlug\":\"full\",\"className\":\"is-style-distress-top-bottom\"} -->\n<figure class=\"wp-block-image size-full is-style-distress-top-bottom\"><img src=\"https://source.unsplash.com/Zm2n2O7Fph4/1200x800\" alt=\"\" class=\"wp-image-30\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-columns is-style-default\"><!-- wp:column {\"width\":66.66} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:paragraph -->\n<p>Sita nobis eribus dolecepelese invent ad quis dolum eum eossitaquias voluptatest lam landanimin re mos inis eatquissi rae conempor autecuptiaes de renda pernam rationsed estiis ut ut prae enditas alia dolupta temquis estrumqui ut volorro voluptio\&nbsp;</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":33.33} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:33.33%\"><!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":20,\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link\" style=\"border-radius:20px\">Gift Baskets</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
            )
        );

        register_block_pattern(
            'reblock_patterns/image-text-vertical-overlap',
            array(
                'title'       => __( 'Vertical Image & Text Overlap', 'reblock_patterns' ),
                'description' => __( 'A vertical overlapping image and text block with a CTA included.', 'reblock_patterns' ),
                'content'     => "<!-- wp:group {\"align\":\"wide\",\"className\":\"pattern-text-image-vertical-overlap\"} -->\n<div class=\"wp-block-group alignwide pattern-text-image-vertical-overlap\"><div class=\"wp-block-group__inner-container\"><!-- wp:heading -->\n<h2><strong>This is the title</strong> of the Block</h2>\n<!-- /wp:heading -->\n\n<!-- wp:image {\"id\":91,\"sizeSlug\":\"large\",\"className\":\"is-style-distress-top-bottom\"} -->\n<figure class=\"wp-block-image size-large is-style-distress-top-bottom\"><img src=\"/wp-content/plugins/reblock-patterns/dist/images/overlap-large.jpg\" alt=\"\" class=\"wp-image-91\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"className\":\"is-style-default\"} -->\n<div class=\"wp-block-columns is-style-default\"><!-- wp:column {\"width\":50} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:paragraph -->\n<p>Sita nobis eribus dolecepelese invent ad quis dolum eum eossitaquias voluptatest lam landanimin re mos inis eatquissi rae conempor autecuptiaes de renda pernam rationsed estiis ut ut prae enditas alia dolupta temquis estrumqui ut volorro voluptio\\\&nbsp;</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":50} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:image {\"id\":92,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"/wp-content/plugins/reblock-patterns/dist/images/overlap-small.jpg\" alt=\"\" class=\"wp-image-92\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:group -->",
            )
        );

        register_block_pattern(
            'reblock_patterns/product-cat',
            array(
                'title'       => __( 'Product Category', 'reblock_patterns' ),
                'description' => __( 'A block pattern to be used on the shop page or anywhere you want to highlight a cheese category.', 'reblock_patterns' ),
                'content'     => "<!-- wp:columns {\"align\":\"wide\",\"className\":\"pattern-product-cat\"} -->\n<div class=\"wp-block-columns alignwide pattern-product-cat\"><!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"column-text\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center column-text\"><!-- wp:heading -->\n<h2><strong>country cheese curds</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link\">Shop Now</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"column-Image\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center column-Image\"><!-- wp:image {\"id\":114,\"sizeSlug\":\"large\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"/wp-content/plugins/reblock-patterns/dist/images/cheese-curds.jpg\" alt=\"\" class=\"wp-image-114\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
            )
        );
    }
}
add_action('init', 'reblock_patterns');
