<?php
global $post;
$adf_p_tabs_rename_description_field           = get_post_meta( $post->ID, 'adf_p_tabs_rename_description_field', true );
$adf_p_tabs_rename_review_field                = get_post_meta( $post->ID, 'adf_p_tabs_rename_review_field', true );
$adfp_tabs_rename_additional_information_field = get_post_meta( $post->ID, 'adfp_tabs_rename_additional_information_field', true );
?>
<div>
	<?php wp_nonce_field( 'cptm_nonce_action', 'cptm_field_nonce' ); ?>
	<div class="div_main_global">
		<div class="div_sub_global"><?php echo esc_html__( 'Disable Global Tabs', 'addify_ptabs' ); ?></div>
			<div class="div_input_global">
				<input type="checkbox" name="disable_global_tabs"  value="on"
				<?php
				if ( 'on' === get_post_meta( $post->ID, 'disable_global_tabs', true ) ) {
					echo 'checked';
				}
				?>
				><span><?php echo esc_html__( 'Enable this checkbox to disable the Global tabs.', 'addify_ptabs' ); ?></span>
			</div> 
		</div>
		<div class="div_main_global">
			<div class="div_sub_global"><?php echo esc_html__( 'Customize Default Tabs', 'addify_ptabs' ); ?></div>
			<div class="div_input_global">
			<input type="checkbox" id="chec_def_tabs" name="checkbox_enable_default_tabs"  value="on"
			<?php
			if ( 'on' === get_post_meta( $post->ID, 'checkbox_enable_default_tabs', true ) ) {
				echo 'checked';
			}
			?>
			><span><?php echo esc_html__( 'Customize default tabs for this product.', 'addify_ptabs' ); ?></span>
			</div>
		</div> 

	<div class="div_main_global hide_p_level">
		<div class="div_sub_global"><?php echo esc_html__( 'Enable Description Tab', 'addify_ptabs' ); ?></div>
		<div class="div_input_global">
				<input type="checkbox" name="checkbox_tabs_enable_description"  value="on"
			<?php
			if ( 'on' === get_post_meta( $post->ID, 'checkbox_tabs_enable_description', true ) ) {
				echo 'checked';
			}
			?>
			><span><?php echo esc_html__( 'Enable this checkbox for description tab.', 'addify_ptabs' ); ?></span>
		</div>
	</div>

	<div class="div_main_global hide_p_level">
			<div class="div_sub_global"><?php echo esc_html__( 'Rename Description Tab', 'addify_ptabs' ); ?></div>
				<div class="div_input_global">
				<?php
				if ( empty( $adf_p_tabs_rename_description_field ) ) {
					$adf_p_tabs_rename_description_field = 'Description';
				}
				?>
				<input type="text" name="adf_p_tabs_rename_description_field" title="Enter text here" pattern="^[ A-Za-z_,-]*$" value="<?php echo esc_attr( $adf_p_tabs_rename_description_field ); ?>">
				<br>
				<p><?php echo esc_html__( 'Enter text for change description tab title.', 'addify_ptabs' ); ?></p>
		</div>
	</div>

	<div class="div_main_global hide_p_level">
		<div class="div_sub_global"><?php echo esc_html__( 'Enable review tab', 'addify_ptabs' ); ?></div>
		<div class="div_input_global">
				<input type="checkbox" name="checkbox_enable_review_field"  value="on"
					<?php
					if ( 'on' === get_post_meta( $post->ID, 'checkbox_enable_review_field', true ) ) {
						echo 'checked';
					}
					?>
					><span><?php echo esc_html__( 'Enable this checkbox for review tab', 'addify_ptabs' ); ?></span>
		</div>
	</div>

	<div class="div_main_global hide_p_level">
		<div class="div_sub_global"><?php echo esc_html__( 'Rename review tab', 'addify_ptabs' ); ?></div>
		<div class="div_input_global">
				<?php
				if ( empty( $adf_p_tabs_rename_review_field ) ) {
					$adf_p_tabs_rename_review_field = 'Reviews';
				}
				?>
			<input type="text" name="adf_p_tabs_rename_review_field" title="Enter text here" pattern="^[ A-Za-z_,-]*$" value="<?php echo esc_attr( $adf_p_tabs_rename_review_field ); ?>">
			<br>
						<p><?php echo esc_html__( 'Enter text for change review tab title.', 'addify_ptabs' ); ?></p>
		</div>
	</div>

	<div class="div_main_global hide_p_level">
		<div class="div_sub_global"><?php echo esc_html__( 'Enable Additional Information tab', 'addify_ptabs' ); ?></div>
		<div class="div_input_global">
				<input type="checkbox" name="checkbox_additional_information_field"  value ="on"
							<?php
							if ( 'on' === get_post_meta( $post->ID, 'checkbox_additional_information_field', true ) ) {
								echo 'checked';
							}
							?>
							><span><?php echo esc_html__( 'Enable this checkbox for Additional Information tab.', 'addify_ptabs' ); ?></span>
		</div>
	</div>

	<div class="div_main_global hide_p_level">
		<div class="div_sub_global"><?php echo esc_html__( 'Rename Additional Information Tab', 'addify_ptabs' ); ?></div>
		<div class="div_input_global">
				<?php
				if ( empty( $adfp_tabs_rename_additional_information_field ) ) {

					$adfp_tabs_rename_additional_information_field = 'Additional Information';
				}
				?>
					<input type="text" name="adfp_tabs_rename_additional_information_field" title="Enter text here" pattern="^[ A-Za-z_,-]*$" value="<?php echo esc_attr( $adfp_tabs_rename_additional_information_field ); ?>">
					<br>
					<p>
						<?php echo esc_html__( 'Enter text for change Additional Information tab title.', 'addify_ptabs' ); ?>
					</p>
		</div>
	</div>

	<div class="div_main_global">
		<div class="div_sub_global"><?php echo esc_html__( 'Enable Tabs Sorting.', 'addify_ptabs' ); ?></div>
		<div class="div_input_global">
				<input type="checkbox" id="tabs_sort_p" name="checkbox_all_tabs_sort"  value="on"
					<?php
					if ( 'on' === get_post_meta( $post->ID, 'checkbox_all_tabs_sort', true ) ) {
						echo 'checked';
					}
					?>
					><span><?php echo esc_html__( 'Enable this checkbox sort the tabs.', 'addify_ptabs' ); ?></span>
		</div>
	</div>

	<div class="div_main_global hide_p_tabs_sorting">
		<div class="div_sub_global"><?php echo esc_html__( 'Tabs Sorting.', 'addify_ptabs' ); ?></div>
		<div class="div_input_global">
				<?php


					$checkbox_tabs_enable_description = get_post_meta( get_the_ID(), 'checkbox_tabs_enable_description', true );
				// $adf_p_tabs_rename_description_field  = get_post_meta( get_the_ID(), 'adf_p_tabs_rename_description_field', true );
				$checkbox_enable_review_field          = get_post_meta( get_the_ID(), 'checkbox_enable_review_field', true );
				$psorting_rename_review                = get_post_meta( get_the_ID(), 'adf_p_tabs_rename_review_field', true );
				$checkbox_additional_information_field = get_post_meta( get_the_ID(), 'checkbox_additional_information_field', true );
				$psorting_additional_information       = get_post_meta( get_the_ID(), 'adfp_tabs_rename_additional_information_field', true );
				$psorting_description                  = get_post_meta( get_the_ID(), 'adf_p_tabs_rename_description_field', true );

				$sorting_description = get_option( 'ka_tabs_rename_description_field' );

				$sorting_rename_review          = get_option( 'ka_tabs_rename_review_field' );
				$sorting_additional_information = get_option( 'ka_tabs_rename_additional_information_field' );
				$enable_description             = get_option( 'ka_enable_description_checkbox' );
				$enable_review                  = get_option( 'ka_enable_review_checkbox' );
				$enable_additional_information  = get_option( 'ka_enable_additional_information_checkbox' );
				$checkbox_enable_default_tabs   = get_post_meta( get_the_ID(), 'checkbox_enable_default_tabs', true );
				$ka_enable_defaul_tabs_rule     = get_option( 'ka_enable_defaul_tabs_rule' );

				if ( 'on' === $checkbox_enable_default_tabs && ! empty( $psorting_description ) && 'on' === $checkbox_tabs_enable_description ) {
					$pvalues1          = $psorting_description;
					$p_description_tab = isset( $pvalues1 ) && ! empty( $pvalues1 ) ? $pvalues1 : 'Description';
				} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && ! empty( $sorting_description ) && 'yes' === $enable_description ) {
						$pvalues1          = get_option( 'ka_tabs_rename_description_field' );
						$p_description_tab = isset( $pvalues1 ) && ! empty( $pvalues1 ) ? $pvalues1 : 'Description';
				} else {
						$p_description_tab = '';
				}

				if ( 'on' === $checkbox_enable_default_tabs && ! empty( $psorting_rename_review ) && 'on' === $checkbox_enable_review_field ) {
					$pnewvalues   = $psorting_rename_review;
					$p_review_tab = isset( $pnewvalues ) && ! empty( $pnewvalues ) ? $pnewvalues : 'Reviews';
				} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && ! empty( $sorting_rename_review ) && 'yes' === $enable_review ) {
						$pnewvalues   = get_option( 'ka_tabs_rename_review_field' );
						$p_review_tab = isset( $pnewvalues ) && ! empty( $pnewvalues ) ? $pnewvalues : 'Reviews';
				} else {
						$p_review_tab = '';
				}

				if ( 'on' === $checkbox_enable_default_tabs && ! empty( $psorting_additional_information ) && 'on' === $checkbox_additional_information_field ) {
					$prenamevalues  = $psorting_additional_information;
					$p_add_info_tab = isset( $prenamevalues ) && ! empty( $prenamevalues ) ? $prenamevalues : 'Additional Information';
				} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && ! empty( $sorting_additional_information ) && 'yes' === $enable_additional_information ) {

						$prenamevalues  = get_option( 'ka_tabs_rename_additional_information_field' );
						$p_add_info_tab = isset( $prenamevalues ) && ! empty( $prenamevalues ) ? $prenamevalues : 'Additional Information';

				} else {
						$p_add_info_tab = '';
				}

				$_ptab_array = array(
					'description'            => $p_description_tab,
					'reviews'                => $p_review_tab,
					'additional_information' => $p_add_info_tab,
				);

				$data = get_posts(
					array(
						'post_type'   => 'cptm_level_tab',
						'post_status' => 'publish',
						'post_parent' => get_the_ID(),
						'fields'      => 'ids',
						'numberposts' => -1,
					)
				);

				$allcustomtabs = get_posts(
					array(
						'post_type'   => 'product_tab',
						'post_status' => 'publish',
						'numberposts' => -1,
						'fields'      => 'ids',
					)
				);
				$user_match    = false;
				foreach ( $allcustomtabs as $rule_id ) {
					$cpt_hide_products   = (array) json_decode( get_post_meta( intval( $rule_id ), 'new_for_search_products', true ) );
					$cpt_hide_categories = (array) json_decode( get_post_meta( intval( $rule_id ), 'product_tabs_category', true ) );
					$cpt_all_user_roles  = (array) get_post_meta( intval( $rule_id ), 'enable_all_user_roles', true );

					$applied_on_tags         = (array) json_decode( get_post_meta( $rule_id, 'search_product_tags', true ) );
					$enable_for_all_products = get_post_meta( $rule_id, 'ap_checkbox', true );
					

					if ( 'yes' === $enable_for_all_products ) {
							$user_match = true;
					}
					if ( in_array( (string) get_the_ID(), $cpt_hide_products, true ) ) {

						$user_match = true;
					}

					foreach ( $cpt_hide_categories as $cptm_category ) {

						if ( ! empty( $cptm_category ) && has_term( $cptm_category, 'product_cat', get_the_ID() ) ) {

								$user_match = true;
						}
					}

					foreach ( $applied_on_tags as $cptm_tags ) {
						if ( ! empty( $cptm_tags ) && has_term( $cptm_tags, 'product_tag', get_the_ID() ) ) {

							$user_match = true;
						}
					}
				}
				if ( $user_match ) {
					$all_ids = array_merge( $data, $allcustomtabs );
				} else {
					$all_ids = $data;
				}



				foreach ( $all_ids as $current_post_id ) {
					$custom_tab_tittle               = get_post_meta( $current_post_id, 'tabetittle', true );
					$_ptab_array[ $current_post_id ] = $custom_tab_tittle;
				}

				$p_sorted_array = array();
				$p_cpt_sortable = (array) get_post_meta( $post->ID, 'p_cpt_sortable', true );
				if ( ! empty( $p_cpt_sortable ) ) {
					foreach ( $p_cpt_sortable  as $key => $value ) {
						if ( ! empty( intval( $value ) ) ) {
							$p_tab_post = get_post( $value );

							if ( ! empty( $p_tab_post ) && isset( $_ptab_array[ $value ] ) ) {
								$p_sorted_array[ $value ] = $_ptab_array[ $value ];
							}
						} elseif ( isset( $_ptab_array[ $value ] ) ) {

								$p_sorted_array[ $value ] = $_ptab_array[ $value ];
						}
					}
					foreach ( $_ptab_array as $key => $value ) {
						if ( ! isset( $p_sorted_array[ $key ] ) ) {
							$p_sorted_array[ $key ] = $_ptab_array[ $key ];
						}
					}
				} else {
					$p_sorted_array = $_ptab_array;
				}
				?>
			<ul id="sortable" class="pcpt_sortable ">
				<?php
				foreach ( $p_sorted_array as $key => $value ) :
					?>
					<li class="ui-state-default">
						<input type="hidden" name="p_cpt_sortable[]" value="<?php echo esc_html( $key ); ?>">	
						<?php echo esc_attr( $value ); ?><span class="dashicons dashicons-move"></span>
					</li>
				<?php endforeach; ?>

			</ul>
		</div>
	</div>
</div>						
