<?php

if (!defined('ABSPATH')) {
	exit;
}

class CU_PR_TA_MA_Front {




	public function __construct() {

		add_action('wp_enqueue_scripts', array( $this, 'cu_pr_ta_ma_custom_styles' ));
		add_filter('woocommerce_product_tabs', array( $this, 'ka_woo_new_custom_tab' ), 100, 1);
		add_action('wp_footer', array( $this, 'cu_pr_ta_ma_set_tab_style' ));
	}//end __construct()

	public function cu_pr_ta_ma_custom_styles() {
		wp_enqueue_style('cu_pr_ta_ma_', CU_PR_TA_MA_URL . '/assets/css/cu-pr-ta-ma-front-style.css', false, 1.0);

		$cu_ta_ma_google_map_url = 'https://maps.googleapis.com/maps/api/js?key=AIzaSyDE19uW2_YIeuZRC3IYFl1cMZ4QYSrqkbE&libraries=visualization';
		wp_enqueue_script('cu_ta_ma_google_map', $cu_ta_ma_google_map_url, array(), '1.0.5', false);
	}


	/**
	 *  Ka_woo_new_custom_tab function start.
	 *
	 * @param int $newtab .
	 */
	public function ka_woo_new_custom_tab( $newtab ) {

		global $product;
		$disable_global_tabs              = get_post_meta( get_the_ID(), 'disable_global_tabs', true );
		$checkbox_enable_default_tabs     = get_post_meta( get_the_ID(), 'checkbox_enable_default_tabs', true );
		$checkbox_tabs_enable_description = get_post_meta( get_the_ID(), 'checkbox_tabs_enable_description', true );
		// $adf_p_tabs_rename_description_field  = get_post_meta( get_the_ID(), 'adf_p_tabs_rename_description_field', true );
		$checkbox_enable_review_field          = get_post_meta( get_the_ID(), 'checkbox_enable_review_field', true );
		$psorting_rename_review                = get_post_meta( get_the_ID(), 'adf_p_tabs_rename_review_field', true );
		$checkbox_additional_information_field = get_post_meta( get_the_ID(), 'checkbox_additional_information_field', true );
		$psorting_additional_information       = get_post_meta( get_the_ID(), 'adfp_tabs_rename_additional_information_field', true );
		$psorting_description                  = get_post_meta( get_the_ID(), 'adf_p_tabs_rename_description_field', true );

		$sorting_description = get_option( 'ka_tabs_rename_description_field' );

		$sorting_rename_review          = get_option( 'ka_tabs_rename_review_field' );
		$sorting_additional_information = get_option( 'ka_tabs_rename_additional_information_field' );
		$enable_description             = get_option( 'ka_enable_description_checkbox' );
		$enable_review                  = get_option( 'ka_enable_review_checkbox' );
		$enable_additional_information  = get_option( 'ka_enable_additional_information_checkbox' );
		$ka_enable_defaul_tabs_rule     = get_option( 'ka_enable_defaul_tabs_rule' );

		if ( 'on' === $checkbox_enable_default_tabs && empty( $checkbox_tabs_enable_description ) ) {
			unset( $newtab['description'] );
		} elseif ( 'on' === $checkbox_enable_default_tabs && ! empty( $psorting_description ) && 'on' === $checkbox_tabs_enable_description ) {

			$newtab['description']['title'] = esc_html( $psorting_description );
		} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && 'no' === $enable_description ) {
			unset( $newtab['description'] );
		} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && ! empty( $sorting_description ) && 'yes' === $enable_description ) {

				$newtab['description']['title'] = esc_html( $sorting_description );
		}

		if ( 'on' === $checkbox_enable_default_tabs && empty( $checkbox_enable_review_field ) ) {
			unset( $newtab['reviews'] );
		} elseif ( 'on' === $checkbox_enable_default_tabs && ! empty( $psorting_rename_review ) && 'on' === $checkbox_enable_review_field ) {

			$newtab['reviews']['title'] = esc_html( $psorting_rename_review );
		} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && 'no' === $enable_review ) {
			unset( $newtab['reviews'] );
		} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && ! empty( $sorting_rename_review ) && 'yes' === $enable_review ) {

				$newtab['reviews']['title'] = esc_html( $sorting_rename_review );
		}

		if ( 'on' === $checkbox_enable_default_tabs && empty( $checkbox_additional_information_field ) ) {
			unset( $newtab['additional_information'] );
		} elseif ( 'on' === $checkbox_enable_default_tabs && ! empty( $psorting_additional_information ) && 'on' === $checkbox_additional_information_field ) {

			$newtab['additional_information']['title'] = esc_html( $psorting_additional_information );
		} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && 'no' === $enable_additional_information ) {
			unset( $newtab['additional_information'] );
		} elseif ( 'yes' === $ka_enable_defaul_tabs_rule && ! empty( $sorting_additional_information ) && 'yes' === $enable_additional_information ) {

				$newtab['additional_information']['title'] = esc_html( $sorting_additional_information );
		}

		if ( 'on' === $disable_global_tabs ) {

			$tabs_cusdata = $this->all_product_level_rules();

			if ( $tabs_cusdata ) {
				foreach ( $tabs_cusdata as $current_post_id ) {
					$tabetittle               = get_post_meta( $current_post_id, 'tabetittle', true );
					$product_enable_user_rule = (array) get_post_meta( $current_post_id, 'product_enable_user_rule', true );
					$enable_pcustom_prod_tabs = get_post_meta( $current_post_id, 'enablecheckbox', true );
					$p_tabcallback_select     = get_post_meta( $current_post_id, 'p_tabcallback_select', true );
					$pcheckbox_styling        = get_post_meta( $current_post_id, 'pcheckbox', true );

					$pnewcolor_tab                  = get_post_meta( $current_post_id, 'pnewcolor', true );
					$p_specific_user                = (array) get_post_meta( $current_post_id, 'p_specific_user', true );
					$adf_p_enable_global_icon_field = get_post_meta( $current_post_id, 'adf_p_enable_global_icon_field', true );

					$adf_p_background_img_field = get_post_meta( $current_post_id, 'adf_p_background_img_field', true );

					if ( 'yes' !== get_post_meta( $current_post_id, 'enablecheckbox', true ) ) {
						continue;
					}

					$user_match = false;

					// Allow showing to everyone if both conditions are empty.
					if ( empty( $product_enable_user_rule ) && empty( $p_specific_user ) ) {
						$user_match = true;
					} elseif ( ! is_user_logged_in() ) {
						// Show to guests if specified.
						if ( in_array( 'guest', $product_enable_user_rule, true ) ) {
							$user_match = true;
						}
					} else {
						$curr_user      = wp_get_current_user();
						$curr_user_role = current( $curr_user->roles );

						// Check for specific user or user role match.
						if ( in_array( (string) $curr_user->ID, $p_specific_user, true ) ) {
							$user_match = true;
						}
						if ( in_array( (string) $curr_user_role, $product_enable_user_rule, true ) ) {
							$user_match = true;
						}
					}

					// Add the tab if user_match is true.
					if ( $user_match ) {
						$newtab[ $current_post_id ] = array(
							'title'            => $tabetittle,
							'callback'         => array( $this, 'p_customized_custom_tabs_content' ),
							'priority'         => 50,
							'p_custom_tabs_id' => $current_post_id,
						);
					}
				}
			}

			$sorted_array = array();

			if ( ! empty( (array) get_post_meta( get_the_ID(), 'p_cpt_sortable', true ) ) ) {
				foreach ( (array) get_post_meta( get_the_ID(), 'p_cpt_sortable', true ) as $key => $value ) {
					if ( ! empty( intval( $value ) ) ) {
						$tab_post = get_post( $value );
						if ( ! empty( $tab_post ) && isset( $newtab[ $value ] ) ) {
							$sorted_array[ $value ] = $newtab[ $value ];
						}
					} elseif ( isset( $newtab[ $value ] ) ) {

							$sorted_array[ $value ] = $newtab[ $value ];
					}
				}
				foreach ( $newtab as $key => $value ) {

					if ( ! isset( $sorted_array[ $key ] ) ) {
						$sorted_array[ $key ] = $newtab[ $key ];
					}
				}
			} else {
				$sorted_array = $newtab;
			}

			return $sorted_array;
		} else {
			$tabs_cusdata  = $this->all_product_level_rules();
			$allcustomtabs = $this->all_general_ruels();

			foreach ( $allcustomtabs as $alltabs_id ) {
				$slected_user_roles_id        = get_post_meta( $alltabs_id, 'enable_all_user_roles', true );
				$custom_tab_tittle            = get_post_meta( $alltabs_id, 'tabetittle', true );
				$enable_custom_product_tabs   = get_post_meta( $alltabs_id, 'enablecheckbox', true );
				$callback_custom_product_tabs = get_post_meta( $alltabs_id, 'tabcallback_select', true );

				$enable_tab_styling_setting = get_post_meta( $alltabs_id, 'ccheckbox', true );

				$custom_product_tab_text_color       = get_post_meta( $alltabs_id, 'newcolor', true );
				$custom_product_tab_icon_image       = get_post_meta( $alltabs_id, 'ka_enable_global_icon_field', true );
				$custom_product_tab_background_image = get_post_meta( $alltabs_id, 'ka_background_img_field', true );
				$ka_front_text_editor                = get_post_meta( $alltabs_id, 'cpt_tab_content', true );
				$tabcallback_select                  = get_post_meta( $alltabs_id, 'tabcallback_select', true );
				$ka_cpt_editor_form                  = get_post_meta( $alltabs_id, 'contact_7formm_select', true );

				if ( 'checkbox' !== get_post_meta( $alltabs_id, 'enablecheckbox', true ) ) {
					continue;
				}

				if ( ! $this->ka_check_rule_for_product( $alltabs_id, $product->get_id() ) ) {

					continue;
				}

				$newtab[ $alltabs_id ] = array(
					'title'             => $custom_tab_tittle,
					'callback'          => array( $this, 'ka_customized_custom_tabs_content' ),
					'priority'          => 50,
					'ka_custom_tabs_id' => $alltabs_id,
				);
			}

			$sorted_array = array();

			if ( ! empty( get_option( 'cpt_sortable' ) ) ) {
				foreach ( get_option( 'cpt_sortable' ) as $key => $value ) {
					if ( ! empty( intval( $value ) ) ) {
						$tab_post = get_post( $value );
						if ( ! empty( $tab_post ) && isset( $newtab[ $value ] ) ) {
							$sorted_array[ $value ] = $newtab[ $value ];
						}
					} elseif ( isset( $newtab[ $value ] ) ) {

							$sorted_array[ $value ] = $newtab[ $value ];
					}
				}
				foreach ( $newtab as $key => $value ) {

					if ( ! isset( $sorted_array[ $key ] ) ) {
						$sorted_array[ $key ] = $newtab[ $key ];
					}
				}
			} else {
				$sorted_array = $newtab;
			}
			if ( $tabs_cusdata ) {
				foreach ( $tabs_cusdata as $current_post_id ) {
					$tabetittle               = get_post_meta( $current_post_id, 'tabetittle', true );
					$product_enable_user_rule = (array) get_post_meta( $current_post_id, 'product_enable_user_rule', true );
					$enable_pcustom_prod_tabs = get_post_meta( $current_post_id, 'enablecheckbox', true );
					$p_tabcallback_select     = get_post_meta( $current_post_id, 'p_tabcallback_select', true );
					$pcheckbox_styling        = get_post_meta( $current_post_id, 'pcheckbox', true );

					$pnewcolor_tab                  = get_post_meta( $current_post_id, 'pnewcolor', true );
					$p_specific_user                = (array) get_post_meta( $current_post_id, 'p_specific_user', true );
					$adf_p_enable_global_icon_field = get_post_meta( $current_post_id, 'adf_p_enable_global_icon_field', true );

					$adf_p_background_img_field = get_post_meta( $current_post_id, 'adf_p_background_img_field', true );

					if ( 'yes' !== get_post_meta( $current_post_id, 'enablecheckbox', true ) ) {
						continue;
					}

					$user_match = false;

					// Allow showing to everyone if both conditions are empty.
					if ( empty( $product_enable_user_rule ) && empty( $p_specific_user ) ) {
						$user_match = true;
					} elseif ( ! is_user_logged_in() ) {
						// Show to guests if specified.
						if ( in_array( 'guest', $product_enable_user_rule, true ) ) {
							$user_match = true;
						}
					} else {
						$curr_user      = wp_get_current_user();
						$curr_user_role = current( $curr_user->roles );

						// Check for specific user or user role match.
						if ( in_array( (string) $curr_user->ID, $p_specific_user, true ) ) {
							$user_match = true;
						}
						if ( in_array( (string) $curr_user_role, $product_enable_user_rule, true ) ) {
							$user_match = true;
						}
					}
					if ( $user_match ) {
						$newtab[ $current_post_id ] = array(
							'title'            => $tabetittle,
							'callback'         => array( $this, 'p_customized_custom_tabs_content' ),
							'priority'         => 50,
							'p_custom_tabs_id' => $current_post_id,
						);
					}
				}
			}

			if ( ! empty( (array) get_post_meta( get_the_ID(), 'p_cpt_sortable', true ) ) ) {
				foreach ( (array) get_post_meta( get_the_ID(), 'p_cpt_sortable', true ) as $key => $value ) {
					if ( ! empty( intval( $value ) ) ) {
						$tab_post = get_post( $value );
						if ( ! empty( $tab_post ) && isset( $newtab[ $value ] ) ) {
							$sorted_array[ $value ] = $newtab[ $value ];
						}
					} elseif ( isset( $newtab[ $value ] ) ) {

							$sorted_array[ $value ] = $newtab[ $value ];
					}
				}
				foreach ( $newtab as $key => $value ) {

					if ( ! isset( $sorted_array[ $key ] ) ) {
						$sorted_array[ $key ] = $newtab[ $key ];
					}
				}
			} else {
				$sorted_array = $newtab;
			}
		}

		return $sorted_array;
	}

	public function all_product_level_rules() {

		$parent_post_id = get_the_ID();
		$data           = array(
			'post_type'   => 'cptm_level_tab',
			'post_parent' => $parent_post_id,
			'fields'      => 'ids',
			'post_status' => 'published',
			'numberposts' => -1,
		);

		return get_posts($data);
	}

	public function all_general_ruels() {

		return get_posts(
			array(
				'post_type'        => 'product_tab',
				'post_status'      => 'publish',
				'numberposts'      => -1,
				'order_by'         => 'post_date',
				'fields'           => 'ids',
				'suppress_filters' => false,
			)
		);
	}

	/**
	 *  Ka_woo_new_custom_tab function start.
	 *
	 * @param int $rule_id .
	 *
	 * @param int $product_id .
	 */
	public function ka_check_rule_for_product( $rule_id, $product_id ) {

		$cpt_hide_products   = (array) json_decode( get_post_meta( intval( $rule_id ), 'new_for_search_products', true ) );
		$cpt_hide_categories = (array) json_decode( get_post_meta( intval( $rule_id ), 'product_tabs_category', true ) );
		$cpt_all_user_roles  = (array) get_post_meta( intval( $rule_id ), 'enable_all_user_roles', true );

		$applied_on_tags         = (array) json_decode( get_post_meta( $rule_id, 'search_product_tags', true ) );
		$ka_specific_user        = (array) json_decode( get_post_meta( $rule_id, 'ka_specific_user', true ) );
		$enable_for_all_products = get_post_meta( $rule_id, 'ap_checkbox', true );
		$user_match              = false;

		$cpt_all_user_roles = array_filter( $cpt_all_user_roles );
		if ( empty( $cpt_all_user_roles ) ) {
			$user_match = true;
		} elseif ( ! is_user_logged_in() ) {

			if ( in_array( 'guest', (array) $cpt_all_user_roles, true ) ) {

				$user_match = true;
			}
		} else {

			$curr_user      = wp_get_current_user();
			$curr_user_role = current( $curr_user->roles );

			if ( in_array( (string) $curr_user->ID, $ka_specific_user, true ) ) {

				$user_match = true;
			}
			if ( in_array( (string) $curr_user_role, (array) $cpt_all_user_roles, true ) ) {

				$user_match = true;
			}
		}

		if ( ! $user_match ) {

			return false;
		}

		if ( 'yes' === $enable_for_all_products ) {
			return true;
		}
		if ( in_array( (string) $product_id, $cpt_hide_products, true ) ) {

			return true;
		}

		foreach ( $cpt_hide_categories as $cat ) {

			if ( ! empty( $cat ) && has_term( $cat, 'product_cat', $product_id ) ) {

				return true;
			}
		}

		foreach ( $applied_on_tags as $cat ) {

			if ( ! empty( $cat ) && has_term( $cat, 'product_tag', $product_id ) ) {

				return true;
			}
		}

		return false;
	}






	/**
	 *  Ka_woo_new_custom_tab function start.
	 *
	 * @param int $tabid .
	 *
	 * @param int $tab .
	 */
	public function ka_customized_custom_tabs_content( $tabid, $tab ) {

		$new_tab_id = $tab['ka_custom_tabs_id'];

		$custom_product_tab_background_image = get_post_meta($new_tab_id, 'ka_background_img_field', true);
		$custom_product_tab_icon_image       = get_post_meta($new_tab_id, 'ka_enable_global_icon_field', true);

		$custom_product_tab_text_color = get_post_meta($new_tab_id, 'newcolor', true);

		if (!isset($tab['ka_custom_tabs_id'])) {
			return;
		}
		?>
		<div class="get_custom_product_tab_data" id="ka_custom_tab_<?php echo intval($new_tab_id); ?>">

			<?php
			if ('yes' === get_post_meta($new_tab_id, 'ccheckbox', true)) {
				?>

				<style type="text/css">
					.woocommerce-tabs ul.tabs li#tab-title-<?php echo intval($new_tab_id); ?>:after {

						font-family: WooCommerce;
						background: url('<?php echo esc_url($custom_product_tab_icon_image); ?>') 0 0 no-repeat;
						background-size: contain;
						content: "";
						display: inline-block;
						vertical-align: middle;
						width: 25px;
						height: 25px;
						opacity: 1;
					}

					#ka_custom_tab_<?php echo intval($new_tab_id); ?> {
						background-image: url('	<?php echo esc_url($custom_product_tab_background_image); ?>');
						background-size: cover;
						height: 100%;
						background-repeat: no-repeat;
						height: auto;
						min-height: 350px;
						background-position: center;
						padding: 25px 15px 25px 15px;
						color:
							<?php echo esc_attr(get_post_meta($new_tab_id, 'newcolor', true)) . ' !important'; ?>
						;

					}
				</style>
				<?php
			}
			if ('checkbox' === get_post_meta($new_tab_id, 'enablecheckbox', true)) {

				echo '<h2>' . esc_attr(get_post_meta($new_tab_id, 'tabetittle', true)) . '</h2>';

				if ('editor' === get_post_meta($new_tab_id, 'tabcallback_select', true)) {
					$af_tab_content = get_post_meta($new_tab_id, 'cpt_tab_content', true);
					global $product;

					$af_tab_content = $this->cu_pr_ta_ma_get_variables_from_editor($product, $af_tab_content);
					echo wp_kses_post(apply_filters('the_content', wpautop(wptexturize($af_tab_content))));

				} elseif ('form' === get_post_meta($new_tab_id, 'tabcallback_select', true)) {
					$ka_cpt_editor_form = get_post_meta($new_tab_id, 'contact_7formm_select', true);
					$shortcode          = '[contact-form-7 id="' . $ka_cpt_editor_form . '"]';
					// add your contact form short code here.
					echo do_shortcode($shortcode);
				} elseif ('image_gallery' === get_post_meta($new_tab_id, 'tabcallback_select', true)) {
					$p_image_gallery = (array) get_post_meta($new_tab_id, 'cu_pr_ta_ma_image_gallery_input', true);
					$this->cu_pr_ta_ma_image_gallery_output($p_image_gallery);
				} elseif ('video_gallery' === get_post_meta($new_tab_id, 'tabcallback_select', true)) {
					$p_video_gallery = (array) get_post_meta($new_tab_id, 'cu_pr_ta_ma_video_gallery_input', true);
					?>
					<div class="cu_pr_ta_ma_video_gallery_front cu_pr_ta_ma_gallery_front">
						<?php foreach ($p_video_gallery as $single_video) { ?>
							<div class="cu_pr_ta_ma_single_video_front">
								<button type="button" class="cu_pr_ta_ma_video_gallery_btn cu_pr_ta_ma_view_gallery_btn" value="video">
									<video src="<?php echo esc_url(wp_get_attachment_url($single_video)); ?>"></video>
								</button>
							</div>
						<?php } ?>
					</div>

					<section tabindex="0" class="cu_pr_ta_ma_video_gallery_modal cu_pr_ta_ma_gallery_modal cu_pr_ta_ma_gallery_hidden">

						<div class="cu_pr_ta_ma_gallery_modal_header">
							<button class="cu_pr_ta_ma_gallery_btn_close" type="button"><i class="fa fa-times"></i></button>
						</div>

						<div class="cu_pr_ta_ma_gallery_modal_body">

						</div>
					</section>
					<div class="cu_pr_ta_ma_gallery_overlay cu_pr_ta_ma_gallery_hidden"></div>

					<?php
				} elseif ('download_files' === get_post_meta($new_tab_id, 'tabcallback_select', true)) {
					$cu_pr_ta_ma_files = (array) get_post_meta($new_tab_id, 'cu_pr_ta_ma_file_input', true);
					?>
					<div class="cu_pr_ta_ma_file_front">
						<?php
						if (!empty($cu_pr_ta_ma_files)) {
							foreach ($cu_pr_ta_ma_files as $cu_pr_ta_ma_file) {
								$attachment_metadata = wp_get_attachment_metadata($cu_pr_ta_ma_file);
								if ($attachment_metadata) {
									$file_url   = wp_get_attachment_url($cu_pr_ta_ma_file);
									$file_size  = filesize(get_attached_file($cu_pr_ta_ma_file));
									$mime_type  = get_post_mime_type($cu_pr_ta_ma_file);
									$file_title = get_the_title($cu_pr_ta_ma_file);
									?>
									<div class="cu_pr_ta_ma_single">
										<p><?php echo esc_attr($file_title . ' (' . $mime_type . ') size: ' . number_format($file_size / 1024, 2) . ' KB'); ?>
										</p>
										<div class="cu_pr_ta_ma_download_file">
											<a class="button button-small" href="<?php echo esc_url($file_url); ?>" download><i
													class="fa fa-download"></i> </a>
										</div>
									</div>
									<?php
								}
							}
						}
						?>
					</div>
					<?php
				} elseif ('store_location' === get_post_meta($new_tab_id, 'tabcallback_select', true)) {
					$cu_pr_ta_ma_store_location              = get_post_meta($new_tab_id, 'cu_pr_ta_ma_store_location', true);
					$cu_pr_ta_ma_store_location_address_lat  = get_post_meta($new_tab_id, 'cu_pr_ta_ma_store_location_address_lat', true);
					$cu_pr_ta_ma_store_location_address_long = get_post_meta($new_tab_id, 'cu_pr_ta_ma_store_location_address_long', true);

					?>
					<div class="cu_pr_ta_ma_store_location_front">

						<input type="hidden" class="af_all_address"
							value="<?php echo !empty($cu_pr_ta_ma_store_location) ? esc_attr($cu_pr_ta_ma_store_location) : ''; ?>"
							data-url="<?php echo !empty($cu_pr_ta_ma_store_location) ? esc_attr($cu_pr_ta_ma_store_location) : ''; ?>"
							data-lat="<?php echo !empty($cu_pr_ta_ma_store_location_address_lat) ? esc_attr($cu_pr_ta_ma_store_location_address_lat) : ''; ?>"
							data-long="<?php echo !empty($cu_pr_ta_ma_store_location_address_long) ? esc_attr($cu_pr_ta_ma_store_location_address_long) : ''; ?>">

						<style>
							.ez-map {
								min-height: 150px;
								min-width: 150px;
								height: 420px;
								width: 100%;
							}
						</style>
						<div class="ez-map"></div>
					</div>

					<?php
				}
				?>
			</div>
			<?php
			}
	}

	public function p_customized_custom_tabs_content( $tabid, $tab ) {

		$p_tab_id = $tab['p_custom_tabs_id'];

		$pcustom_product_tab_background_image = get_post_meta($p_tab_id, 'adf_p_background_img_field', true);
		$pcustom_product_tab_icon_image       = get_post_meta($p_tab_id, 'adf_p_enable_global_icon_field', true);

		$custom_product_tab_text_color = get_post_meta($p_tab_id, 'pnewcolor', true);

		if (!isset($tab['p_custom_tabs_id'])) {
			return;
		}
		?>
		<div class="get_custom_product_tab_data" id="ka_custom_tab_<?php echo intval($p_tab_id); ?>">

			<?php
			if ('yes' === get_post_meta($p_tab_id, 'pcheckbox', true)) {
				?>

				<style type="text/css">
					.woocommerce-tabs ul.tabs li#tab-title-<?php echo intval($p_tab_id); ?>:after {

						font-family: WooCommerce;
						background: url('<?php echo esc_url($pcustom_product_tab_icon_image); ?>') 0 0 no-repeat;
						background-size: contain;
						content: "";
						display: inline-block;
						vertical-align: middle;
						width: 25px;
						height: 25px;
						opacity: 1;
					}

					#ka_custom_tab_<?php echo intval($p_tab_id); ?> {
						background-image: url('	<?php echo esc_url($pcustom_product_tab_background_image); ?>');
						background-size: cover;
						height: 100%;
						background-repeat: no-repeat;
						height: auto;
						min-height: 350px;
						background-position: center;
						padding: 25px 15px 25px 15px;
						color:
							<?php echo esc_attr(get_post_meta($p_tab_id, 'pnewcolor', true)); ?>
						;
					}

					/*.custom-tab-title{
																																							color: <?php echo esc_attr(get_post_meta($p_tab_id, 'pnewcolor', true)); ?>
					;
					}

					*/
				</style>
				<?php
			}
			if ('yes' === get_post_meta($p_tab_id, 'enablecheckbox', true)) {

				echo '<h2>' . esc_attr(get_post_meta($p_tab_id, 'tabetittle', true)) . '</h2>';

				if ('editor' === get_post_meta($p_tab_id, 'p_tabcallback_select', true)) {
					$p_tab_content = get_post_meta($p_tab_id, 'p_cpt_tab_content' . $p_tab_id, true);
					global $product;

					$p_tab_content = $this->cu_pr_ta_ma_get_variables_from_editor($product, $p_tab_content);

					echo wp_kses_post(apply_filters('the_content', wpautop(wptexturize($p_tab_content))));
				} elseif ('form' === get_post_meta($p_tab_id, 'p_tabcallback_select', true)) {
					$p_cpt_editor_form = get_post_meta($p_tab_id, 'p_contact_7formm_select', true);
					$shortcode         = '[contact-form-7 id="' . $p_cpt_editor_form . '"]';
					// add your contact form short code here.
					echo do_shortcode($shortcode);
				} elseif ('image_gallery' === get_post_meta($p_tab_id, 'p_tabcallback_select', true)) {
					$p_image_gallery = (array) get_post_meta($p_tab_id, 'cu_pr_ta_ma_image_gallery_input', true);
					$this->cu_pr_ta_ma_image_gallery_output($p_image_gallery);

				} elseif ('video_gallery' === get_post_meta($p_tab_id, 'p_tabcallback_select', true)) {
					$p_video_gallery = (array) get_post_meta($p_tab_id, 'cu_pr_ta_ma_video_gallery_input', true);
					?>
					<div class="cu_pr_ta_ma_video_gallery_front cu_pr_ta_ma_gallery_front">
						<?php foreach ($p_video_gallery as $single_video) { ?>
							<div class="cu_pr_ta_ma_single_video_front">
								<button type="button" class="cu_pr_ta_ma_video_gallery_btn cu_pr_ta_ma_view_gallery_btn" value="video"
									data-src="">
									<video src="<?php echo esc_url(wp_get_attachment_url($single_video)); ?>"></video>
								</button>
							</div>
						<?php } ?>
					</div>

					<section tabindex="0" class="cu_pr_ta_ma_gallery_modal cu_pr_ta_ma_gallery_hidden">
						<div class="cu_pr_ta_ma_gallery_modal_header">
							<button class="cu_pr_ta_ma_gallery_btn_close" type="button"><i class="fa fa-times"></i></button>
						</div>
						<div class="cu_pr_ta_ma_gallery_modal_body">

						</div>
					</section>
					<div class="cu_pr_ta_ma_gallery_overlay cu_pr_ta_ma_gallery_hidden"></div>

					<?php
				} elseif ('download_files' === get_post_meta($p_tab_id, 'p_tabcallback_select', true)) {
					$cu_pr_ta_ma_files = (array) get_post_meta($p_tab_id, 'cu_pr_ta_ma_file_input', true);
					?>
					<div class="cu_pr_ta_ma_file_front">
						<?php
						if (!empty($cu_pr_ta_ma_files)) {
							foreach ($cu_pr_ta_ma_files as $cu_pr_ta_ma_file) {
								$attachment_metadata = wp_get_attachment_metadata($cu_pr_ta_ma_file);
								if ($attachment_metadata) {
									$file_url   = wp_get_attachment_url($cu_pr_ta_ma_file);
									$file_size  = filesize(get_attached_file($cu_pr_ta_ma_file));
									$mime_type  = get_post_mime_type($cu_pr_ta_ma_file);
									$file_title = get_the_title($cu_pr_ta_ma_file);
									?>
									<div class="cu_pr_ta_ma_single">
										<p><?php echo esc_attr($file_title . ' (' . $mime_type . ') size: ' . number_format($file_size / 1024, 2) . ' KB'); ?>
										</p>
										<div class="cu_pr_ta_ma_download_file">
											<a class="button button-small" href="<?php echo esc_url($file_url); ?>" download><i
													class="fa fa-download"></i> </a>
										</div>
									</div>
									<?php
								}
							}
						}
						?>
					</div>

					<?php
				} elseif ('store_location' === get_post_meta($p_tab_id, 'p_tabcallback_select', true)) {
					$cu_pr_ta_ma_store_location              = get_post_meta($p_tab_id, 'cu_pr_ta_ma_store_location', true);
					$cu_pr_ta_ma_store_location_address_lat  = get_post_meta($p_tab_id, 'cu_pr_ta_ma_store_location_address_lat', true);
					$cu_pr_ta_ma_store_location_address_long = get_post_meta($p_tab_id, 'cu_pr_ta_ma_store_location_address_long', true);

					?>
					<div class="cu_pr_ta_ma_store_location_front">

						<input type="hidden" class="af_all_address"
							value="<?php echo !empty($cu_pr_ta_ma_store_location) ? esc_attr($cu_pr_ta_ma_store_location) : ''; ?>"
							data-url="<?php echo !empty($cu_pr_ta_ma_store_location) ? esc_attr($cu_pr_ta_ma_store_location) : ''; ?>"
							data-lat="<?php echo !empty($cu_pr_ta_ma_store_location_address_lat) ? esc_attr($cu_pr_ta_ma_store_location_address_lat) : ''; ?>"
							data-long="<?php echo !empty($cu_pr_ta_ma_store_location_address_long) ? esc_attr($cu_pr_ta_ma_store_location_address_long) : ''; ?>">
						<style>
							.ez-map {
								min-height: 150px;
								min-width: 150px;
								height: 420px;
								width: 100%;
							}
						</style>
						<div class="ez-map"></div>

					</div>

					<?php
				}
				?>
			</div>
			<?php
			}
	}

	public function cu_pr_ta_ma_get_variables_from_editor( $product, $p_tab_content ) {

		$p_tab_content = str_replace('{product_id}', $product->get_id(), $p_tab_content);
		$p_tab_content = str_replace('{product_name}', $product->get_name(), $p_tab_content);
		$p_tab_content = str_replace('{product_slug}', $product->get_slug(), $p_tab_content);
		$p_tab_content = str_replace('{product_date_created}', $product->get_date_created(), $p_tab_content);
		$p_tab_content = str_replace('{product_date_modified}', $product->get_date_modified(), $p_tab_content);
		$p_tab_content = str_replace('{product_status}', $product->get_status(), $p_tab_content);
		$p_tab_content = str_replace('{product_featured}', $product->get_featured(), $p_tab_content);
		$p_tab_content = str_replace('{product_catalog_visibility}', $product->get_catalog_visibility(), $p_tab_content);
		$p_tab_content = str_replace('{product_description}', $product->get_description(), $p_tab_content);
		$p_tab_content = str_replace('{product_short_description}', $product->get_short_description(), $p_tab_content);
		$p_tab_content = str_replace('{product_sku}', $product->get_sku(), $p_tab_content);
		$p_tab_content = str_replace('{product_menu_order}', $product->get_menu_order(), $p_tab_content);
		$p_tab_content = str_replace('{product_virtual}', $product->get_virtual(), $p_tab_content);
		$p_tab_content = str_replace('{product_permalink}', '<a href="' . $product->get_permalink() . '">' . $product->get_permalink() . '</a>', $p_tab_content);
		$p_tab_content = str_replace('{product_price}', $product->get_price(), $p_tab_content);
		$p_tab_content = str_replace('{product_regular_price}', $product->get_regular_price(), $p_tab_content);
		$p_tab_content = str_replace('{product_sale_price}', $product->get_sale_price(), $p_tab_content);
		$p_tab_content = str_replace('{product_total_sales}', $product->get_total_sales(), $p_tab_content);
		$p_tab_content = str_replace('{product_tax_status}', $product->get_tax_status(), $p_tab_content);
		$p_tab_content = str_replace('{product_tax_class}', $product->get_tax_class(), $p_tab_content);
		$p_tab_content = str_replace('{product_stock_status}', $product->get_stock_status(), $p_tab_content);
		$p_tab_content = str_replace('{product_sold_individually}', $product->get_sold_individually(), $p_tab_content);
		$p_tab_content = str_replace('{product_purchase_note}', $product->get_purchase_note(), $p_tab_content);
		$p_tab_content = str_replace('{product_weight}', $product->get_weight(), $p_tab_content);
		$p_tab_content = str_replace('{product_length}', $product->get_length(), $p_tab_content);
		$p_tab_content = str_replace('{product_width}', $product->get_width(), $p_tab_content);
		$p_tab_content = str_replace('{product_height}', $product->get_height(), $p_tab_content);
		$p_tab_content = str_replace('{product_download_expiry}', $product->get_download_expiry(), $p_tab_content);
		$p_tab_content = str_replace('{product_download_limit}', $product->get_download_limit(), $p_tab_content);
		$p_tab_content = str_replace('{product_image}', $product->get_image(), $p_tab_content);
		$p_tab_content = str_replace('{product_reviews_allowed}', $product->get_reviews_allowed(), $p_tab_content);
		$p_tab_content = str_replace('{product_reviews_count}', $product->get_review_count(), $p_tab_content);
		$p_tab_content = str_replace('{product_rating_count}', $product->get_rating_count(), $p_tab_content);

		$p_tab_content = str_replace('{product_average_rating}', $product->get_average_rating(), $p_tab_content);

		$categories = '';
		foreach ($product->get_category_ids() as $cat_id) {
			$cat_term = get_term_by('id', (int) $cat_id, 'product_cat');
			if ($cat_term) {
				$categories .= ' ' . $cat_term->name;
			}
		}
		$tags = '';
		foreach ($product->get_tag_ids() as $tag_id) {
			$tag_term = get_term_by('id', (int) $tag_id, 'product_tag');
			if ($tag_term) {
				$tags .= ' ' . $tag_term->name;
			}
		}
		$p_tab_content = str_replace('{product_category}', $categories, $p_tab_content);
		$p_tab_content = str_replace('{product_tags}', $tags, $p_tab_content);
		$p_tab_content = str_replace('{product_excerpt}', get_the_excerpt($product->get_id()), $p_tab_content);

		$custom_shortcode_values = array();
		$custom_shortcode        = preg_replace_callback(
			'/\{custom_shortcode_name=([^\}]+)\}/',
			function ( $matches ) use ( &$custom_shortcode_values ) {
				$custom_shortcode_values[] = $matches[1];

				return '';
			},
			$p_tab_content
		);

		foreach ($custom_shortcode_values as $custom_shortcode_value) {
			if (!empty($custom_shortcode_value)) {
				ob_start();
				do_shortcode($custom_shortcode_value);
				$output = ob_get_contents();
				ob_end_clean();
				$p_tab_content = str_replace(
					'{custom_shortcode_name=' . $custom_shortcode_value . '}',
					'<div>' . $output . '</div>',
					$p_tab_content
				);
			}
		}

		return $p_tab_content;
	}

	public function cu_pr_ta_ma_image_gallery_output( $p_image_gallery ) {

		$cpt_gallery_style = get_option('cptm_gallery_style');
		if ('slideshow' === $cpt_gallery_style) {

			$cptm_gallery_slideshow_autoplay     = get_option('cptm_gallery_slideshow_autoplay');
			$cptm_gallery_slideshow_files_number = get_option('cptm_gallery_slideshow_files_number') < 1 ? 1 : get_option('cptm_gallery_slideshow_files_number');
			$cptm_gallery_slideshow_files_number = $cptm_gallery_slideshow_files_number >= 5 ? 5 : $cptm_gallery_slideshow_files_number;

			?>
			<div class="cu_pr_ta_ma_slideshow-container"
				data-autoplay_enable="<?php echo esc_attr($cptm_gallery_slideshow_autoplay); ?>"
				data-files_number="<?php echo esc_attr($cptm_gallery_slideshow_files_number); ?>">
				<div class="cu_pr_ta_ma_slider">
					<?php
					$total_dots = 0;
					foreach ($p_image_gallery as $single_image) {
						++$total_dots;
						?>
						<div class="cu_pr_ta_ma_mySlides">
							<img src="<?php echo esc_url(wp_get_attachment_thumb_url($single_image)); ?>" alt="Image">
						</div>
					<?php } ?>
				</div>

				<a class="cu_pr_ta_ma_prev cu_pr_ta_ma_move_slide" data-move="-1"><</a>
					
						<a class="cu_pr_ta_ma_next cu_pr_ta_ma_move_slide" data-move="1">></a>

						<div class="cu_pr_ta_ma_dot-container">
							<?php for ($i = 0; $i <= ( $total_dots - $cptm_gallery_slideshow_files_number ); $i++) { ?>
								<span class="cu_pr_ta_ma_dot cu_pr_ta_ma_dot_<?php echo esc_attr($i); ?>"
									data-current="<?php echo esc_attr($i); ?>"></span>
								<?php
							}
							$total_dots = 0;
							?>
						</div>
			</div>
			<?php
		} else {
			?>
			<div class="cu_pr_ta_ma_image_gallery_front cu_pr_ta_ma_gallery_front">
				<?php foreach ($p_image_gallery as $single_image) { ?>
					<div class="cu_pr_ta_ma_single_image_front">
						<button type="button" class="cu_pr_ta_ma_image_gallery_btn cu_pr_ta_ma_view_gallery_btn" value="img"
							data-src="<?php echo esc_url(wp_get_attachment_thumb_url($single_image)); ?>">
							<img src="<?php echo esc_url(wp_get_attachment_thumb_url($single_image)); ?>" alt="Image">
						</button>
					</div>
				<?php } ?>
			</div>
			<section tabindex="0" class="cu_pr_ta_ma_gallery_modal cu_pr_ta_ma_gallery_hidden" id="cu_pr_ta_ma_image_gallery_modal">
				<!-- Modal header -->
				<div class="cu_pr_ta_ma_gallery_modal_header">
					<button class="cu_pr_ta_ma_gallery_btn_close" type="button"><i class="fa fa-times"></i></button>
				</div>
				<!-- Modal body -->
				<div class="cu_pr_ta_ma_gallery_modal_body">

				</div>
			</section>
			<div class="cu_pr_ta_ma_gallery_overlay cu_pr_ta_ma_gallery_hidden"></div>
			<?php
		}
	}

	public function cu_pr_ta_ma_set_tab_style() {
		if ('vertical' === get_option('cptm_tab_style')) {
			if ('left' === get_option('cptm_tabs_position') || empty(get_option('cptm_tabs_position'))) {
				?>
				<script type="text/javascript">
					jQuery(document).ready(function ($) {
						$('.woocommerce-tabs.wc-tabs-wrapper').addClass('tabs-container tabs-container-v-l');
						$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').addClass('tab-vertical tab-left');
					});
				</script>
				<?php
			} elseif ('right' === get_option('cptm_tabs_position')) {

				?>
				<script type="text/javascript">
					jQuery(document).ready(function ($) {
						$('.woocommerce-tabs.wc-tabs-wrapper').addClass('tabs-container tabs-container-v-r');
						$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').addClass('tab-vertical tab-right');
					});
				</script>
				<style>
					.woocommerce-tabs ul.tabs li.active::before {
						opacity: 1;
					}

					.woocommerce-tabs ul.tabs li::before {
						content: "\f104";
						font-family: "Font Awesome 5 Free";
						display: inline-block;
						font-style: normal;
						font-variant: normal;
						font-weight: normal;
						line-height: 1;
						font-family: "Font Awesome 5 Free";
						font-weight: 900;
						line-height: inherit;
						/* vertical-align: baseline; */
						/*content: "";*/
						display: block;
						position: absolute;
						top: 50%;
						transform: translateY(-50%);
						opacity: 0;
						left: 1em;
						transition: all, ease, .3s;
					}

					.woocommerce-tabs ul.tabs li a {
						padding-left: 30%;
					}

					.woocommerce-tabs ul.tabs li.active {
						border-left: none;
					}

					.woocommerce-tabs ul.tabs li::after {
						content: "";
					}
				</style>
				<?php
			}
		} elseif ('horizontal' === get_option('cptm_tab_style')) {
			if ('top' === get_option('cptm_tabs_position') || empty(get_option('cptm_tabs_position'))) {

				?>
				<script type="text/javascript">
					jQuery(document).ready(function ($) {

						$('.woocommerce-tabs.wc-tabs-wrapper').addClass('tabs-container tabs-container-h-t');
						$('.woocommerce-tabs.wc-tabs-wrapper div.woocommerce-Tabs-panel').css({
							'width': '100%',
						});
						$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').css({
							'display': 'flex',
							'width': '100%',
							'overflow-x': 'auto'
						});
						$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').addClass('tab-horizontal tab-top');
					});
				</script>
				<style>
					.woocommerce-tabs ul.tabs li::after {
						content: "\f078";
						font-family: "Font Awesome 5 Free";
					}
				</style>
				<?php

			} elseif ('bottom' === get_option('cptm_tabs_position')) {

				?>
				<script type="text/javascript">
					jQuery(document).ready(function ($) {

						$('.woocommerce-tabs.wc-tabs-wrapper').addClass('tabs-container tabs-container-h-b');
						$('.woocommerce-tabs.wc-tabs-wrapper div.woocommerce-Tabs-panel').css({
							'width': '100%',
						});
						$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').css({
							'display': 'flex',
							'width': '100%',
							'overflow-x': 'auto'
						});
						$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').addClass('tab-horizontal tab-bottom');
					});
				</script>
				<style>
					.woocommerce-tabs ul.tabs li::after {
						content: "\f077";
						font-family: "Font Awesome 5 Free";
					}
				</style>
				<?php

			}
		} elseif ('accordion' === get_option('cptm_tab_style')) {
			?>
			<script type="text/javascript">
				jQuery(document).ready(function ($) {
					$('.woocommerce-tabs.wc-tabs-wrapper').addClass('tabs-container tabs-container-accordion');
					$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').css({ 'display': 'flex', 'width': '100%' });
					$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').addClass('tab-accordion');

					$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs li').each(function () {
						var current_li = $(this);
						var div_tab_details_id = $(this).attr('id').replace('-title-', '-');
						var div_tab = $("#" + div_tab_details_id);
						if (div_tab.length) {
							$("#" + div_tab_details_id).remove();
							current_li.after(div_tab);
							div_tab.css({ 'width': '100%' });
						}
					});
				});
			</script>

			<style>
				.woocommerce-tabs ul.tabs li::after {
					content: "\f078";
					font-family: "Font Awesome 5 Free";
				}
			</style>

			<?php
		} elseif ('full' === get_option('cptm_tab_style')) {
			?>
			<script type="text/javascript">
				jQuery(document).ready(function ($) {
					$('.woocommerce-tabs.wc-tabs-wrapper').addClass('tabs-container tabs-container-full');
					$('.woocommerce-tabs.wc-tabs-wrapper ul.tabs').hide();

					setTimeout(
						function () {
							// var divs = $('.tabs-container-full div');
							$('.tabs-container-full div').css({ 'width': '100%', 'margin': '10px auto' });
							$('.tabs-container-full div').show();
							$('.cu_pr_ta_ma_gallery_overlay').hide();

						}
						, 5000
					);
				});
			</script>

			<?php
		}
	}
}//end class

if (class_exists('CU_PR_TA_MA_Front')) {
	new CU_PR_TA_MA_Front();
}