<?php

class CU_PR_TA_MA_Ajax_Controller {

	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'cu_pr_ta_ma_enqueue_select2_jquery' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'cu_pr_ta_ma_admin_script' ) );

		add_action( 'wp_enqueue_scripts', array( $this, 'cu_pr_ta_ma_front_script' ) );

		add_action( 'wp_ajax_ka_wocommerce_custom_products', array( $this, 'ka_wocommerce_custom_products' ) );
		add_action( 'wp_ajax_ka_apply_for_sus_search', array( $this, 'ka_apply_for_sus_search' ) );

		add_action( 'wp_ajax_ka_apply_for_product_search', array( $this, 'ka_apply_for_product_search' ) );
		add_action( 'wp_ajax_add_and_delete_tab', array( $this, 'add_and_delete_tab' ) );
	}//end __construct()


	public function cu_pr_ta_ma_enqueue_select2_jquery() {
		wp_enqueue_style( 'select2-css', plugins_url( 'assets/css/select2.css', WC_PLUGIN_FILE ), array(), '5.7.2' );
		wp_enqueue_script( 'select2-js', plugins_url( 'assets/js/select2/select2.min.js', WC_PLUGIN_FILE ), array( 'jquery' ), '4.0.3', true );
	}
	public function cu_pr_ta_ma_admin_script() {
		$screen = get_current_screen();

		if ( ! in_array( $screen->id, array( 'product_tab', 'cptm_level_tab', 'edit-product_tab', 'woocommerce_page_wc-settings', 'product', 'product_tab_page_product_settings' ), true ) ) {
			return;
		}
		wp_enqueue_script( 'cu_pr_ta_ma_', CU_PR_TA_MA_URL . '/assets/js/cu-pr-ta-ma-admin-script.js', array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'new_custom_products', CU_PR_TA_MA_URL . '/assets/js/icon.js', true, '1.0', $in_footer = false );
		wp_enqueue_style('font_owsem_ptm', CU_PR_TA_MA_URL . '/assets/css/fontawesome/css/all.min.css', false, '6.0.0-beta3');
		wp_enqueue_script( 'media-upload' );

		wp_enqueue_editor();
		wp_enqueue_media();

		$result = '';
		if ( in_array( $screen->id, array( 'cptm_level_tab', 'product', 'woocommerce_page_wc-settings' ), true ) ) {
			ob_start();
			require_once CU_PR_TA_MA_PLUGIN_DIR . '/template/sort-tabs-template-replace.php';
			$result = ob_get_clean();

			wp_enqueue_script( 'cu_pr_ta_ma_', CU_PR_TA_MA_URL . '/assets/js/tabs.js', array( 'jquery' ), '1.0', $in_footer = true );

		}

		$new_data = array(
			'admin_url'    => admin_url( 'admin-ajax.php' ),
			'nonce'        => wp_create_nonce( 'custom_product_tab_nonce' ),
			'cpt_sortable' => $result,
			'screen'       => $screen,
		);
		wp_localize_script( 'cu_pr_ta_ma_', 'custom_product_tab_url', $new_data );
	}






	public function cu_pr_ta_ma_front_script() {
		wp_enqueue_script( 'cu_pr_ta_ma_', CU_PR_TA_MA_URL . '/assets/js/cu-pr-ta-ma-front-script.js', array( 'jquery' ), '1.0.0', true );

		$args = array(
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'nonce'    => wp_create_nonce( 'cu_pr_ta_ma_front_action' ),
		);

		wp_localize_script( 'cu_pr_ta_ma_', 'cu_pr_ta_ma_link_obj', $args );
	}//end cu_pr_ta_ma_front_script()
	/**
	 * Ka_wocommerce_custom_products function start.
	 */
	public function ka_wocommerce_custom_products() {

			 $nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['nonce'] ) ) : '';
		if ( ! wp_verify_nonce( $nonce, 'custom_product_tab_nonce' ) ) {
			wp_send_json_error( 'Failed ajax security check!' );
			wp_die();
		}
		if ( isset( $_POST['q'] ) && '' !== $_POST['q'] ) {
			$pro = sanitize_text_field( wp_unslash( $_POST['q'] ) );
		} else {
			$pro = '';
		}

		$data_array = array();
		$args       = array(
			'post_type'   => array( 'product' ),
			'post_status' => 'publish',
			'numberposts' => -1,
			's'           => $pro,
		);
		$pros       = get_posts( $args );
		if ( ! empty( $pros ) ) {
			foreach ( $pros as $proo ) {
				$title        = ( mb_strlen( $proo->post_title ) > 50 ) ? mb_substr( $proo->post_title, 0, 49 ) . '...' : $proo->post_title;
				$data_array[] = array( $proo->ID, $title ); // array( Post ID, Post Title ).
			}
		}
		echo wp_json_encode( $data_array );
		die();
	}

	/**
	 * New  ka_apply_for_product_search function start.
	 */
	public function ka_apply_for_sus_search() {

		 $nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['nonce'] ) ) : '';
		if ( ! wp_verify_nonce( $nonce, 'custom_product_tab_nonce' ) ) {
			wp_send_json_error( 'Failed ajax security check!' );
			wp_die();
		}
		if ( isset( $_POST['q'] ) && '' !== $_POST['q'] ) {
			$pro = sanitize_text_field( wp_unslash( $_POST['q'] ) );
		} else {
			$pro = '';
		}
		$data_array  = array();
		$users       = new WP_User_Query(
			array(
				'search'         => '*' . esc_attr( $pro ) . '*',
				'search_columns' => array(
					'user_login',
					'user_nicename',
					'user_email',
					'user_url',
				),
			)
		);
		$users_found = $users->get_results();
		if ( ! empty( $users_found ) ) {
			foreach ( $users_found as $proo ) {
				$title        = $proo->display_name . '(' . $proo->user_email . ')';
				$data_array[] = array( $proo->ID, $title ); // array( User ID, User name and email ).
			}
		}
		echo wp_json_encode( $data_array );
		die();
	}

	/**
	 * New  ka_apply_for_product_search function start.
	 */
	public function ka_apply_for_product_search() {

			 $nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['nonce'] ) ) : '';
		if ( ! wp_verify_nonce( $nonce, 'custom_product_tab_nonce' ) ) {
			wp_send_json_error( 'Failed ajax security check!' );
			wp_die();
		}
		if ( isset( $_POST['q'] ) && '' !== $_POST['q'] ) {
			$new = sanitize_text_field( wp_unslash( $_POST['q'] ) );
		} else {
			$new = '';
		}

		$data_array = array();
		$args       = array(
			'post_type'   => array( 'product' ),
			'post_status' => 'publish',
			'numberposts' => -1,
			's'           => $new,
		);
		$pros       = get_posts( $args );
		if ( ! empty( $pros ) ) {
			foreach ( $pros as $proo ) {
				$title        = ( mb_strlen( $proo->post_title ) > 50 ) ? mb_substr( $proo->post_title, 0, 49 ) . '...' : $proo->post_title;
				$data_array[] = array( $proo->ID, $title ); // array( Post ID, Post Title ).
			}
		}
		echo wp_json_encode( $data_array );
		die();
	}

	public function add_and_delete_tab() {

			 $nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['nonce'] ) ) : '';
		if ( ! wp_verify_nonce( $nonce, 'custom_product_tab_nonce' ) ) {
			wp_send_json_error( 'Failed ajax security check!' );
			wp_die();
		}
		if ( isset( $_POST['add_or_delete'] ) && isset( $_POST['parent_post_id'] ) ) {

			$add_or_delete = sanitize_text_field( wp_unslash( $_POST['add_or_delete'] ) );

			if ( 'add' === $add_or_delete ) {
				$parent_post_id  = sanitize_text_field( wp_unslash( $_POST['parent_post_id'] ) );
				$aurgs           = array(
					'post_type'   => 'cptm_level_tab',
					'post_parent' => $parent_post_id,
					'post_status' => 'publish',
				);
				$current_post_id = wp_insert_post( $aurgs );
				ob_start();
				include CU_PR_TA_MA_PLUGIN_DIR . 'template/product-level-tab.php';
				$new_html = ob_get_clean();
				wp_send_json(
					array(
						'new_html' => $new_html,
						'post_id'  => $current_post_id,
					)
				);
			}

			if ( 'delete' === $add_or_delete && isset( $_POST['current_post_id'] ) ) {
				$delete_post_id = sanitize_text_field( wp_unslash( $_POST['current_post_id'] ) );
				wp_delete_post( $delete_post_id );
			}
		}
	}
}//end class

new CU_PR_TA_MA_Ajax_Controller();
