<?php

global $post;

$enablecheckbox          = get_post_meta( $post->ID, 'enablecheckbox', true );
$enable_all_user_roles   = get_post_meta( $post->ID, 'enable_all_user_roles', true );
$ka_cpt_editor_content   = get_post_meta( $post->ID, 'cpt_tab_content', true );
$tabetittle              = get_post_meta( $post->ID, 'tabetittle', true );
$tabcallback_select      = get_post_meta( $post->ID, 'tabcallback_select', true );
$product_tabs_category   = json_decode( get_post_meta( $post->ID, 'product_tabs_category', true ) );
$search_product_tags     = json_decode( get_post_meta( $post->ID, 'search_product_tags', true ) );
$ap_checkbox             = get_post_meta( $post->ID, 'ap_checkbox', true );
$new_for_search_products = json_decode( get_post_meta( $post->ID, 'new_for_search_products', true ) );
$ka_specific_user        = json_decode( get_post_meta( $post->ID, 'ka_specific_user', true ) );

$cu_pr_ta_ma_images = get_post_meta( $post->ID, 'cu_pr_ta_ma_image_gallery_input', true );
$cu_pr_ta_ma_videos = get_post_meta( $post->ID, 'cu_pr_ta_ma_video_gallery_input', true );
$cu_pr_ta_ma_files  = get_post_meta( $post->ID, 'cu_pr_ta_ma_file_input', true );


$cu_pr_ta_ma_store_location              = get_post_meta( $post->ID, 'cu_pr_ta_ma_store_location', true );
$cu_pr_ta_ma_store_location_address_lat  = get_post_meta( $post->ID, 'cu_pr_ta_ma_store_location_address_lat', true );
$cu_pr_ta_ma_store_location_address_long = get_post_meta( $post->ID, 'cu_pr_ta_ma_store_location_address_long', true );

?>
<div>
	<table class="addify-table-option">
		<?php wp_nonce_field( 'cptm_nonce_action', 'cptm_field_nonce' ); ?>

		<tr class="addify-option-field">
			<th>
				<div class="option-head">
					<h3>
						<?php echo esc_html__( 'Enable Global Tab', 'addify_ptabs' ); ?>
					</h3>
				</div>
			</th>
			<td>
				<input type="checkbox" name="enablecheckbox" value="checkbox"
					<?php
					if ( 'checkbox' === get_post_meta( get_the_ID(), 'enablecheckbox', true ) ) {
						echo 'checked';
					}
					?>
				>
				<p><?php echo esc_html__( 'Enable this tab.', 'addify_ptabs' ); ?></p></td>
		</tr>

		<tr class="addify-option-field">
			<th>
				<div class="option-head">
					<h3>
						<?php echo esc_html__( 'Global Tab Title', 'addify_ptabs' ); ?>
					</h3>
				</div>
			</th>
			<td>
				<input type="text" name="tabetittle" id="tabetittle" placeholder=" title for tab"
						value="<?php echo esc_attr( $tabetittle ); ?>">
				<p><?php echo esc_html__( 'Enter title for tab.', 'addify_ptabs' ); ?>
			</td>
		</tr>
		<tr class="addify-option-field" name='treditor'>
			<th>
				<div class="option-head">
					<h3>
						<?php esc_html_e( 'Callback', 'addify_ptabs' ); ?>
				</div>
				</h3>
			</th>
			<td>
				<select name="tabcallback_select" id="tabcallback_select">
					<option value="editor" name='save_fe'
						<?php
						if ( 'editor' === $tabcallback_select ) {
							echo 'selected';
						}
						?>
					>
						<?php esc_html_e( 'Editor', 'addify_ptabs' ); ?>
					</option>
					<option value="form" name='save_fe'
						<?php
						if ( 'form' === $tabcallback_select ) {
							echo 'selected';
						}
						?>
					>
						<p><?php esc_html_e( 'Contact 7 form', 'addify_ptabs' ); ?></p>
					</option>
					<option value="image_gallery" name='save_fe'
						<?php
						if ( 'image_gallery' === $tabcallback_select ) {
							echo 'selected';
						}
						?>
					>
						<p><?php esc_html_e( 'Image Gallery', 'addify_ptabs' ); ?></p>
					</option>
					<option value="video_gallery" name='save_fe'
						<?php
						if ( 'video_gallery' === $tabcallback_select ) {
							echo 'selected';
						}
						?>
					>
						<p><?php esc_html_e( 'Video Gallery', 'addify_ptabs' ); ?></p>
					</option>
					<option value="download_files" name='save_fe'
						<?php
						if ( 'download_files' === $tabcallback_select ) {
							echo 'selected';
						}
						?>
					>
						<p><?php esc_html_e( 'Download Files', 'addify_ptabs' ); ?></p>
					</option>
					<option value="store_location" name='save_fe'
						<?php
						if ( 'store_location' === $tabcallback_select ) {
							echo 'selected';
						}
						?>
					>
						<p><?php esc_html_e( 'Store Location', 'addify_ptabs' ); ?></p>
					</option>
				</select>
			</td>
		</tr>
		<tr class="addify-option-field"
			<?php
			if ( 'form' !== $tabcallback_select ) {
				?>
				style="display: none;" <?php } ?>>
			<th>
				<div class="option-head">
					<h3>
						<?php esc_html_e( 'Contact 7 form', 'addify_ptabs' ); ?></h3>
				</div>
			</th>
			<td>
				<div class="form_hide">
					<?php
					$ka_cpt_editor_form        = get_post_meta( $post->ID, 'contact_7formm_select', true ); // example.
					$ka_cpt_contact_form_posts = get_posts(
						array(
							'post_type'   => 'wpcf7_contact_form',
							'numberposts' => - 1,
						)
					);
					if ( ! empty( $ka_cpt_contact_form_posts ) ) {
						?>
						<select name="contact_7formm_select">
							<?php
							foreach ( $ka_cpt_contact_form_posts as $p ) {
								echo '<option value="' . esc_html( $p->ID ) . '"' . selected( esc_html( $p->ID ), $ka_cpt_editor_form, false ) . '>' . esc_html( $p->post_title ) . ' (' . esc_html( $p->ID ) . ')</option>';
							}
							?>
						</select>
					<?php } else { ?>
						<p><?php esc_html_e( 'No contact 7 form found.', 'addify_ptabs' ); ?></p>
					<?php } ?>
				</div>
			</td>
		</tr>
		<tr class="addify-option-field" name='texteditor'
			<?php
			if ( 'editor' !== $tabcallback_select ) {
				?>
				style="display: none;" <?php } ?>>
			<th>
				<div class="option-head">
					<h3><?php esc_html_e( 'Editor Text', 'addify_ptabs' ); ?></h3>
				</div>
			</th>
			<td>
				<div class="editor_div">
					<?php
					$settings = array(
						'wpautop'             => true,
						// enable auto paragraph?.
						'media_buttons'       => true,
						// show media buttons?.
						'textarea_rows'       => 10,
						// This is equivalent to rows="" in HTML.
						'tabindex'            => '',
						'editor_css'          => '',
						// additional styles for Visual and Text editor.
						'editor_class'        => 'cu_pr_ma_tab_textarea',
						// sdditional classes to be added to the editor.
						'teeny'               => true,
						// show minimal editor.
						'dfw'                 => false,
						'_content_editor_dfw' => false,
						// 'tinymce'             => true,
						// 'quicktags'           => true, // replace the default fullscreen with DFW.
						'tinymce'             => array(
							// Items for the Visual Tab.
							'toolbar1' => 'formatselect,bold,italic,underline,separator,alignleft,aligncenter,alignright,separator,bullist,numlist,link,unlink,forecolor,undo,redo',
							'toolbar2' => '',
							'toolbar3' => '',
						),
						'quicktags'           => array(
							// Items for the Text Tab.
							'buttons' => 'strong,em,underline,ul,ol,li,link,code',
						),
					);
					wp_editor( $ka_cpt_editor_content, 'cpt_tab_content', $settings );
					?>
					<div class="cu_pr_ta_ma_tab_shortcode">

					<p>          {product_id},
								{product_name}, </p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">
								{product_slug},
								{product_status},
								{product_featured},
								{product_catalog_visibility},</p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">
								{product_description},
								{product_short_description},
								{product_sku},
								{product_menu_order},
							</p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">     {product_virtual},
								{product_permalink},
								{product_price},
								{product_regular_price},
							</p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">     {product_sale_price},
								{product_total_sales},
								{product_tax_status},
								{product_tax_class},
							</p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">     {product_stock_status},
								{product_sold_individually},
								{product_purchase_note},
								{product_weight},
							</p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">     {product_length},
								{product_width},
								{product_height},
								{product_download_expiry},
							</p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">     {product_download_limit},
								{product_image},
								{product_reviews_allowed},
								{product_reviews_count},
							</p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">     {product_rating_count},
								{product_average_rating},
								{product_category},
								{product_tags}</p>
						<p class="cu_pr_ta_ma_tab_shortcode_hide_content">
								{product_excerpt}
						{product_date_created}
								{product_date_modified},</p>
						<p>
							<button type="button"  class="cu_pr_ta_ma_tab_shortcode_show_content_button"><?php echo esc_html__( 'View All Shortcodes', 'addify_ptabs' ); ?></button>
						</p>
					</div>
				</div>
			</td>
		</tr>
		<tr class="addify-option-field cu_pr_ta_ma_tab_types cu_pr_ta_ma_image_gallery"
			<?php
			if ( 'image_gallery' !== $tabcallback_select ) {
				?>
				style="display: none;" <?php } ?> >
			<th>
				<div class="option-head">
					<h3><?php esc_html_e( 'Image Gallery', 'addify_ptabs' ); ?></h3>
				</div>
			</th>
			<td>
				<div class="cu_pr_ta_ma_meta-image-field-wrapper">
					<div class="cu_pr_ta_ma_image-preview cu_pr_ta_ma_gallery-preview">
						<?php
						if ( ! empty( $cu_pr_ta_ma_images ) ) {
							foreach ( (array) $cu_pr_ta_ma_images as $cu_pr_ta_ma_image ) {
								?>
								<div class="cu_pr_ta_ma_single">
									<span class="cu_pr_ta_ma_remove_span cu_pr_ta_ma_img_remove_button cu_pr_ta_ma_button-danger button button-small">X</span>
									<img src="<?php echo esc_url( wp_get_attachment_thumb_url( $cu_pr_ta_ma_image ) ); ?>"
										alt="image">
									<input type="hidden" name="cu_pr_ta_ma_image_gallery_input[]"
											class="cu_pr_ta_ma_image_input"
											value="<?php echo esc_attr( $cu_pr_ta_ma_image ); ?>">
								</div>
								<?php
							}
						}
						?>
					</div>
					<div class="cu_pr_ta_ma_button-wrapper">
						<button type="button"
								class="cu_pr_ta_ma_upload_button cu_pr_ta_ma_img_upload_button button button-primary button-small"
								value="image"><?php esc_html_e( 'Upload / Add images', 'addify_ptabs' ); ?></button>
						<?php if ( ! empty( $cu_pr_ta_ma_images ) ) { ?>
							<button type="button"
									class="cu_pr_ta_ma_remove-all-button cu_pr_ta_ma_button-danger button button-small"
									style="">Remove All
							</button>
						<?php } ?>
					</div>
				</div>
			</td>
		</tr>
		<tr class="addify-option-field cu_pr_ta_ma_tab_types cu_pr_ta_ma_video_gallery"
			<?php
			if ( 'video_gallery' !== $tabcallback_select ) {
				?>
				style="display: none;" <?php } ?> >
			<th>
				<div class="option-head">
					<h3><?php esc_html_e( 'Video Gallery', 'addify_ptabs' ); ?></h3>
				</div>
			</th>
			<td>
				<div class="cu_pr_ta_ma_meta-video-field-wrapper">
					<div class="cu_pr_ta_ma_video-preview cu_pr_ta_ma_gallery-preview">
						<?php
						if ( ! empty( $cu_pr_ta_ma_videos ) ) {
							foreach ( (array) $cu_pr_ta_ma_videos as $cu_pr_ta_ma_video ) {
								?>
								<div class="cu_pr_ta_ma_single">
									<span class="cu_pr_ta_ma_remove_span  cu_pr_ta_ma_button-danger button button-small">X</span>
									<video src="<?php echo esc_url( wp_get_attachment_url( $cu_pr_ta_ma_video ) ); ?> "
											controls="controls"></video>
									<input type="hidden" name="cu_pr_ta_ma_video_gallery_input[]"
											class="cu_pr_ta_ma_video_input"
											value="<?php echo esc_attr( $cu_pr_ta_ma_video ); ?>">
								</div>
								<?php
							}
						}
						?>
					</div>
					<div class="cu_pr_ta_ma_button-wrapper">
						<button type="button"
								class="cu_pr_ta_ma_upload_button cu_pr_ta_ma_video_upload_button button button-primary button-small"
								value="video"><?php esc_html_e( 'Upload / Add Video', 'addify_ptabs' ); ?></button>
						<?php if ( ! empty( $cu_pr_ta_ma_videos ) ) { ?>
							<button type="button"
									class="cu_pr_ta_ma_remove-all-button cu_pr_ta_ma_button-danger button button-small"
									style="">Remove All
							</button>
						<?php } ?>
					</div>
				</div>
			</td>
		</tr>
		<tr class="addify-option-field cu_pr_ta_ma_tab_types cu_pr_ta_ma_store_location"
			<?php
			if ( 'store_location' !== $tabcallback_select ) {
				?>
				style="display: none;" <?php } ?> >
			<th>
				<div class="option-head">
					<h3><?php esc_html_e( 'Store Location', 'addify_ptabs' ); ?></h3>
				</div>
			</th>
			<td>
				<div class="cu_pr_ta_ma_meta-location-field-wrapper">
					<div class="cu_pr_ta_ma_store-location-preview">
						<div class="cu_pr_ta_ma_single_location">
							<div class="cu_pr_ta_ma_location_address">
								<label for="cu_pr_ta_ma_location_input">Address</label>
								<textarea rows="10" cols="50" name="cu_pr_ta_ma_store_location"
											id="cu_pr_ta_ma_location_input"
											class="cu_pr_ta_ma_location_input"><?php echo esc_attr( $cu_pr_ta_ma_store_location ); ?></textarea>
							</div>
							<div class="cu_pr_ta_ma_location_address_lat_long">
								<div class="cu_pr_ta_ma_location_address_lat">
									<label for="cu_pr_ta_ma_location_address_lat">Latitude</label>
									<input type="text" name="cu_pr_ta_ma_store_location_address_lat"
											id="cu_pr_ta_ma_location_address_lat"
											class="cu_pr_ta_ma_location_address_lat"
											value="<?php echo esc_attr( $cu_pr_ta_ma_store_location_address_lat ); ?>">
								</div>
								<div class="cu_pr_ta_ma_location_address_long">
									<label for="cu_pr_ta_ma_location_long">Longitude</label>
									<input type="text" name="cu_pr_ta_ma_store_location_address_long"
											id="cu_pr_ta_ma_location_address_long"
											class="cu_pr_ta_ma_location_address_long"
											value="<?php echo esc_attr( $cu_pr_ta_ma_store_location_address_long ); ?>">
								</div>
							</div>

						</div>
					</div>
				</div>
			</td>
		</tr>
		<tr class="addify-option-field cu_pr_ta_ma_tab_types cu_pr_ta_ma_download_files"
			<?php
			if ( 'download_files' !== $tabcallback_select ) {
				?>
				style="display: none;" <?php } ?> >
			<th>
				<div class="option-head">
					<h3><?php esc_html_e( 'Downloadable Files', 'addify_ptabs' ); ?></h3>
				</div>
			</th>
			<td>
				<div class="cu_pr_ta_ma_meta-download-files-field-wrapper cu_pr_ta_ma_meta_tab_type">
					<div class="cu_pr_ta_ma_file-preview">
						<?php
						if ( ! empty( $cu_pr_ta_ma_files ) ) {
							foreach ( (array) $cu_pr_ta_ma_files as $cu_pr_ta_ma_file ) {
								$attachment_metadata = wp_get_attachment_metadata( $cu_pr_ta_ma_file );
								if ( $attachment_metadata ) {
									$file_url   = wp_get_attachment_url( $cu_pr_ta_ma_file );
									$file_size  = filesize( get_attached_file( $cu_pr_ta_ma_file ) );
									$mime_type  = get_post_mime_type( $cu_pr_ta_ma_file );
									$file_title = get_the_title( $cu_pr_ta_ma_file );
									?>
									<div class="cu_pr_ta_ma_single">
										<p><?php echo esc_attr( $file_title . ' (' . $mime_type . ') size: ' . number_format( $file_size / 1024, 2 ) . ' KB' ); ?> </p>
										<div class="cu_pr_ta_ma_download_file">
											<button type="button"
													class="cu_pr_ta_ma_remove_span cu_pr_ta_ma_button-danger button button-small">
												X
											</button>
											<button type="button" class="button button-small"
													href="<?php echo esc_url( $file_url ); ?>" download><i
														class="fa fa-download"></i></button>
										</div>
										<input type="hidden" name="cu_pr_ta_ma_file_input[]"
											class="cu_pr_ta_ma_file_input"
											value="<?php echo esc_attr( $cu_pr_ta_ma_file ); ?>">
									</div>
									
									<?php
								} elseif ( ! empty( $cu_pr_ta_ma_file ) ) {
									?>
									<div class="cu_pr_ta_ma_single cu_pr_ta_ma_error error-message ">
										<?php echo esc_html__( 'The file has been removed or does not exist in system', 'addify_ptabs' ); ?>
										<input type="hidden" name="cu_pr_ta_ma_file_input[]"
												class="cu_pr_ta_ma_file_input"
												value="<?php echo esc_attr( $cu_pr_ta_ma_file ); ?>">
									</div>
									<?php
								}
							}
						}
						?>
					</div>
					<div class="cu_pr_ta_ma_button-wrapper">
						<button type="button"
								class="cu_pr_ta_ma_upload_button button button-primary button-small"
								value="file"><?php esc_html_e( 'Upload / Add File', 'addify_ptabs' ); ?></button>
						<?php if ( ! empty( $cu_pr_ta_ma_files ) ) { ?>
							<button type="button"
									class="cu_pr_ta_ma_remove-all-button cu_pr_ta_ma_button-danger button button-small"
									style="">Remove All
							</button>
						<?php } ?>
					</div>
				</div>
			</td>
		</tr>
		<tr class="addify-option-field">
			<th>
				<div class="option-head">
					<h3>
						<?php esc_html_e( 'Search Specific User', 'addify_ptabs' ); ?>
					</h3>
				</div>
			</th>
			<td>
				<select class="ka_specific_user" name="ka_specific_user[]" id="specific" multiple style="width: 90%; ">
					<?php
					foreach ( (array) $ka_specific_user as $search_sus ) {
						$ka_sus_user = get_user_by( 'id', $search_sus );
						if ( ! is_object( $ka_sus_user ) ) {
							continue;
						}
						?>
						<option value="<?php echo intval( $search_sus ); ?>"
								selected="selected"><?php echo esc_attr( $ka_sus_user->user_email ); ?> )
						</option>
						<?php
					}
					?>
				</select>
				<p><?php echo esc_html__( 'Enter specific user.', 'addify_ptabs' ); ?></p>
			</td>
		</tr>
		<tr class="addify-option-field">
			<th>
				<div class="option-head">
					<h3><?php esc_html_e( 'User Roles', 'addify_ptabs' ); ?></h3>
				</div>
			</th>
			<td>
				<select name="enable_all_user_roles[]" class="cu_pr_ta_all_user_select_input" multiple>
					<?php
					global $wp_roles;
					$roles = $wp_roles->get_names();
					foreach ( $roles as $key => $newuserrole ) {
						$is_selected = in_array( (string) $key, (array) $enable_all_user_roles, true ) ? 'selected' : '';
						echo '<option value="' . esc_attr( $key ) . '" ' . esc_attr( $is_selected ) . '>' . esc_attr( $newuserrole ) . '</option>';
					}
					?>
					<option value="guest"
						<?php
						if ( in_array( (string) 'guest', (array) $enable_all_user_roles, true ) ) {
							echo 'selected';
						}
						?>
					>Guest Users
					</option>
				</select>
				<p><?php echo esc_html__( 'Select the user roles associated with this tab.', 'addify_ptabs' ); ?></p>
				<br><br>
			</td>
		</tr>
		<tr class="addify-option-field">
			<th>
				<div class="option-head">
					<h3>
						<?php esc_html_e( 'All Products', 'addify_ptabs' ); ?>
					</h3>
				</div>
			</th>
			<td>
				<input type="checkbox" name="ap_checkbox" value="yes" id="ap_checkbox"
					<?php
					if ( 'yes' === get_post_meta( get_the_ID(), 'ap_checkbox', true ) ) {
						echo 'checked';
					}
					?>
				>
				<p><?php echo esc_html__( 'Enable this for all products.', 'addify_ptabs' ); ?></p>
			</td>
		</tr>
		<tr class="addify-option-field">
			<th>
				<div class="option-head">
					<h3>
						<?php esc_html_e( ' Products', 'addify_ptabs' ); ?>
					</h3>
				</div>
			</th>
			<div class="cpt_div">
				<td class="ka_style_field1">
					<select class="new_for_search_products" id="new_for_search_products"
							name="new_for_search_products[]" multiple
							style="width: 90%;">
						<?php
						foreach ( (array) $new_for_search_products as $search_product ) {
							$product = wc_get_product( $search_product );
							if ( $product ) {
								?>
								<option value="<?php echo esc_attr( $search_product ); ?>"
										selected><?php echo esc_attr( $product->get_name() ); ?></option>
								<?php
							}
						}
						?>
					</select>
					<p><?php echo esc_html__( 'Enter specific product.', 'addify_ptabs' ); ?></p>
				</td>
			</div>
		</tr>
		<tr class="addify-option-field">
			<th>
				<div class="option-head">
					<h3>
						<?php esc_html_e( 'Product Category', 'addify_ptabs' ); ?>
					</h3></div>
			</th>
			<div class="cpt_div_cat">
				<td class="ka_style_field2">
					<?php

					$product_tabs_category = get_terms( 'product_cat' );
					global $post;
					$selected_categories = json_decode( get_post_meta( $post->ID, 'product_tabs_category', true ) );
					$selected_categories = is_array( $selected_categories ) ? $selected_categories : array();
					?>
					<select name="product_tabs_category[]" id="product_tabs_category"
							data-placeholder="Choose Categories..." class="product_tabs_category" multiple="multiple"
							tabindex="-1" style="width: 90%;">;
						<?php
						foreach ( $product_tabs_category as $search_catogery ) {
							?>
							<option value="<?php echo esc_html( $search_catogery->term_id ); ?>"
								<?php
								if ( in_array( (string) $search_catogery->term_id, (array) $selected_categories, true ) ) {
									echo 'selected';
								}
								?>
							><?php echo esc_html( $search_catogery->name ); ?>
							</option>
							<?php
						}
						?>
					</select>
					<p><?php echo esc_html__( 'Enter specific catogeries.', 'addify_ptabs' ); ?></p>
				</td>
			</div>
		</tr>
		<tr class="addify-option-field">
			<th>
				<div class="option-head">
					<h3>
						<?php esc_html_e( 'Product Tags', 'addify_ptabs' ); ?>
					</h3></div>
			</th>
			<div class="cpt_div_tag">
				<td>
					<?php
					$search_product_tags = get_terms( array( 'taxonomy' => 'product_tag' ) );
					$selected_tags       = json_decode( get_post_meta( $post->ID, 'search_product_tags', true ) );
					$selected_tags       = is_array( $selected_tags ) ? $selected_tags : array();
					?>
					<select name="search_product_tags[]" id="product_by_tag" data-placeholder="Choose Tags..."
							class="search_product_tags" multiple="multiple" tabindex="-1" style="width: 90%;">;
						<?php
						global $post;
						foreach ( $search_product_tags as $product_tag ) {
							?>
							<option value="<?php echo esc_html( $product_tag->term_id ); ?>"
								<?php
								if ( in_array( (string) $product_tag->term_id, (array) $selected_tags, true ) ) {
									echo 'selected';
								}
								?>
							>
								<?php echo esc_attr( $product_tag->name ); ?>
							</option>
						<?php } ?>
					</select>
					<p><?php echo esc_html__( 'Enter specific tags.', 'addify_ptabs' ); ?></p>
				</td>
			</div>
		</tr>
	</table>
</div>
