<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CU_PR_TA_MA_Admin {


	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'cu_pr_ta_ma_style_script_function' ) );

		add_action( 'save_post_product_tab', array( $this, 'save_post_cu_pr_ta_ma_function' ) );

		add_filter( 'post_row_actions', array( $this, 'cu_pr_ta_ma_post_row_actions' ), 10, 1 );

		add_filter( 'post_updated_messages', array( $this, 'cu_pr_ta_ma_custom_post_updated_messages' ) );

		add_action( 'add_meta_boxes', array( $this, 'cu_pr_ta_ma_custom_metabox' ) );
		add_action( 'admin_head', array( $this, 'custom_admin_post_css' ) );

		add_filter( 'woocommerce_settings_tabs_array', array( $this, 'cptmrl_add_settings_tab' ), 50 );
		add_action( 'woocommerce_sections_cptmrl', array( $this, 'cptmrl_get_sections' ) );
		add_action( 'woocommerce_settings_cptmrl', array( $this, 'cptmrl_settings_tab' ) );
		add_action( 'woocommerce_settings_save_cptmrl', array( $this, 'cptmrl_update_settings' ) );

		add_action( 'save_post_product', array( $this, 'adf_update_psorttabs_data' ) );
		add_action( 'save_post_product', array( $this, 'adf_update_pruletabs_data' ) );

		add_filter( 'woocommerce_product_data_tabs', array( $this, 'create_cptm_tab' ) );
		add_filter( 'woocommerce_product_data_panels', array( $this, 'display_cptm_tabs_setting' ), 98 );
	}//end __construct()





	public function cu_pr_ta_ma_style_script_function() {
		wp_enqueue_style( 'cu_pr_ta_ma_', CU_PR_TA_MA_URL . '/assets/css/cu-pr-ta-ma-admin-style.css', false, '1.0.0' );
	wp_enqueue_style(
		'cu_pr_ta_ma_font-awesome',
		'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css', // Replace with the latest stable version
		false,
		'6.5.0' // Specify version here
	);


		//wp_enqueue_style( 'cu_pr_ta_ma_font-awesome', '//cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), '1.0.0' );
	}

	public function cu_pr_ta_ma_custom_metabox() {

		add_meta_box(
			'tabs_setting',
			esc_html__( 'Global Product Tab', 'addify_ptabs' ),
			array( $this, 'cu_pr_ta_ma_metabox' ),
			'product_tab',
			'advanced',
			'default',
			array( 'type' => 'cu-pr-ta-ma-meta-box' )
		);
		add_meta_box(
			'styling',
			esc_html__( 'Styling of Global Tab', 'addify_ptabs' ),
			array( $this, 'cu_pr_ta_ma_metabox_styling' ),
			'product_tab',
			'advanced',
			'default',
			array( 'type' => 'cu-pr-ta-ma-tab-styling-meta-box' )
		);
	}

	public function cu_pr_ta_ma_metabox( $post, $metabox ) {
		
		include_once CU_PR_TA_MA_PLUGIN_DIR . '/include/admin/metabox/cu-pr-ta-ma-meta-box.php';
	}

	public function cu_pr_ta_ma_metabox_styling( $post, $metabox ) {
		include_once CU_PR_TA_MA_PLUGIN_DIR . '/include/admin/metabox/cu-pr-ta-ma-tab-styling-meta-box.php';
	}

	public function cu_pr_ta_ma_post_row_actions( $actions ) {
		global $post;

		if ( 'product_tab' === $post->post_type ) {
			unset( $actions['view'], $actions['inline hide-if-no-js'] );
		}
		return $actions;
	}
	public function cu_pr_ta_ma_custom_post_updated_messages( $messages ) {
		global $post;
		if ( 'product_tab' === $post->post_type ) {
			$messages['post'][1] = 'Post Updated';
		}
		return $messages;
	}

	/**
	 *  Custom_admin_post_css function start.
	 */
	public function custom_admin_post_css() {

		global $post_type;

		if ( 'product_tab' === $post_type ) {
			echo '<style>#edit-slug-box {display:none;}</style>';
			echo '<style>#preview-action {display:none;}</style>';
			echo '<style>#visibility {display:none;}</style>';
			?>
			<script>
				jQuery(document).ready(function ($) {
					$(document).on('click','#publish',function (e){
						var tab_type=$('#tabcallback_select').val();
						var tab_style= $('.cu_pr_ta_ma_'+tab_type);


						if($("#tabetittle").val() ===''){
							$("#tabetittle").focus();
							alert("Please enter title for this post");
							return false;
						}

						if(tab_style){
							if (!$(tab_style).find('.cu_pr_ta_ma_single').length && ( tab_type === 'image_gallery' || tab_type === 'video_gallery' || tab_type === 'download_files')) {
								var $upload_type = '';
								if ($('#tabcallback_select').val() === 'image_gallery') {
									$upload_type = 'image';
								} else if ($('#tabcallback_select').val() === 'video_gallery') {
									$upload_type = 'video';
								} else if ($('#tabcallback_select').val() === 'download_files') {
									$upload_type = 'file';
								}
								e.preventDefault();
								alert("Please Upload " + $upload_type + "/" + $upload_type + "s for this post");
								$('div.cu_pr_ta_ma_meta-' + $upload_type + '-field-wrapper').closest('tr').focus();
								return false;
							}
							if(tab_style==='store_location'){
								if($('textarea.cu_pr_ta_ma_store_location')==='' || $('input.cu_pr_ta_ma_store_location_address_lat')==='' || $('input.cu_pr_ta_ma_store_location_address_long')==='' ){
									alert("Please add all location details for this post");
									$('div.cu_pr_ta_ma_meta-location-field-wrapper').closest('tr').focus();
									return false;
								}
							}


						}
						if(!$("#ap_checkbox").prop('checked')){
							if(!($("#new_for_search_products").val().length || $("#product_tabs_category").val().length || $("#product_by_tag").val().length)){
								alert("Please Select one option from products for this post");
								return false;
							}
						}



					});
				});
			</script>

			<?php
		}
	}

	public function display_cptm_tabs_setting() {
		?>
		<div id="addify_cptm_pannel_tabs" class="panel woocommerce_options_panel ">
			<?php
			include CU_PR_TA_MA_PLUGIN_DIR . '/template/cptm-product-level-tabs-setting.php';
			?>
		</div>
		<div id="addify_cptm_pannel_tabs_sort" class="panel woocommerce_options_panel ">
			<?php
			wp_nonce_field( 'cptm_nonce_action', 'cptm_nonce_field' );

			include CU_PR_TA_MA_PLUGIN_DIR . '/template/cptm-save-product-level-data.php';
			?>
		</div>
		<?php
	}
	public function create_cptm_tab( $tabs ) {
		$tabs['addify_cptm_tab'] = array(
			'label'    => esc_html__( 'Custom Tabs', 'addify_ptabs' ), // The name of your panel.
			'target'   => 'addify_cptm_pannel_tabs', // Will be used to create an anchor link so needs to be unique.
			'class'    => array(), // Class for your panel tab - helps hide/show depending on product type.
			'priority' => 90, // Where your panel will appear. By default, 70 is last item.
			// 'callback'   => 'display_cptm_tabs_setting'
		);

		$tabs['addify_cptm_tab_sort'] = array(
			'label'    => esc_html__( 'Tabs Sorting ', 'addify_ptabs' ), // The name of your panel.
			'target'   => 'addify_cptm_pannel_tabs_sort', // Will be used to create an anchor link so needs to be unique.
			'class'    => array(), // Class for your panel tab - helps hide/show depending on product type.
			'priority' => 100, // Where your panel will appear. By default, 70 is last item.
			// 'callback'   => 'display_cptm_tabs_setting_sorting'
		);
		return $tabs;
	}


	public function adf_update_pruletabs_data( $post_id ) {

		if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
			|| ! current_user_can( 'edit_posts' )
			|| in_array( get_post_status( $post_id ), array( 'auto-draft', 'trash' ), true )
			|| is_ajax()
			|| 'untrash' === ( isset( $_GET['action'] ) ? sanitize_text_field( wp_unslash( $_GET['action'] ) ) : '' )
		) {
			return;
		}

		if (isset( $_POST['cptm_field_nonce'] )) {
			$retrieved_nonce = isset( $_POST['cptm_field_nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['cptm_field_nonce'] ) ) : '';

			if ( ! wp_verify_nonce( $retrieved_nonce, 'cptm_nonce_action' ) ) {
				die( 'Failed Security' );
			}
		}
			$data = new WP_Query(
				array(
					'post_type'   => 'cptm_level_tab',
					'post_parent' => $post_id,
					'fields'      => 'ids',
					'numberposts' => -1,
				)
			);

		if ( $data->have_posts() ) {

			foreach ( $data->posts as $current_post_id ) {

				$checkbox = isset( $_POST['enablecheckbox'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['enablecheckbox'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'enablecheckbox', $checkbox );

				$tabetittle = isset( $_POST['tabetittle'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['tabetittle'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'tabetittle', $tabetittle );

				$product_enable_user_rule = isset( $_POST['product_enable_user_rule'][ $current_post_id ] ) ? sanitize_meta( '', wp_unslash( $_POST['product_enable_user_rule'][ $current_post_id ] ), '' ) : array();

				update_post_meta( $current_post_id, 'product_enable_user_rule', $product_enable_user_rule );

				$p_tabcallback_select = isset( $_POST['p_tabcallback_select'][ $current_post_id ] ) ? sanitize_meta( '', wp_unslash( $_POST['p_tabcallback_select'][ $current_post_id ] ), '' ) : array();

				update_post_meta( $current_post_id, 'p_tabcallback_select', $p_tabcallback_select );

				$p_specific_user = isset( $_POST['p_specific_user'][ $current_post_id ] ) ? sanitize_meta( '', wp_unslash( $_POST['p_specific_user'][ $current_post_id ] ), '' ) : array();
				update_post_meta( $current_post_id, 'p_specific_user', $p_specific_user );

				$p_contact_7formm_select = isset( $_POST['p_contact_7formm_select'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['p_contact_7formm_select'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'p_contact_7formm_select', $p_contact_7formm_select );

				$p_cpt_tab_content = isset( $_POST[ 'p_cpt_tab_content' . $current_post_id ] ) ? sanitize_meta( '', wp_unslash( $_POST[ 'p_cpt_tab_content' . $current_post_id ] ), '' ) : '';

				update_post_meta( $current_post_id, 'p_cpt_tab_content' . $current_post_id, $p_cpt_tab_content );

				$pcheckbox = isset( $_POST['pcheckbox'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['pcheckbox'][ $current_post_id ] ) ) : '';

				update_post_meta( $current_post_id, 'pcheckbox', $pcheckbox );

				$adf_p_background_img_field = isset( $_POST['adf_p_background_img_field'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['adf_p_background_img_field'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'adf_p_background_img_field', $adf_p_background_img_field );

				$adf_p_enable_global_icon_field = isset( $_POST['adf_p_enable_global_icon_field'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['adf_p_enable_global_icon_field'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'adf_p_enable_global_icon_field', $adf_p_enable_global_icon_field );

				$pnewcolor = isset( $_POST['pnewcolor'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['pnewcolor'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'pnewcolor', $pnewcolor );

				$cu_pr_ta_ma_images = isset( $_POST['cu_pr_ta_ma_image_gallery_input'][ $current_post_id ] ) ? sanitize_meta( '', wp_unslash( $_POST['cu_pr_ta_ma_image_gallery_input'][ $current_post_id ] ), '' ) : array();
				update_post_meta( $current_post_id, 'cu_pr_ta_ma_image_gallery_input', $cu_pr_ta_ma_images );

				$cu_pr_ta_ma_videos = isset( $_POST['cu_pr_ta_ma_video_gallery_input'][ $current_post_id ] ) ? sanitize_meta( '', wp_unslash( $_POST['cu_pr_ta_ma_video_gallery_input'][ $current_post_id ] ), '' ) : array();
				update_post_meta( $current_post_id, 'cu_pr_ta_ma_video_gallery_input', $cu_pr_ta_ma_videos );

				$cu_pr_ta_ma_files = isset( $_POST['cu_pr_ta_ma_file_input'][ $current_post_id ] ) ? sanitize_meta( '', wp_unslash( $_POST['cu_pr_ta_ma_file_input'][ $current_post_id ] ), '' ) : array();
				update_post_meta( $current_post_id, 'cu_pr_ta_ma_file_input', $cu_pr_ta_ma_files );

				$cu_pr_ta_ma_store_location = isset( $_POST['cu_pr_ta_ma_store_location'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['cu_pr_ta_ma_store_location'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'cu_pr_ta_ma_store_location', $cu_pr_ta_ma_store_location );

				$cu_pr_ta_ma_store_location_address_lat = isset( $_POST['cu_pr_ta_ma_store_location_address_lat'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['cu_pr_ta_ma_store_location_address_lat'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'cu_pr_ta_ma_store_location_address_lat', $cu_pr_ta_ma_store_location_address_lat );

				$cu_pr_ta_ma_store_location_address_long = isset( $_POST['cu_pr_ta_ma_store_location_address_long'][ $current_post_id ] ) ? sanitize_text_field( wp_unslash( $_POST['cu_pr_ta_ma_store_location_address_long'][ $current_post_id ] ) ) : '';
				update_post_meta( $current_post_id, 'cu_pr_ta_ma_store_location_address_long', $cu_pr_ta_ma_store_location_address_long );

			}
		}
	}
	public function adf_update_psorttabs_data( $post_id ) {

		// Tabs sorting product level.

		if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
			|| ! current_user_can( 'edit_posts' )
			|| in_array( get_post_status( $post_id ), array( 'auto-draft', 'trash' ), true )
			|| is_ajax()
			|| 'untrash' === ( isset( $_GET['action'] ) ? sanitize_text_field( wp_unslash( $_GET['action'] ) ) : '' )
		) {
			return;
		}
		if (isset( $_POST['cptm_field_nonce'] )) {
			$retrieved_nonce = isset( $_POST['cptm_field_nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['cptm_field_nonce'] ) ) : '';

			if ( ! wp_verify_nonce( $retrieved_nonce, 'cptm_nonce_action' ) ) {
				die( 'Failed Security' );
			}
		}

			$checkbox_tabs_enable_description = isset( $_POST['checkbox_tabs_enable_description'] ) ? sanitize_text_field( wp_unslash( $_POST['checkbox_tabs_enable_description'] ) ) : '';

			update_post_meta( $post_id, 'checkbox_tabs_enable_description', $checkbox_tabs_enable_description );

			$checkbox_enable_review_field = isset( $_POST['checkbox_enable_review_field'] ) ? sanitize_text_field( wp_unslash( $_POST['checkbox_enable_review_field'] ) ) : '';

			update_post_meta( $post_id, 'checkbox_enable_review_field', $checkbox_enable_review_field );

			$checkbox_additional_information_field = isset( $_POST['checkbox_additional_information_field'] ) ? sanitize_text_field( wp_unslash( $_POST['checkbox_additional_information_field'] ) ) : '';

			update_post_meta( $post_id, 'checkbox_additional_information_field', $checkbox_additional_information_field );

			$adf_p_tabs_rename_description_field = isset( $_POST['adf_p_tabs_rename_description_field'] ) ? sanitize_text_field( wp_unslash( $_POST['adf_p_tabs_rename_description_field'] ) ) : '';
			update_post_meta( $post_id, 'adf_p_tabs_rename_description_field', $adf_p_tabs_rename_description_field );

			$adf_p_tabs_rename_review_field = isset( $_POST['adf_p_tabs_rename_review_field'] ) ? sanitize_text_field( wp_unslash( $_POST['adf_p_tabs_rename_review_field'] ) ) : '';
			update_post_meta( $post_id, 'adf_p_tabs_rename_review_field', $adf_p_tabs_rename_review_field );

			$adfp_tabs_rename_additional_information_field = isset( $_POST['adfp_tabs_rename_additional_information_field'] ) ? sanitize_text_field( wp_unslash( $_POST['adfp_tabs_rename_additional_information_field'] ) ) : '';
			update_post_meta( $post_id, 'adfp_tabs_rename_additional_information_field', $adfp_tabs_rename_additional_information_field );

			$p_cpt_sortable = isset( $_POST['p_cpt_sortable'] ) ? sanitize_meta( '', wp_unslash( $_POST['p_cpt_sortable'] ), '' ) : array();
			update_post_meta( $post_id, 'p_cpt_sortable', $p_cpt_sortable );

			$checkbox_all_tabs_sort = isset( $_POST['checkbox_all_tabs_sort'] ) ? sanitize_text_field( wp_unslash( $_POST['checkbox_all_tabs_sort'] ) ) : '';
			update_post_meta( $post_id, 'checkbox_all_tabs_sort', $checkbox_all_tabs_sort );

			$checkbox_enable_default_tabs = isset( $_POST['checkbox_enable_default_tabs'] ) ? sanitize_text_field( wp_unslash( $_POST['checkbox_enable_default_tabs'] ) ) : '';
			update_post_meta( $post_id, 'checkbox_enable_default_tabs', $checkbox_enable_default_tabs );

			$disable_global_tabs = isset( $_POST['disable_global_tabs'] ) ? sanitize_text_field( wp_unslash( $_POST['disable_global_tabs'] ) ) : '';
			update_post_meta( $post_id, 'disable_global_tabs', $disable_global_tabs );
	}



	public function save_post_cu_pr_ta_ma_function( $post_id ) {

		if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
			|| ! current_user_can( 'edit_posts' )
			|| in_array( get_post_status( $post_id ), array( 'auto-draft', 'trash' ), true )
			|| is_ajax()
			|| 'untrash' === ( isset( $_GET['action'] ) ? sanitize_text_field( wp_unslash( $_GET['action'] ) ) : '' )
		) {
			return;
		}
		$retrieved_nonce = ! empty( $_POST['cptm_field_nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['cptm_field_nonce'] ) ) : '';

		if ( ! wp_verify_nonce( $retrieved_nonce, 'cptm_nonce_action' ) ) {
			die( 'Failed Security Check!' );
		}

		$enablecheckbox = isset( $_POST['enablecheckbox'] ) ? sanitize_meta( '', wp_unslash( $_POST['enablecheckbox'] ), '' ) : '';
		update_post_meta( $post_id, 'enablecheckbox', $enablecheckbox );

		$tabetittle = isset( $_POST['tabetittle'] ) ? sanitize_meta( '', wp_unslash( $_POST['tabetittle'] ), '' ) : '';
		update_post_meta( $post_id, 'tabetittle', $tabetittle );

		$tabcallback_select = isset( $_POST['tabcallback_select'] ) ? sanitize_text_field( wp_unslash( $_POST['tabcallback_select'] ) ) : '';
		update_post_meta( $post_id, 'tabcallback_select', $tabcallback_select );

		$cpt_tab_content = isset( $_POST['cpt_tab_content'] ) ? sanitize_meta( '', wp_unslash( $_POST['cpt_tab_content'] ), '' ) : '';
		update_post_meta( $post_id, 'cpt_tab_content', $cpt_tab_content );

		$contact_7formm_select = isset( $_POST['contact_7formm_select'] ) ? sanitize_text_field( wp_unslash( $_POST['contact_7formm_select'] ) ) : '';
		update_post_meta( $post_id, 'contact_7formm_select', $contact_7formm_select );

		$ka_specific_user = isset( $_POST['ka_specific_user'] ) ? sanitize_meta( '', wp_unslash( $_POST['ka_specific_user'] ), '' ) : '';
		update_post_meta( $post_id, 'ka_specific_user', wp_json_encode( $ka_specific_user ? $ka_specific_user : array() ) );

		$enable_all_user_roles = isset( $_POST['enable_all_user_roles'] ) ? sanitize_meta( '', wp_unslash( $_POST['enable_all_user_roles'] ), '' ) : '';
		update_post_meta( $post_id, 'enable_all_user_roles', $enable_all_user_roles );

		$ap_checkbox = isset( $_POST['ap_checkbox'] ) ? sanitize_meta( '', wp_unslash( $_POST['ap_checkbox'] ), '' ) : '';
		update_post_meta( $post_id, 'ap_checkbox', $ap_checkbox );

		$new_for_search_products = isset( $_POST['new_for_search_products'] ) ? sanitize_meta( '', wp_unslash( $_POST['new_for_search_products'] ), '' ) : '';
		update_post_meta( $post_id, 'new_for_search_products', wp_json_encode( $new_for_search_products ? $new_for_search_products : array() ) );

		$product_tabs_category = isset( $_POST['product_tabs_category'] ) ? sanitize_meta( '', wp_unslash( $_POST['product_tabs_category'] ), '' ) : '';
		update_post_meta( $post_id, 'product_tabs_category', wp_json_encode( $product_tabs_category ? $product_tabs_category : array() ) );

		$search_product_tags_meta = isset( $_POST['search_product_tags'] ) ? sanitize_meta( '', wp_unslash( $_POST['search_product_tags'] ), '' ) : '';
		update_post_meta( $post_id, 'search_product_tags', wp_json_encode( $search_product_tags_meta ? $search_product_tags_meta : array() ) );

		$ccheckbox = isset( $_POST['ccheckbox'] ) ? sanitize_meta( '', wp_unslash( $_POST['ccheckbox'] ), '' ) : '';
		update_post_meta( $post_id, 'ccheckbox', $ccheckbox );

		$ka_enable_global_icon_field = isset( $_POST['ka_enable_global_icon_field'] ) ? sanitize_meta( '', wp_unslash( $_POST['ka_enable_global_icon_field'] ), '' ) : '';
		update_post_meta( $post_id, 'ka_enable_global_icon_field', $ka_enable_global_icon_field );

		$ka_background_img_field = isset( $_POST['ka_background_img_field'] ) ? sanitize_meta( '', wp_unslash( $_POST['ka_background_img_field'] ), '' ) : '';
		update_post_meta( $post_id, 'ka_background_img_field', $ka_background_img_field );

		$newcolor = isset( $_POST['newcolor'] ) ? sanitize_meta( '', wp_unslash( $_POST['newcolor'] ), '' ) : '';
		update_post_meta( $post_id, 'newcolor', $newcolor );

		$cu_pr_ta_ma_images = isset( $_POST['cu_pr_ta_ma_image_gallery_input'] ) ? sanitize_meta( '', wp_unslash( $_POST['cu_pr_ta_ma_image_gallery_input'] ), '' ) : array();
		update_post_meta( $post_id, 'cu_pr_ta_ma_image_gallery_input', $cu_pr_ta_ma_images );

		$cu_pr_ta_ma_videos = isset( $_POST['cu_pr_ta_ma_video_gallery_input'] ) ? sanitize_meta( '', wp_unslash( $_POST['cu_pr_ta_ma_video_gallery_input'] ), '' ) : array();
		update_post_meta( $post_id, 'cu_pr_ta_ma_video_gallery_input', $cu_pr_ta_ma_videos );

		$cu_pr_ta_ma_store_location = isset( $_POST['cu_pr_ta_ma_store_location'] ) ? sanitize_text_field( wp_unslash( $_POST['cu_pr_ta_ma_store_location'] ) ) : '';
		update_post_meta( $post_id, 'cu_pr_ta_ma_store_location', $cu_pr_ta_ma_store_location );

		$cu_pr_ta_ma_store_location_address_lat = isset( $_POST['cu_pr_ta_ma_store_location_address_lat'] ) ? sanitize_text_field( wp_unslash( $_POST['cu_pr_ta_ma_store_location_address_lat'] ) ) : '';
		update_post_meta( $post_id, 'cu_pr_ta_ma_store_location_address_lat', $cu_pr_ta_ma_store_location_address_lat );

		$cu_pr_ta_ma_store_location_address_long = isset( $_POST['cu_pr_ta_ma_store_location_address_long'] ) ? sanitize_text_field( wp_unslash( $_POST['cu_pr_ta_ma_store_location_address_long'] ) ) : '';
		update_post_meta( $post_id, 'cu_pr_ta_ma_store_location_address_long', $cu_pr_ta_ma_store_location_address_long );

		$cu_pr_ta_ma_file_inputs = isset( $_POST['cu_pr_ta_ma_file_input'] ) ? sanitize_meta( '', wp_unslash( $_POST['cu_pr_ta_ma_file_input'] ), '' ) : array();
		update_post_meta( $post_id, 'cu_pr_ta_ma_file_input', $cu_pr_ta_ma_file_inputs );
	}


	public function cptmrl_get_sections() {
		global $current_section;

		$tab_id = 'cptmrl';

		$sections = array(
			'section_general_setting'  => esc_html__( 'Settings', 'addify_ptabs' ),
			'cptm_tabs_sorting'        => esc_html__( 'Tabs Sorting', 'addify_ptabs' ),
			'cptm_tabs_style_settings' => esc_html__( 'Tabs Style Settings', 'addify_ptabs' ),
		);

		$array_keys      = array_keys( $sections );
		$current_section = empty( $current_section ) ? 'section_general_setting' : $current_section;
		?>
		<ul class="subsubsub">
			<?php
			foreach ( $sections as $id => $label ) {
				echo wp_kses_post( '<li><a href="' . admin_url( 'admin.php?page=wc-settings&tab=' . $tab_id . '&section=' . sanitize_title( $id ) ) . '" class="' . ( $current_section === $id ? 'current' : '' ) . '">' . esc_attr( $label ) . '</a> ' . ( end( $array_keys ) === $id ? '' : '|' ) . ' </li>' );
			}
			?>
		</ul>
		<br class="clear"/>
		<?php
	}//end cptmrl_get_sections()


	public function cptmrl_add_settings_tab( $settings_tabs ) {
		$settings_tabs['cptmrl'] = esc_html__( 'Product Custom Tabs', 'addify_ptabs' );

		return $settings_tabs;
	}//end cptmrl_add_settings_tab()


	public function cptmrl_settings_tab() {
		// Call settings function
		$settings = $this->cptmrl_get_custom_settings();
		WC_Admin_Settings::output_fields( $settings );
	}//end cptmrl_settings_tab()


	public function cptmrl_get_custom_settings() {
		global $current_section;

		$settings = array();
		if ( 'section_general_setting' === $current_section ) {
			// Add Title to the Settings
			$settings =
				array(
					array(
						'name' => esc_html__( 'Default Tabs Setting', 'addify_ptabs' ),
						'type' => 'title',
						'id'   => 'cptm_default_tabs_setting_section',
					),

					array(
						'name'     => esc_html__( 'Enable Default tabs', 'addify_ptabs' ),
						'id'       => 'ka_enable_defaul_tabs_rule',
						'type'     => 'checkbox',
						'desc_tip' => esc_html__( 'Enable/disable default tabs setting.', 'addify_ptabs' ),
					),

					array(
						'name'     => esc_html__( 'Enable Description Tab', 'addify_ptabs' ),
						'id'       => 'ka_enable_description_checkbox',
						'type'     => 'checkbox',
						'desc_tip' => esc_html__( 'Enable description tab.', 'addify_ptabs' ),
						'class'    => 'hide_general_tabs_sorting',
					),

					array(
						'name'     => esc_html__( 'Rename Description Tab', 'addify_ptabs' ),
						'id'       => 'ka_tabs_rename_description_field',
						'type'     => 'text',
						'desc_tip' => esc_html__( 'Enter text for change description tab title.', 'addify_ptabs' ),
						'class'    => 'hide_general_tabs_sorting',
					),
					array(
						'name'     => esc_html__( 'Enable Review Tab', 'addify_ptabs' ),
						'id'       => 'ka_enable_review_checkbox',
						'type'     => 'checkbox',
						'desc_tip' => esc_html__( 'Enable review tab.', 'addify_ptabs' ),
						'class'    => 'hide_general_tabs_sorting',
					),

					array(
						'name'     => esc_html__( 'Rename Review Tab', 'addify_ptabs' ),
						'id'       => 'ka_tabs_rename_review_field',
						'type'     => 'text',
						'desc_tip' => esc_html__( 'Enter text for change review tab title.', 'addify_ptabs' ),
						'class'    => 'hide_general_tabs_sorting',
					),

					array(
						'name'     => esc_html__( 'Enable Additional Information Tab', 'addify_ptabs' ),
						'id'       => 'ka_enable_additional_information_checkbox',
						'type'     => 'checkbox',
						'desc_tip' => esc_html__( 'Enable Additional Information tab.', 'addify_ptabs' ),
						'class'    => 'hide_general_tabs_sorting',
					),

					array(
						'name'     => esc_html__( 'Rename Additional Information Tab', 'addify_ptabs' ),
						'id'       => 'ka_tabs_rename_additional_information_field',
						'type'     => 'text',
						'desc_tip' => esc_html__( 'Enter text for change Additional Information tab title.', 'addify_ptabs' ),
						'class'    => 'hide_general_tabs_sorting',
					),

					array(
						'type' => 'sectionend',
						'id'   => 'cptm_default_tabs_setting_section',
					),

				);
		} elseif ( 'cptm_tabs_sorting' === $current_section ) {
			$settings[] = array(
				'name' => esc_html__( 'Tabs Sorting', 'addify_ptabs' ),
				'type' => 'title',
				'id'   => 'cptm-tabs-sorting-section',
			);

			$settings[] = array(
				'name'  => esc_html__( 'Custom Product tabs Sorting', 'addify_ptabs' ),
				'id'    => 'cpt_sortable',
				'type'  => 'text',
				'value' => '   ',
			);
			$settings[] = array(
				'type' => 'sectionend',
				'id'   => 'cptm-tabs-sorting-section',
			);

		} elseif ( 'cptm_tabs_style_settings' === $current_section ) {

			$cpt_position = get_option( 'cptm_tabs_position' );
			$cpt_style    = get_option( 'cptm_tabs_style' );

			$current_tab_style = empty( $cpt_style ) || ! in_array(
				$cpt_style,
				array(
					'default'    => 'Default',
					'vertical'   => 'Vertical',
					'horizontal' => 'Horizontal',
					'accordion'  => 'Accordion',
					'full'       => 'Full',
				),
				true
			) ? 'default' : $cpt_style;

			$cpt_gallery_style     = get_option( 'cptm_gallery_style' );
			$current_gallery_style = empty( $cpt_gallery_style ) || ! in_array(
				$cpt_gallery_style,
				array(
					'simple'    => 'Simple',
					'slideshow' => 'SlideShow',
				),
				true
			) ? 'simple' : $cpt_gallery_style;

			$current_tab_style_type = 'vertical' === $current_tab_style || 'horizontal' === $current_tab_style;

			if ( $current_tab_style_type ) {
				if ( 'horizontal' === $current_tab_style ) {
					$current_position = empty( $cpt_position ) ||
										! in_array(
											$cpt_position,
											array(
												'top'    => 'Top',
												'bottom' => 'Bottom',
											),
											true
										) ? 'top' : $cpt_position;

				} elseif ( 'vertical' === $current_tab_style ) {
					$current_position = empty( $cpt_position ) ||
										! in_array(
											$cpt_position,
											array(
												'left'  => 'Left',
												'right' => 'Right',
											),
											true
										) ? 'left' : $cpt_position;
				}
			}

			$settings[] = array(
				'name' => esc_html__( 'Content Styling', 'addify_ptabs' ),
				'type' => 'title',
				'id'   => 'cptm-tabs-style-section',
			);
			// $settings[] = array(
			// 'text' => esc_html__( 'Use this shortcode to show tabs (af_cu_pr_ta_ma_shortcode)', 'addify_ptabs' ),
			// 'type' => 'info',
			// );

			$settings[] = array(
				'name'     => esc_html__( 'Tab Style ', 'addify_ptabs' ),
				'type'     => 'select',
				'id'       => 'cptm_tab_style',
				'options'  => array(
					'default'    => 'Default',
					'vertical'   => 'Vertical',
					'horizontal' => 'Horizontal',
					'accordion'  => 'Accordion',
					'full'       => 'Full',
				),
				'desc_tip' => true,
				'tooltip'  => esc_html__( 'Set style of tabs.', 'addify_ptabs' ),
				'desc'     => esc_html__( 'Set style of tabs.', 'addify_ptabs' ),
				'selected' => $current_tab_style,
			);

			$settings[] = array(
				'name'     => esc_html__( 'Tab position ', 'addify_ptabs' ),
				'type'     => 'select',
				'id'       => 'cptm_tabs_position',
				'options'  => array(
					'top'    => 'Top',
					'bottom' => 'Bottom',
					'left'   => 'Left',
					'right'  => 'Right',
				),
				'desc_tip' => true,
				'tooltip'  => esc_html__( 'Set the position of Tab.Defualt is the top for Horizontal style and left for Vertical style.', 'addify_ptabs' ),
				'desc'     => esc_html__( 'Set the position of Tab.Defualt is the top for Horizontal style and left for Vertical style.', 'addify_ptabs' ),
				'selected' => $cpt_position,
			);
			$settings[] = array(
				'name'     => esc_html__( 'Gallery Style ', 'addify_ptabs' ),
				'id'       => 'cptm_gallery_style',
				'type'     => 'select',
				'options'  => array(
					'simple'    => 'Simple',
					'slideshow' => 'SlideShow',
				),
				'desc_tip' => true,
				'tooltip'  => esc_html__( 'Set the style of Gallery.', 'addify_ptabs' ),
				'desc'     => esc_html__( 'Set the style of Gallery.', 'addify_ptabs' ),
				'selected' => $current_gallery_style,
			);
			$settings[] = array(
				'name'     => esc_html__( 'Slideshow Autoplay ', 'addify_ptabs' ),
				'type'     => 'checkbox',
				'id'       => 'cptm_gallery_slideshow_autoplay',
				'desc_tip' => true,
				'tooltip'  => esc_html__( 'Enable the autoplay of content in slideshow.', 'addify_ptabs' ),
				'desc'     => esc_html__( 'Enable the autoplay of content in slideshow.', 'addify_ptabs' ),
			);

			$cptm_gallery_slideshow_files_number       = get_option( 'cptm_gallery_slideshow_files_number' );
			$cptm_gallery_slideshow_files_number_value = empty( $cptm_gallery_slideshow_files_number ) || $cptm_gallery_slideshow_files_number <= 1 ? 1 : $cptm_gallery_slideshow_files_number;
			$cptm_gallery_slideshow_files_number_value = $cptm_gallery_slideshow_files_number_value >= 5 ? 5 : $cptm_gallery_slideshow_files_number_value;

			$settings[] = array(
				'name'              => esc_html__( 'Gallery Images ', 'addify_ptabs' ),
				'type'              => 'number',
				'id'                => 'cptm_gallery_slideshow_files_number',
				'default'           => esc_attr( $cptm_gallery_slideshow_files_number_value ),
				'custom_attributes' => array(
					'min' => 1,
					'max' => 5,
				),
				'desc_tip'          => true,
				'tooltip'           => esc_html__( 'Set the number of images in slideshow.Defualt is 1', 'addify_ptabs' ),
				'desc'              => esc_html__( 'Set the number of images in slideshow.Defualt is 1', 'addify_ptabs' ),
			);

			$settings[] = array(
				'type' => 'sectionend',
				'id'   => 'cptm-tabs-style-section',
			);
		}
		return $settings;
	}//end cptmrl_get_custom_settings()

	/*
	This function will save the inputs of current tab in database.
	*/
	public function cptmrl_update_settings() {

		global $current_section;
		$tab_id          = 'cptmrl';
		$current_section = ! empty( $current_section ) ? $current_section : 'section_general_setting';

		$settings = $this->cptmrl_get_custom_settings();
		if ( $current_section ) {
			WC_Admin_Settings::save_fields( $settings );

			/*
			* Saving options values
			*
			* @since 1.0.0
			*
			*/
			do_action( 'woocommerce_update_options_' . $tab_id . '_' . $current_section );
		}
	}//end cptmrl_update_settings()
}//end class

if ( class_exists( 'CU_PR_TA_MA_Admin' ) ) {
	new CU_PR_TA_MA_Admin();
}
