<?php
/**
 * Plugin Name: Custom Product Tabs Manager
 * Plugin URI: https://woocommerce.com/products/custom-product-tabs-manager
 * Description: Add unlimited custom product tabs, edit default tabs and sort them as per your requirements.
 * Version: 1.2.2
 * Author: Addify
 * Developed By: Addify
 * Author URI:https://woocommerce.com/vendor/addify/
 * Support: https://woocommerce.com/vendor/addify/
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Domain Path: /languages
 * TextDomain: addify_ptabs
 * Requires Plugins:  woocommerce
 * WC requires at least: 4.0
 * WC tested up to: 9.*.*
 * Requires at least: 6.5
 * Tested up to: 6.*.*
 * Requires PHP: 7.4
 * Woo: 7449969:577c77a0ee244f6b27b3bd62d878a702

 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'CU_PR_TA_MA_Main' ) ) {
	class CU_PR_TA_MA_Main {
		public function __construct() {
			$this->cu_pr_ta_ma_global_constant_variables();
			add_action( 'plugins_loaded', array( $this, 'cu_pr_ta_ma_check_woocommerce' ) );
			add_action( 'init', array( $this, 'cu_pr_ta_ma_hooks' ) );
			add_action( 'before_woocommerce_init', array( $this, 'cu_pr_ta_ma_hops_compatibility' ) );
		}//end __construct()

		public function cu_pr_ta_ma_check_woocommerce() {
			// Check the installation of WooCommerce module if it is not a multi site.
			if ( ! is_multisite() && ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) ) {
				add_action( 'admin_notices', array( $this, 'cu_pr_ta_ma_admin_notice' ) );
			}
		}
		public function cu_pr_ta_ma_admin_notice() {
			deactivate_plugins( __FILE__ );
			?>
			<div id="message" class="error">
				<p>
					<strong>
						<?php esc_html_e( 'Custom Product Tabs Manager plugin is inactive. WooCommerce plugin must be active in order to activate it.', 'addify_ptabs' ); ?>
					
					</strong>
				</p>
			</div>
			<?php
		}
		public function cu_pr_ta_ma_hooks() {
			if ( defined( 'WC_PLUGIN_FILE' ) ) {

				add_action( 'wp_loaded', array( $this, 'cu_pr_ta_ma_custom_post_types' ) );
				add_action( 'after_setup_theme', array( $this, 'cu_pr_ta_ma_reg_init' ) );

				register_activation_hook( __FILE__, array( $this, 'af_set_default_settings' ) );

				add_filter( 'plugin_action_links_' . CU_PR_TA_MA_BASENAME, array( $this, 'cu_pr_ta_ma_plugin_action_links' ) );
				add_filter( 'wp_kses_allowed_html', array( $this, 'custom_wpkses_post_tags' ), 10, 2 );

				include_once CU_PR_TA_MA_PLUGIN_DIR . '/include/class-cu-pr-ta-ma-ajax-controller.php';

				if ( is_admin() ) {
					include_once CU_PR_TA_MA_PLUGIN_DIR . '/include/admin/class-cu-pr-ta-ma-admin.php';
				} else {
					include_once CU_PR_TA_MA_PLUGIN_DIR . '/include/front/class-cu-pr-ta-ma-front.php';
				}
			}
		}


		/**
		 * Add custom action links on plugin screen.
		 *
		 * @param mixed $actions Plugin Actions Links.
		 * @return array
		 */
		public function cu_pr_ta_ma_plugin_action_links( $actions ) {
			$custom_actions = array(
				'settings' => sprintf( '<a href="%s">%s</a>', admin_url( 'admin.php?page=wc-settings&tab=cptmrl' ), __( 'Settings', 'addify_ptabs' ) ),
			);
			return array_merge( $custom_actions, $actions );
		}


		public function custom_wpkses_post_tags( $tags, $context ) {

			if ( 'post' === $context ) {
				$tags['iframe'] = array(
					'src'             => true,
					'height'          => true,
					'width'           => true,
					'frameborder'     => true,
					'allowfullscreen' => true,
				);
			}

			return $tags;
		}

		public function af_set_default_settings() {

			$enable_description_tab = get_option( 'ka_tabs_enable_description_field' );
			$rename_description_tab = get_option( 'ka_tabs_rename_description_field' );

			$enable_review_tab = get_option( 'ka_tabs_enable_review_field' );
			$rename_review_tab = get_option( 'ka_tabs_rename_review_field' );

			$enable_add_information_tab = get_option( 'ka_tabs_enable_additional_information_field' );
			$rename_add_information_tab = get_option( 'ka_tabs_rename_additional_information_field' );

			if ( empty( $enable_description_tab ) ) {
				update_option( 'ka_tabs_enable_description_field', 'on' );
			}
			if ( empty( $rename_description_tab ) ) {
				update_option( 'ka_tabs_rename_description_field', 'Description' );
			}

			if ( empty( $enable_review_tab ) ) {
				update_option( 'ka_tabs_enable_review_field', 'on' );
			}
			if ( empty( $rename_review_tab ) ) {
				update_option( 'ka_tabs_rename_review_field', 'Reviews' );
			}

			if ( empty( $enable_add_information_tab ) ) {
				update_option( 'ka_tabs_enable_additional_information_field', 'on' );
			}
			if ( empty( $rename_add_information_tab ) ) {
				update_option( 'ka_tabs_rename_additional_information_field', 'Additional Information' );
			}
		}



		public function cu_pr_ta_ma_global_constant_variables() {
			if ( ! defined( 'CU_PR_TA_MA_URL' ) ) {
				define( 'CU_PR_TA_MA_URL', plugin_dir_url( __FILE__ ) );
			}
			if ( ! defined( 'CU_PR_TA_MA_BASENAME' ) ) {
				define( 'CU_PR_TA_MA_BASENAME', plugin_basename( __FILE__ ) );
			}
			if ( ! defined( 'CU_PR_TA_MA_PLUGIN_DIR' ) ) {
				define( 'CU_PR_TA_MA_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
			}
		}//end cu_pr_ta_ma_global_constant_variables()

		public function cu_pr_ta_ma_custom_post_types() {
			$this->custom_post_register_product_level();
			$this->ka_custom_tabs_custom_post_type();
		}



		public function custom_post_register_product_level() {

			$label = array(
				'name'          => esc_html__( 'Product Tabs', 'addify_ptabs' ),
				'singular_name' => esc_html__( ' All Tabs', 'addify_ptabs' ),
				'add_new'       => esc_html__( 'Add New Tab', 'addify_ptabs' ),
				'all_items'     => esc_html__( 'All Tabs', 'addify_ptabs' ),
				'edit_item'     => esc_html__( 'Edit Tab', 'addify_ptabs' ),
			);
			$args  = array(
				'labels'                  => $label,
				'public'                  => true,
				'can_export'              => true,
				'has_archive'             => true,
				// 'exclude_from_search' => true,
					'publicily_queryable' => true,
				'query_var'               => true,
				'rewrite'                 => array( 'slug' => 'cptm_level_tab' ),
				'capability_type'         => 'post',
				'hierarchical'            => false,
				'show_in_menu'            => false,
				'map_meta_cap'            => true,
				'publicly_queryable'      => true,
				'exclude_from_search'     => false,
				'supports'                => array(
					'title',
				),
			);
			register_post_type( 'cptm_level_tab', $args );
		}

		/**
		 * Custom product tabs local_updates function tart.
		 */
		public function ka_custom_tabs_custom_post_type() {

			$label = array(
				'name'          => esc_html__( 'Global Tabs', 'addify_ptabs' ),
				'singular_name' => esc_html__( ' Global Tabs', 'addify_ptabs' ),
				'add_new'       => esc_html__( 'Add New Tab', 'addify_ptabs' ),
				'all_items'     => esc_html__( 'Global Tabs', 'addify_ptabs' ),
				'edit_item'     => esc_html__( 'Edit Tab', 'addify_ptabs' ),
			);
			$args  = array(
				'labels'              => $label,
				'public'              => true,
				'has_archives'        => true,
				'publicity_queryable' => true,
				'query_var'           => true,
				'rewrite'             => array( 'slug' => 'product_tab' ),
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'show_in_menu'        => 'edit.php?post_type=product',
				// 'menu_icon'          => plugin_dir_url( __FILE__ ) . 'img/grey.png',
					'supports'        => array(
						'title',
					),
			);
			register_post_type( 'product_tab', $args );
		}



		public function cu_pr_ta_ma_hops_compatibility() {

			if ( class_exists( Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
				Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			}
		}

		public function cu_pr_ta_ma_reg_init() {

			if ( function_exists( 'load_plugin_textdomain' ) ) {
				load_plugin_textdomain( ' addify_ptabs', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
			}
		}
	}//end class
	new CU_PR_TA_MA_Main();
}



