jQuery( document ).ready(
	function ($) {

		function cu_pr_ta_ma_adjust_layout() {
			  var width         = $( window ).width();
			  var gallery_modal = $( "section.cu_pr_ta_ma_gallery_modal" );
			gallery_modal.each(
				function () {
					if (width < 240) {
							updateTopPosition( $( this ), 40, -30 );
					} else if (width >= 240 && width < 420) {
						  updateTopPosition( $( this ), 60, -20 );
					} else {
						updateTopPosition( $( this ), 60, -20 );
					}
				}
			);
		}
		cu_pr_ta_ma_adjust_layout();

		$( window ).resize( cu_pr_ta_ma_adjust_layout() );

		function updateTopPosition(Modal,  initialTop, scrollOffset) {
			$( window ).on(
				"scroll",
				function () {
					if (Modal) {
						var newTop = "calc(" + initialTop + "% + " + (scrollOffset + 70) + "px)";
						$( "section.cu_pr_ta_ma_gallery_modal" ).css( 'top', newTop );
					}
				}
			);
		}

		var gallery_model = $( ".cu_pr_ta_ma_gallery_modal" );
		if (gallery_model) {
			gallery_model.hide();
			gallery_model.siblings( "div.cu_pr_ta_ma_gallery_overlay" ).hide();
		}

		$( document ).on(
			"click",
			".cu_pr_ta_ma_gallery_btn_close",
			function () {
				var close_btn = $( this );
				modal         = close_btn.closest( ".cu_pr_ta_ma_gallery_modal" );
				modal.find( 'video' ).trigger( 'pause' );
				modal.hide();
				modal.siblings( ".cu_pr_ta_ma_gallery_overlay" ).hide();

				$( ".cu_pr_ta_ma_slideshow-container" ).each(
					function () {
						$( this ).find( 'span.cu_pr_ta_ma_dot_0' ).click();
						$( this ).find( 'span.cu_pr_ta_ma_dot_0' ).addClass( 'cu_pr_ta_ma_active-dot' );
					}
				);

			}
		);

		// close modal when the Esc key is pressed

		$( document ).on(
			'keydown',
			function (e) {
				if (e.key === "Escape" && ! $( ".cu_pr_ta_ma_image_gallery_modal" ).hasClass( "cu_pr_ta_ma_gallery_hidden" )) {
					$( ".cu_pr_ta_ma_gallery_btn_close" ).click();
				}
				if (e.key === "Escape" && ! $( ".cu_pr_ta_ma_video_gallery_modal" ).hasClass( "cu_pr_ta_ma_gallery_hidden" )) {
					$( ".cu_pr_ta_ma_gallery_btn_close" ).click();
				}

			}
		);

		// open  Modal function
		$( document ).on(
			"click",
			".cu_pr_ta_ma_view_gallery_btn",
			function () {
				var this_btn = $( this );

				if (this_btn.attr( 'value' ) === 'img' || this_btn.attr( 'value' ) === 'video') {
					var element = $( this ).find( this_btn.attr( 'value' ) );
					var modal   = this_btn.closest( 'div.cu_pr_ta_ma_gallery_front' ).siblings( "section.cu_pr_ta_ma_gallery_modal" );

					if (this_btn.attr( 'value' ) === 'video') {
						element = $( '<video >' ).attr( 'src',this_btn.find( 'video' ).attr( 'src' ) );
						element.attr( 'controls',true );
					}

					modal.css( {'top': 'calc(60%' + '50px)'} );
					modal.find( '.cu_pr_ta_ma_gallery_modal_body' ).html( element.prop( 'outerHTML' ) );
					modal.show();
					modal.siblings( "div.cu_pr_ta_ma_gallery_overlay" ).show();
				}
			}
		);

			$( ".cu_pr_ta_ma_slideshow-container" ).each(
				function () {
					var currentSlide       = 0;
					var slideshowContainer = $( this );
					var autoplayEnabled    = slideshowContainer.data( "autoplay_enable" ) === "yes"; // Check if autoplay is enabled
					var filesNumber        = parseInt( slideshowContainer.data( "files_number" ) ); // Number of files to show

					function showSlide(slideNumber) {
						slideshowContainer.find( ".cu_pr_ta_ma_mySlides" ).hide();
						// slideshowContainer.find(".cu_pr_ta_ma_mySlides").css({'flex':'0 0 '+ 90/filesNumber+'%' });

						for (var i = 1; i <= filesNumber; i++) {
							slide = slideNumber + i;
							slideshowContainer.find( ".cu_pr_ta_ma_mySlides:nth-child(" + slide + ")" ).show();

						}

						slideshowContainer.find( ".cu_pr_ta_ma_dot" ).removeClass( "cu_pr_ta_ma_active-dot" );
						slideshowContainer.find( ".cu_pr_ta_ma_dot[data-current=" + slideNumber + "]" ).addClass( "cu_pr_ta_ma_active-dot" );
					}

					function autoplay() {
						if (autoplayEnabled) {
							if (currentSlide + filesNumber >= slideshowContainer.find( ".cu_pr_ta_ma_mySlides" ).length) {
								currentSlide = 0;
							} else {
								currentSlide++;
							}
							showSlide( currentSlide );
						}
					}

					showSlide( currentSlide );

					slideshowContainer.find( ".cu_pr_ta_ma_move_slide" ).on(
						"click",
						function () {
							var move        = parseInt( $( this ).data( "move" ) );
							var last_child  = slideshowContainer.find( ".cu_pr_ta_ma_mySlides:last-child" );
							var first_child = slideshowContainer.find( ".cu_pr_ta_ma_mySlides:first-child" );

							if (currentSlide + filesNumber >= slideshowContainer.find( ".cu_pr_ta_ma_mySlides" ).length && move === 1) {
								currentSlide = 0;
							} else if (first_child.is( ':visible' ) && move === -1) {
								currentSlide = slideshowContainer.find( ".cu_pr_ta_ma_mySlides" ).length - filesNumber;
							} else {
								currentSlide += move;
							}
							showSlide( currentSlide );
						}
					);

					slideshowContainer.find( ".cu_pr_ta_ma_dot" ).on(
						"click",
						function () {
							currentSlide = parseInt( $( this ).data( "current" ) );
							showSlide( currentSlide );
						}
					);

					if (autoplayEnabled) {
						setInterval( autoplay, 3000 );
					}
				}
			);

		function get_google_map_location(current_element) {

			var mapOptions = { "center": {  lat: 25.2, lng: 55.2 }, "clickableIcons": true, "disableDoubleClickZoom": false, "draggable": true, "fullscreenControl": true, "keyboardShortcuts": true, "mapTypeControl": true, "mapTypeControlOptions": {  "text": "Default (depends on viewport size etc.)",  "style": 0 }, "mapTypeId": "roadmap", "rotateControl": true, "scaleControl": true, "scrollwheel": true, "streetViewControl": true, "styles": [  {   "featureType": "all",   "elementType": "labels.text.fill",   "stylers": [    {     "saturation": 36    },    {     "color": "#ffffff"    },    {     "lightness": 40    }   ]  },  {   "featureType": "all",   "elementType": "labels.text.stroke",   "stylers": [    {     "visibility": "off"    },    {     "color": "#000000"    },    {     "lightness": 16    }   ]  },  {   "featureType": "all",   "elementType": "labels.icon",   "stylers": [    {     "visibility": "off"    }   ]  },  {   "featureType": "administrative",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#c0c0c0"    },    {     "lightness": 20    },    {     "visibility": "on"    }   ]  },  {   "featureType": "administrative",   "elementType": "geometry.stroke",   "stylers": [    {     "color": "#000000"    },    {     "lightness": 17    },    {     "weight": 1.2    },    {     "visibility": "off"    }   ]  },  {   "featureType": "landscape",   "elementType": "geometry",   "stylers": [    {     "color": "#000000"    },    {     "lightness": 20    }   ]  },  {   "featureType": "landscape",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#3f3f3f"    }   ]  },  {   "featureType": "landscape",   "elementType": "geometry.stroke",   "stylers": [    {     "visibility": "off"    }   ]  },  {   "featureType": "landscape.man_made",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#333333"    },    {     "visibility": "on"    },    {     "saturation": "0"    },    {     "lightness": "0"    },    {     "gamma": "1.00"    }   ]  },  {   "featureType": "landscape.man_made",   "elementType": "geometry.stroke",   "stylers": [    {     "visibility": "off"    }   ]  },  {   "featureType": "landscape.natural",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#2b2b2b"    },    {     "visibility": "on"    },    {     "gamma": "1"    },    {     "lightness": "0"    },    {     "saturation": "0"    }   ]  },  {   "featureType": "landscape.natural",   "elementType": "geometry.stroke",   "stylers": [    {     "visibility": "off"    }   ]  },  {   "featureType": "landscape.natural.landcover",   "elementType": "geometry.fill",   "stylers": [    {     "visibility": "off"    },    {     "color": "#ff0000"    }   ]  },  {   "featureType": "landscape.natural.landcover",   "elementType": "geometry.stroke",   "stylers": [    {     "visibility": "off"    }   ]  },  {   "featureType": "landscape.natural.terrain",   "elementType": "geometry.fill",   "stylers": [    {     "visibility": "on"    },    {     "color": "#222222"    }   ]  },  {   "featureType": "landscape.natural.terrain",   "elementType": "geometry.stroke",   "stylers": [    {     "visibility": "off"    }   ]  },  {   "featureType": "poi",   "elementType": "geometry",   "stylers": [    {     "color": "#000000"    },    {     "lightness": 21    }   ]  },  {   "featureType": "poi",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#4a4a4a"    },    {     "visibility": "on"    }   ]  },  {   "featureType": "road.highway",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#ac9455"    },    {     "lightness": "0"    },    {     "gamma": "1.00"    }   ]  },  {   "featureType": "road.highway",   "elementType": "geometry.stroke",   "stylers": [    {     "color": "#000000"    },    {     "lightness": 29    },    {     "weight": 0.2    }   ]  },  {   "featureType": "road.arterial",   "elementType": "geometry",   "stylers": [    {     "color": "#ac9455"    },    {     "lightness": "0"    }   ]  },  {   "featureType": "road.arterial",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#ac9455"    }   ]  },  {   "featureType": "road.arterial",   "elementType": "geometry.stroke",   "stylers": [    {     "visibility": "off"    }   ]  },  {   "featureType": "road.local",   "elementType": "geometry",   "stylers": [    {     "color": "#000000"    },    {     "lightness": 16    }   ]  },  {   "featureType": "road.local",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#222222"    }   ]  },  {   "featureType": "road.local",   "elementType": "geometry.stroke",   "stylers": [    {     "visibility": "off"    }   ]  },  {   "featureType": "transit",   "elementType": "geometry",   "stylers": [    {     "color": "#000000"    },    {     "lightness": 19    }   ]  },  {   "featureType": "water",   "elementType": "geometry",   "stylers": [    {     "color": "#000000"    },    {     "lightness": 17    }   ]  },  {   "featureType": "water",   "elementType": "geometry.fill",   "stylers": [    {     "color": "#1a1a1a"    }   ]  } ], "zoom": 15, "zoomControl": true};

			var mapElement  = current_element.find( 'div.ez-map' );
			var hiddenInput = current_element.find( 'input.af_all_address' );
			console.log( hiddenInput );
			if (hiddenInput) {
				var lat = parseFloat( hiddenInput.attr( 'data-lat' ) );
				var lng = parseFloat( hiddenInput.attr( 'data-long' ) );

				if ( ! isNaN( lat ) && ! isNaN( lng )) {
					mapOptions.center = { lat: lat, lng: lng };
				}

				var map = new google.maps.Map( mapElement[0], mapOptions );

				var heatmap = new google.maps.visualization.HeatmapLayer( {data: []} );
				heatmap.setOptions( {"dissipating":false,"opacity":0.6,"radius":2} );
				heatmap.setMap( map );

				var geocoder = new google.maps.Geocoder();
				geocoder.geocode(
					{'address':hiddenInput.val() },
					function (results, status) {
						if (status === 'OK') {
							var marker = new google.maps.Marker(
								{
									map: map,
									position: results[0].geometry.location
								}
							);
						}
					}
				);
			}

			window.addEventListener(
				"resize",
				function() {
					var center = map.getCenter();
					google.maps.event.trigger( map, "resize" );
				}
			);

		}
		$( '.cu_pr_ta_ma_store_location_front' ).each(
			function(){
				window.addEventListener( 'load', get_google_map_location( $( this ) ) );
			}
		);

	}
);
